#############################################################################
#
# This is the makefile for TC v2.0 and TC++ (1.0).
#
# Rename this file to 'makefile.mak' to use it.
#


#############################################################################
#
# Specify directories to use
#

!if $(__MAKE__) >= 0x0300
TC  = d:\tcpp
!else
TC  = c:\tc
!endif

OBJ = obj\\

EXE = exe\\


#############################################################################
#
# Get 286 and 87 options.  Define the env-var "87" or "286" and the
# corresponding type of executable will be built automatically
#

!if $d(87)
OPS87=-f87
LIB87=fp87
!else
LIB87=emu
!endif

!if $d(286)
OPS286=-1
!endif


#############################################################################
#
# Decide if we want to use TC++ or TC 1.5/2.0.  If make version is 3.0, then
# assume the user has TC++.  If this is not correct, fix it yourself.
#

!if $(__MAKE__) >= 0x0300
C_PLUS_PLUS = YES
USE_OVERLAYS = YES
!endif

!if $d(USE_OVERLAYS)
OVER_START = /o
OVER_END = /o-
OVER_LIB = $(TC)\lib\overlay
!endif


#############################################################################
#
# Define command lines to use.
#
#

TCOPTS= -O -d -r -ml -N- -Z -c $(OPS87) $(OPS286)

TCC = tcc $(TCOPTS) $(TCC_OPTS) -I$(TC)\include -n$(OBJ) $&.c


!if $d(USE_OVERLAYS)
TCC_NRM = tcc $(TCOPTS) $(TCC_OPTS) -Y -I$(TC)\include -n$(OBJ) $&.c
TCC_OVL = tcc $(TCOPTS) $(TCC_OPTS) -Yo -I$(TC)\include -n$(OBJ) $&.c
TCC_VER = tcc $(TCOPTS) $(TCC_OPTS) -Y -I$(TC)\include -n$(OBJ) version.c

!else
TCC_NRM = $(TCC)
TCC_OVL = $(TCC)
TCC_VER = tcc $(TCOPTS) $(TCC_OPTS) -I$(TC)\include -n$(OBJ) version.c
!endif



#############################################################################
#
#
# Normal, non-overlaid bbs files
#
BBS_NRM = \
        $(OBJ)bbs.obj $(OBJ)bbsutl.obj $(OBJ)bbsutl1.obj $(OBJ)com.obj\
        $(OBJ)conio.obj $(OBJ)connect1.obj $(OBJ)extrn.obj $(OBJ)modem.obj\
        $(OBJ)msgbase.obj $(OBJ)msgbase1.obj $(OBJ)utility.obj\
        $(OBJ)xfer.obj $(OBJ)strings.obj $(OBJ)share.obj $(OBJ)subacc.obj\
        $(OBJ)bbsutl2.obj $(OBJ)mmenu.obj $(OBJ)ripspeed.obj ripint.obj
#
# Overlaid bbs files
#
BBS_OVL = \
        $(OBJ)newuser.obj $(OBJ)sysopf.obj $(OBJ)voteedit.obj\
        $(OBJ)gfledit.obj $(OBJ)tedit.obj $(OBJ)chnedit.obj\
        $(OBJ)uedit.obj $(OBJ)diredit.obj $(OBJ)subedit.obj\
        $(OBJ)xferovl.obj $(OBJ)multmail.obj $(OBJ)gfiles.obj\
        $(OBJ)defaults.obj $(OBJ)misccmd.obj $(OBJ)xinit.obj\
        $(OBJ)xfertmp.obj $(OBJ)batch.obj $(OBJ)srrcv.obj\
        $(OBJ)srsend.obj $(OBJ)lilo.obj $(OBJ)subreq.obj\
        $(OBJ)netsup.obj $(OBJ)subxtr.obj $(OBJ)multinst.obj\
        $(OBJ)conf.obj $(OBJ)readmail.obj $(OBJ)instmsg.obj\
        $(OBJ)bbsovl1.obj $(OBJ)extrn1.obj $(OBJ)bbsovl2.obj\
        $(OBJ)sr.obj $(OBJ)ini.obj $(OBJ)xferovl2.obj\
        $(OBJ)bbsovl3.obj $(OBJ)qwk.obj $(OBJ)qwk1.obj\
        $(OBJ)ripovl.obj

#############################################################################
#
# Building everything requires bbs.exe, return.exe, miniesm.exe, and fix.exe.
#

all: $(EXE)bbs.exe $(EXE)return.exe $(EXE)miniesm.exe $(EXE)fix.exe

#############################################################################
#
# Building return.exe is easy and the same everywhere.
#

!if $(__MAKE__) >= 0x0300

$(EXE)return.exe: $(OBJ)return.obj $(OBJ)share.obj version.c
  $(TCC_VER)
  tlink /c /x @&&^
$(TC)\lib\c0l $(OBJ)return $(OBJ)share.obj $(OBJ)version.obj
$(EXE)return
return.map
$(TC)\lib\$(LIB87) $(TC)\lib\mathl $(TC)\lib\cl
^

!else

$(EXE)return.exe: $(OBJ)return.obj $(OBJ)share.obj version.c
  $(TCC_VER)
  tlink /c /x $(TC)\lib\c0l+$(OBJ)return+$(OBJ)version,$(EXE)return,,$(TC)\lib\$(LIB87)+$(TC)\lib\mathl+$(TC)\lib\cl

!endif


$(EXE)miniesm.exe: miniesm.c strings.c
  $(TCC_NRM)
  tlink /c /x $(TC)\lib\c0l+$(OBJ)miniesm,$(EXE)miniesm,,$(TC)\lib\$(LIB87)+$(TC)\lib\mathl+$(TC)\lib\cl


$(EXE)fix.exe: fix.c
  $(TCC_NRM)
  $(TCC_VER)
  tlink /c /x $(TC)\lib\c0l+$(OBJ)fix+$(OBJ)version,$(EXE)fix,,$(TC)\lib\$(LIB87)+$(TC)\lib\mathl+$(TC)\lib\cl


#############################################################################
#
# make v3.0 supports response files, previous versions were brain-dead.
#

!if $(__MAKE__) >= 0x0300

$(EXE)bbs.exe: $(BBS_NRM) $(BBS_OVL) version.c
  $(TCC_VER)
  tlink /c /x @&&^
shrnka.obj $(TC)\lib\c0l.obj $(OBJ)version.obj $(BBS_NRM) $(OVER_START) $(BBS_OVL) $(OVER_END)
$(EXE)bbs
bbs.map
shrnk $(TC)\lib\$(LIB87) $(TC)\lib\mathl $(OVER_LIB) $(TC)\lib\cl
^

!else

$(EXE)bbs.exe: $(BBS_NRM) $(BBS_OVL) linkfile version.c
  $(TCC_VER)
  tlink /c /x @linkfile,$(EXE)bbs,bbs.map,$(TC)\lib\$(LIB87)+$(TC)\lib\mathl+$(TC)\lib\cl

linkfile: makefile.mak makelf.bat
  @command /c makelf $(TC) $(OBJ)

!endif


#############################################################################
#
# How each of the .OBJ files depends upon source files.
#


$(OBJ)bbs.obj     : bbs.c      vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)modem.obj   : modem.c    vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)bbsutl.obj  : bbsutl.c   vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)bbsutl1.obj : bbsutl1.c  vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)com.obj     : com.c      vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)conio.obj   : conio.c    vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)connect1.obj: connect1.c vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)extrn.obj   : extrn.c    vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)msgbase.obj : msgbase.c  vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)msgbase1.obj: msgbase1.c vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)newuser.obj : newuser.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)shrink.obj  : shrink.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)sr.obj      : sr.c       vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)ini.obj     : ini.c      vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)extrn1.obj  : extrn1.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)subacc.obj  : subacc.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)sysopf.obj  : sysopf.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)utility.obj : utility.c  vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)xfer.obj    : xfer.c     vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)strings.obj : strings.c
  $(TCC_NRM)
$(OBJ)ripspeed.obj: ripspeed.c vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)netsup.obj  : netsup.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)voteedit.obj: voteedit.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)gfledit.obj : gfledit.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)tedit.obj   : tedit.c    vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)chnedit.obj : chnedit.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)uedit.obj   : uedit.c    vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)diredit.obj : diredit.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)subedit.obj : subedit.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)subreq.obj  : subreq.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)xferovl.obj : xferovl.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)xferovl2.obj: xferovl2.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)multmail.obj: multmail.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)gfiles.obj  : gfiles.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)defaults.obj: defaults.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)misccmd.obj : misccmd.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)xinit.obj   : xinit.c    vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)subxtr.obj  : subxtr.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)xfertmp.obj : xfertmp.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)batch.obj   : batch.c    vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)srrcv.obj   : srrcv.c    vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)srsend.obj  : srsend.c   vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)lilo.obj    : lilo.c     vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)share.obj   : share.c    vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)multinst.obj: multinst.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)conf.obj    : conf.c     vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)readmail.obj: readmail.c vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)instmsg.obj : instmsg.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)bbsovl1.obj : bbsovl1.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)bbsovl2.obj : bbsovl2.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)bbsutl2.obj : bbsutl2.c  vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)mmenu.obj   : mmenu.c    vars.h vardec.h net.h
  $(TCC_NRM)
$(OBJ)bbsovl3.obj : bbsovl3.c  vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)qwk.obj     : qwk.c      vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)qwk1.obj    : qwk1.c     vars.h vardec.h net.h
  $(TCC_OVL)
$(OBJ)ripovl.obj  : ripovl.c vars.h vardec.h net.h
  $(TCC_OVL)


$(OBJ)return.obj  : return.c   vars.h vardec.h net.h
  $(TCC)


#############################################################################
#
# routine to make fcns.h
#

!if $(__MAKE__) >= 0x0300


.\strip.exe: strip.c
  tcc -ml strip.c
  del strip.obj

fcns: .\strip.exe
  del fcns.h
  strip fcns.h &&^
$(BBS_NRM) $(BBS_OVL)
^

!endif

