REM This batch will expand the files from floppy to C:\AHA398X directory.
REM DOS files will be expanded in C:\AHA398X\DOS directory.
REM NetWare files will be expanded in C:\AHA398X\NETWARE directory.

@echo   Installing AHA-3980/3985 Software to C:\AHA398X
@echo   Please wait...                    
@echo off

if '%1' == '' goto no_parameter

REM Check if directory exist. If exists give a warning to overwrite 
REM the directory.

if NOT exist aha398X goto makedir
 
@echo C:\AHA398X directory already exists. This batch file will overwrite
@echo the existing files.

:makedir 

REM Check to see if all the files exists on the floppy.

if NOT exist *.txt goto chgdrive

if NOT exist dos\*.tx! goto chgdrive
if NOT exist dos\*.sy_ goto chgdrive
if NOT exist dos\*.ex_ goto chgdrive
if NOT exist dos\*.ba_ goto chgdrive
if NOT exist dos\*.cw_ goto chgdrive
if NOT exist dos\*.hl_ goto chgdrive

REM if NOT exist netware\*.tx! goto chgdrive
if NOT exist netware\*.nl_ goto chgdrive
if NOT exist netware\*.ms! goto chgdrive
if NOT exist netware\*.de! goto chgdrive

if NOT exist netware\v3_1x\*.tx! goto chgdrive
if NOT exist netware\v3_1x\*.ds_ goto chgdrive

if NOT exist netware\v4_xx\*.tx! goto chgdrive
if NOT exist netware\v4_xx\*.ds_ goto chgdrive
if NOT exist netware\v4_xx\*.dd! goto chgdrive

REM Check if some or all directories exists on C: drive.

if exist c:\aha398X goto 398xexist

mkdir c:\aha398x > nul

:398xexist

if exist c:\aha398X\dos goto dosexist

mkdir c:\aha398x\dos > nul

:dosexist

if exist c:\aha398X\netware goto netwareexist

mkdir c:\aha398x\netware > nul

:netwareexist

REM Copy readme.txt in the root directory.
copy readme.txt c:\aha398x

REM Expand all the DOS related drivers

for %%f in (dos\*.??_) do expand %%f c:\aha398x\dos > nul 
for %%f in (c:\aha398x\dos\*.sy_) do copy  %%f c:\aha398x\dos\*.sys
for %%f in (c:\aha398x\dos\*.ex_) do copy  %%f c:\aha398x\dos\*.exe
for %%f in (c:\aha398x\dos\*.ba_) do copy  %%f c:\aha398x\dos\*.bat
for %%f in (c:\aha398x\dos\*.cw_) do copy  %%f c:\aha398x\dos\*.cwa
for %%f in (c:\aha398x\dos\*.hl_) do copy  %%f c:\aha398x\dos\*.hlp

for %%f in (dos\*.??!) do expand %%f c:\aha398x\dos > nul 
for %%f in (c:\aha398x\dos\*.tx!) do copy  %%f c:\aha398x\dos\*.txt

del c:\aha398x\dos\*.??_ 
del c:\aha398x\dos\*.??!

REM Expand all the Netware related drivers

for %%f in (netware\*.??_) do expand %%f c:\aha398x\netware > nul 
for %%f in (c:\aha398x\netware\*.nl_) do copy %%f c:\aha398x\netware\*.nlm 

for %%f in (netware\*.??!) do expand %%f c:\aha398x\netware > nul 
REM for %%f in (c:\aha398x\netware\*.tx!) do copy %%f c:\aha398x\netware\*.txt
for %%f in (c:\aha398x\netware\*.ms!) do copy %%f c:\aha398x\netware\*.msg 
for %%f in (c:\aha398x\netware\*.de!) do copy %%f c:\aha398x\netware\*.def 

REM Depending upon version expand the appropriate files.

if '%1' == '3' goto expand3
if '%1' == '4' goto expand4

@echo Please enter either 3 or 4 for version of the Netware operating
@echo system on the command line.
@echo e.g. install 3
goto end

:expand3

for %%f in (netware\v3_1x\*.??_) do expand %%f c:\aha398x\netware > nul 
for %%f in (c:\aha398x\netware\*.ds_) do copy %%f c:\aha398x\netware\*.dsk

for %%f in (netware\v3_1x\*.??!) do expand %%f c:\aha398x\netware > nul 
for %%f in (c:\aha398x\netware\*.tx!) do copy %%f c:\aha398x\netware\*.txt

del c:\aha398x\netware\*.??_
del c:\aha398x\netware\*.??!

REM if NOT exist c:\aha398x\netware\*.txt goto fail
if NOT exist c:\aha398x\netware\*.nlm goto fail
if NOT exist c:\aha398x\netware\*.msg goto fail
if NOT exist c:\aha398x\netware\*.def goto fail

if NOT exist c:\aha398x\netware\*.txt goto fail
if NOT exist c:\aha398x\netware\*.dsk goto fail

goto success

:expand4

for %%f in (netware\v4_xx\*.??_) do expand %%f c:\aha398x\netware > nul 
for %%f in (c:\aha398x\netware\*.ds_) do copy %%f c:\aha398x\netware\*.dsk

for %%f in (netware\v4_xx\*.??!) do expand %%f c:\aha398x\netware > nul 
for %%f in (c:\aha398x\netware\*.tx!) do copy %%f c:\aha398x\netware\*.txt
for %%f in (c:\aha398x\netware\*.dd!) do copy %%f c:\aha398x\netware\*.ddi


del c:\aha398x\netware\*.??_
del c:\aha398x\netware\*.??!

REM if NOT exist c:\aha398x\netware\*.txt goto fail
if NOT exist c:\aha398x\netware\*.nlm goto fail
if NOT exist c:\aha398x\netware\*.msg goto fail
if NOT exist c:\aha398x\netware\*.def goto fail


if NOT exist c:\aha398x\netware\*.txt goto fail
if NOT exist c:\aha398x\netware\*.dsk goto fail
if NOT exist c:\aha398x\netware\*.ddi goto fail

goto success


:fail
@echo.
@echo Unable to decompress the installation utility to your hard drive.
@echo Please make sure your C: drive has at least 500K of free disk space.
@echo.

:success
@echo All files successfully copied to C:
@echo Refer to the Quick Install Guide for the next step.
goto end

:no_parameter
@echo.
@echo Please specify the version of NetWare by typing
@echo install 3 for V3.1X or install 4 for V4.XX 
@echo.
goto end

:chgdrive
@echo.
@echo Please change to the drive and directory where the installation program
@echo resides, then type INSTALL 3 or Install 4.
@echo.

:end
