/**********************************************************************
* Module   : TOINTKIT.H
* Part of  : TeamOFFICE Integration Kit 3.0
* Abstract : The function declarations for TOINTKIT.DLL.
*
*     Copyright (C) 1994 International Computers Limited
***********************************************************************

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

/***** PUBLIC DEFINES ***************************/

/* Message types */
#define MSGTYPE_STATUS    0
#define MSGTYPE_NOTE      1
#define MSGTYPE_QUESTION  2
#define MSGTYPE_ERROR     3

/***** PUBLIC FUNCTION DECLARATIONS *************/

/* TeamOFFICE program starting functions */
BOOL CALLBACK TOIStartMail(void);
BOOL CALLBACK TOIStartLibrary(void);
BOOL CALLBACK TOIStartCalendar(void);
BOOL CALLBACK TOIStartForum(void);
BOOL CALLBACK TOIStartAssistant(void);
BOOL CALLBACK TOIStartFlowStarter(void);

/* Program activation functions */
BOOL CALLBACK TOIStartOrActivateProgram(LPSTR lpszExeFileName);
BOOL CALLBACK TOIIsRunning(LPSTR lpszExeFileName);
BOOL CALLBACK TOIActivateRunningProgram(LPSTR lpszExeFileName);
HWND CALLBACK TOIGetMainWindow(LPSTR lpszExeFileName);

/* Program path information services */
LPSTR CALLBACK TOIGetFlowStarterFullPath(void);

/* Session control functions */
BOOL CALLBACK TOILogin(BOOL fShowMessages);
BOOL CALLBACK TOILogout(BOOL fShowMessages);

/* Data passing services */
BOOL CALLBACK TOISendMail(LPSTR lpszSubject, LPSTR lpszAttachmentFiles,
                          LPSTR lpszRecipients, BOOL fMsgOnClipboard);
BOOL CALLBACK TOIWriteToForum(LPSTR lpszSubject, LPSTR lpszAttachmentFiles, 
                              LPSTR lpszKeywords, BOOL fMsgOnClipboard);
BOOL CALLBACK TOISaveInLibrary(LPSTR lpszName, LPSTR lpszAttachmentFiles, 
                               LPSTR lpszKeywords, LPSTR lpszDescription);
BOOL CALLBACK TOIInsertToAssistant(LPSTR lpszTitle, LPSTR lpszFile);
BOOL CALLBACK TOIFlowStart(LPSTR lpszSubject, LPSTR lpszAttachmentFiles);

/* Error message services */
int CALLBACK TOIShowMessage(int nMsgId, int nType, LPSTR lpszDetailStr);

/* TOINTKIT.INI file handling */
LPSTR CALLBACK TOIGetProfileString(LPSTR lpszSection, LPSTR lpszEntry);

/* Default printer service */
LPSTR CALLBACK TOIDefaultToFaxDriver(void);
LPSTR CALLBACK TOIDefaultToOriginalDriver(LPSTR lpszPrinter);

#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif  /* __cplusplus */
