/* REXX program to 1) make Workplace Shell object for PMView, 2) unzip
filters, and 3) create NEWVARS.CMD and/or append to CONFIG.SYS */

'cls'

say "Welcome to the PMView installer."
say "This program will do the following:"
say ""

say "1) It will create a desktop icon for PMView, complete with"
say "   filename associations (so you can double-click on an image"
say "   filename in a drives object to automatically start PMView"
say '   and view that image). The icon will be named "PMView90", since'
say "   we do not want to overwrite any customized PMView icon you"
say "   might have on the desktop."
say ""
say "2) It will unzip the transformation filters."
say ""
say "3) It will append three SET statements to your CONFIG.SYS file."
say ""
say "It will ask your permission before doing any of these steps. If you'd"
say "rather do these steps yourself, please read the file DIY.TXT."
say ""

reply = GetYesNo("Have you unzipped the PMView ZIP file yet")
if \reply then do
   say ""
   say "Please unzip the ZIP file into the current directory and then re-run"
   say "this program."
   say ""
   say "Bye for now."
   exit
   end

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

fullpath=Directory()
if right(fullpath, 1) \= "\" then do
   fullpath = fullpath || "\"
   end
say
say "Okay. Is" fullPath
reply = GetYesNo("the directory where you want to install PMView")
if \reply then do
   say "Please create the directory for PMView, unzip the ZIP file"
   say "there, and run this program from that directory."
   say ""
   say "Bye for now."
   exit
   end

say
say "Good. Should I create a desktop icon for PMView, complete with"
reply = GetYesNo("associations")
if reply then do
   drop res.
   call SysFileTree fullpath || "PMVIEW.EXE", res, "OF"
   if res.1 = "RES.1" then do
      say "Hmm, I can't find PMView.EXE here...."
      say "I'm afraid I'll have to stop."
      say
      say "Please make sure to unzip PMView into this directory and"
      say "re-run this program."
      exit
      end
   else do
      assoc = '*.BMP,*.EPS,*.GIF,*.JPG,*.PBM,*.PCD,*.PCX,*.PIC,*.PGM,' ||,
              '*.PPM,*.SHW,*.TGA,*.TIF,'
      Call SysCreateObject 'WPProgram','PMView90','<WP_DESKTOP>','CCVIEW=YES;EXENAME='||fullpath||'\PMVIEW.EXE;PROGTYPE=PM;PARAMETERS=%*;STARTUPDIR='||fullpath||';ASSOCFILTER='||assoc,'R'
      Say "Okay, I've created a desktop icon for PMView."
      end
   end

drop filterPath
say
reply = GetYesNo("Do you have Info-Zip's unzip.exe on your path")
if \reply then do
   say "Then I'm afraid I will not be able to set up the filters."
   say "See DIY.TXT for instructions on doing this by hand."
   end
else do
   reply = GetYesNo("Good. Should I set up the transformation filters")
   if reply then do
      drop res.
      filterPath = fullPath || "filters"
      call SysFileTree filterPath, res, "OD"
      if res.1 = "RES.1" then do
         'md filters'
         drop res.
         call SysFileTree filterPath, res, "OD"
         if res.1 = "RES.1" then do
            say
            say "I'm sorry, but I can't seem to create the directory"
            say filterPath
            say "I'm afraid I will have to stop."
            say "Please create this directory for me and re-run"
            say "this program."
            say
            say "Bye for now."
            exit
            end
         end
      'cd filters&&unzip -o -qq ../filters&&cd ..'
      end
   end

'@if exist newvars.cmd del newvars.cmd'
call lineout "newvars.cmd", "set pmview_ini=" || fullPath || "pmview.ini"
call lineout "newvars.cmd", "set pmview_help=" || fullpath
if filterPath = "FILTERPATH" then do
   filterPath = fullPath
   end
call lineout "newvars.cmd", "set pmview_filter=" || filterPath
say
say "Okay. Before you run PMView, you need to set 3 environment variables."
reply = GetYesNo("May I append these to your CONFIG.SYS file")
if reply then do
   configName = "\CONFIG.SYS"
   configLen = length(configName)
   reply = GetYesNo("Is your OS/2 CONFIG.SYS file on drive C:")
   if reply then do
      configPath = "c:"
      end
   else do
      configPath = "unknown"
      end
   do until res.1 \= "RES.1"
      if right(configPath, configLen) \= configName then do
         configPath = configPath || configName
         end
      drop res.
      call SysFileTree configPath, res, "OF"
      if res.1 = "RES.1" then do
         say "I can't find" || ' "' || configPath || '".'
         say "In response to the following question, please enter a full" ||,
             " path."
         say "For example, you might enter H:\CONFIG.SYS"
         call charout, "Where does OS/2 find CONFIG.SYS when it boots? "
         pull configPath
         drop res.
         call SysFileTree configPath, res, "OF"
         if res.1 = "RES.1" then do
            say "Yow! I can't find that file!"
            say
            end
         end
      end /* loop*/
   cBaq = left(configPath, length(configPath) - 3) || "baq"
   drop res.
   call SysFileTree cBaq, res, "OF"
   if res.1 \= "RES.1" then do
      call CantBaqup
      end
   else do
      'copy' configPath cBaq
      drop res.
      call SysFileTree cBaq, res, "OF"
      if res.1 = "RES.1" then do
         call CantBaqup
         end
      else do
         call lineout configPath, "rem *** Set up 3 environment" ||,
                                  " variables for PMView"
         call lineout configPath, "set pmview_ini=" || fullPath || "pmview.ini"
         call lineout configPath, "set pmview_help=" || fullpath
         call lineout configPath, "set pmview_filter=" || filterPath
         call lineout configPath
         say
         say "Okay, I've updated CONFIG.SYS"
         say "I've saved a copy of the old version in CONFIG.BAQ in your"
         say "boot directory."
         say "Please shutdown and reboot OS/2 after this installation program"
         say "is done."
         end
      end
   end
else do
   say
   say "Well, all right then."
   say 'You can enter "NEWVARS" at the OS/2 prompt to set the variables'
   say "correctly -- but this will work only for the current OS/2"
   say "session."
   say
   say "To set the variables permanently, for all OS/2 sessions, please"
   say "add the lines from NEWVARS.CMD to your CONFIG.SYS file."
   end

say
say "Should PMView register itself with OS/2 as a TAP client?"
say "You should answer YES if you want TAP servers (such as the LiveWire"
say "communications program) start PMView and use it to view images."
say "To register as a TAP client, PMView will have to write to your"
say "OS/2 system INI file. THIS IS THE ONLY TIME PMVIEW WILL EVER"
say "WRITE TO YOUR SYSTEM FILES."
reply = GetYesNo("Should PMView register itself as a TAP client")
if reply then do
   'PMVIEW /TAP=REG'
   end
else do
   say "Okay. If you want PMView to register itself later, please enter"
   say "   pmview /TAP=REG"
   say "at an OS/2 command prompt."
   end

say
say "If you added a desktop icon, with associations, I recommend that you"
say "remove any other associations that these file types may have."
say "Basically: If you double-click an image, and some program other"
say "than PMView starts up (and you want PMView to start up), please"
say "remove the association from that other program."
say
say "(For instance, OS/2 defaults to attaching *.BMP/Bitmap associations to"
say "the Icon Editor, and Warp also attaches them to Windows Paintbrush."
say
say "Whew! We're done! Thanks for your patience, and thanks for your"
say "interest in PMView!"

exit

GetYesNo: procedure
ok = 0
do until ok
   call charout, arg(1) || "? "
   pull reply
   reply = left(reply, 1)
   ok = (reply = "Y") | (reply = "N")
   if \ok then do
      say
      say 'Huh? Please enter "Y" or "N".'
      end
   end /* loop */
return (reply = "Y")

CantBaqup: procedure
say d2c(7) d2c(7)
say "Ouch! I cannot make a backup copy of CONFIG.SYS."
say "Therefore, to be safe, I will not modify your CONFIG.SYS file."
say "PLEASE edit CONFIG.SYS by hand, and add the 3 lines"
say "from NEWVARS.CMD."

return
