//
// TAP
// Sample Application
// Revision 1.10
//
//  1/5/95    First created
//
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "tapapp.h"

//
// void RegisterSampleApplication(char *szProgramPath);
//
// Registers the TAP application so that any
// TAP server on the system can find it. This function
// need only be called once.
//
// Parameters:
// szProgramPath
//   Fully qualified path to the executable. Must include .EXE
//   extension.
//   EX: C:\TAPSAMP.EXE
//
// Returns: Nothing
//
void RegisterSampleApplication(char *szProgramPath)
{
TAPAPPENTRY TapAppEntry;

	// Fill in information structure
	TapAppEntry . cb = sizeof(TAPAPPENTRY);

	// Each TAP application can have a description
	// up to 256 characters and 6 lines long
	strcpy(TapAppEntry . szDescription,
				"This is a sample TAP application "      //
				"used for development purposes.\n\r\n\r" //
				"Each file encountered is displayed "    //
				"along with its data as the transfer "   //
				"progresses." );

	// Any extra parameters needed to be passed go here
	strcpy(TapAppEntry . szParams, "");

	strcpy(TapAppEntry . szProgram,
				szProgramPath);

   // No extensions for this application
   TapAppEntry . ulExtensions = 0;

	//
	// Register this TAP application
	//
	// This registration can be removed later with
	// DeRegisterApplication_TAP
	//
	if (!RegisterApplication_TAP("TAP Development Sample",
											 &TapAppEntry))
		printf("Error : Could not register TAP application\n");
	else
		printf("Application registered successfully\n");

}

//
// void ProcessData(HFILE TAPFile,
//						  long lCurrentFileSize);
//
// This function is called when new data needs to
// be processed by the TAP application. This is the
// place where a GIF viewer might interpret new data
// and display it as a picture on the screen.
//
// The code here is only a sample of what can be done,
// and if you are basing your TAP application on this
// source it's best if you replace this entire function.
//
// Parameters:
// TAPFile
//   OS/2 file handle (for use with Dosxxx commands)
//   that has read-only access to the file being
//   transferred.
// lCurrentFileSize
//   The current file size. Attempts to read past
//   past this point will normally fail.
//
// Returns: Nothing
//
void ProcessData(HFILE TAPFile,
						long lCurrentFileSize)
{
unsigned char szBuf[10];
ULONG BytesRead;
APIRET rc = 0;
int cnter;

	// Seek to the end of the file,
	// minus ten bytes
	rc |=
		DosSetFilePtr(TAPFile,
			lCurrentFileSize - 10,
			FILE_BEGIN,
			&BytesRead);

	// Read those ten last bytes
	rc |=
		DosRead(TAPFile,
		  szBuf,
		  10,
		  &BytesRead);

	// If we didn't read ten bytes,
	// there was an error
	if (BytesRead<10)
			rc = 1;

	if (rc)
		// Something went wrong
		printf("%8d : error reading\n", lCurrentFileSize);
	else
	{
		// Print current file size
		printf("%8d Data :", lCurrentFileSize);

		// And then display last 10 bytes of data
		// in hexidecimal format
		for (cnter=0; cnter<10; cnter++)
			printf(" %2.2X", szBuf[cnter]);

		// Carriage return: don't fill up the
		// screen w
		printf("%c",13);
		// Need to flush if our compiler has buffered output
		// (Note that buffered output is only flushed for LF, not CR !)
		fflush (stdout);
	}
}

//
// int main(int argc, char **argv);
//
// Main TAP function.
//
// This function registers the TAP
// application, then attempts to start
// a TAP session.
//
// The standard structure of a TAP
// application must be:
//
// Initialize();
// while (NextFile)
//	{
//		OpenFile();
//    while (MoreData)
//			ProcessData();  <-- Here's where your
//    ProcessData();     <-- application does its work
//		CloseFile();
//  }
// DeInitialize();
//
// Parameters:
// It's important to have the argc
// and argv information around because
// TAP initialize must parse the
// command line.
//
// Returns: Return value unimportant to TAP
//
int main(int argc, char **argv)
{
PTAPAPPINFO pTapAppInfo;      // TAP instance data structure
										// (You needn't worry about this)

	//
	// Attempt to register this application so
	// TAP servers can see it.
	//
	// The full path, as below, must be passed.
	// The program name is kept in argv[0] (ANSI standard)
	// but some compilers handle this differently.
	//
	// Borland C will give you the fully qualified path
	// while CSet will give you only the application name
	// typed at the command prompt.
	//
	// If you're one of those lucky people who are only
	// passed the file name you can construct a fully qualified
	// path name by calling DosQueryPathInfo with 2nd parameter
	// of FIL_QUERYFULLNAME.
	//

	// Les: I suggest you *always* call DosQueryPathInfo even though
   //      Borland C already gives you the full name: DosQueryPathInfo
   //      makes sure that the returned path is valid, etc. etc...

	{  CHAR szFullPath[CCHMAXPATH];
		strcpy (szFullPath, argv[0]);
		if (!strchr (szFullPath, '.'))
			strcat (szFullPath, ".EXE");
		DosQueryPathInfo (szFullPath, FIL_QUERYFULLNAME, szFullPath, sizeof (szFullPath));
		RegisterSampleApplication(szFullPath);
		}

	// Initialize the TAP subsystem
	pTapAppInfo = InitializeApplication_TAP(argc, argv);

	// On success we get a non-NULL pointer back
	if (pTapAppInfo)
	{
		CHAR szBuffer[32];
		printf("Application initialized successfully\n\n");

		QueryServerVersion_TAP (pTapAppInfo, szBuffer, sizeof (szBuffer));

		printf ("Server Version: %s\n", szBuffer);

		// NextFile_TAP will wait for the next file to arrive.
		// If no more files are pending, NextFile_TAP will
		// return FALSE, otherwise TRUE
		while (NextFile_TAP(pTapAppInfo))
		{
		char szFileName[CCHMAXPATH];
		long lCompleteFileSize;
		long lCurrentFileSize;
		HFILE TAPFile;

			// Get the fully qualified name of the file
			QueryFileName_TAP(pTapAppInfo, szFileName);

			// Get the complete size of the file
			// -1 (TAP_SIZE_UNKNOWN) if we don't know it
			lCompleteFileSize = QueryCompleteSize_TAP(pTapAppInfo);

			// Display status
			printf("File : %s of size %d\n",
						szFileName,
						lCompleteFileSize);

			// Open the TAP file. The file must be opened
			// using this TAP API so file sharing can take place
			if (!OpenFile_TAP(pTapAppInfo, &TAPFile))
				printf("Error opening file!\n");

			// MoreData_TAP waits until new data has been
			// written to the file.
			//
			// If the end of file has been reached, or
			// the transfer has been cancelled MoreData_TAP
			// returns FALSE, otherwise TRUE.
			while (MoreData_TAP(pTapAppInfo))
			{
				// Get the current file size
				// This will always be different from the last time
				lCurrentFileSize = QueryCurrentSize_TAP(pTapAppInfo);

				// Now process any new data
				ProcessData(TAPFile,
								lCurrentFileSize);
			}

			// Determine complete file length,
			// which may have changed if the
			// file was cut short
			DosSetFilePtr(TAPFile,
								0,
								FILE_END,
								(PULONG)(PVOID)&(lCompleteFileSize));

			// There may be some data we didn't
			// finish processing. Process all
			// data before opening a new file
			ProcessData(TAPFile,
							lCompleteFileSize);

			printf("\nFile complete at %d bytes\n\n", lCompleteFileSize);

			// Close the file: processing complete
			CloseFile_TAP(pTapAppInfo, TAPFile);
		}

		// We've dropped out of the main loop
		// so there are no more files
		printf("Transfer complete.\n");

		// Deinitialize the TAP application
		DeInitializeApplication_TAP(pTapAppInfo);
	}
	 else
	{
		printf("Error : Cannot initialize TAP application\n\n");
		printf("Start this application from a TAP server\n");
	}

	return 0;
}

