#ifndef _TAPAPP
#define _TAPAPP
//
// TAPAPP.H
//
// TAP
// File Transfer Data Sharing
// Application Code
// Revision 1.00
//
// 12/28/94
//
#define TAP_APP_VERSION 	"Sample"   // Max 30 chars
#include "tap.h"

typedef struct _TAPINFO
{
	ULONG  ulFlags;
	UCHAR  szFileName[CCHMAXPATH];  // Fully qualified file name
	LONG   lCurrentFileSize;        // Partial current size of the file
	LONG   lCompleteFileSize;       // Size the file will be when complete (-1 if unknown)
} TAPINFO, *PTAPINFO;

typedef struct _TAPAPPINFO
{
	ULONG cb;              // Number of bytes in this structure

	HMTX hAppMutex;		  // Semaphore for controlling access
	HFILE hReadPipe;		  // Pipe write handle
	HFILE hUserFile;       // Handle to shared file

	TID tidTAP;				  // Thread ID of the TAP code
	long lShutdown;		  // True if the TAP code should shut down

	TAPINFO tiCurrent;	  // Current data packet received over the pipe
	TAPINFO tiNext;	 	  // Next data packet received over the pipe

	UCHAR szVersion[32];   // Server version string
	LONG	lVersionAvailable; // True if version recieved from the server

} TAPAPPINFO, *PTAPAPPINFO;

//
// For information on the functions
// prototyped below see TAPAPP.C
//
PTAPAPPENTRY BuildTapAppEntry_TAP(char *szDescription,
                                  char *szProgram,
                                  char *szParams,
                                  PSZ pszExtension[],
                                  ULONG ulNumExtensions);

int RegisterApplication_TAP(char *szAppName,
									 PTAPAPPENTRY pTapAppEntry);

int DeRegisterApplication_TAP(char *szAppName);

int OpenFile_TAP(PTAPAPPINFO pTapAppInfo, PHFILE phFile);

int CloseFile_TAP(PTAPAPPINFO pTapAppInfo, HFILE hFile);

PTAPAPPINFO InitializeApplication_TAP(int argc, char **argv);

int DeInitializeApplication_TAP(PTAPAPPINFO pTapAppInfo);

int NextFile_TAP(PTAPAPPINFO pTapAppInfo);

int MoreData_TAP(PTAPAPPINFO pTapAppInfo);

long QueryStatus_TAP(PTAPAPPINFO pTapAppInfo);

int QueryServerVersion_TAP(PTAPAPPINFO pTapAppInfo,
									char *szVersion,
									ULONG ulBufLen); 

int QueryFileName_TAP(PTAPAPPINFO pTapAppInfo,
								char *szFileName);

long QueryCompleteSize_TAP(PTAPAPPINFO pTapAppInfo);

long QueryCurrentSize_TAP(PTAPAPPINFO pTapAppInfo);

void ApplicationThread_TAP(void *AppInfo);

#endif
