#define NOCOMM
#define NOMINMAX
#define _WINDOWS
#define _WINDLL

#include <windows.h>
#include <swtype.h>
#include <swin.h>
#include <sql.h>
#include <sqlsrv.h>


#define SHOW_FONTS  0
#define SHOW_SIZES  1
#define CREATE_FONT 2


typedef struct {
	       int     iOperation;
	       LONG    lElements;
	       HARRAY  hArray;
	       int     iHeight;
	       HFONT   hFont;
	       BOOL    bItalic;
	       BOOL    bStrikeOut;
	       BOOL    bBold;
	       BOOL    bUnderline;
	       HDC     hDC;
	       } ENUMFUNCDATA;


BOOL	   FAR PASCAL CommandType	    (char, LPHSTRING);
HFONT	   FAR PASCAL ditCreateFont	    (HWND, LPSTR, int, BOOL, BOOL,
					     BOOL, BOOL);
INT	   FAR PASCAL EnumFunc		    (LPLOGFONT, LPTEXTMETRIC, short,
					     ENUMFUNCDATA FAR *);
SQLTAPI    FAR PASCAL GetCursorInfo	    (LPSTR, LPSTR,
					     HARRAY, HARRAY, HARRAY,
					     HARRAY, HARRAY, HARRAY,
					     HARRAY, HARRAY, HARRAY,
					     HARRAY, HARRAY, HARRAY);
int	   FAR PASCAL LibMain		    (HANDLE, WORD, WORD, LPSTR);
VOID	   FAR PASCAL LoadhStringArray	    (HARRAY, LONG, LPSTR);
VOID	   FAR PASCAL LoadNumberArray	    (HARRAY, LONG, WORD);
INT	   FAR PASCAL OedPixelsToPoints     (INT, HDC);
BOOL	   FAR PASCAL SetLPHSTRING	    (LPHSTRING, LPSTR);
VOID	   FAR PASCAL WEP		    (int);


FARPROC lpfnEnumFunc;


int FAR PASCAL EnumFunc (lpLogFont, lpTextMetrics, nFontType, lpData)

  LOGFONT      far *lpLogFont;
  TEXTMETRIC   far *lpTextMetrics;
  short 	    nFontType;
  ENUMFUNCDATA far *lpData;

  {
  HSTRING   hString;
  NUMBER    number;
  LPSTR     lpszString;
  LONG	    lDummy;

  nFontType;

  switch (lpData->iOperation) {
    case SHOW_FONTS:

      SalSetArrayBounds (lpData->hArray, 0L, lpData->lElements);
      SWinArrayGetHString (lpData->hArray, lpData->lElements, &hString);
      SalStrSetBufferLength (&hString,
	(long) lstrlen (lpLogFont->lfFaceName) + 1);
      lpszString = SWinHStringLock (hString, &lDummy);
      lstrcpy (lpszString, lpLogFont->lfFaceName);
      SWinArrayPutHString (lpData->hArray, lpData->lElements++, hString);
      SWinHStringUnlock (hString);

      return TRUE;

    case SHOW_SIZES:

      SalSetArrayBounds (lpData->hArray, 0L, lpData->lElements);
      SWinArrayGetNumber (lpData->hArray, lpData->lElements, &number);

      SWinCvtIntToNumber (OedPixelsToPoints (lpTextMetrics->tmHeight -
			    lpTextMetrics->tmInternalLeading,
			    lpData->hDC),
			  &number);

      SWinArrayPutNumber (lpData->hArray, lpData->lElements++, &number);

      return TRUE;

    case CREATE_FONT:

      /*
      If this font is the height we're looking for, go ahead and create a
      font with the specified characteristics.	Otherwize return TRUE so
      EnumFunc will be called again with next size.
      */

      if (lpData->iHeight ==
	  OedPixelsToPoints (lpTextMetrics->tmHeight -
			     lpTextMetrics->tmInternalLeading,
			     lpData->hDC)) {
	lpLogFont->lfItalic = (BYTE) lpData->bItalic;
	lpLogFont->lfStrikeOut = (BYTE) lpData->bStrikeOut;
	if (lpData->bBold) {
	  lpLogFont->lfWeight = 700;
	  }
	lpLogFont->lfUnderline = (BYTE) lpData->bUnderline;
	lpData->hFont = CreateFontIndirect (lpLogFont);
	return FALSE;
	}
      else {
	return TRUE;
	}

    default:
      return FALSE;
    }
  }


HFONT FAR PASCAL ditCreateFont (hWnd, lpszFont, iHeight, bItalic,
				bStrikeOut, bBold, bUnderline)

  HWND	hWnd;
  LPSTR lpszFont;
  int	iHeight;
  BOOL	bItalic, bStrikeOut, bBold, bUnderline;

  {
  HDC		 hDC;
  ENUMFUNCDATA	 enumfuncdata;

  hDC = GetDC (hWnd);

  /*
  Indicate to EnumFunc that we need a font created.  EnumFunc will
  be called until it finds the right size.  It will then create the
  font and return FALSE terminating the call-back cycle.
  */

  enumfuncdata.iOperation = CREATE_FONT;
  enumfuncdata.iHeight	  = iHeight;
  enumfuncdata.bItalic	  = bItalic;
  enumfuncdata.bStrikeOut = bStrikeOut;
  enumfuncdata.bBold	  = bBold;
  enumfuncdata.bUnderline = bUnderline;
  enumfuncdata.hDC	  = hDC;
  EnumFonts (hDC, lpszFont, lpfnEnumFunc, (LPSTR) &enumfuncdata);

  ReleaseDC (hWnd, hDC);
  return enumfuncdata.hFont;
  }


BOOL FAR PASCAL SetLPHSTRING (lphString, lpString)

  LPHSTRING lphString;
  LPSTR     lpString;

  {
  LPSTR lpszString;
  LONG	lDummy;

  if (!SWinInitLPHSTRINGParam (lphString, (LONG) lstrlen (lpString) + 1)) {
    return FALSE;
    }
  lpszString = SWinHStringLock (*lphString, &lDummy);
  lstrcpy (lpszString, lpString);
  SWinHStringUnlock (*lphString);
  return  TRUE;
  }


BOOL FAR PASCAL CommandType (cCommandType, lphCommandType)

  char	    cCommandType;
  LPHSTRING lphCommandType;

  {
  switch (cCommandType) {
    case SQLTSEL:
      return SetLPHSTRING (lphCommandType, "SELECT");
    case SQLTINS:
      return SetLPHSTRING (lphCommandType, "INSERT");
    case SQLTCTB:
      return SetLPHSTRING (lphCommandType, "CREATE TABLE");
    case SQLTUPD:
      return SetLPHSTRING (lphCommandType, "UPDATE");
    case SQLTDEL:
      return SetLPHSTRING (lphCommandType, "DELETE");
    case SQLTCIN:
      return SetLPHSTRING (lphCommandType, "CREATE INDEX");
    case SQLTDIN:
      return SetLPHSTRING (lphCommandType, "DROP INDEX");
    case SQLTDTB:
      return SetLPHSTRING (lphCommandType, "DROP TABLE");
    case SQLTCMT:
      return SetLPHSTRING (lphCommandType, "COMMIT");
    case SQLTRBK:
      return SetLPHSTRING (lphCommandType, "ROLLBACK");
    case SQLTACO:
      return SetLPHSTRING (lphCommandType, "ADD COLUMN");
    case SQLTDCO:
      return SetLPHSTRING (lphCommandType, "DROP COLUMN");
    case SQLTRTB:
      return SetLPHSTRING (lphCommandType, "RENAME TABLE");
    case SQLTRCO:
      return SetLPHSTRING (lphCommandType, "RENAME COLUMN");
    case SQLTMCO:
      return SetLPHSTRING (lphCommandType, "MODIFY COLUMN");
    case SQLTGRP:
      return SetLPHSTRING (lphCommandType, "GRANT PRIVILEGE ON TABLE");
    case SQLTGRD:
      return SetLPHSTRING (lphCommandType, "GRANT DBA");
    case SQLTGRC:
      return SetLPHSTRING (lphCommandType, "GRANT CONNECT");
    case SQLTGRR:
      return SetLPHSTRING (lphCommandType, "GRANT RESOURCE");
    case SQLTREP:
      return SetLPHSTRING (lphCommandType, "REVOKE PRIVILEGE ON TABLE");
    case SQLTRED:
      return SetLPHSTRING (lphCommandType, "REVOKE DBA");
    case SQLTREC:
      return SetLPHSTRING (lphCommandType, "REVOKE CONNECT");
    case SQLTRER:
      return SetLPHSTRING (lphCommandType, "REVOKE RESOURCE");
    case SQLTCOM:
      return SetLPHSTRING (lphCommandType, "COMMENT ON");
    case SQLTWAI:
      return SetLPHSTRING (lphCommandType, "WAIT");
    case SQLTPOS:
      return SetLPHSTRING (lphCommandType, "POST");
    case SQLTCSY:
      return SetLPHSTRING (lphCommandType, "CREATE SYNONYM");
    case SQLTDSY:
      return SetLPHSTRING (lphCommandType, "DROP SYNONYM");
    case SQLTCVW:
      return SetLPHSTRING (lphCommandType, "CREATE VIEW");
    case SQLTDVW:
      return SetLPHSTRING (lphCommandType, "DROP VIEW");
    case SQLTRCT:
      return SetLPHSTRING (lphCommandType, "ROW COUNT");
    case SQLTAPW:
      return SetLPHSTRING (lphCommandType, "ALTER PASSWORD");
    case SQLTLAB:
      return SetLPHSTRING (lphCommandType, "LABEL ON");
    case SQLTCHN:
      return SetLPHSTRING (lphCommandType, "CHAINED COMMAND");
    case SQLTRPT:
      return SetLPHSTRING (lphCommandType, "REPAIR TABLE");
    case SQLTSVP:
      return SetLPHSTRING (lphCommandType, "SAVEPOINT");
    case SQLTRBS:
      return SetLPHSTRING (lphCommandType, "ROLLBACK TO SAVEPOINT");
    case SQLTUDS:
      return SetLPHSTRING (lphCommandType, "UPDATE STATISTICS");
    case SQLTCDB:
      return SetLPHSTRING (lphCommandType, "CHECK DATABASE");
    default:
      return FALSE;
    }
  }


VOID FAR PASCAL LoadhStringArray (hArray, lElement, lpString)

  HARRAY hArray;
  LONG	 lElement;
  LPSTR  lpString;
  {

  HSTRING hString;
  LONG	  lDummy;
  LPSTR   lpszString;

  SWinArrayGetHString (hArray, lElement, &hString);
  SalStrSetBufferLength (&hString, (long) lstrlen (lpString) + 1);
  lpszString = SWinHStringLock (hString, &lDummy);
  lstrcpy (lpszString, lpString);
  SWinHStringUnlock (hString);
  SWinArrayPutHString (hArray, lElement, hString);
  }


VOID FAR PASCAL LoadNumberArray (hArray, lElement, w)

  HARRAY hArray;
  LONG	 lElement;
  WORD	 w;
  {
  NUMBER number;

  SWinCvtWordToNumber (w, &number);
  SWinArrayPutNumber  (hArray, lElement, &number);
  }


SQLTRCD FAR PASCAL GetCursorInfo (lpszServer, lpszPassword,
				  currow, curibl, curobl,
				  curspr, curspw, cursvr,
				  cursvw, curtyp, curpnm,
				  curiso, curunb, curdbn)

  LPSTR  lpszServer, lpszPassword;
  HARRAY currow, curibl, curobl,
	 curspr, curspw, cursvr,
	 cursvw, curtyp, curpnm,
	 curiso, curunb, curdbn;

  {
  SQLTRCD rcd;
  SQLTSVH shandle;
  HANDLE  hlpBuffer;
  LPVOID  lpBuffer;
  SQLTDAL rbuflen;
  hdrdef  FAR *lphdrdef;
  mshdef  FAR *lpmshdef;
  curdef  FAR *lpcurdef;
  int	  mshnen = 0;
  NUMBER  number;

  if (rcd = sqlcsv (&shandle, lpszServer, lpszPassword)) {
    return rcd;
    }

  if (NULL != (hlpBuffer = GlobalAlloc (GHND, 1024L))) {
    lpBuffer = (LPVOID) GlobalLock (hlpBuffer);

    if (rcd = sqlgsi (shandle, SQLGCUR, (SQLTDAP) lpBuffer, 1024, &rbuflen)) {
      return rcd;
      }

    lphdrdef = lpBuffer;
    lpmshdef = (mshdef FAR *) ((BYTE FAR *) lpBuffer + HDRSIZ);
    lpcurdef = (curdef FAR *) ((BYTE FAR *) lpmshdef + MSHSIZ);

    SalSetArrayBounds (currow, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curibl, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curobl, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curspr, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curspw, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (cursvr, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (cursvw, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curtyp, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curpnm, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curiso, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curunb, 0L, (LONG) (lpmshdef->mshnen - 1L));
    SalSetArrayBounds (curdbn, 0L, (LONG) (lpmshdef->mshnen - 1L));

    while (mshnen++ < (lpmshdef->mshnen)) {

      SWinCvtLongToNumber (lpcurdef->currow, &number);
      SWinArrayPutNumber  (currow, (LONG) mshnen - 1, &number);

      LoadNumberArray (curibl, (LONG) mshnen - 1, lpcurdef->curibl);
      LoadNumberArray (curobl, (LONG) mshnen - 1, lpcurdef->curobl);
      LoadNumberArray (curspr, (LONG) mshnen - 1, lpcurdef->curspr);
      LoadNumberArray (curspw, (LONG) mshnen - 1, lpcurdef->curspw);
      LoadNumberArray (cursvr, (LONG) mshnen - 1, lpcurdef->cursvr);
      LoadNumberArray (cursvw, (LONG) mshnen - 1, lpcurdef->cursvw);

      LoadNumberArray (curtyp, (LONG) mshnen - 1, (WORD) lpcurdef->curtyp);
      LoadNumberArray (curpnm, (LONG) mshnen - 1, (WORD) lpcurdef->curpnm);

      LoadhStringArray (curiso, (LONG) mshnen - 1, lpcurdef->curiso);
      LoadhStringArray (curunb, (LONG) mshnen - 1, lpcurdef->curunb);
      LoadhStringArray (curdbn, (LONG) mshnen - 1, lpcurdef->curdbn);

      lpcurdef++;
      }

    sqldsv (shandle);
    GlobalUnlock (hlpBuffer);
    GlobalFree (hlpBuffer);
    }
  }


int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
			LPSTR lpszCmdLine)
   {
   hInstance;
   lpszCmdLine;

   if (wHeapSize == 0)
      return(FALSE);

   lpfnEnumFunc = MakeProcInstance (EnumFunc, hInstance);

   return (LocalInit (wDataSeg, NULL, wHeapSize));
   }


INT FAR PASCAL OedPixelsToPoints (nPixels, hDC)

  int nPixels;
  HDC hDC;

  {
  int nLogPixelsY = GetDeviceCaps( hDC, LOGPIXELSY );
  return( (int)((((LONG)nPixels * 10000) / nLogPixelsY * 72 + 5000) / 10000) );
  }


VOID FAR PASCAL WEP (bSystemExit)

  int  bSystemExit;

  {
  bSystemExit;
  FreeProcInstance (lpfnEnumFunc);
  return;
  }


