Application Description: Autosave Sample application
		
		Can be used to launch applications with command line parameters also
		
		Example:  You want to start FOO.APP and autosave it every 10 minutes
		
		Directions:
		1. In program manager setup an Icon with the following...
		
		Description: FOO with Autosave
		Command Line: AUTOSAVE.EXE /a FOO.APP /t 10
		
		Command line parameters
		/a APPNAME.APP - The application to autosave
		/t n - the number of minutes between autosave's optional - defaults to 5
		
		The parameters do not have to be specified in any specific order
	Outline Version - 4.0.22
	Design-time Settings
		Outline Window State: Maximized
		Outline Window Location and Size
.data VIEWINFO
0000: 6600020000001B00 0200000000001301 E5008B1F760F0500 1D00FFFF4D61696E
0020: 001E000000000000 002602CA019E205C 1000000100FFFF66 726D4D61696E00
.enddata
.data VIEWSIZE
0000: 3F00
.enddata
			Left:   0.05"
			Top:    0.063"
			Width:  7.888"
			Height: 2.25"
		Options Box Location
.data VIEWINFO
0000: C438C50DB80B2600
.enddata
.data VIEWSIZE
0000: 0800
.enddata
			Visible? Yes
			Left:   5.125"
			Top:    2.906"
			Width:  3.763"
			Height: 3.052"
		Class Editor Location
			Visible? No
			Left:   Default
			Top:    Default
			Width:  Default
			Height: Default
		Tool Palette Location
			Visible? No
			Left:   3.775"
			Top:    4.042"
		Fully Qualified External References? No
		Reject Multiple Window Instances? No
		Enable Runtime Checks Of External References? No
		Use Release 4.0 Scope Rules? Yes
		! Outline Browser Location
			                Visible? No
			                Left:   Default
			                Top:    Default
			                Width:  Default
			                Height: Default
	Libraries
		Select From: date.apl
			Class Definitions
			Constants
		Select From: assert.apl
			Class Definitions
	Global Declarations
		Window Defaults
			Tool Bar
				Display Style? Etched
				Font Name: System Default
				Font Size: System Default
				Font Enhancement: System Default
				Text Color: System Default
				Background Color: System Default
			Form Window
				Display Style? Etched
				Font Name: Arial
				Font Size: 8
				Font Enhancement: System Default
				Text Color: System Default
				Background Color: System Default
			Dialog Box
				Display Style? Etched
				Font Name: Arial
				Font Size: 8
				Font Enhancement: System Default
				Text Color: System Default
				Background Color: System Default
			Top Level Table Window
				Font Name: System Default
				Font Size: System Default
				Font Enhancement: System Default
				Text Color: System Default
				Background Color: System Default
			Data Field
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Multiline Field
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Spin Field
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Background Text
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Pushbutton
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
			Radio Button
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Check Box
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Option Button
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
			Group Box
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Child Table Window
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			List Box
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Combo Box
				Font Name: Use Parent
				Font Size: Use Parent
				Font Enhancement: Use Parent
				Text Color: Use Parent
				Background Color: Use Parent
			Line
				Line Color: Use Parent
			Frame
				Border Color: Use Parent
				Background Color: Use Parent
			Picture
				Border Color: Use Parent
				Background Color: Use Parent
		Formats
			Number: 0%
			Number: #0
			Number: ###000
			Number: ###000;###000
			Date/Time: hh:mm:ss AMPM
			Date/Time: M/d/yy
			Date/Time: MM-dd-yy
			Date/Time: dd-MMM-yyyy
			Date/Time: MMM d, yyyy
			Date/Time: MMM d, yyyy hh:mm AMPM
			Date/Time: MMMM d, yyyy hh:mm AMPM
			Date/Time: MMMM d, yyyy hh:mm:ss AMPM
		External Functions
			Library name: USER.EXE
				Function: GetParent
					Description:
					Export Ordinal: 0
					Returns
						Window Handle: HWND
					Parameters
						Window Handle: HWND
		Constants
			System
			User
				Number: WM_COMMAND = 0x0111
				Number: IDM_SAVE = 0x0207
				Number: IDT_CURTIME = 1
				Number: IDT_AUTOSAVE = 2
				Number: PM_Update = SAM_User + 1
				Number: PM_SetTimer = SAM_User + 2
		Resources
		Variables
.data RESOURCE 0 0 1 4277074418
0000: 0C0000000C000000 0000000000000000 0000010002000100 680000000000
.enddata
			! For a production build the following symbol should be commented out
			! Boolean: DEBUG
		Named Menus
		Internal Functions
		Class Definitions
		Default Classes
			MDI Window:
			Form Window:
			Dialog Box:
			Table Window:
			Quest Window:
			Data Field:
			Spin Field:
			Multiline Field:
			Pushbutton:
			Radio Button:
			Check Box:
			Option Button:
			Child Table:
			Quest Child Window:
			List Box:
			Combo Box:
			Picture:
			Vertical Scroll Bar:
			Horizontal Scroll Bar:
			Column:
			Background Text:
			Group Box:
			Line:
			Frame:
			Custom Control:
		Application Actions
	Form Window: frmMain
		Class:
		Class DLL Name:
		Title: Auto Save
		Icon File: C:\WINDOWS\ICONS\CLCKTALK.ICO
.data RESOURCE 2 0 1 3034352855
0000: FE02000027010000 0000000000000000 01000006000008F8 01102020B6F80174
0020: 02FB2CFE01E50F40 FE00E80FEB87A0DF 0012E88D6807007B 611F60DD988359FA
0040: 0460C0807FE4BF17 F6FDD78D3998A54F 70E70EFC0F7D0080 436F0037C36193EB
0060: B38D99FAC3DD0018 0366CC98D9064CF9 04BED5FFB6297B6B 0EC6C33B016FA0F4
0080: B1BE0EBEF3A132B8 BEFEFAC77F19EC3D 113E66B077674FBC 081133C821FFF8E8
00A0: 85FE99DD9913EFA3 0ECF8FF82DFF90F8 F94AED38FF8097B0 783CD41F0B11FF92
00C0: 3FF307BE0F127F31 3FC0C1FACB3FB5BE FF94FFFEA90D82CF ED3CBF33083E915F
00E0: E0EBE12F263D1F74 E0CE9D3B7039BD1C D6A3C407784DCFF6 1DDF6F74BF76C094
0100: F018E80001376B17 ECF66BBC59B3F5C7 8E1DB3EB056055EC DAA901DEC2EE169B
0120: B7BBEE604AFF663B 9FB35D87DA47EB05 F730B85110FC0AF8 07
.enddata
		Accesories Enabled? No
		Visible? Yes
		Display Settings
			Display Style? Default
			Visible at Design time? No
			Automatically Created at Runtime? Yes
			Initial State: Normal
			Maximizable? Yes
			Minimizable? Yes
			System Menu? Yes
			Resizable? Yes
			Window Location and Size
				Left:   2.888"
				Top:    2.198"
				Width:  4.4"
				Width Editable? Yes
				Height: 3.5"
				Height Editable? Yes
			Form Size
				Width:  Default
				Height: Default
				Number of Pages: Dynamic
			Font Name: Arial
			Font Size: Default
			Font Enhancement: Default
			Text Color: Default
			Background Color: Default
		Description:
		Named Menus
		Menu
		Tool Bar
			Display Settings
				Display Style? Default
				Location? Top
				Visible? Yes
				Size: Default
				Size Editable? Yes
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Contents
		Contents
			Group Box: SQLWindows Auto Save
				Resource Id: 12120
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.083"
					Top:    -0.012"
					Width:  3.9"
					Width Editable? Yes
					Height: 1.5"
					Height Editable? Yes
				Visible? Yes
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Pushbutton: pbAppFind
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Class DLL Name:
				Title: App
				Window Location and Size
					Left:   0.283"
					Top:    0.238"
					Width:  0.8"
					Width Editable? Yes
					Height: 0.25"
					Height Editable? Yes
				Visible? Yes
				Keyboard Accelerator: (none)
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Picture File Name:
				Picture Transparent Color: None
				Image Style: Single
				Text Color: Default
				Background Color: Default
				Message Actions
					On SAM_Click
						Set sFilters[0] = 'SW Apps'
						Set sFilters[1] = '*.ap?'
						Call SalDlgOpenFile( hWndForm, 'Application to Autosave', sFilters, 2, nIndex, sFile, dfsPath )
			Data Field: dfsPath
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Class DLL Name:
				Data
					Maximum Data Length: Default
					Data Type: String
					Editable? Yes
				Display Settings
					Window Location and Size
						Left:   1.283"
						Top:    0.238"
						Width:  2.4"
						Width Editable? Yes
						Height: 0.25"
						Height Editable? Yes
					Visible? Yes
					Border? Yes
					Justify: Left
					Format: Unformatted
					Country: Default
					Font Name: Default
					Font Size: Default
					Font Enhancement: Default
					Text Color: Default
					Background Color: Default
					Input Mask: Unformatted
				Message Actions
			Data Field: dfnMinutes
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Class DLL Name:
				Data
					Maximum Data Length: Default
					Data Type: Number
					Editable? Yes
				Display Settings
					Window Location and Size
						Left:   0.95"
						Top:    0.679"
						Width:  0.8"
						Width Editable? Yes
						Height: 0.25"
						Height Editable? Yes
					Visible? Yes
					Border? Yes
					Justify: Left
					Format: Unformatted
					Country: Default
					Font Name: Default
					Font Size: Default
					Font Enhancement: Default
					Text Color: Default
					Background Color: Default
					Input Mask: Unformatted
				Message Actions
					On SAM_Create
						Set dfnMinutes = 5
			Pushbutton: pbBegin
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Class DLL Name:
				Title: &Begin
				Window Location and Size
					Left:   0.25"
					Top:    1.012"
					Width:  1.733"
					Width Editable? Yes
					Height: 0.298"
					Height Editable? Yes
				Visible? Yes
				Keyboard Accelerator: Enter
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Picture File Name:
				Picture Transparent Color: None
				Image Style: Single
				Text Color: Default
				Background Color: Default
				Message Actions
					On SAM_Click
						If SalIsNull( dfsPath )
							Set hWnd = SalAppFind( 'SQLWIN41.EXE', TRUE )
							! Autosave on currently running copy of SW
							If hWnd
								Call SalBringWindowToTop( hWndForm )
								If SalMessageBox( 'Autosave will save the last application launched by SQLWindows - If this is not the one you want to autosave, enter the name you want to save in the filename field
										Do you want to continue?', 'Autosave', MB_YesNo | MB_IconQuestion ) = IDNO
									Return FALSE
							Else
								! Could not find the currently running copy
								Call SalMessageBox( 'SQLWIN41.EXE is not currently running, you should specify the application file that you want to open in the app field first',  
										'Error', MB_Ok | MB_IconStop )
								Return FALSE
						Else
							If not SalLoadApp( 'SQLWIN41.EXE', dfsPath )
								Call SalMessageBox( 'Could not find SQLWIN41.EXE - make sure SQLWindows 4.1 is in your path',  'Error', MB_Ok | MB_IconStop )
							Else
								Call SalPostMsg( hWndForm, PM_SetTimer, 0, 0 )
			Pushbutton: pbCancel
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Class DLL Name:
				Title: &Cancel
				Window Location and Size
					Left:   2.083"
					Top:    1.012"
					Width:  1.667"
					Width Editable? Yes
					Height: 0.298"
					Height Editable? Yes
				Visible? Yes
				Keyboard Accelerator: Esc
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Picture File Name:
				Picture Transparent Color: None
				Image Style: Single
				Text Color: Default
				Background Color: Default
				Message Actions
			Background Text: Every:
				Resource Id: 12118
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.283"
					Top:    0.714"
					Width:  0.6"
					Width Editable? Yes
					Height: 0.19"
					Height Editable? Yes
				Visible? Yes
				Justify: Right
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Background Text: minutes
				Resource Id: 12119
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   1.85"
					Top:    0.714"
					Width:  0.7"
					Width Editable? Yes
					Height: 0.167"
					Height Editable? Yes
				Visible? Yes
				Justify: Left
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Background Text: Current:
				Resource Id: 12124
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.383"
					Top:    2.202"
					Width:  0.733"
					Width Editable? Yes
					Height: 0.167"
					Height Editable? Yes
				Visible? Yes
				Justify: Right
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Background Text: Next:
				Resource Id: 12122
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.383"
					Top:    2.536"
					Width:  0.733"
					Width Editable? Yes
					Height: 0.167"
					Height Editable? Yes
				Visible? Yes
				Justify: Right
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Group Box: Autosave Times
				Resource Id: 12123
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.083"
					Top:    1.571"
					Width:  3.9"
					Width Editable? Yes
					Height: 1.417"
					Height Editable? Yes
				Visible? Yes
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Data Field: dfdtPrevious
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class: cdfDate
				Class DLL Name:
				Data
					Maximum Data Length: Class Default
					Data Type: Class Default
					Editable? No
				Display Settings
					Window Location and Size
						Left:   1.183"
						Top:    1.821"
						Width:  2.6"
						Width Editable? Class Default
						Height: 0.25"
						Height Editable? Class Default
					Visible? Class Default
					Border? Class Default
					Justify: Class Default
					Format: MMMM d, yyyy hh:mm:ss AMPM
					Country: Class Default
					Font Name: Class Default
					Font Size: Class Default
					Font Enhancement: Class Default
					Text Color: Class Default
					Background Color: Class Default
					Input Mask: Class Default
				Message Actions
					On PM_Update
						If wParam = IDT_AUTOSAVE
							Call dfdtPrevious.SetDate( dfdtTime )
			Data Field: dfdtTime
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class: cdfDate
				Class DLL Name:
				Data
					Maximum Data Length: Class Default
					Data Type: Class Default
					Editable? No
				Display Settings
					Window Location and Size
						Left:   1.183"
						Top:    2.155"
						Width:  2.6"
						Width Editable? Class Default
						Height: 0.25"
						Height Editable? Class Default
					Visible? Class Default
					Border? Class Default
					Justify: Class Default
					Format: MMMM d, yyyy hh:mm:ss AMPM
					Country: Class Default
					Font Name: Class Default
					Font Size: Class Default
					Font Enhancement: Class Default
					Text Color: Class Default
					Background Color: Class Default
					Input Mask: Class Default
				Message Actions
			Background Text: Previous:
				Resource Id: 25637
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class:
				Window Location and Size
					Left:   0.283"
					Top:    1.869"
					Width:  0.833"
					Width Editable? Yes
					Height: 0.167"
					Height Editable? Yes
				Visible? Yes
				Justify: Right
				Font Name: Default
				Font Size: Default
				Font Enhancement: Default
				Text Color: Default
				Background Color: Default
			Data Field: dfdtNext
				Class Child Ref Key: 0
				Class ChildKey: 0
				Class: cdfDate
				Class DLL Name:
				Data
					Maximum Data Length: Class Default
					Data Type: Class Default
					Editable? No
				Display Settings
					Window Location and Size
						Left:   1.183"
						Top:    2.488"
						Width:  2.6"
						Width Editable? Class Default
						Height: 0.25"
						Height Editable? Class Default
					Visible? Class Default
					Border? Class Default
					Justify: Class Default
					Format: MMMM d, yyyy hh:mm:ss AMPM
					Country: Class Default
					Font Name: Class Default
					Font Size: Class Default
					Font Enhancement: Class Default
					Text Color: Class Default
					Background Color: Class Default
					Input Mask: Class Default
				Message Actions
					On PM_Update
						Call dfdtNext.SetDate( dfdtTime )
						Call dfdtNext.AddMin( dfnMinutes )
		Functions
			Function: ParseCmdLine
				Description:
				Returns
				Parameters
				Static Variables
				Local variables
					Number: n
				Actions
					While n <= nArgCount
						If SalStrUpperX( strArgArray[n] )  = '/A'
							! Application name is the next parameter
							Set n = n + 1
							Set dfsPath = strArgArray[n]
						Else If SalStrUpperX( strArgArray[n] ) = '/T'
							! Time to save in minutes is the next parameter
							Set n = n + 1
							Set dfnMinutes = SalStrToNumber( strArgArray[n] )
						Set n = n + 1
					If dfnMinutes = 0
						Set dfnMinutes = 5
					If dfnMinutes and not SalIsNull( dfsPath )
						Call SalPostMsg( pbBegin, SAM_Click, 0, 0 )
		Window Parameters
		Window Variables
			Window Handle: hWnd
			Boolean: bStarted
			Number: nMinCnt
			Number: nIndex
			String: sFile
			String: sFilters[*]
			: Debug
				Class: ASSERTMACRO
		Message Actions
			On SAM_Timer
				Select Case wParam
					Case IDT_CURTIME
						Call dfdtTime.Current()
						If bStarted and SalGetWindowState( hWnd ) = Window_Invalid
							Return SalQuit()
						Break
					Case IDT_AUTOSAVE
						If nMinCnt >= (dfnMinutes-1)
							Call SalPostMsg( hWnd, WM_COMMAND, IDM_SAVE, 0 )
							Call SalSendMsgToChildren( hWndForm, PM_Update, IDT_AUTOSAVE, 0 )
							Set nMinCnt = 0
						Else
							Set nMinCnt = nMinCnt + 1
						Break
			On SAM_Create
				Call SalTimerSet( hWndForm, IDT_CURTIME, 1000 )
				Call SalSendMsg( hWndForm, SAM_Timer, IDT_CURTIME, 0 )
			On SAM_CreateComplete
				If nArgCount
					Call ParseCmdLine()
			On PM_SetTimer
				Set hWnd = SalAppFind( 'SQLWIN41.EXE', TRUE )
				If hWnd = hWndNULL
					Call Debug.ASSERTMSG( 'SalAppFind did not find SQLWIN41.EXE after a succesful SalAppLoad' )
				Call SalTimerSet( hWndForm, IDT_AUTOSAVE, (60000) )
				Call SalSendMsgToChildren( hWndForm, PM_Update, IDT_AUTOSAVE, 0 )
