{$B+}
{$R+}
program LightspeedEdit;   { inventory and resource editor }

{ Program copyright 1992 by Charles J. Kelly III }

uses
  CRT, DOS;

var
  DirInfo: SearchRec;
  savefile: file;
  GameFile: string[12];
  ClusterName: string[8];
  Inventory: array[1..18] of Word;
  Resources: array[1..6] of Word;
  Category, Choice, ClearVar: Integer;
  Modifier: Longint;

label
  stt, Fin, DOA;

procedure SAVEINVENTORY;
  begin
    Reset(savefile, 1);
    Seek(SaveFile, ($AA3 + Modifier));
    BlockWrite(SaveFile, Inventory[1], 2);
    Seek(SaveFile, ($AA5 + Modifier));
    BlockWrite(SaveFile, Inventory[2], 2);
    Seek(SaveFile, ($AA7 + Modifier));
    BlockWrite(SaveFile, Inventory[3], 2);
    Seek(SaveFile, ($AA9 + Modifier));
    BlockWrite(SaveFile, Inventory[4], 2);
    Seek(SaveFile, ($AAB + Modifier));
    BlockWrite(SaveFile, Inventory[5], 2);
    Seek(SaveFile, ($AAD + Modifier));
    BlockWrite(SaveFile, Inventory[6], 2);
    Seek(SaveFile, ($AAF + Modifier));
    BlockWrite(SaveFile, Inventory[7], 2);
    Seek(SaveFile, ($AB1 + Modifier));
    BlockWrite(SaveFile, Inventory[8], 2);
    Seek(SaveFile, ($AB3 + Modifier));
    BlockWrite(SaveFile, Inventory[9], 2);
    Seek(SaveFile, ($AB5 + Modifier));
    BlockWrite(SaveFile, Inventory[10], 2);
    Seek(SaveFile, ($AB7 + Modifier));
    BlockWrite(SaveFile, Inventory[11], 2);
    Seek(SaveFile, ($ABB + Modifier));
    BlockWrite(SaveFile, Inventory[12], 2);
    Seek(SaveFile, ($ABF + Modifier));
    BlockWrite(SaveFile, Inventory[13], 2);
    Seek(SaveFile, ($AC1 + Modifier));
    BlockWrite(SaveFile, Inventory[14], 2);
    Seek(SaveFile, ($ACB + Modifier));
    BlockWrite(SaveFile, Inventory[15], 2);
    Seek(SaveFile, ($AD1 + Modifier));
    BlockWrite(SaveFile, Inventory[16], 2);
    Seek(SaveFile, ($AC9 + Modifier));
    BlockWrite(SaveFile, Inventory[17], 2);
    Seek(SaveFile, ($ADF + Modifier));
    BlockWrite(SaveFile, Inventory[18], 2);
    Close(SaveFile);
  end;

procedure LOADINVENTORY;
  begin                          
    Reset(savefile, 1);
    Seek(SaveFile, ($AA3 + Modifier));
    BlockRead(SaveFile, Inventory[1], 2);
    Seek(SaveFile, ($AA5 + Modifier));
    BlockRead(SaveFile, Inventory[2], 2);
    Seek(SaveFile, ($AA7 + Modifier));
    BlockRead(SaveFile, Inventory[3], 2);
    Seek(SaveFile, ($AA9 + Modifier));
    BlockRead(SaveFile, Inventory[4], 2);
    Seek(SaveFile, ($AAB + Modifier));
    BlockRead(SaveFile, Inventory[5], 2);
    Seek(SaveFile, ($AAD + Modifier));
    BlockRead(SaveFile, Inventory[6], 2);
    Seek(SaveFile, ($AAF + Modifier));
    BlockRead(SaveFile, Inventory[7], 2);
    Seek(SaveFile, ($AB1 + Modifier));
    BlockRead(SaveFile, Inventory[8], 2);
    Seek(SaveFile, ($AB3 + Modifier));
    BlockRead(SaveFile, Inventory[9], 2);
    Seek(SaveFile, ($AB5 + Modifier));
    BlockRead(SaveFile, Inventory[10], 2);
    Seek(SaveFile, ($AB7 + Modifier));
    BlockRead(SaveFile, Inventory[11], 2);
    Seek(SaveFile, ($ABB + Modifier));
    BlockRead(SaveFile, Inventory[12], 2);
    Seek(SaveFile, ($ABF + Modifier));
    BlockRead(SaveFile, Inventory[13], 2);
    Seek(SaveFile, ($AC1 + Modifier));
    BlockRead(SaveFile, Inventory[14], 2);
    Seek(SaveFile, ($ACB + Modifier));
    BlockRead(SaveFile, Inventory[15], 2);
    Seek(SaveFile, ($AD1 + Modifier));
    BlockRead(SaveFile, Inventory[16], 2);
    Seek(SaveFile, ($AC9 + Modifier));
    BlockRead(SaveFile, Inventory[17], 2);
    Seek(SaveFile, ($ADF + Modifier));
    BlockRead(SaveFile, Inventory[18], 2);
    Close(SaveFile);
  end;

procedure SAVERESOURCES;
  begin
  Reset(SaveFile, 1);
  Seek(SaveFile, ($A85 + Modifier));
  BlockWrite(SaveFile, Resources[1], 2);
  Seek(SaveFile, ($A87 + Modifier));
  BlockWrite(SaveFile, Resources[2], 2);
  Seek(SaveFile, ($A89 + Modifier));
  BlockWrite(SaveFile, Resources[3], 2);
  Seek(SaveFile, ($A8B + Modifier));
  BlockWrite(SaveFile, Resources[4], 2);
  Seek(SaveFile, ($741 + Modifier));
  BlockWrite(SaveFile, Resources[5], 2);
  Seek(SaveFile, ($74B + Modifier));
  BlockWrite(SaveFile, Resources[6], 2);
  Close(SaveFile);
  end;


procedure LOADRESOURCES;
  begin
  Reset(SaveFile, 1);
  Seek(SaveFile, ($A85 + Modifier));
  BlockRead(SaveFile, Resources[1], 2);
  Seek(SaveFile, ($A87 + Modifier));
  BlockRead(SaveFile, Resources[2], 2);
  Seek(SaveFile, ($A89 + Modifier));
  BlockRead(SaveFile, Resources[3], 2);
  Seek(SaveFile, ($A8B + Modifier));
  BlockRead(SaveFile, Resources[4], 2);
  Seek(SaveFile, ($741 + Modifier));
  BlockRead(SaveFile, Resources[5], 2);
  Seek(SaveFile, ($74B + Modifier));
  BlockRead(SaveFile, Resources[6], 2);
  Close(SaveFile);
  end;

procedure TitleScreen;
  begin
    HighVideo;
    ClrScr;
    TextBackground(9);
    TextColor(15);
    ClrScr;
    Writeln(' Lightspeed inventory and resource editor');
    Writeln(' Copyright 1992  by C. Kelly III ');
    NormVideo;
    Window(1, 4, 80, 25);
    TextBackground(9);
    TextColor(15);
  end;

procedure MainMenu;
  label
    bg;
  begin
bg: ClrScr;
    Writeln(' MENU FOR SAVEFILE ', Gamefile,' in ',ClusterName,' cluster');
    Writeln(' ');
    Writeln('                1.  Items in ship''s hold. ');
    Writeln('                2.  Resources. ');
    Writeln(' ');
    Write(' Choose category to edit  ( 3 to exit program ): ');
    Readln(Choice);
    If (Choice < 1) or (Choice > 3) then
      goto bg;
  end;

procedure INVENTORYMENU;
  var
    Value: Word;
    Number: Integer;
  label
    bg, stp;
  begin
    Writeln(' Inventory menu for savefile ', Gamefile,' in ',ClusterName,' cluster');
    Window(1, 6, 80, 25);
bg: ClrScr;
    Writeln('1. Turbines: ',Inventory[1],'   2. Normal Burners: ',Inventory[2],'   3. Accelerators: ',Inventory[3]);
    TextColor(10);
    Writeln('4. Normal Blasters: ',Inventory[4],'   5. Normal Secondaries: ',Inventory[5]);
    TextColor(15);
    Writeln('6. Radiators: ',Inventory[6],'   7. Linkages: ',Inventory[7],'   8. Converters: ',Inventory[8]);
    TextColor(10);
    Writeln('9. Cody Targeters: ',Inventory[9],'   10. Vespucci Navigators: ',Inventory[10]);
    TextColor(15);
    Writeln('11. Data Casings: ',Inventory[11],'   12. Maneuverable Burners: ',Inventory[12]);
    TextColor(10);
    Writeln('13. High Energy Blasters: ',Inventory[13],'   14. Neutron Secondaries: ',Inventory[14]);
    TextColor(15);
    Writeln('15. Magellan Navigators: ',Inventory[15],'   16. Fast Burners: ',Inventory[16]);
    TextColor(10);
    Writeln('17. Hickock Targeters: ',Inventory[17],'   18. Oakley Targeters: ',Inventory[18]);
    Writeln(' ');
    TextColor(15);
    Write(' Enter inventory number to change ( 255 to exit ): ');
    Readln(Number);
    If ((Number < 1) or (Number > 18)) and (Number <> 255) then
      goto bg;
    If Number = 255 then goto stp;
    Write(' Enter value for inventory ( 0 - 65535 ) : ');
    Readln(Value);
    Inventory[Number]:=Value;
    goto bg;
stp:Window(1, 4, 80, 25);
    SaveInventory;
  end;

procedure RESOURCEMENU;
  var
    Number: Integer;
    Value: Word;
  label
    bg, stp;
  begin
    Writeln(' Resource menu for savefile ', Gamefile,' in ',ClusterName,' cluster');
    Window(1, 6, 80, 25);
bg: ClrScr;
    Writeln('   1. Radioactives:  ',Resources[1]);
    Writeln('   2. Waters      :  ',Resources[2]);
    Writeln('   3. Organics    :  ',Resources[3]);
    Writeln('   4. Metals      :  ',Resources[4]);
    Writeln(' ');
    Writeln('   5. Mining Pods     : ',Resources[5]);
    Writeln('   6. Missile Chassis : ',Resources[6]);
    Write(' Select resource number to change ( 255 to exit ): ');
    Readln(Number);
    If ((Number < 1) or (Number > 6)) and (Number <> 255) then
      goto bg;
    If Number = 255 then
      goto stp;
    Write(' Enter value for resource ( 0 - 65535): ');
    Readln(Value);
    Resources[Number]:=Value;
    goto bg;
stp:Window(1, 4, 80, 25);
    SAVERESOURCES;
  end;

begin
  GameFile:=ParamStr(1);
  FindFirst(GameFile, AnyFile, DirInfo);
  If DosError <> 0 then
      begin
      Writeln(' ');
      Writeln(' I can''t find ', GameFile,' ! ');
      Writeln(' ');
      Writeln(' You must run this program in the same directory');
      Writeln(' in which ', GameFile,' resides.');
      Writeln(' ');
      Halt;
    end;
  If (DirInfo.size <> 4775) and (DirInfo.size <> 7685) then
    begin
      ClrScr;
      Writeln(' The file you specified is not a valid LIGHTSPEED savegame ');
      Writeln(' file.  Please make sure you enter the correct filename. ');
      Writeln('  ');
      Writeln(' EXAMPLE:  LSCHEAT savegame.sav  ');
      goto Doa;
    end;
  If DirInfo.size = 4775 then
    Modifier:=0;
  If DirInfo.size = 7685 then
    Modifier:=$B5E;
  If DirInfo.size = 4775 then
    ClusterName:='HYADES';
  If DirInfo.size = 7685 then
    ClusterName:='CERBERUS';
For ClearVar:=1 to 18 do
  Inventory[ClearVar]:=0;
For ClearVar:=1 to 4 do
  Resources[ClearVar]:=0;
Assign(savefile, GameFile);  { savename file entered after .EXE }
TitleScreen; { screen setup and title display }
LOADINVENTORY;
LOADRESOURCES;
stt:MainMenu;
Case Choice of
  1: INVENTORYMENU;
  2: RESOURCEMENU;
  3: GOTO FIN;
end;
goto stt;
Fin:ClrScr;
Writeln(' Lightspeed editor ');
Writeln(' Finished !');
DOA:end.