program PHANTOM_3D_ENGINE;
{+M 16384,0,32768}
uses vga256,crt;
const SCRWIDTH=320;
      MWIDTH=128;
      MCENTRE=64;
      SIZE=160;           { veelvoud van 2!! }
      LINES=70;           { aantal lijnen voor vloer (MAX. 70) }
      KIM=29;             { hoogte tussen plafond en vloer }
      XPOS=0;
      DARK=1;             { donker in de verte }
      DIST=3500;          { 1769 voor SIZE=320 }
      HAZE=0;             { mistig in de verte }
      YSHIFT=-10;         { om hem toch in het midden te krijgen }

{ Bitmap 60 gaat gebruikt worden voor diverse variabelen }

      BZ=62*1024;              { BZ betekent 'Bitmap zestig' }
      coltab=BZ+0;
      steptab=BZ+2;
      hight=BZ+4;
      loop=BZ+6;
      laatst=BZ+8;
      vooruit=BZ+10;
      terug=BZ+12;
      links=BZ+14;
      rechts=BZ+16;
      nokke=BZ+18;
      screen=BZ+20;
      screen2=BZ+22;
      stepsize=BZ+24;
      inner=BZ+26;
      htable=BZ+28;
      store1=BZ+30;
      store2=BZ+32;
      store3=BZ+34;
      stackp=BZ+36;
      basep=BZ+38;
      ceiling=BZ+40;
      map=BZ+42;
      xdelta=BZ+44;
      ydelta=BZ+46;
      seg1=BZ+48;
      exsp=BZ+50;

{ Aan het eind van de kaart worden ook nog wat variabelen bijgehouden }
{ De gemiddelde gestructureerde programmeur begint hier heftige braak- }
{ neigingen te vertonen - Sorry mensen }

      NK=32700;                { NK betekent 'na kaart' }
      transp=NK+0;
      xp=NK+2;
      yp=NK+4;
      seg3=NK+6;


Var s1,s3,s2: word;
    p1,p2,p3: pointer;
    c,i,x,y,width: word;
    a1,a2,a3,x1,y1: word;
    sy,ss,w,bg: real;
    f: file;
    sn,cs: array[0..360] of real;
    a: char;
    b,q: byte;
    s,d,x2,y2,x3,y3,r,v: integer;
    cset: string;
    px,py: array[0..360] of integer;
    quit: boolean;
    t: array[0..32] of string[33];
    by: array [0..319] of longint;      {blokzak array}

procedure ScrollLava; Assembler;
label regels,bytes;
asm
   mov ES,[s3]                { bitmap-segment }
   mov DI,45*1024
   mov AL,32
regels:
   mov CX,31
   mov DL,ES:[DI]             { eerste word opslaan }
bytes:
   mov BL,ES:[DI+32]
   mov ES:[DI],BL
   add DI,32
   loop bytes
   mov ES:[DI],DL
   sub DI,31*32-1
   dec AL
   jnz regels
end;

procedure SetPalette;
var r,g,b: array[0..31] of byte;
    a,i: byte;
begin
   { 32 kleuren kunnen gedefinieerd worden: Alle andere worden
     hieruit afgeleid (donkerder). Elk van de 32 kleuren wordt
     donkerder in de diepte, in 8 stappen.                       }

{        red:     green:      blue:     description:             }

   r[ 0]:= 0; g[ 0]:= 0; b[ 0]:= 0;     { grey-scale             a }
   r[ 1]:= 0; g[ 1]:= 0; b[ 1]:= 0;     { very black color       b }
   r[ 2]:=63; g[ 2]:= 2; b[ 2]:= 2;     { red for squares        c }
   r[ 3]:=20; g[ 3]:=50; b[ 3]:=20;     { blue-grey for doors    d }
   r[ 4]:=15; g[ 4]:=40; b[ 4]:=15;     { darker blue-grey       e }
   r[ 5]:=32; g[ 5]:=20; b[ 5]:= 0;     { tiles - initial        f }
   r[ 6]:=30; g[ 6]:=19; b[ 6]:= 0;     { tile color 2           g }
   r[ 7]:=28; g[ 7]:=18; b[ 7]:= 0;     { tile color 3           h }
   r[ 8]:= 0; g[ 8]:= 0; b[ 8]:= 0;     { elevator door color 1  i }
   r[ 9]:= 0; g[ 9]:= 0; b[ 9]:= 0;     { elevator door color 2  j }
   r[10]:=30; g[10]:=18; b[10]:= 0;     { tile - dark version    k }
   r[11]:=28; g[11]:=17; b[11]:= 0;     { dark tile color 2      l }
   r[12]:=26; g[12]:=16; b[12]:= 0;     { dark tile color 3      m }
   r[13]:=20; g[13]:=15; b[13]:=10;     { Brown-Yellow wall c1   n }
   r[14]:=19; g[14]:=14; b[14]:= 9;     { Brown-Yellow wall c2   o }
   r[15]:=18; g[15]:=13; b[15]:= 8;     { Brown-Yellow wall c3   p }
   r[16]:=24; g[16]:=14; b[16]:= 0;     { Ceiling grey - color 1 q }
   r[17]:=22; g[17]:=12; b[17]:= 0;     { Ceiling grey - color 2 r }
   r[18]:=20; g[18]:=10; b[18]:= 0;     { Ceiling- edges         s }
   r[19]:=10; g[19]:=7; b[19]:=  4;     { Wood                   t }
   r[20]:= 2; g[20]:= 2; b[20]:= 2;     { Dark grey 1 (for airco)u }
   r[21]:= 4; g[21]:= 4; b[21]:= 4;     { Dark grey 2            v }
   r[22]:= 6; g[22]:= 6; b[22]:= 6;     { Dark grey 3            w }
   r[23]:=12; g[23]:=12; b[23]:=12;     { Dark grey 4            x }
   r[24]:=63; g[24]:=10; b[24]:=10;     { Vuurstroom kleur 1       }
   r[25]:=55; g[25]:= 7; b[25]:= 7;     { Vuurstroom kleur 2       }
   r[26]:=47; g[26]:= 4; b[26]:= 4;     { Vuurstroom kleur 3       }
   r[27]:= 0; g[27]:= 0; b[27]:= 0;     {                          }
   r[28]:= 0; g[28]:= 0; b[28]:= 0;     {                          }
   r[29]:= 0; g[29]:= 0; b[29]:= 0;     {                          }
   r[30]:= 0; g[30]:= 0; b[30]:= 0;     {                          }
   r[31]:=63; g[31]:=63; b[31]:=63;     {                          }

   if (DARK=1) then for a:=0 to 7 do for i:=0 to 31 do palette(i+a*32,
                                             r[i]-((r[i]*a) div 8),
                                             g[i]-((g[i]*a) div 8),
                                             b[i]-((b[i]*a) div 8));
   if (HAZE=1) then for a:=0 to 7 do for i:=0 to 31 do palette(i+a*32,
                                         r[i]+(((63-r[i])*a) div 8),
                                         g[i]+(((63-g[i])*a) div 8),
                                         b[i]+(((63-b[i])*a) div 8));
   if (HAZE=0) and (DARK=0) then for a:=0 to 7 do for i:=0 to 31 do
                                         palette(i+a*32,r[i],g[i],b[i]);
end;

procedure DrawInside(xm,ym,r: integer); assembler;
label q1,q2,q3,q4,picture_q1,picture_q2,drawline_q1,drawline_q2,einde
      ,cx_q1,cy_q1,skipx_q1,skipx_q2,fillup
      ,cx_q2,cy_q2,cy_q3,cx_q3,skipx_q3,drawline_q3,picture_q3
      ,nextx,picture_q4,cy_q4,cx_q4,skipx_q4,drawline_q4
      ,drawx,clear,uitgang,update,regels
      ,balk_q1,balk_q2,balk_q3,balk_q4,wx_entry_q1,wx_entry_q2,wx_entry_q3
      ,wx_entry_q4,wy_entry_q1,wy_entry_q2,wy_entry_q3,wy_entry_q4,skiph_q1
      ,skiph_q2,skiph_q3,skiph_q4,black_q1,black_q2
      ,nx_entry_q1,nx_entry_q2,nx_entry_q3,nx_entry_q4,black_q3,black_q4
      ,ny_entry_q1,ny_entry_q2,ny_entry_q3,ny_entry_q4
      ,special_q4,special_q1,special_q2,special_q3,scx_q1,scy_q1
      ,scx_q2,scy_q2,scx_q3,scy_q3,scx_q4,scy_q4,sp_loop_q1,sp_loop_q2
      ,sp_loop_q3,sp_loop_q4,sskipx_q1,sskipx_q2,sskipx_q3,sskipx_q4
      ,sskipy_q1,sskipy_q2,sskipy_q3,sskipy_q4,sx_entry_q1,sx_entry_q2
      ,sx_entry_q3,sx_entry_q4,sy_entry_q1,sy_entry_q2,sy_entry_q3
      ,sy_entry_q4,sbalk_q1,sbalk_q2,sbalk_q3,sbalk_q4,sp_blk_q1
      ,sp_blk_q2,sp_blk_q3,sp_blk_q4,no_bar_q1,no_bar_q2,no_bar_q3
      ,no_bar_q4,bar_q1,bar_q2,bar_q3,bar_q4;

{ This version draws a floor, a ceiling and shaded walls. }
{ For other features, see previous procedure.             }

asm
    mov BX,[s1]
    mov CX,[s3]
    push DS
    mov DS,CX
    mov [SEG1],BX
    mov DS,[SEG1]
    mov [SEG3],CX
    pop DS

    mov CX,[xm]
    mov BX,[ym]
    mov AX,[r]

    push DS
    mov DS,[s1]
    mov word ptr [xp],CX
    mov word ptr [yp],BX
    mov DS,[SEG3]
    mov word ptr [basep],BP
    mov word ptr [coltab],65350
    mov word ptr [steptab],64600       { adres stepsize-tabel      }

    mov BX,65000
    mov CX,SIZE
    mov DL,200-LINES
fillup:
    mov DS:[BX],DL
    inc BX
    loop fillup
    mov byte ptr [hight],2*LINES+KIM
    mov BX,$A000
    mov ES,BX
    cmp AX,45                 { richting > 90?            }
    jae q2
q1:                           { rotaties van 0-89 graden  }
    mov BX,AX                 { BX=rot*560                }
    shl BX,9                  { BX=rot*512                }
    shl AX,4                  { AX=rot*16                 }
    add BX,AX                 { BX=nu rot*(512+16)        }
    shl AX,1                  { AX=rot*32                 }
    add BX,AX                 { BX=nu rot*(512+16+32)     }
    add BX,32768              { NEG werkt niet!?          }

    mov DS,[SEG1]
    mov [transp],BX           { store transtabel-pointer  }
    mov DS,[SEG3]

    mov word ptr[screen],(200+YSHIFT)*320+XPOS-2+2*SIZE
    mov word ptr[screen2],((198-2*LINES)-KIM+YSHIFT)*320+XPOS-2+2*SIZE

    mov word ptr [loop],LINES  { for loop=0 to 69          }
picture_q1:
    sub byte ptr [hight],2    { hoogteverschil scherm     }

    mov DS,[SEG1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,DS:[SI]            { start x-coord lijn        }
    add AX,[xp]
    mov BP,DS:[SI+2]          { start y-coord lijn        }
    add BP,[yp]
    mov DX,DS:[SI+4]          { xplus                     }
    mov DI,DS:[SI+6]          { yplus                     }
    add word ptr [transp],8
    mov DS,[SEG3]

    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov DS,[SEG3]

    shr DI,8
    shl DI,10
    mov [ceiling],DI

    mov DS,[SEG1]
    mov SI,DS:[SI]            { en haal actuele veld op   }
    mov DS,[SEG3]

    shr SI,8
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub word ptr [screen],320+2*SIZE
    add word ptr [screen2],320-2*SIZE
    mov BX,[steptab]          { haal adres step-tabel     }
    mov BX,DS:[BX]            { BX bevat nu stepsize      }
    mov [stepsize],BX         { bewaar stepsize           }
    add word ptr [steptab],2  { alvast voor volgende lijn }
    mov BX,[coltab]           { haal adres colortabel     }
    mov DX,DS:[BX]            { SP bevat colsize          }
    mov [exsp],DX
    add word ptr [coltab],2   { alvast voor volgende lijn }
    mov word ptr [inner],SIZE { dot-counter               }
    mov word ptr [htable],64999

    cmp SI,17                 { blokken 1-7               }
    jb  special_q1            { speciale behandeling      }

    shl SI,10

drawline_q1:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  skipx_q1              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  cx_q1
    add BP,[ydelta]
    jo  cy_q1
    dec word ptr [inner]
    jnz drawline_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q1:
    add AX,[xdelta]
    jo  cx_q1
    add BP,[ydelta]
    jo  cy_q1
    dec word ptr [inner]
    jnz drawline_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q1:
    inc word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sx_entry_q1
wx_entry_q1:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    add BP,[ydelta]
    jo  cy_q1
    dec word ptr [inner]
    jnz drawline_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q1:
    add word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sy_entry_q1
wy_entry_q1:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz drawline_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }

special_q1:                   { Muren met plaatselijke    }
    shl SI,10                 { balkjes (tralies ofzo)    }
sp_loop_q1:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  sskipx_q1             { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    cmp CL,0                  { lijntje omhoog trekken    }
    jz  sp_blk_q1             { speciale routine daarvoor }
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  scx_q1
    add BP,[ydelta]
    jo  scy_q1
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sp_blk_q1:
    mov DI,[htable]
    mov byte ptr DS:[DI],0    { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]    { Bereken hoogte muur       }
    shr CX,8                  { CX is nu loop-counter     }
    add CL,3                  { Iets overdrijven graag    }
    mov DI,[screen]           { huidige schermadres       }
    cmp CX,KIM+2*LINES+1      { maximale hoogte?          }
    jz  no_bar_q1             { dan zwart tekenen         }
    mov [store1],AX
    mov [store2],SI
    mov [store3],BP
    mov BP,SI
    shr BP,10
    sub BP,1
    mov BX,32*2048-1          { Onderaan beginnen         }
    push DX
    mov DX,[stepsize]         { Aantal stappen per pixel  }
bar_q1:
    mov SI,BX                 { bereken adres in bitmap   }
    shr SI,11                 { delen door 2048           }
    shl SI,5                  { *32 geeft goede adres     }
    add SI,BP                 { + muurtype                }
    mov AL,DS:[SI]            { haal byte op              }
    mov AH,AL                 { effe 16 bits maken        }
    add AX,[exsp]
    mov ES:[DI],AX            { en tekenen graag          }
    sub DI,320                { volgende schermregel      }
    sub BX,DX                 { opschuiven in brongebied  }
    loop bar_q1
    pop DX
    mov AX,[store1]
    mov SI,[store2]
    mov BP,[store3]
    add AX,[xdelta]
    jo  scx_q1
    add BP,[ydelta]
    jo  scy_q1
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
no_bar_q1:
    mov word ptr ES:[DI],0
    sub DI,320
    loop no_bar_q1
    add AX,[xdelta]
    jo  scx_q1
    add BP,[ydelta]
    jo  scy_q1
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sskipx_q1:
    add AX,[xdelta]
    jo  scx_q1
    add BP,[ydelta]
    jo  scy_q1
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scx_q1:
    inc word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q1           { gewone vloertegel         }
sx_entry_q1:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    add BP,[ydelta]
    jo  scy_q1
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scy_q1:
    add word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q1           { gewone vloertegels        }
sy_entry_q1:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz sp_loop_q1
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q1            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q2:                           { rotaties van 0-89 graden  }
    sub AX,45
    cmp AX,45
    jae q3
    mov BX,AX                 { BX=rot*560                }
    shl BX,9                  { BX=rot*512                }
    shl AX,4                  { AX=rot*16                 }
    add BX,AX                 { BX=nu rot*(512+16)        }
    shl AX,1                  { AX=rot*32                 }
    add BX,AX                 { BX=nu rot*(512+16+32)     }
    add BX,32768              { NEG werkt niet!?          }

    mov DS,[SEG1]
    mov [transp],BX           { store transtabel-pointer  }
    mov DS,[SEG3]

    mov word ptr[screen],(200+YSHIFT)*320+XPOS-2+2*SIZE
    mov word ptr[screen2],((198-2*LINES)-KIM+YSHIFT)*320+XPOS-2+2*SIZE

    mov word ptr [loop],LINES  { for loop=0 to 69          }
picture_q2:
    sub byte ptr [hight],2    { hoogteverschil scherm     }
    mov DS,[SEG1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,[xp]
    sub AX,DS:[SI+2]          { start x-coord lijn        }
    mov BP,DS:[SI]            { start y-coord lijn        }
    add BP,[yp]
    mov DX,DS:[SI+6]          { xmin                      }
    mov DI,DS:[SI+4]          { yplus                     }
    add word ptr [transp],8
    mov DS,[SEG3]

    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov DS,[SEG3]

    shr DI,8
    shl DI,10
    mov [ceiling],DI

    mov DS,[SEG1]
    mov SI,DS:[SI]            { en haal actuele veld op   }
    mov DS,[SEG3]

    shr SI,8
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub word ptr [screen],320+2*SIZE
    add word ptr [screen2],320-2*SIZE
    mov BX,[steptab]          { haal adres step-tabel     }
    mov BX,DS:[BX]            { BX bevat nu stepsize      }
    mov [stepsize],BX         { bewaar stepsize           }
    add word ptr [steptab],2  { alvast voor volgende lijn }
    mov BX,[coltab]           { haal adres colortabel     }
    mov DX,DS:[BX]            { SP bevat colsize          }
    mov [exsp],DX
    add word ptr [coltab],2   { alvast voor volgende lijn }
    mov word ptr [inner],SIZE { dot-counter               }
    mov word ptr [htable],64999

    cmp SI,17                 { blokken 1-7               }
    jb  special_q2            { speciale behandeling      }

    shl SI,10

drawline_q2:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  skipx_q2              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  cx_q2
    add BP,[ydelta]
    jo  cy_q2
    dec word ptr [inner]
    jnz drawline_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q2:
    sub AX,[xdelta]
    jo  cx_q2
    add BP,[ydelta]
    jo  cy_q2
    dec word ptr [inner]
    jnz drawline_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q2:
    dec word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sx_entry_q2
wx_entry_q2:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    add BP,[ydelta]
    jo  cy_q2
    dec word ptr [inner]
    jnz drawline_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q2:
    add word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sy_entry_q2
wy_entry_q2:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz drawline_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }

special_q2:                   { Muren met plaatselijke    }
    shl SI,10                 { balkjes (tralies ofzo)    }
sp_loop_q2:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  sskipx_q2             { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    cmp CL,0                  { lijntje omhoog trekken    }
    jz  sp_blk_q2             { speciale routine daarvoor }
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  scx_q2
    add BP,[ydelta]
    jo  scy_q2
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sp_blk_q2:
    mov DI,[htable]
    mov byte ptr DS:[DI],0    { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]    { Bereken hoogte muur       }
    shr CX,8                  { CX is nu loop-counter     }
    add CL,3                  { Iets overdrijven graag    }
    mov DI,[screen]           { huidige schermadres       }
    cmp CX,KIM+2*LINES+1      { maximale hoogte?          }
    jz  no_bar_q2             { dan zwart tekenen         }
    mov [store1],AX
    mov [store2],SI
    mov [store3],BP
    mov BP,SI
    shr BP,10
    sub BP,1
    mov BX,32*2048-1          { Onderaan beginnen         }
    push DX
    mov DX,[stepsize]         { Aantal stappen per pixel  }
bar_q2:
    mov SI,BX                 { bereken adres in bitmap   }
    shr SI,11                 { delen door 2048           }
    shl SI,5                  { *32 geeft goede adres     }
    add SI,BP                 { + muurtype                }
    mov AL,DS:[SI]            { haal byte op              }
    mov AH,AL                 { effe 16 bits maken        }
    add AX,[exsp]
    mov ES:[DI],AX            { en tekenen graag          }
    sub DI,320                { volgende schermregel      }
    sub BX,DX                 { opschuiven in brongebied  }
    loop bar_q2
    pop DX
    mov AX,[store1]
    mov SI,[store2]
    mov BP,[store3]
    sub AX,[xdelta]
    jo  scx_q2
    add BP,[ydelta]
    jo  scy_q2
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
no_bar_q2:
    mov word ptr ES:[DI],0
    sub DI,320
    loop no_bar_q2
    sub AX,[xdelta]
    jo  scx_q2
    add BP,[ydelta]
    jo  scy_q2
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sskipx_q2:
    sub AX,[xdelta]
    jo  scx_q2
    add BP,[ydelta]
    jo  scy_q2
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scx_q2:
    dec word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q2           { gewone vloertegel         }
sx_entry_q2:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    add BP,[ydelta]
    jo  scy_q2
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scy_q2:
    add word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q2           { gewone vloertegels        }
sy_entry_q2:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz sp_loop_q2
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q2            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q3:                           { rotaties van 0-89 graden  }
    sub AX,45
    cmp AX,45
    jae q4
    mov BX,AX                 { BX=rot*560                }
    shl BX,9                  { BX=rot*512                }
    shl AX,4                  { AX=rot*16                 }
    add BX,AX                 { BX=nu rot*(512+16)        }
    shl AX,1                  { AX=rot*32                 }
    add BX,AX                 { BX=nu rot*(512+16+32)     }
    add BX,32768              { NEG werkt niet!?          }

    mov DS,[SEG1]
    mov [transp],BX           { store transtabel-pointer  }
    mov DS,[SEG3]

    mov word ptr[screen],(200+YSHIFT)*320+XPOS-2+2*SIZE
    mov word ptr[screen2],((198-2*LINES)-KIM+YSHIFT)*320+XPOS-2+2*SIZE

    mov word ptr [loop],LINES { for loop=0 to 69          }
picture_q3:
    sub byte ptr [hight],2    { hoogteverschil scherm     }
    mov DS,[SEG1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,[xp]
    sub AX,DS:[SI]            { start x-coord lijn        }
    mov BP,[yp]
    sub BP,DS:[SI+2]          { start y-coord lijn        }
    mov DX,DS:[SI+4]          { xmin                      }
    mov DI,DS:[SI+6]          { ymin                      }
    add word ptr [transp],8
    mov DS,[SEG3]

    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov DS,[SEG3]

    shr DI,8
    shl DI,10
    mov [ceiling],DI

    mov DS,[SEG1]
    mov SI,DS:[SI]            { en haal actuele veld op   }
    mov DS,[SEG3]

    shr SI,8
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub word ptr [screen],320+2*SIZE
    add word ptr [screen2],320-2*SIZE
    mov BX,[steptab]          { haal adres step-tabel     }
    mov BX,DS:[BX]            { BX bevat nu stepsize      }
    mov [stepsize],BX         { bewaar stepsize           }
    add word ptr [steptab],2  { alvast voor volgende lijn }
    mov BX,[coltab]           { haal adres colortabel     }
    mov DX,DS:[BX]            { SP bevat colsize          }
    mov [exsp],DX
    add word ptr [coltab],2   { alvast voor volgende lijn }
    mov word ptr [inner],SIZE { dot-counter               }
    mov word ptr [htable],64999

    cmp SI,17                 { blokken 1-7               }
    jb  special_q3            { speciale behandeling      }

    shl SI,10

drawline_q3:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  skipx_q3              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  cx_q3
    sub BP,[ydelta]
    jo  cy_q3
    dec word ptr [inner]
    jnz drawline_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q3:
    sub AX,[xdelta]
    jo  cx_q3
    sub BP,[ydelta]
    jo  cy_q3
    dec word ptr [inner]
    jnz drawline_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q3:
    dec word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sx_entry_q3
wx_entry_q3:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    sub BP,[ydelta]
    jo  cy_q3
    dec word ptr [inner]
    jnz drawline_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q3:
    sub word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sy_entry_q3
wy_entry_q3:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz drawline_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }

special_q3:                   { Muren met plaatselijke    }
    shl SI,10                 { balkjes (tralies ofzo)    }
sp_loop_q3:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  sskipx_q3             { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    cmp CL,0                  { lijntje omhoog trekken    }
    jz  sp_blk_q3             { speciale routine daarvoor }
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    sub AX,[xdelta]
    jo  scx_q3
    sub BP,[ydelta]
    jo  scy_q3
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sp_blk_q3:
    mov DI,[htable]
    mov byte ptr DS:[DI],0    { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]    { Bereken hoogte muur       }
    shr CX,8                  { CX is nu loop-counter     }
    add CL,3                  { Iets overdrijven graag    }
    mov DI,[screen]           { huidige schermadres       }
    cmp CX,KIM+2*LINES+1      { maximale hoogte?          }
    jz  no_bar_q3             { dan zwart tekenen         }
    mov [store1],AX
    mov [store2],SI
    mov [store3],BP
    mov BP,SI
    shr BP,10
    sub BP,1
    mov BX,32*2048-1          { Onderaan beginnen         }
    push DX
    mov DX,[stepsize]         { Aantal stappen per pixel  }
bar_q3:
    mov SI,BX                 { bereken adres in bitmap   }
    shr SI,11                 { delen door 2048           }
    shl SI,5                  { *32 geeft goede adres     }
    add SI,BP                 { + muurtype                }
    mov AL,DS:[SI]            { haal byte op              }
    mov AH,AL                 { effe 16 bits maken        }
    add AX,[exsp]
    mov ES:[DI],AX            { en tekenen graag          }
    sub DI,320                { volgende schermregel      }
    sub BX,DX                 { opschuiven in brongebied  }
    loop bar_q3
    pop DX
    mov AX,[store1]
    mov SI,[store2]
    mov BP,[store3]
    sub AX,[xdelta]
    jo  scx_q3
    sub BP,[ydelta]
    jo  scy_q3
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
no_bar_q3:
    mov word ptr ES:[DI],0
    sub DI,320
    loop no_bar_q3
    sub AX,[xdelta]
    jo  scx_q3
    sub BP,[ydelta]
    jo  scy_q3
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sskipx_q3:
    sub AX,[xdelta]
    jo  scx_q3
    sub BP,[ydelta]
    jo  scy_q3
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scx_q3:
    dec word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q3           { gewone vloertegel         }
sx_entry_q3:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    sub BP,[ydelta]
    jo  scy_q3
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scy_q3:
    sub word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q3           { gewone vloertegels        }
sy_entry_q3:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz sp_loop_q3
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q3            { volgende lijn             }
    jmp einde                 { verlaat routine           }

q4:                           { rotaties van 0-89 graden  }
    sub AX,45
    mov BX,AX                 { BX=rot*560                }
    shl BX,9                  { BX=rot*512                }
    shl AX,4                  { AX=rot*16                 }
    add BX,AX                 { BX=nu rot*(512+16)        }
    shl AX,1                  { AX=rot*32                 }
    add BX,AX                 { BX=nu rot*(512+16+32)     }
    add BX,32768              { NEG werkt niet!?          }

    mov DS,[SEG1]
    mov [transp],BX           { store transtabel-pointer  }
    mov DS,[SEG3]

    mov word ptr[screen],(200+YSHIFT)*320+XPOS-2+2*SIZE
    mov word ptr[screen2],((198-2*LINES)-KIM+YSHIFT)*320+XPOS-2+2*SIZE

    mov word ptr [loop],LINES { for loop=0 to 69          }

picture_q4:
    sub byte ptr [hight],2    { hoogteverschil scherm     }
    mov DS,[SEG1]
    mov SI,[transp]           { restore transtabel-pointer}
    mov AX,DS:[SI+2]          { start x-coord lijn        }
    add AX,[xp]
    mov BP,[yp]
    sub BP,DS:[SI]            { start y-coord lijn        }
    mov DX,DS:[SI+6]          { xplus                     }
    mov DI,DS:[SI+4]          { ymin                      }
    add word ptr [transp],8
    mov DS,[SEG3]

    mov [xdelta],DX           { free registers, use mem.  }
    mov [ydelta],DI           { idem                      }
    mov SI,AX                 { adres op map=             }
    shr SI,9                  { bx shr 8+                 }
    mov DI,BP                 { (cx shr 8)                }
    shr DI,9
    shl DI,7
    add SI,DI                 { si= nu adres op map       }
    mov [map],SI              { bewaar dat adres          }

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov DS,[SEG3]

    shr DI,8
    shl DI,10
    mov [ceiling],DI

    mov DS,[SEG1]
    mov SI,DS:[SI]            { en haal actuele veld op   }
    mov DS,[SEG3]

    shr SI,8
    shl AX,7                  { laagste 7 bits * 512      }
    shl BP,7                  { levert start-steps op     }
    xor AH,128
    xor BP,32768
    sub word ptr [screen],320+2*SIZE
    add word ptr [screen2],320-2*SIZE
    mov BX,[steptab]          { haal adres step-tabel     }
    mov BX,DS:[BX]            { BX bevat nu stepsize      }
    mov [stepsize],BX         { bewaar stepsize           }
    add word ptr [steptab],2  { alvast voor volgende lijn }
    mov BX,[coltab]           { haal adres colortabel     }
    mov DX,DS:[BX]            { SP bevat colsize          }
    mov [exsp],DX
    add word ptr [coltab],2   { alvast voor volgende lijn }
    mov word ptr [inner],SIZE { dot-counter               }
    mov word ptr [htable],64999

    cmp SI,17                 { blokken 1-7               }
    jb  special_q4            { speciale behandeling      }

    shl SI,10

drawline_q4:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  skipx_q4              { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  cx_q4
    sub BP,[ydelta]
    jo  cy_q4
    dec word ptr [inner]
    jnz drawline_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
skipx_q4:
    add AX,[xdelta]
    jo  cx_q4
    sub BP,[ydelta]
    jo  cy_q4
    dec word ptr [inner]
    jnz drawline_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cx_q4:
    inc word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sx_entry_q4
wx_entry_q4:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    sub BP,[ydelta]
    jo  cy_q4
    dec word ptr [inner]
    jnz drawline_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
cy_q4:
    sub word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    jbe sy_entry_q4
wy_entry_q4:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz drawline_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }

special_q4:                   { Muren met plaatselijke    }
    shl SI,10                 { balkjes (tralies ofzo)    }
sp_loop_q4:
    add word ptr [screen],2
    add word ptr [screen2],2
    inc word ptr [htable]
    mov DI,[htable]
    cmp byte ptr DS:[DI],0    { cmp SS:[htable] gaat fout }
    jz  sskipx_q4             { x niet meer behandelen    }
    mov BX,SI                 { haal byte uit map-memory  }
    mov BL,AH                 { VERY tricky piece of code }
    shr BL,3
    mov DI,BP
    shr DI,11
    shl DI,5
    mov CL,DS:[DI+BX]
    cmp CL,0                  { lijntje omhoog trekken    }
    jz  sp_blk_q4             { speciale routine daarvoor }
    mov CH,CL
    add CX,DX
    sub DI,SI
    add DI,[ceiling]
    mov BL,DS:[DI+BX]         { BL bevat plafond-pixel    }
    mov BH,BL
    add BX,DX                 { CH en CL donkerder maken  }
    mov DI,[screen2]
    mov ES:[DI],BX
    mov DI,[screen]
    mov ES:[DI],CX
    add AX,[xdelta]
    jo  scx_q4
    sub BP,[ydelta]
    jo  scy_q4
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sp_blk_q4:
    mov DI,[htable]
    mov byte ptr DS:[DI],0    { blokkeer x-coordinaat     }
    mov CH,byte ptr[hight]    { Bereken hoogte muur       }
    shr CX,8                  { CX is nu loop-counter     }
    add CL,3                  { Iets overdrijven graag    }
    mov DI,[screen]           { huidige schermadres       }
    cmp CX,KIM+2*LINES+1      { maximale hoogte?          }
    jz  no_bar_q4             { dan zwart tekenen         }
    mov [store1],AX
    mov [store2],SI
    mov [store3],BP
    mov BP,SI
    shr BP,10
    sub BP,1
    mov BX,32*2048-1          { Onderaan beginnen         }
    push DX
    mov DX,[stepsize]         { Aantal stappen per pixel  }
bar_q4:
    mov SI,BX                 { bereken adres in bitmap   }
    shr SI,11                 { delen door 2048           }
    shl SI,5                  { *32 geeft goede adres     }
    add SI,BP                 { + muurtype                }
    mov AL,DS:[SI]            { haal byte op              }
    mov AH,AL                 { effe 16 bits maken        }
    add AX,[exsp]
    mov ES:[DI],AX            { en tekenen graag          }
    sub DI,320                { volgende schermregel      }
    sub BX,DX                 { opschuiven in brongebied  }
    loop bar_q4
    pop DX
    mov AX,[store1]
    mov SI,[store2]
    mov BP,[store3]
    add AX,[xdelta]
    jo  scx_q4
    sub BP,[ydelta]
    jo  scy_q4
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
no_bar_q4:
    mov word ptr ES:[DI],0
    sub DI,320
    loop no_bar_q4
    sub AX,[xdelta]
    jo  scx_q4
    sub BP,[ydelta]
    jo  scy_q4
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
sskipx_q4:
    add AX,[xdelta]
    jo  scx_q4
    sub BP,[ydelta]
    jo  scy_q4
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scx_q4:
    inc word ptr [map]
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q4           { gewone vloertegel         }
sx_entry_q4:                  { dirty-jump spot           }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    sub BP,[ydelta]
    jo  scy_q4
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }
scy_q4:
    sub word ptr [map],MWIDTH
    mov SI,[map]

    mov DS,[SEG1]
    mov DI,DS:[SI+16384]
    mov SI,DS:[SI]
    mov DS,[SEG3]

    shr SI,8
    cmp SI,16
    ja  wx_entry_q4           { gewone vloertegels        }
sy_entry_q4:                  { nasty-branch place        }
    shr DI,8
    shl DI,10
    mov [ceiling],DI
    shl SI,10
    dec word ptr [inner]
    jnz sp_loop_q4
    dec word ptr [loop]       { verlaag loopcounter       }
    jnz picture_q4            { volgende lijn             }
    jmp einde                 { verlaat routine           }


einde:
    mov DI,XPOS+((199-(LINES-YSHIFT))-KIM)*320
                              { beginadres huidige x      }
    mov BP,SIZE               { loopcounter (horizontaal  }
    mov SI,65000              { adres htable              }
    mov AL,0
    mov DL,255*HAZE
    mov DH,DL
clear:
    cmp DS:[SI],AL            { staat daar een muur?      }
    jz nextx                  { ja: volgende x positie    }
    mov CX,KIM+1              { anders lijntje trekken    }
    mov BX,DI                 { haal beginadres op        }
drawx:
    mov ES:[BX],DX            { zet een byte neer         }
    add BX,320                { volgende regel            }
    loop drawx
nextx:
    add DI,2
    inc SI
    dec BP                    { volgende kolom graag      }
    jnz clear
    mov BP,word ptr [basep]
    pop DS

end;

procedure Move(d: string; r1,r2,dr,t1,t2,ds,vr1,vr2,vrs: integer);
{ Demo-sequence command parser }
var rr,sr: integer;     {richting en snelheid van veranderingen}
    nokke: boolean;
    i: word;
begin
    if (r1<>0) or (t1<>0) or (vrs<>0) then begin
       if (r1=0) and (r2=0) then begin
          r1:=r;
          r2:=r;
          dr:=0;
       end;
       if (t1=0) and (t2=0) then begin
          t1:=v;
          t2:=v;
          ds:=0;
       end;
       if (vr1=0) and (vr2=0) then begin   {follow direction}
          vr1:=r1;
          vr2:=r2;
          vrs:=dr;
       end;
       r:=r1;
       v:=t1;
       repeat
          r:=r+dr;
          if (r>179) then r:=r-180;
          if (r<0) then r:=r+180;
          if (r=r2) then dr:=0;
          v:=v+ds;
          if (v=t2) then ds:=0;
          vr1:=vr1+vrs;
          if (vr1>179) then vr1:=vr1-180;
          if (vr1<0) then vr1:=vr1+180;
          if (vr1=vr2) then vrs:=0;
          x2:=x2+((px[r]*v) div 100);
          y2:=y2+((py[r]*v) div 100);
          ScrollLava;
          DrawInside(x2,y2,vr1);
          WaitVbl;
       until ((ds=0) and (dr=0) and (vrs=0)) or keypressed;
    end else if (dr>0) then begin
       repeat
          x2:=x2+((px[r]*v) div 100);
          y2:=y2+((py[r]*v) div 100);
          dr:=dr-1;
          ScrollLava;
          DrawInside(x2,y2,r);
          WaitVbl;
       until (dr=0) or keypressed;
    end;
    if keypressed then quit:=True;
end;

procedure Initialize;
begin
    for i:=0 to 360 do begin
       sn[i]:=sin((i*3.14159)/180);
       cs[i]:=cos((i*3.14159)/180);
    end;

    GetMem(p1,65535);
    GetMem(p3,65535);
    assign (f,'3dspace.wad');
    reset(f,1);
    BlockRead(f,p1^,65535);
    BlockRead(f,p3^,65535);
    close(f);

    s3:=Seg(p3^);
    s1:=Seg(p1^);

    InitScreen;
    NCls(0);
    for i:=0 to 255 do palette(i,0,0,0);

    {Achtergrond voor scroller opslaan}
    x2:=-1551;
    y2:=-9232;
    r:=90;
    v:=0;
    DrawInside(x2-21*512,y2,r);
    GetMem(p2,64000);
    s2:=Seg(p2^);
    for a1:=0 to 15999 do meml[s2:a1 shl 2]:=meml[$a000:a1 shl 2];
    NCls(0);
    SetPalette;

    for i:=0 to 179 do begin
       px[i]:=round(sin(i*3.14159/90)*100);
       py[i]:=round(-cos(i*3.14159/90)*100);
    end;

end;

procedure SetColor(n,x,y,z: byte);
var i: byte;
begin
   for i:=0 to 7 do palette(n+i*32,x-(x*i) div 8,y-(y*i) div 8,z-(z*i) div 8);
end;

procedure EndOfDemo;
begin
    TextMode(LastMode);
    ClrScr;
end;

procedure FloorPixel(n,x,y: byte);
var a: word;
begin
   a:=((x+16) mod 32)+32*((y+16) mod 32);
   mem[s3:a+n*1024]:=mem[s3:a+57*1024];
end;

procedure DarkPixel(n,x,y,c: byte);
var a: word;
begin
   a:=((x+16) mod 32)+32*((y+16) mod 32);
   mem[s3:a+n*1024]:=c;
end;


{/////////////////////////////////////////////////////////////////////}
{///                                                               ///}
{///          THE   ANIMATION !!                                   ///}
{///                                                               ///}
{/////////////////////////////////////////////////////////////////////}


begin
  Initialize;

  v:=0;
  Quit:=False;
                       {'description', r1, r2,dr,  s1,  s2,ds,vr1,vr2,vrs}
                       {'-----------  --- --- -- ---- ---- --}
  { Make elevator door visible }
  for i:=0 to 7 do begin
     SetColor(8,50,50,55);
     SetColor(9,45,45,50);
  end;

  x2:=-6953;
  y2:=13417;
  r:=143;

  { Open the elevator door }
  if not quit then begin
     for i:=0 to 59 do begin
        for b:=10 to 19 do begin
           DarkPixel(14,b,i div 2,12);
           DarkPixel(15,b,31-i div 2,12);
        end;
        DarkPixel(14,20,i div 2,1);
        DarkPixel(14,21,i div 2,1);
        DarkPixel(15,20,31-i div 2,1);
        DarkPixel(15,21,31-i div 2,1);
        if i<31 then begin
           for b:=0 to 9 do begin
              FloorPixel(14,b,i);
              FloorPixel(14,b,i+1);
              FloorPixel(15,b,31-i);
              FloorPixel(15,b,30-i);
           end;
           for b:=22 to 31 do begin
              FloorPixel(14,b,i);
              FloorPixel(14,b,i+1);
              FloorPixel(15,b,31-i);
              FloorPixel(15,b,30-i);
           end;
        end;
        DrawInside(x2,y2,r);
     end;
  end;

  { Start of part two: Cam. is now right in front of elevator }
  if not quit then Move('Go in room ',143,138,-1,   1,  71, 2,  0,  0, 0);
  if not quit then Move('Stop       ',  0,  0, 2,  70,   0,-2,  0,  0, 0);
  if not quit then Move('Look left  ',138,100,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Wait       ',  0,  0,30,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Look right ',100,140, 1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('accelerate ',140,  0, 1,   1,  71, 2,  0,  0, 0);
  if not quit then Move('high speed ',  0,  0, 0,  71, 161, 2,  0,  0, 0);
  if not quit then Move('corner     ',  1, 45, 2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('straigt    ',  0,  0,45,   0,   0, 0,  0,  0, 0);
  if not quit then Move('avoid      ', 45, 32,-1,   0,   0, 0, 45, 71, 2);
  if not quit then Move('           ', 32, 58, 1,   0,   0, 0, 71,111, 2);
  if not quit then Move('           ', 58, 45,-1, 161, 251, 0,111, 45,-3);
  if not quit then Move('           ',  0,  0,13,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Go artifact',  0,  0, 0, 251,   1,-10, 0,  0, 0);
  if not quit then Move('See it     ',  0,  0,20,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Turn back  ',110, 95,-1,   1,  41, 2, 45, 10,-1);
  if not quit then Move('Further    ', 95, 75,-2,  40,   0,-4, 10,  0,-1);
  if not quit then Move('Turn left  ',179,169,-1,   1,  41, 4,  0,  0, 0);
  if not quit then Move('Speed      ',169,141,-2,  41, 185, 4,  0,  0, 0);
  if not quit then Move('Bounce     ',141,131,-1, 185, 221, 4,  0,  0, 0);
  if not quit then Move('Appr. wall ',  0,  0,10,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Hit wall   ',131,135, 1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('Beng       ',  0,  0, 2,   0,   0, 0,  0,  0, 0);
  r:=45;
  if not quit then Move('Stop bounce',  0,  0, 0, 216,   0,-8,135,135, 0);
  if not quit then Move('go forward ',135,135, 0,   2,  42, 4,  0,  0, 0);
  if not quit then Move('avoid wall ',135,150, 1,  42,  82, 2,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 6,   0,   0, 0,  0,  0, 0);
  if not quit then Move('past wall  ',150,135,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,10,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',135,120,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',120,135, 1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,17,   0,   0, 0,  0,  0, 0);
  if not quit then Move('turn right ',136,178, 2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('go in room ',  0,  0, 0,  82, 154, 4,  0,  0, 0);
  if not quit then Move('allign     ',178,  0, 1, 154, 190, 4,  0,  0, 0);
  if not quit then Move('           ',  0,  0,10,   0,   0, 0,  0,  0, 0);

  v:=190;
  r:=0;
  x2:=-1402;
  y2:=-2585;
  if not quit then Move('Look back  ',  0,  0, 0,   0,   0, 0,179,155,-3);
  if not quit then Move('and stop   ',  0,  0, 0, 184,   0,-8,153, 90,-3);
  if not quit then Move('Avoid pilar', 90, 98, 1,   1,   9, 1,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0,   9,  41, 4,  0,  0, 0);
  if not quit then Move('           ', 98, 92,-1,  41,  65, 4,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 90,135, 3,  65,  89, 2,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0,  89, 149, 4,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 7,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',135,157, 2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',158, 45, 1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,37,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 45,137, 4,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0, 149, 101,-2,137, 21, 2);
  if not quit then Move('           ',  0,  0, 0,  96,   0,-6, 21, 45, 2);
  if not quit then Move('           ', 45, 45, 0,   1,  21, 2,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 45, 90, 1,  21,  45, 1,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0,  44,   0,-4,  0,  0, 0);

  x2:=-1551;
  y2:=-9232;
  r:=90;
  v:=0;
  DrawInside(x2,y2,r);
  { Blok laten zakken (shit best wel moeilijk) }
  if not quit then begin
     for i:=20 to 67 do by[i]:=round(4096*(((154-104)+((24/47)*(67-i)))/(178-104)));
     for i:=81 to 224 do by[i]:=round(4096*((154-104)/(178-104)));
     for i:=250 to 295 do by[i]:=round(4096*(((154-104)+((24/45)*(i-250)))/(178-104)));
     for i:=31 to 104 do begin
        for c:=20 to 295 do mem[$a000:i*320+c]:=mem[s2:i*320+c];
        for c:=67 to 157 do begin
           a1:=(160-(c-66));
           if ((a1+i-31)<178) then mem[$a000:c+(a1+i-31)*320]:=1;
        end;
        for c:=158 to 247 do begin
           a1:=c-88;
           if ((a1+i-31)<178) then mem[$a000:c+(a1+i-31)*320]:=1;
        end;
        WaitVbl;
        WaitVbl;
     end;
     for i:=105 to 178 do begin
        for c:=67 to 157 do begin
           a1:=(160-(c-66));
           if ((a1+i-31)<178) then mem[$a000:c+(a1+i-31)*320]:=1;
        end;
        for c:=158 to 247 do begin
           a1:=c-88;
           if ((a1+i-31)<178) then mem[$a000:c+(a1+i-31)*320]:=1;
        end;

        for c:=20 to 67 do begin
           a1:=(((by[c]*(i-105)) shr 12)+104)*320+c;
           mem[$a000:a1]:=mem[s2:a1];
        end;
        for c:=250 to 295 do begin
           a1:=(((by[c]*(i-105)) shr 12)+104)*320+c;
           mem[$a000:a1]:=mem[s2:a1];
        end;
        a1:=(((by[81]*(i-105)) shr 12)+104)*320;
        for c:=68 to 249 do mem[$a000:a1+c]:=mem[s2:a1+c];
        WaitVbl;
        WaitVbl;
     end;
  end;

  mem[s1:6077]:=55;  {muur vervangen door zwarte vlakken}
  mem[s1:6078]:=55;
  for x:=0 to 255 do meml[s3:14*1024+x shl 2]:=0;
  for x:=0 to 31 do meml[s3:x*32+13]:=2;
  x2:=-1551;
  y2:=-9232;
  r:=90;
  v:=0;
  SetPalette;
  if not quit then Move('           ',  0,  0,20,   0,   0, 0,  0,  0, 0);
  if not quit then Move('End movie  ', 90, 50,-1,  -1, -21,-2,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0, -20,   0, 2,  0,  0, 0);
  if not quit then Move('           ', 50, 30,-1,   2, 102, 4,  0,  0, 0);
  if not quit then Move('           ', 30, 45, 1, 102, 178, 4,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0, 176,   0,-8,  0,  0, 0);
  if not quit then Move('           ', 45, 16,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 16, 50, 2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 50, 90, 2,   2, 142, 4,  0,  0, 0);
  if not quit then Move('           ', 90, 45,-3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,10,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 45, 21,-3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 21,  0,-3,   0,   0, 0, 21,157,-4);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,157,154,-3);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,154,152,-2);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,152,151,-1);
  if not quit then Move('           ',  0,  0, 0, 142, 140,-2,151,151, 0);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,151,152, 1);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,152,154, 2);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,154,  1, 3);
  if not quit then Move('           ',  1, 28, 3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,22,   0,   0, 0,  0,  0, 0);

  x2:=11247;
  y2:=-13750;
  r:=28;
  v:=140;
  if not quit then Move('           ', 29, 45, 1, 140,  32,-3,  0,  0, 0);
  if not quit then Move('           ', 45, 90, 3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0,  32, 320, 8,  0,  0, 0);
  r:=0; {smash}
  if not quit then Move('           ',  0,  0,15,   0,   0, 0, 88, 10,-6);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0, 10,  6,-4);
  if not quit then Move('           ',  0,  0, 0,   0,   0, 0,  6,  0,-2);
  if not quit then Move('           ',179,131,-6,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',131,126,-5,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',126,122,-4,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',122,119,-3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',119, 97,-2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 97, 90,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0,10,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 0, 320, 264,-8,  0,  0, 0);
  if not quit then Move('           ', 90, 54,-3,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 54, 48,-2,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ', 48, 45,-1,   0,   0, 0,  0,  0, 0);
  if not quit then Move('           ',  0,  0, 1,   0,   0, 0,  0,  0, 0);
  for a1:=0 to 15999 do meml[$a000:a1 shl 2]:=$2020202;
  for i:=0 to 63 do begin
     palette(2,63-i,0,0);
     WaitVbl;
  end;
  EndOfDemo;
end.






