/************************************************
   
  Global record structures for WILDCAT! version 4.0
  Copyright 1986,94 Mustang Software Inc. 
  All rights reserved.
                                                                             
    Last Revised: 04-07-94

************************************************/

#include "wcstring.h" 


typedef unsigned char        BYTEBOOL;
typedef unsigned int         WORD;
typedef unsigned char        BYTE;
 
/* Defined maximum limits */

extern const WORD  MaximumConfs;
extern const WORD  MaximumFiles;
extern const WORD  MaximumMsgs;
extern const int   MaximumProfiles;
extern const int   MaximumDoors;
extern const int   MaximumIdle;
extern const int   MaximumLang;

typedef WORD Date;
typedef long Time;

typedef struct tagTDateTime {
  Date                     D;
  Time                     T;
} TDateTime;

/* Various bit set types */

typedef BYTE                 TNodeInfoBits[32];
typedef TNodeInfoBits        *PNodeInfoBits;
typedef BYTE                 TArray1000Bits[126];
typedef BYTE                 TArray32768Bits[4096];


/* Modem profile file (*.MDM) */

extern const int mpFixedRate;
extern const int mpCtsRtsFlow;
extern const int mpDropOnExit;
                            
enum TGetBaud                {gbResult1, gbResult2, gbByCR, gbDTE};
enum TAnswer                 {aRing, aResult, aAutoAnswer};
enum TInterface              {iSerial, iDigiboard, iFossil, iNone};

enum TBaudType               {bNone,  b300,   b1200,  b2400,  b4800,  b7200, 
                              b9600,  b12000, b14400, b16800, b19200, b21600,
                              b24000, b26400, b28800, b38400, b57600, b115200};
                             
#define TBaudCount 18        /* Must be updated to reflect actual TBaudType count! */
                                                 
const extern long BaudNumber[];

typedef struct tagTModemProfile {
    WORD                     Version;
    Str30                    ModemName;
    long                     InitBaud;
    BYTE                     Commport,
                             CommIrq,
                             CarrierDelay,
                             pFlags,
                             FifoTrigger;
    WORD                     CommBase,
                             RingDelay,
                             DropDtrDelay,
                             PreLogDelay,
                             ResultDelay,
                             ResetDelay;
    BYTE                     AnswerPhone;        /* enum TAnswer */
    BYTE                     DetermineBaud;      /* enum TGetBaud */
    BYTE                     InterfaceType;      /* enum TInterface */
    Str60                    RingStr,
                             AnswerStr,
                             CallerIdStr, 
                             ModemReset,
                             OnHook,
                             OffHook,
                             ErrorStr,
                             ModemInit;
    Str20                    BaudStrings[20];
    long                     BaudRates[20];
    Str10                    DumpStr,
                             ResetStr,
                             WriteStr;
    Str40                    SetupStr[3];
    Str64                    Notes[3];
    BYTE                     FifoSend;
    BYTE                     Reserved[49];
} TModemProfile;

/* MakeWild file (MAKEWILD.DAT) */
                                                            
extern const long mwLogOffIfNotVerified;
extern const long mwSysopDropToDos;
extern const long mwShowSec;
extern const long mwUseClearScreens;
extern const long mwFreeFormPhone;
extern const long mwEncryptPasswords;
extern const long mwOverwriteChatFiles;
extern const long mwLockOutForSecError;
extern const long mwForceRipMode;
extern const long mwDynamicFileKeys;
extern const long mwSysopReadPrivate;
extern const long mwShowUserSec;
extern const long mwPrinterOnline;
extern const long mwBulletsOptional;
extern const long mwTerminateOnDoors;
extern const long mwAutoId;
extern const long mwForce8N1;
extern const long mwReserved3;
extern const long mwCopyOnCD;
extern const long mwIndexLongDesc;
extern const long mwAllowLocalUpgrades;
extern const long mwPreferredChatMode;
extern const long mwLanguageAtLogon;

extern const int mwTCBulletins;
extern const int mwTCNews;
extern const int mwTCFiles;
extern const int mwTCDetailDL;
extern const int mwTCCheckDups;
extern const int mwTCFaxSupport;

extern const int mwCTUserAliasAllowed;
extern const int mwCTActionWords;
extern const int mwCTPaging;
extern const int mwCTPrivateChan;
extern const int mwCTChangeTopic;
                                       
enum    TModerate            {mdAll, mdPrivate, mdPublic, mdNone};
enum    TSwapMethod          {tDisk, tEms, tXms, tNoSwap};
enum    TMonitorType         {sColor, sMono, sAuto};
enum    TSystemAccess        {cOpen, cClosed, cClosedComment, 
                              cClosedQuestionnaire};
enum    TDBProtect           {dbNone, dbMarkMode, dbSaveMode};
enum    TScreenBlank         {sbNone, sbBox, sbBlackOut};
enum    TConsoleSec          {csNone, csPassword, csNoConsole};
enum    TSettingSec          {ssYes, ssMessage, ssNo};
enum    TNetSupportType      {wcNoNet, wcNovell, wcMsNet};
enum    TSavePacketLevel     {plNone, plNetStatus, plAll};
enum    TColorMenus          {tAscii, tAnsi, tRip};
enum    TOverlayType         {otDisk, otEms, otXms};
enum    TDupUserType         {duNone, duNoneChk, duAllow};
                             
typedef BYTE                 TDriveTable[26];

typedef struct tagTCBaudLimitRec
{
    WORD                     MaxPacket;
    WORD                     MaxConf;
} TCBaudLimitRec;
  
typedef struct tagTPackerRec
{ 
    char                     Letter;
    Str30                    Description;
    Str03                    Extension;
    Str08                    PackerExe;
    Str40                    PackerCmdLine;
    Str08                    UnpackerExe;
    Str40                    UnpackerCmdLine;
} TPackerRec;
  
typedef struct tagTExcludeBullRec
{
    WORD                     Conference;
    WORD                     BullNumber;
} TExcludeBullRec;
  
typedef struct tagTMakeWildRec
{
    Str05                    MWVersion;
    Str25                    SysopName;
    Str05                    Reserved1;
    Str25                    FirstCall;
    Str08                    PacketId;
    Str25                    Phone;
    Str30                    BBSName;
    Str67                    FileDataBasePath,
                             UserDataBasePath,
                             NodeInfoPath,
                             ReservedPath,
                             BatchFilePath,
                             ModemFilePath,
                             ChatFilePath,
                             LanguagePath;
    Str10                    NewUserSec;
    BYTE                     MonitorType;        /* enum TMonitorType */
    BYTE                     CloseOption;        /* enum TSystemAccess */
    BYTE                     Network;            /* enum TNetSupportType */
    BYTE                     DatabaseMode;       /* enum TDBProtect */
    BYTE                     ScreenBlankMode;    /* enum TScreenBlank */
    WORD                     ScrollBackBuffer;
    char                     ExtLtr[10];
    Str12                    ExtUpBatch[10],
                             ExtDnBatch[10],
                             ExtName[10];
    BYTEBOOL                 ExtBatchDriven[10];
    BYTE                     ExtraMemForOverlay,
                             NodeId,
                             SecTries;
    WORD                     MaxFileAreas,
                             MaxConfAreas,
                             FirstCallLimit;
    long                     MwFlags;
    Str40                    DateFormat,
                             TimeFormat;
    Str07                    RegString;
    WORD                     FlexEventInactivity;
    Time                     FlexEventForceTime;
    TDriveTable              LockDriveTable;
    Str04                    DefaultExt;
    Str12                    ThumbNailFile;
    Str14                    ConsolePassword;
    BYTE                     ConsoleSec;         /* enum TConsoleSec */
    BYTE                     ChangePhone,        /* enum TSettingSec */
                             ChangeAlias,
                             ChangeBDate;
    BYTE                     SwapMethod;         /* enum TSwapMethod */
    TPackerRec               Packer[10];
    Str30                    TCCity;
    WORD                     TCFlags;
    WORD                     PreScanArea;
    BYTE                     SavePacketLevel;    /* enum TSavePacketLevel */
    TCBaudLimitRec           TCMaxPerBaud[TBaudCount];
    TExcludeBullRec          TCExcludeBulls[40];
    WORD                     MaxChannelSize;
    WORD                     ChatTimeOut;
    WORD                     TalkTimeOut;
    BYTE                     ChatWaitTime;
    BYTE                     ChatModerate;       /* enum TModerate */
    long                     ChatFlags;
    TModemProfile            ModemProfile;
    BYTE                     HoldOverlay;        /* enum TOverlayType */
    BYTE                     DupUserLevel;       /* enum TDupUserType */
    char                     Reserved[198];
} TMakeWildRec;

typedef TMakeWildRec         *PMakeWildRec;

/* Security profiles (SECLEVEL,DAT) */

enum TSysopAccess            {saNo, saYes, saMaster, saNetStatus};
enum TRatioAction            {raNothing, raWarn, raNoDownloads};
enum TProfileType            {ptFullProfile, ptSecondary};
enum TUploadType             {utNoDupes, utWarnOfDupe, utIgnore}; 

typedef BYTE                 TMenuItemAccess[8];

extern const long pfAscii;
extern const long pfXmodem;
extern const long pfXmodemCrc;
extern const long pfXmodem1K;
extern const long pfXmodem1kG;
extern const long pfYmodem;
extern const long pfYModemG;
extern const long pfKermit;
extern const long pfZmodem;
extern const long pfExternal1;
extern const long pfExternal2;
extern const long pfExternal3;
extern const long pfExternal4;
extern const long pfExternal5;
extern const long pfExternal6;
extern const long pfExternal7;
extern const long pfExternal8;
extern const long pfExternal9;
extern const long pfExternal10;

extern const long sfFastLogin;
extern const long sfOverwrite;
extern const long sfShowPWFiles;
extern const long sfTCFileAccess;
extern const long sfUpOverTime;
extern const long sfDnOverTime;
extern const long sfReserved;
extern const long sfDistMail;
extern const long sfModifyUpload;

extern const int cfChatSysop;
extern const int cfActionWords;
extern const int cfUninvite;
extern const int cfPageUsers;
extern const int cfModerator;
extern const int cfChatAlias;

extern const int sConfRead;
extern const int sConfWrite;
extern const int sConfJoin;

extern const int sFileList;
extern const int sFileDown;
extern const int sFileUp;

typedef struct tagTSecHeader
{
  Str10                    ProfileName;
  BYTE                     ProfileType;        /* enum TProfileType */
} TSecHeader;
  
typedef struct tagTSecRec
{
  Str10                    ProfileName;
  BYTE                     ProfileType;        /* enum TProfileType */
  Str10                    ExpiredName;
  Str08                    DisplayName;
  TNodeInfoBits            NodeAccess;
  TArray1000Bits           DoorAccess;
  TMenuItemAccess          MenuItemAccess;
  BYTE                     SysopStatus;        /* enum TSysopAccess */
  BYTE                     RatioAction;        /* enum TRatioAction */
  BYTE                     UploadComp,
                           MaxRatio;
  char                     Menus;
  WORD                     ChatFlags;
  long                     sFlags;
  Date                     ExpireDate;
  WORD                     DailyTimeLimit,
                           MaxLogon,
                           VerifyBDate,
                           VerifyPhone,
                           MaxDL,
                           MaxDK,
                           MaxKRatio,
                           MaxConfAreas,
                           MaxFileAreas,
                           FaxFlags;
  Str10                    DoorProfile;
  BYTE                     UploadAccess;       /* enum TUploadType */                  
  char                     Reserved[36];
} TSecRec;

/* Conference name list (CONFDESC.IX, CONFDESC.UX) */

typedef struct tagTConfList
{
  Str25                    ConfName;
  WORD                     ConfNum;
} TConfList;
  
/* Conference list (CONFDESC.DAT) */

extern const int cfPromptToKillMsg;
extern const int cfHighAscii;
extern const int cfAllowCarbon;
extern const int cfReserved1;
extern const int cfReserved2;
extern const int cfReturnReceipt;
extern const int cfLongAddress;
extern const int cfUseAlias;
extern const int cfAllowAttach;
extern const int cfPromptToKillAttach;
extern const int cfShowCtrlLines;

enum    TMailType          {mtNormalPublicPrivate, 
                            mtNormalPublic, 
                            mtNormalPrivate,
                            mtFidoNetMail, 
                            mtInternetEmail, 
                            mtInternetNewsgroup};    
enum    TValidName         {vnYes, vnNo, vnPrompt};
                              
typedef struct tagTConfDesc
{                           
  Str25                    ConfName,
                           ConfOp;
  Str12                    ConfShortName;
  BYTE                     ConfMail;           /* enum TMailType */
  TArray1000Bits           DoorAccess;
  Str67                    BullPath,
                           QuesPath,
                           MenuPath,
                           HelpPath,
                           DisplayPath,
                           MsgPath,
                           AttachPath;
  BYTE                     Reserved1;         
  WORD                     cFlags,
                           ConfNumber;
  BYTE                     ValidNames;         /* enum TValidName */
  WORD                     MaxMessages,
                           MaxFileAreas;
  char                     Reserved[50];
} TConfDesc;
                              
/* File area name file (FILEAREA.IX, FILEAREA.UX) */

typedef struct tagTFileList
{
  Str30                    AreaName;
  WORD                     AreaNumber;
} TFileList;
  
/* File Area file (FILEAREA.DAT) */

typedef struct tagTFileAreaRec
{
  Str30                    AreaName;
  Str67                    AreaPath;
  char                     Reserved[20];
} TFileAreaRec;
  
/* Language file (LANGDESC.DAT) */

typedef struct tagTLangDesc
{
  Str08                    Language;
  Str73                    Description;
  char                     YesChar;
  char                     NoChar;
} TLangDesc;
  
/* Door file (DOOR.DAT) */

extern const int diMultiUser;
extern const int diInUse;
extern const int diMenuHook;

typedef struct tagTDoor
{                         
  Str20                    diName;
  Str08                    diBat;
  Str08                    diDisp;
  BYTE                     diFlags;
  char                     Reserved[20];
} TDoor;
  
/* Idle program data (IDLEPGM.DAT) */

typedef struct tagTIdleProgram
{
  Str30                    Name;
  Str79                    ShellPath;
  Str14                    Password;
  char                     Reserved[20];
} TIdleProgram;

/* Master info file (NODEINFO.DAT record 0) */

typedef struct tagTMasterInfo
{
  Str05                    VersionId;
  TNodeInfoBits            ActiveNodes;
  long                     TotalCalls,
                           TotalUsers,
                           TotalFiles,
                           TotalMessages;
  WORD                     TempCalls,
                           TempMsgs,
                           TempDownloads,
                           TempUploads;
  BYTE                     ReservedWords[8];                         
  TDateTime                TempReset;
  long                     HighestUserId;
  BYTE                     ChatCount;
  char                     Reserved[160];
} TMasterInfo;
    
/* Nodeinfo file (NODEINFO.DAT) */

extern const long niLptr;
extern const long niPage;
extern const long niBell;
extern const long niKybd;
extern const long niLocalNext;
extern const long niScreenWrite;
extern const long niEventNext;
extern const long niBringDown;
extern const long niKillCaller;
extern const long niPagingSysop;
extern const long niOnLocally;
extern const long niMNPConnect;
extern const long niSysopNext;
extern const long niUseVgaMode;
extern const long niCapture;
extern const long niStayDown;

enum   TNodeStatus         {nsDown, nsUp, nsSigningOn, nsLoggedIn,  
                            nsEventProcessing, nsRepair, nsReceiveFax};
enum   TUserStatus         {usNone, usFileTransfer, usEnteringMsg, 
                            usInDoor, usInDOS, usPChat, usDChat};
enum   TSysWindow          {swNoWindow, swSingleWindow, swOrigWindow, 
                            swBigWindow};

typedef struct tagTNodeInfo
{
  Str10                    Security;
  BYTE                     NodeStatus;         /* enum TNodeStatus */
  BYTE                     UserStatus;         /* enum TUserStatus */
  BYTE                     SysWindow;          /* enum TSysWindow  */
  Str25                    CallersName;
  Str30                    From;
  Str50                    PrevCaller;
  long                     UserID;
  long                     BaudRate;
  TDateTime                TimeCalled,
                           PrevLogOff,
                           TimeOff;
  int                      RequestNode;
  long                     CallerNumber,
                           nFlags,
                           QuoteIndex,
                           LowestBaud;
  Str20                    CurStatus;
  long                     NumberOfCalls;
  char                     Reserved[50];
} TNodeInfo;
  
/* User database (ALLUSERS.DAT) */

extern const long ufNeverDelete;
extern const long ufChatPage;
extern const long ufHotKey;
extern const long ufLockedOut;
extern const long ufQuoteOnReply;
extern const long ufBellAtLogin;
extern const long ufNoPrivMail;
extern const long ufNoDelMail;
extern const long ufTCNoPvtExport;
extern const long ufTCSendFromYou;
extern const long ufTCSendNewFiles;
extern const long ufTCSendNewBulls;
extern const long ufTCUploadHangup;
extern const long ufTCAllAttachments;
extern const long ufTCScanPrivate;
extern const long ufTCScanFaxes;
extern const long ufTCScripts;
extern const long ufSortedLists;
extern const long ufCrashMail;
extern const long ufFileAttach;
extern const long ufCaptureUser;
extern const long ufSevenBitAscii;
                                       
extern const int cufSysopMail;
extern const int cufSelected;
extern const int cufLockedOut;
extern const int cufTitleOff;
extern const int cufPersonalOnly;
extern const int cufScanAll;
                                 
enum   TPacketType         {pText, pQwk};
enum   TUserConfRecType    {ucrIndex, ucrData};
                             
typedef struct tagTUserConfData
{
  BYTE                     cuFlags;
  WORD                     cuLastRead;
  WORD                     cuFirstUnread;
} TUserConfData;
  
typedef TUserConfData TUserConfArray[1024];

typedef struct tagTUserConfPageHeader
{
  WORD                     RecLen;
  BYTE                     RecType;            /* enum TUserConfRecType */
  long                     UserID;
  int                      Page;
  long                     This;
} TUserConfPageHeader;
  
typedef struct tagTUserConfPage
{
  WORD                     RecLen;
  BYTE                     RecType;            /* enum TUserConfRecType */
  long                     UserID;
  int                      Page;
  long                     This;
  TUserConfArray           UserConfData;
} TUserConfPage;
                              
typedef struct tagTUserConfIndex
{
  WORD                     RecLen;
  BYTE                     RecType;            /* enum TUserConfRecType */
  long                     OffSets[32];
} TUserConfIndex;
  
enum    TEditor            {ePrompt, eNormal, eFullScreen};
enum    TMorePrompt        {mpErasePrompt, mpNextLine};
enum    TFileDisplay       {fdSingleLine, fdDoubleLine, fdFull};
enum    TExpertiseLevel    {elNovice, elRegular, elExpert};
enum    TSex               {sUnKnown, sMale, sFemale};
enum    TMsgDisplay        {mdScroll, mdClear, mdHeader};
enum    TScrnDisplay       {sdNoColor, sdColor, sdRip, sdAuto};
enum    TProtocol          {pAll, pXmodem, pXmodemCRC, pYmodem, pYModemG, 
                            pXModem1K, pXmodem1KG, pKermit, pZmodem, pAscii,
                            pExt1, pExt2, pExt3, pExt4, pExt5, pExt6, pExt7, 
                            pExy8, pExt9, pExt10};

typedef Str10              TSecondarys[5];

typedef struct tagTUserRec
{
  long                     Status;
  Str25                    UserName;
  Str30                    From;
  Str14                    Password;
  long                     UserID;
  Str15                    PhoneNumber,
                           DataNumber,
                           FaxNumber,
                           ComputerType;
  Str10                    SecLevel;
  TSecondarys              Secondary;
  Str30                    Company,
                           Address1,
                           Address2,
                           City;
  Str15                    State;
  Str10                    Zip;
  Str25                    Country;
  Str10                    Title;
  Str25                    Alias;
  Str08                    NovellName;
  Str08                    Language;
  Str30                    Comment[5];
  BYTE                     Sex;                /* enum TSex */
  BYTE                     Editor;             /* enum TEditor */
  BYTE                     MorePrompt;         /* enum TMorePrompt */
  BYTE                     Xpert;              /* enum TExpertiseLevel */
  BYTE                     TranserMethod;      /* enum TProtocol */
  BYTE                     ScreenDisplay;      /* enum TScrnDisplay */
  BYTE                     FileDisplay;        /* enum TFileDisplay */
  BYTE                     MsgDisplay;         /* enum TMsgDisplay */
  BYTE                     LinesPerPage;
  TDateTime                LastCall,
                           LastNewFiles;
  WORD                     ExpireDate,
                           MemoDate,
                           UserSince,
                           BirthDate;
  WORD                     ActiveConf,
                           MsgsWritten,
                           Uploads,
                           Downloads,
                           TimesOn,
                           TimeLeft;
  long                     UFlags,
                           DailyDL,
                           DailyDK,
                           TotalUK,
                           TotalDK,
                           MinutesLogged,
                           SubScriptionBalance,
                           NetMailBalance;
  BYTE                     ReservedByte;
  BYTE                     TCPacket;           /* enum TPacketType */
  char                     TCPacker;
  WORD                     TCMaxPerConf;
  WORD                     TCMaxPerPacket;
  WORD                     TCMaxAttachSize;
  long                     UserConfData;
  BYTE                     Reserved[50];
} TUserRec;
  
/* Message Files (MSGxxx.IX) */

extern const int mfPrivate;
extern const int mfReceiveable;
extern const int mfReceived;
extern const int mfReceipt;
extern const int mfCarboned;
extern const int mfForwarded;
extern const int mfEchoFlag;
extern const int mfHasReplies;
extern const int mfDeleted;
extern const int mfTagged;
extern const int mfSent;

typedef struct tagTFidoAddress
{
  WORD                     Zone,
                           Net,
                           Node,
                           Point;
} TFidoAddress;
  
typedef char               TMsgText[65520];

typedef struct tagTMsgHeader
{
  long                     MagicNumber;                             
  WORD                     MsgNumber;
  Str70                    Orig;
  Str10                    OrigTitle;
  long                     OrigUserID;
  Str70                    Dest;
  Str10                    DestTitle;
  long                     DestUserID;
  Str70                    Subject;
  Str08                    Network;
  TDateTime                MsgTime,
                           ReadTime;
  WORD                     mFlags;
  WORD                     Reference;
  TFidoAddress             FidoFrom,
                           FidoTo;
  WORD                     MsgBytes;
  Str12                    InternalAttach;
  Str12                    ExternalAttach;
  WORD                     PrevUnread;
  WORD                     NextUnread;
  WORD                     FidoFlags;
  long                     Cost;
  BYTE                     Reserved[20];
} TMsgHeader;
  
typedef struct tagTMsgIndexHeader       /* Must be same size as TMsgIndexEntry */
{
  WORD                     RecordSize;
  WORD                     ActiveRecords;
  WORD                     NextMsgNumber;
} TMsgIndexHeader;
  
typedef struct tagTMsgIndexEntry        /* Must be same size as TMsgIndexHeader */
{
  WORD                     MsgNumber;
  long                     HeaderOffset;
} TMsgIndexEntry;

/* File Database (ALLFILES.DAT) */

extern const int fiNeverOverwrite;
extern const int fiNeverDelete;
extern const int fiDontCharge;
extern const int fiUploadInProgress;
extern const int fiOnCD;
extern const int fiOffLine;
extern const int fiFailedScan;
extern const int fiFreeTime;

typedef BYTE               TFileMsgText[1201];
typedef Str10              TKeyArray[6];
                             
typedef struct tagTFileRec
{
  long                     Status,
                           Size;
  Str12                    FileName;
  Str14                    Password;
  TDateTime                FileTime,                                    
                           LastAccessed;
  Str25                    Uploader;
  long                     UploaderID;
  Str75                    Desc;
  WORD                     MsgBytes,                            
                           fFlags,
                           NumOfAccess,
                           Cost,
                           Area;
  TKeyArray                Keywords;
  Str79                    StoredPath;
  TFileMsgText             MsgText;
} TFileRec;
  
typedef struct tagTFileHeader
{
  long                     Status,
                           Size;
  Str12                    FileName;
  Str14                    Password;        
  TDateTime                FileTime,                                    
                           LastAccessed;
  Str25                    Uploader;
  long                     UploaderID;
  Str75                    Desc;
  WORD                     MsgBytes,                            
                           fFlags,
                           NumOfAccess,
                           Cost,
                           Area;
  TKeyArray                Keywords;
  Str79                    StoredPath;
} TFileHeader;

/* Menu files (xxx.MNU) */

enum TMenuCommand          {cmBulletins,        /***** Main menu *****/
                            cmDoorMenu,
                            cmSysopComment,
                            cmPageSysop, 
                            cmShowHellos,
                            cmQuestionnaires,
                            cmLocateUser,
                            cmChangeSettings,
                            cmStatistics,
                            cmUsersList,
                            cmNewsLetter,
                            cmWhoIsOnline,
                              
                            cmReadMessage,      /***** Message menu *****/
                            cmScanMessages,
                            cmEnterMessage,
                            cmDeleteMessage,
                            cmCheckMailAtMenu,
                            cmUpdateConfScans,
                            cmMailDoor,
                            
                            cmFullFileInfo,     /***** File menu *****/
                            cmListFilesByArea,
                            cmDownloadFiles,
                            cmUploadFiles,
                            cmListFilesByDate,
                            cmSearchFiles,
                            cmFileStats,
                            cmPersonalStats,
                            cmViewArcFile,
                            cmReadAFile,
                            cmEditMarkList,
                            
                            cmManageEvents,     /***** Sysop menu *****/
                            cmEditUserRec,
                            cmReadActLog,
                            cmEraseActLog,
                            cmEditFileRec,
                            cmSysopStatus,
                            cmEditNodes,
                            cmSysopDownload,
                            cmSysopUpload,
                            
                            cmChangeConference, /***** Global options *****/
                            cmRunQuesFile,
                            cmXpertLevel,
                            cmDumpHelpFile,
                            cmDisplayMenuFile,
                            cmDisplayDispFile,
                            cmDisplayTxtFile,
                            cmDisplayBulletin,
                            cmLogoffUser,
                            cmRunScript,
                            cmGotoMenu,
                            cmMenuHook,
                            cmStackCommands,
                            cmPageUser,
                            cmwcCHAT,
                            cmReturnPressed,
                            cmInvalidCommand};
                             
#define MaxMenuItems 40
    
extern const int mufChangeConf;
extern const int mufTopLevel;    
    
typedef struct tagTMenuItem 
{
  char                     Selection;
  Str30                    CommandDesc;
  BYTE                     CommandID;          /* enum TMenuCommand */
  BYTEBOOL                 CommandParam;
  Str40                    CommandStr;
  WORD                     CommandNum;
} TMenuItem;
  
typedef struct tagTMenuRec
{
  TArray1000Bits           SecAccess;
  BYTE                     MenuFields;
  Str35                    MenuDesc;
  Str08                    MenuFile;
  WORD                     ConfNumber;
  BYTE                     muFlags;
  TMenuItem                MenuItem[MaxMenuItems];
} TMenuRec;
  
/* Event file (EVENTxxx.DAT) */

extern const int etSun;
extern const int etMon;
extern const int etTue;
extern const int etWed;
extern const int etThu;
extern const int etFri;
extern const int etSat;
                             
enum   TEventMethod        {emFlex, emSoft, emHard};
enum   TEventShell         {esShell, esTerminate};     
enum   TEventSchedule      {esHourly, esDaily, esMonthly, esYearly};
enum   TEventAction        {eaNoPage, eaResetStats, eaRunBatch, eaAllPageOff,
                            eaNodePage, eaDosNext, eaAllPageOn, eaBaudLimit,  
                            eaRunScript, eaBellOn, eaBellOff, eaAllBellOn,
                            eaAllBellOff};

typedef struct tagTEvent
{
  BYTE                     Method;             /* enum TEventMethod */
  BYTE                     Action;             /* enum TEventAction */
  long                     BaudRate;
  BYTEBOOL                 Active;
  TDateTime                NextExec,
                           LastExec;
  BYTE                     DayBitSet;
  BYTE                     ShellType;          /* enum TEventShell */
  Str79                    BatchPath;
  BYTE                     Schedule;           /* enum TEventSchedule */
  BYTE                     HourDelay,
                           DayOfMonth,
                           Month;
} TEvent;
  
/* Chat file data (CHANNELS.DAT) */

enum  TChannelStatus       {csNotInUse, csPublic, csPrivate, csModerated,
                            csPriMod};

typedef struct tagTChannelRecord
{
  Str08                    FName;
  Str08                    DispFile;
  Str25                    Name;
  Str25                    ModName;
  Str08                    ActionFile;
  Str30                    Topic;
  BYTE                     ChanStatus;         /* enum TChannelStatus */
  WORD                     Moderator;
  WORD                     Users;
  WORD                     MaxUsers;
  BYTEBOOL                 LogChannel;
  BYTEBOOL                 Profanity;
  TArray1000Bits           SecAccess;
} TChannelRecord;
  
/* Action word files (*.ACT) */

typedef struct tagTActionRecord
{
  Str10                    KeyWord;
  Str80                    ToOriginator;
  Str80                    ToTarget;
  Str80                    ThirdPerson;
  Str80                    NoTarget;
} TActionRecord;
