unit WcMisc;

interface

uses
  Crt,
  Dos,
  NumKeys,
  Filer,
  WcType,
  WcGlobal;

const
  NoMoreBits = $FFFF;

const
  ShareMode = $42;

function Upcase(C : Char) : Char;
function StUpcase(S : String) : String;
procedure SetDateTime(var DT : DateTimeRec);
function SameStruct(const Rec1, Rec2; Len : Word) : Boolean;
function LoadConfDesc(var ConfDesc : TConfDesc; Conf : Word) : Boolean;
function GetMemCheck(var P; Bytes : Word) : Boolean;
procedure FreeMemCheck(var P; Bytes : Word);
function ExistFile(const P : PathStr) : Boolean;
procedure WriteTopRight(const S : String);

procedure SetFlag(var Flag : Word; Mask : Word);
function FlagIsSet(Flag : Word; Mask : Word) : Boolean;
procedure ClearFlag(var Flag : Word; Mask : Word);
function LongFlagIsSet(Flag : LongInt; Mask : LongInt) : Boolean;

procedure NoteError(const S : String);
function AddBackslash(const P : PathStr) : PathStr;
function Word2Key(Num : Word) : String;
function Long2Key(Num : LongInt) : String;
function Pad(const S : String; Len : Byte) : String;
function Long2Str(L : LongInt) : String;
function Str2Long(S : String; var I : LongInt) : Boolean;
procedure LogFatalError(const ErrorSt : String; Code : Integer);
procedure OpenFile(var F : File; const FileName : PathStr; RecSize : Word);
procedure CloseFile(var F : File);
procedure ReadFile(var F : File; RecNum : LongInt; var RecInfo; LockRec : Boolean);
procedure WriteFile(var F : File; RecNum : LongInt; var RecInfo);
procedure ReadMInfo(Lock : Boolean);
procedure WriteMInfo;
function SearchUC(const Buffer; BufLength : Word; const Match; MatLength : Word): Word;
function Trim(S : string) : string;

implementation

const
  HoursInDay = 24;           {number of hours in a day}
  SecondsInHour = 3600;      {number of seconds in an hour}
  SecondsInMinute = 60;      {number of seconds in a minute}
  SecondsInDay = 86400;      {number of seconds in a day}
  Threshold2000 : Integer = 1900;
  MinYear  = 1900;
  First2Months = 58;         {1900 was not a leap year}

type
  CaseTable = array[#128..#165] of Char;

const
  UCTable : CaseTable = ('', '', 'E', 'A', '', 'A', '', '', 'E', 'E',
                         'E', 'I', 'I', 'I', '', '', '', '', '', 'O',
                         '', 'O', 'U', 'U', 'Y', '', '', '', '', '',
                         '', '', 'A', 'I', 'O', 'U', '', ''
                        );

var
  UpcaseFunc : Pointer;


  procedure UpcaseAL; assembler;
  asm
    cmp  al,128
    jb   @notex
    cmp  al,165
    ja   @done
    sub  al,128
    push bx
    mov  bx,offset UCTable
    xlat
    pop  bx
    jmp  @done
  @notex:
    cmp  al,'a'
    jb   @done
    cmp  al,'z'
    ja   @done
    sub  al,32
  @done:
  end;


  function Upcase(C : Char) : Char; assembler;
  asm
    mov  al,c
    call UpcaseAL
  end;


  function StUpcase(S : String) : String;
  var
    I : Word;

  begin
    for I := 1 to Length(S) do
      S[I] := UpCase(S[I]);
    StUpcase := S;
  end;


  procedure InitInternationalUpcase;
  var
    C, D : Char;
    CountryInfo : array[0..33] of Byte;

  begin
    UpcaseFunc := nil;
    asm
      mov  ax,3800h
      lea  dx,CountryInfo
      push ds
      push ss
      pop  ds
      int  21h
      pop  ds
      jc   @not
      les  bx,dword ptr CountryInfo+18
      mov  UpcaseFunc.word[0],bx
      mov  UpcaseFunc.word[2],es
  @not:
    end;
    if UpcaseFunc <> nil then
      for C := #128 to #165 do begin
        asm
          mov  al,C
          call UpcaseFunc
          mov  D,al
        end;
        UCTable[C] := D;
      end;
  end;


  function HMStoTime(Hours, Minutes, Seconds : Byte) : Time;
  var
    T : Time;

  begin
    Hours := Hours mod HoursInDay;
    T := (LongInt(Hours) * SecondsInHour) + (LongInt(Minutes) * SecondsInMinute) + Seconds;
    HMStoTime := T mod SecondsInDay;
  end;


  function CurrentTime : Time;
  var
    Hours, Minutes, Seconds, Sec100 : Word;

  begin
    GetTime(Hours, Minutes, Seconds, Sec100);
    CurrentTime := HMStoTime(Hours, Minutes, Seconds);
  end;


  function DMYtoDate(Day, Month, Year : Integer) : Date;
  begin
    if Word(Year) < 100 then begin
      Inc(Year, 1900);
      if Year < Threshold2000 then
        Inc(Year, 100);
    end;
    if (Year = MinYear) and (Month < 3) then
      if Month = 1 then
        DMYtoDate := Pred(Day)
      else
        DMYtoDate := Day + 30
    else begin
      if Month > 2 then
        Dec(Month, 3)
      else begin
        Inc(Month, 9);
        Dec(Year);
      end;
      Dec(Year, MinYear);
      DMYtoDate := ((LongInt(Year) * 1461) div 4) + (((153 * Month) + 2) div 5) + Day + First2Months;
    end;
  end;


  function Today : Date;
  var
    Year, Month, Day, DayOfWeek : Word;

  begin
    GetDate(Year, Month, Day, DayOfWeek);
    Today := DMYtoDate(Day, Month, Year);
  end;


  procedure SetDateTime(var DT : DateTimeRec);
  begin
    DT.T := CurrentTime;
    DT.D := Today;
  end;


  function SameStruct(const Rec1, Rec2; Len : Word) : Boolean;
  type
    ByteArray = array[1..65520] of Byte;

  var
    I : Word;
    B1 : ByteArray absolute Rec1;
    B2 : ByteArray absolute Rec2;

  begin
    if Len = 0 then
      SameStruct := True
    else begin
      for I := 1 to Len do
        if B1[I] <> B2[I] then begin
          SameStruct := False;
          Exit;
        end;
      SameStruct := True;
    end;
  end;


  function LoadConfDesc(var ConfDesc : TConfDesc; Conf : Word) : Boolean;
  var
    F : File;
    ConfRecSize, FileRecSize, SaveFileMode : Word;

  begin
    FileRecSize := (MwConfig.MaxFileAreas - 1) div 8 + 1;
    ConfRecSize := SizeOf(TConfDesc) + FileRecSize;
    Assign(F, 'CONFDESC.DAT');
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F, 1);
    FileMode := SaveFileMode;
    if IoResult = 0 then begin
      Seek(F, LongInt(ConfRecSize) * Conf);
      BlockRead(F, ConfDesc, SizeOf(ConfDesc));
      if IoResult = 0 then
        {ignore};
      Close(F);
      if IoResult = 0 then
        {ignore};
      LoadConfDesc := True;
    end else
      LoadConfDesc := False;
  end;


  function HeapFunc(Size : Word) : Integer; far;
  begin
    if Size = 0 then
      HeapFunc := 2
    else
      HeapFunc := 1;
  end;


  function GetMemCheck(var P; Bytes : Word) : Boolean;
  var
    Pt : Pointer absolute P;
    SaveHeapError : Pointer;

  begin
    SaveHeapError := HeapError;
    HeapError := @HeapFunc;
    GetMem(Pt, Bytes);
    GetMemCheck := Pt <> nil;
    HeapError := SaveHeapError;
  end;


  procedure FreeMemCheck(var P; Bytes : Word);
  var
    Pt : Pointer absolute P;

  begin
    if Pt <> nil then begin
      FreeMem(Pt, Bytes);
      Pt := nil;
    end;
  end;


  function ExistFile(const P : PathStr) : Boolean;
  var
    F : File;
    SaveFileMode : Word;

  begin
    Assign(F, P);
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F);
    FileMode := SaveFileMode;
    if IoResult = 0 then begin
      Close(F);
      if IoResult = 0 then
        {ignore};
      ExistFile := True;
    end else
      ExistFile := False;
  end;


  procedure WriteTopRight(const S : String);
  var
    X, Y : Byte;

  begin
    X := WhereX;
    Y := WhereY;
    GotoXY(65, 1);
    Write(S);
    GotoXY(X, Y);
  end;


  procedure SetFlag(var Flag : Word; Mask : Word);
  begin
    Flag := Flag or Mask;
  end;


  function FlagIsSet(Flag : Word; Mask : Word) : Boolean;
  begin
    FlagIsSet := Flag and Mask = Mask;
  end;


  procedure ClearFlag(var Flag : Word; Mask : Word);
  begin
    Flag := Flag and not Mask;
  end;


  function LongFlagIsSet(Flag : LongInt; Mask : LongInt) : Boolean;
  begin
    LongFlagIsSet := Flag and Mask = Mask;
  end;






  procedure NoteError(const S : String);
  begin
  end;




  function AddBackslash(const P : PathStr) : PathStr;
  begin
    if P[Length(P)] <> '\' then
      AddBackslash := P + '\'
    else
      AddBackslash := P;
  end;


  function Word2Key(Num : Word) : String;
  begin
    Word2Key := CStyleNumKey(WordToKey(Num));
  end;


  function Long2Key(Num : LongInt) : String;
  begin
    Long2Key := CStyleNumKey(LongToKey(Num));
  end;


  function Pad(const S : String; Len : Byte) : String;
  var
    Result : String;

  begin
    if Length(S) >= Len then
      Pad := S
    else begin
      Result[0] := Chr(Len);
      Move(S[1], Result[1], Length(S));
      if Len < 255 then
        FillChar(Result[Length(S) + 1], Len - Length(S), ' ');
      Pad := Result;
    end;
  end;


  function Long2Str(L : LongInt) : String;
  var
    S : String;

  begin
    Str(L, S);
    Long2Str := S;
  end;


  function Str2Long(S : String; var I : LongInt) : Boolean;
  var
    Code : Word;
    SLen : Byte absolute S;

  begin
    while S[SLen] = ' ' do
      Dec(SLen);
    if (SLen > 1) and (Upcase(S[SLen]) = 'H') then begin
      Move(S[1], S[2], SLen - 1);
      S[1] := '$';
    end else if (SLen > 2) and (S[1] = '0') and (Upcase(S[2]) = 'X') then begin
      Dec(SLen);
      Move(S[3], S[2], SLen-1);
      S[1] := '$';
    end;
    Val(S, I, Code);
    if Code <> 0 then begin
      I := Code;
      Str2Long := False;
    end else
      Str2Long := True;
  end;


  procedure LogFatalError(const ErrorSt : String; Code : Integer);
  begin
    Window(1, 1, 80, 25);
    ClrScr;
    WriteLn('Fatal Error - '+ErrorSt+' Code - '+Long2Str(Code));
    Halt;
  end;


  function GetFileRecName(var F : File) : PathStr;
  var
    S : PathStr;
    SLen : Byte absolute S;

  begin
    SLen := 0;
    while (SLen < 79) and (FileRec(F).Name[SLen] <> #0) do
      Inc(SLen);
    Move(FileRec(F).Name[0], S[1], SLen);
    GetFileRecName := S;
  end;


  function IsLockOkayPrim(CheckLockError : Boolean; const Name : String) : Boolean;
  const
    MaxRetries = 50;

  const
    Retries : Byte = 0;

  begin
    if not CheckLockError then
      begin
        IsLockOkayPrim := True;
        Retries := 0;
      end
    else if Retries < MaxRetries then
      begin
        IsLockOkayPrim := False;
        Inc(Retries);
        Delay(500+Random(500));
      end
    else
      LogFatalError('Unable to lock file '+Name, IsamError);
  end;


  function IsFilerOkay(const Name : String) : Boolean;
  begin
    IsFilerOkay := IsLockOkayPrim(not IsamOk and (BtIsamErrorClass = 2), Name);
  end;


  function IsDosOkay(FileResult : Word; const Name : String) : Boolean;
  begin
    IsDosOkay := IsLockOkayPrim(FileResult = 5, Name);
  end;


  procedure LockDosRecord(Handle : Word; Start, Len : LongInt; const Name : String);
  begin
    repeat
      IsamClearOk;
      if not BtIsamLockRecord(Start, Len, Handle, 1, 1) then
        begin
          IsamOk := False;
          IsamError := 10335;
        end;
    until IsFilerOkay(Name);
  end;


  procedure UnLockDosRecord(Handle : Word; Start, Len : LongInt; const Name : String);
  begin
    repeat
      IsamClearOk;
      if not BtIsamUnLockRecord(Start, Len, Handle) then
        begin
          IsamOk := False;
          IsamError := 10340;
        end;
    until IsFilerOkay(Name);
  end;


  procedure OpenFile(var F : File; const FileName : PathStr; RecSize : Word);
  var
    ErrCode : Word;

  begin
    FileMode := ShareMode;
    Assign(F, FileName);
    repeat
      Reset(F, RecSize);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, FileName);
    if ErrCode <> 0 then
      LogFatalError('Error opening file '+FileName, ErrCode);
  end;


  procedure CloseFile(var F : File);
  var
    ErrCode : Word;

  begin
    repeat
      Close(F);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, GetFileRecName(F));
    if ErrCode <> 0 then
      LogFatalError('Error closing file '+GetFileRecName(F), ErrCode);
  end;


  procedure ReadFile(var F : File; RecNum : LongInt; var RecInfo; LockRec : Boolean);
  var
    ErrCode : Word;
    LockPos : LongInt;

  begin
    if LockRec then
      begin
        LockPos := RecNum * FileRec(F).RecSize;
        LockDosRecord(FileRec(F).Handle, LockPos, FileRec(F).RecSize, GetFileRecName(F));
      end;
    repeat
      Seek(F, RecNum);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, GetFileRecName(F));
    if ErrCode <> 0 then
      LogFatalError('Error seeking file '+GetFileRecName(F), ErrCode);
    repeat
      BlockRead(F, RecInfo, 1);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, GetFileRecName(F));
    if ErrCode <> 0 then
      LogFatalError('Error reading file '+GetFileRecName(F), ErrCode);
  end;


  procedure WriteFile(var F : File; RecNum : LongInt; var RecInfo);
  var
    ErrCode : Word;
    LockPos : LongInt;

  begin
    repeat
      Seek(F, RecNum);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, GetFileRecName(F));
    if ErrCode <> 0 then
      LogFatalError('Error seeking file '+GetFileRecName(F), ErrCode);
    repeat
      BlockWrite(F, RecInfo, 1);
      ErrCode := IoResult;
    until IsDosOkay(ErrCode, GetFileRecName(F));
    if ErrCode <> 0 then
      LogFatalError('Error writing file '+GetFileRecName(F), ErrCode);
    LockPos := RecNum * FileRec(F).RecSize;
    UnLockDosRecord(FileRec(F).Handle, LockPos, FileRec(F).RecSize, GetFileRecName(F));
  end;


  procedure ReadMInfo(Lock : Boolean);
  begin
    ReadFile(NodeInfoFile, 0, MasterInfo, Lock);
  end;


  procedure WriteMInfo;
  begin
    WriteFile(NodeInfoFile, 0, MasterInfo);
  end;


  function Trim(S : string) : string;
  var
    I : Word;
    SLen : Byte absolute S;

  begin
    while (SLen > 0) and (S[SLen] <= ' ') do
      Dec(SLen);

    I := 1;
    while (I <= SLen) and (S[I] <= ' ') do
      Inc(I);
    Dec(I);
    if I > 0 then
      Delete(S, 1, I);

    Trim := S;
  end;



  function SearchUC(const Buffer; BufLength : Word; const Match; MatLength : Word): Word; assembler;
  asm
    push    ds
    cld
    les     di,Buffer
    mov     bx,di
    mov     cx,BufLength
    mov     dx,MatLength
    or      dx,dx
    jz      @error
    lds     si,Match
    lodsb
    call    UpcaseAL
    dec     dx
    sub     cx,dx
    jbe     @error
  @next:
    jcxz    @error
    mov     ah,es:[di]
    inc     di
    xchg    al,ah
    call    UpcaseAL
    xchg    al,ah
    cmp     ah,al
    loopne  @next
    jne     @error
    or      dx,dx
    jz      @found
    push    ax
    push    cx
    push    di
    push    si
    mov     cx,dx
  @next1:
    lodsb
    call    UpcaseAL
    mov     ah,es:[di]
    inc     di
    xchg    al,ah
    call    UpcaseAL
    xchg    al,ah
    cmp     ah,al
    loope   @next1
    pop     si
    pop     di
    pop     cx
    pop     ax
    jne     @next
  @found:
    dec     di
    mov     ax,di
    sub     ax,bx
    jmp     @out
  @error:
    xor     ax,ax
    dec     ax
  @out:
    pop     ds
  end;


begin
  InitInternationalUpcase;
end.