program MsgImprt;

(*

This sample program imports data from a text file into the message database.
The command line format is:

  MSGIMPRT ConfNumber FileName

For example,

  MSGIMPRT 0 test.txt

The format of the text file is:

  (to name)
  (from name)
  (subject)
  (private flag)
  message text line 1..
  message text line 2..
  -END-
  ..etc..

For example,

  JOE USER
  THE SYSOP
  Message Subject
  PRIVATE
  This is a private message from the sysop to Joe User.
  This is the last line of this message.
  -END-
  ALL
  JOE USER
  Test public message
  PUBLIC
  This is a public message from Joe User to everybody.
  -END-

*)

uses Filer,
     WcMisc,
     WcType,
     WcUserDb,
     WcMsgDb,
     WcMsgEx;

var f: Text;
    conf: Longint;
    ref: Longint;
    Msg: TMsgHeader;
    MsgText: PMsgText;
    Fakeit: Boolean;
    ExMsgDb: TExMsgBase;

    InputBuffer: array [1..16384] of Byte;

  function MultipleNames(const Name : String; var Found : LongInt) : Boolean;
  var
    Match,
    KeyName : IsamKeyStr;
    Records,
    RefNr   : LongInt;

  begin
    MultipleNames := False;
    Records := 0;
    KeyName := BuildUserNameKey(Name, 0);
    Match   := Trim(Copy(KeyName, 1, 25));
    UserDB.SearchKey(UserNameKey, RefNr, KeyName);

    while IsamOk and (Match = Trim(Copy(KeyName, 1, 25))) do
      begin
        Inc(Records);
        UserDB.NextKey(UserNameKey, RefNr, KeyName);
      end;

    Found := Records;

    if (Records > 1) then
      MultipleNames := True;
  end;

  function UserInDataBase(const Name : String; var RefNr : LongInt) : Boolean;
  var
    TempStr,
    KeyStr : IsamKeyStr;
    IdName,
    Found  : LongInt;

  begin
    UserInDataBase := False;

    KeyStr := BuildUserNameKey(Name, 0);
    TempStr := Trim(Copy(KeyStr, 1, 25));
    UserDB.SearchKey(UserNameKey, RefNr, KeyStr);
    KeyStr  := Trim(Copy(KeyStr, 1, 25));

    if KeyStr <> TempStr then
      IsamOk := False;

    if IsamOK then
      begin
        if MultipleNames(Name, Found) then
          Exit;
        UserInDataBase := True;
        Exit;
      end;

    if Str2Long(Name, IdName) then
      begin
        KeyStr := BuildUserIDKey(IdName);

        if UserDB.FindKey(UserIdKey, RefNr, KeyStr) then
          begin
            UserInDataBase := True;
          end;
      end;
  end;

  function GetUserIdNumber(const Name : String; var ID : LongInt) : Boolean;
  var
    RefNr : LongInt;
    TRec  : TuserRec;

  begin
    GetUserIDNumber := False;
    if not UserInDataBase(Name, RefNr) then
      Exit;
    UserDb.GetRec(RefNr, TRec);
    ID := TRec.UserID;
    GetUserIdNumber := True;
  end;

procedure ImportMessages;

var s: String;
    index: Word;
    inserted: Word;
    x: LOngint;

begin
  inserted := 0;
  while not eof(f) do begin
    FillChar(Msg, SIZEOF(TMsgHeader), 0);
    ReadLn(f,Msg.Dest);
    if Msg.Dest = '' then Msg.Dest := 'BLANK';
    Msg.Dest := StUpcase(Msg.Dest);
    ReadLn(f,Msg.Orig);
    if Msg.Orig = '' then Msg.Orig := 'BLANK';
    Msg.Orig := StUpcase(Msg.Orig);
    ReadLn(f,Msg.Subject);
    SetDateTime(Msg.MsgTime);
    ReadLn(f,s);
    s := Trim(s);
    if s = 'PRIVATE' then
      SetFlag(Msg.mFlags, mfPrivate);
    index := 0;
    ReadLn(f,s);
    while not eof(f) and (s <> '-END-') do begin
      if Length(s) > 79 then
        s[0] := #79;
      Move(s[1], MsgText^[index], Length(s));
      INC(index,Length(s));
      MsgText^[index] := #13;
      Inc(index);
      ReadLn(f,s);
    end;
    Msg.MsgBytes := index;
    GetUserIdNumber(Msg.Dest, Msg.DestUserId);
    if Fakeit then
      ExMsgDb.AddMsg(Msg, MsgText, conf)
    else
      MsgDb.AddMsg(ref, Msg, MsgText);
    Inc(inserted);
  end;
end;

var io: Integer;

begin
  if ParamCount < 2 then begin
    WriteLn('MSGIMPRT  Copyright (c) 1994 Mustang Software, Inc.  Version 4.0');
    WriteLn;
    WriteLn('Usage: MSGIMPRT ConfNumber FileName');
    Halt(1);
  end;

  if not UserDB.Init then begin
    WriteLn('Could not open user database');
    Halt;
  end;

  GetMem(MsgText, 65520);
  if MsgText = nil then begin
    WriteLn('Insufficient memory for message buffer');
    Halt;
  end;

  if not Str2Long(ParamStr(1), conf) then begin
    WriteLn('Invalid conference number: '+ParamStr(1));
    Halt;
  end;
  Fakeit := False;
  MsgDb.Init;
  if not MsgDb.Open(conf, False) then begin
    ExMsgDb.Init;
    Fakeit := True;
  end;

  Assign(f, ParamStr(2));
  Reset(f);
  io := IoResult;
  if io <> 0 then begin
    WriteLn(5, 'Unable to open '+ParamStr(2)+', error code '+Long2Str(io));
    Halt;
  end;
  SetTextBuf(f, InputBuffer);

  ImportMessages;

  Close(f);
  if Fakeit then
    ExMsgDb.Done
  else
    MsgDb.Done;
  UserDb.Done;
end.
