{$O-}

unit Desq;

interface

var
  InDv : Boolean;

const
  TimeSlicing : Boolean = False;

procedure WcDelay(MS : LongInt);
procedure DvPause;

implementation

  procedure WcDelay(MS : LongInt);
  var
    BiosTime : LongInt absolute $40:$6C;
    Ticks : Word;
    Elapsed, StartTime : LongInt;

  begin
    StartTime := BiosTime;
    Ticks := MS div 55;
    repeat
      Elapsed := BiosTime - StartTime;
      if Elapsed < 0 then
        Inc(Elapsed, 1573039);
      if Elapsed < Ticks then
        DvPause;
    until Elapsed > Ticks;
  end;

  function DvGetVersion : Word; assembler;
  asm
    mov   cx,'DE'
    mov   dx,'SQ'
    mov   ax,2b01h
    int   21h
    cmp   al,0ffh
    je    @NoDv
    xchg  ax,bx
    mov   InDv,1
    jmp   @GetDvExit
  @NoDv:
    xor   ax,ax
    mov   InDv,0
  @GetDvExit:
  end;


  procedure DvPause; assembler;
  asm
    cmp   InDv,1
    jne   @NoDv
    mov   bx,1000h
    mov   ax,101ah
    int   15h
    mov   ax,bx
    int   15h
    mov   ax,1025h
    int   15h
  @NoDv:
    cmp   TimeSlicing,0
    jz    @NoSlice
    mov ax,1680h {release time slice for Windows & OS/2}
    int 2fh
  @NoSlice:
  end;

PROCEDURE DV_APICall(func: WORD); INLINE(
$5B/        { pop bx       }
$B8/$101A/  { mov ax,101ah }
$CD/$15/    { int 15h      }
$89/$D8/    { mov ax,bx    }
$CD/$15/    { int 15h      }
$B8/$1025/  { mov ax,1025h }
$CD/$15     { int 15h      }
);

begin
  if DvGetVersion = 0 then
    {ignore};
end.
{.F+}
