#define	SIDE_IS_QUAD	1			// render side as quadrilateral
#define	SIDE_IS_TRI_02	2			// render side as two triangles, triangulated along edge from 0 to 2
#define	SIDE_IS_TRI_13	3			// render side as two triangles, triangulated along edge from 1 to 3

// Set maximum values for segment and face data structures.
#define	MAX_VERTICES_PER_SEGMENT	8
#define	MAX_SIDES_PER_SEGMENT		6
#define	MAX_VERTICES_PER_POLY		4
#define	WLEFT								0
#define	WTOP								1
#define	WRIGHT							2
#define	WBOTTOM							3
#define	WBACK								4
#define	WFRONT							5

#define	MAX_GAME_SEGMENTS				800
#define	MAX_GAME_VERTICES				2800

#define	MAX_SEGMENTS					MAX_GAME_SEGMENTS
#define	MAX_SEGMENT_VERTICES			MAX_GAME_VERTICES

//normal everyday vertices

#define	DEFAULT_LIGHTING			0			// (F1_0/2)

#define	MAX_VERTICES				(MAX_SEGMENT_VERTICES)

//	Returns true if segnum references a child, else returns false.
//	Note that -1 means no connection, -2 means a connection to the outside world.
#define	IS_CHILD(segnum) (segnum > -1)

//Structure for storing u,v,light values. 
typedef struct uvl {
	fix u,v,l;
} uvl;

typedef struct side {
	byte		type;									// replaces num_faces and tri_edge, 1 = quad, 2 = 0:2 triangulation, 3 = 1:3 triangulation
	ubyte		pad;									// keep us longword alligned
	short		wall_num;							// Index into Walls array, which wall (probably door) is on this side
	short		tmap_num;							// Index into array of textures specified in bitmaps.bin
	short		tmap_num2;							//	Index, as above, texture which gets overlaid on tmap_num
	uvl		uvls[4];								//	uvl coordinates at each point
	vms_vector	normals[2];						// 2 normals, if quadrilateral, both the same.
} side;

typedef struct segment {
	side		sides[MAX_SIDES_PER_SEGMENT];	// 6 sides
	short		children[MAX_SIDES_PER_SEGMENT];	// indices of 6 children segments, front, left, top, right, bottom, back
	short		verts[MAX_VERTICES_PER_SEGMENT];	// vertex ids of 4 front and 4 back vertices
	short		objects;								// index of objects in this segment
	ubyte		special;								// special property of a segment (such as damaging, trigger, etc.)
	byte		matcen_num;							//	which center segment is associated with, high bit set
	short		value;								// matcens: bitmask of producable robots, fuelcenters: energy given? --MK, 3/15/95
	fix		static_light;						//average static light in segment
	short		pad;			//make structure longword aligned [Too bad we didn't put this before static_light...MK, 3/15/95]
} segment;

