PROC DoCheckOut()

; We'll enter one film per customer at a time. If a customer is renting
; more than one film, we'll use multiple records to capture the new
; information, using DITTO to grab repeated information.
CLEARALL
EMPTY "ordtemp"                        ; Get temporary table ready for use
EDIT "ordtemp"                         ;   and drop us into empty table
PICKFORM 1                             ;   using film checkout form
WHILE (True)                           ; Keep entering checkouts until user says Done!
  WAIT RECORD                          ; Let user enter a checkout record
    PROMPT "Enter film checkout information",
           "[F2] to save data, [F1] for lookup help, [Esc] to abandon entry"
    UNTIL "F2","Esc"
  IF retval = "Esc"                    ; Does user want to abandon record?
    THEN DEL                           ; Yes, so delete it,
    	 DO_IT!			       ;   and save other records,
         QUITLOOP                      ;   and leave entry section
    ELSE PGDN                          ; No, move to next record
  ENDIF
  ;if we were updating inventory status in FILMS table, we would do it here
  ;must have pressed [F2] to get here
  SHOWMENU "Another?":"Checkout another film to same customer",
           "Done!":"Done entering film checkouts for this customer"
  TO Choice
  IF Choice = "Done!"                  ; Is user done entering info for this customer?
    THEN DO_IT! QUITLOOP               ; Yes, so save and leave entry section
  ENDIF
  ;must want to enter another film if we get here
  ;(we would print last film entered on receipt at this point)
  MOVETO [Customer #]                  ; Make sure we're in first field
  FOR i FROM 1 TO 4
    DITTO RIGHT                        ; Copy previous record's info
  ENDFOR
ENDWHILE
; We've got all the films for this customer stored in ORDTEMP. Now we need
; to extract the important information for our normalized table, ORDERS.
CLEAR                                  ; Clear the canvas to alert user
?? "One moment while I update the files..."
; The following query extracts the information we keep in normalized table
Query

 Ordtemp | Customer # |  Date  | Return Date |
         | Check      | Check  | Check       |
         |            |        |             |
         |            |        |             |

 Ordtemp | Operator | Film # | Due Date | Rental Rate | Days Out |
         | Check    | Check  | Check    | Check       | Check    |
         |          |        |          |             |          |
         |          |        |          |             |          |

 Ordtemp | Rewound? | Total Due |
         | Check    | Check     |
         |          |           |
         |          |           |

Endquery
DO_IT!                                 ; Execute the query
ADD "Answer" "Orders"                  ; And save the normalized results
ENDPROC ;DoCheckOut



PROC DoReturn()

; Instead of processing returns the same way we did rentals, we'll use a
; different method, illustrating the power of the SCAN command to step
; us through relevant records.
CLEARALL                               ; Clear the workspace
Total = 0                              ; So far, the customer owes us nothing
@ 0,0 ?? "Enter the number for the customer returning films: "
ACCEPT "N" TO CustNum                  ; Get the customer number
EDIT "Orders"                          ; Put the master orders table into play
PICKFORM 1                             ;   showing it in a nice, neat form
SCAN FOR [Customer #] = CustNum        ; Now, look through the table for our customer
  MOVETO [Return Date]                 ; Make sure we're in Return Date field
  IF ISBLANK([]) THEN                  ; Has film already been returned?
    WAIT RECORD                        ; No, so let's see if it is being returned
      PROMPT "Enter Film Return Information",
             "[F2] to save data and move to next possible film return"
      UNTIL "F2"
    IF NOT ISBLANK([Return Date])                               ; Yes, film was returned
      THEN [Days Out] = [Return Date] - [Date]                  ;   so, calculate amt due
           IF [Rewound?] <> "Y"
             THEN [Total Due] = [Rental Rate] * [Days Out] + 1  ; Our rewind charge is $1
             ELSE [Total Due] = [Rental Rate] * [Days Out]
           ENDIF
           Total = Total + [Total Due]                          ; Update the customer total
           ;if we were printing receipts, this is the place we'd print info for each film
           ;if we were maintaining inventory status in FILMS table, we'd do that here, too
    ENDIF
  ENDIF
ENDSCAN                                ; Keep looking until we've examine entire table
; If we get here, we've gone through all possible returns for customer, so
; it's time to update the file and collect the damages...
DO_IT!                         ; update the ORDERS table to reflect returned films
CLEAR                          ; Now show the total due from customer
@ 0,0 ?? "Total for this customer was $",FORMAT("W6.2",Total)
?
? "Press {Enter} when ready for next action..."
x = GETCHAR()
ENDPROC ;DoReturn

WHILE (True)
  CLEAR
  SHOWMENU
    "CheckoutFilm":"Process a film rental request.",
    "ReturnFilm":"Process a film return.",
    "Leave":"Return to Main menu."
  TO Choice
  SWITCH
    CASE Choice = "CheckoutFilm":DoCheckOut()
    CASE Choice = "ReturnFilm":DoReturn()
    OTHERWISE : CLEARALL QUITLOOP
  ENDSWITCH
ENDWHILE

