; Copyright (c) 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  DCY 12/15/88
; ****************************************************************************
; RecurseWait allows you to use DoWait on a single table regardless of the
; current form or image type.  Thus should you need to temporarily override
; an existing DPA set from within a DoWait session, you can issue a call to
; RecurseWait.  Furthermore, to use DoWait on a query image you MUST call
; RecurseWait.
;
; Use the SetUpDoWait subsystem of TKMenu to create a DoWait Procedure
; Assignment (DPA) set for the table of interest and specify the name of the
; DPA set in your call to RecurseWait.  As with DoWait, you must call InitWait
; before calling RecurseWait.  InitWait arguments for RecurseWait are
; identical to those for DoWait.
;
; IMPORTANT: RecurseWait will NOT automatically exit when a user successfully
;            leaves the current table image.  Thus you should assign any keys
;            which cause movement out of the table as "Exit" keys, or have
;            your Table Depart procedure (if you assign one) reassign them
;            as such.
;
Proc RecurseWait(TKMessage,DPASet)
   Private;TKMessage      ;Message to display upon entry into RecurseWait
          ;DPASet,        ;Name of DoWait Procedure Assignment (DPA) set
           TKAccept,      ;Specifies whether last key hit will be accepted
           TKHoldCanvas,  ;Specifies whether PAL canvas will be removed
           TKFieldNum,    ;Column position (in table view) of current field
           TKFieldVal,    ;Value of current field upon entry into it
           TKChanged,     ;Indicates field value has changed since arrival
           TKRecMvmnt,    ;Specifies whether last key will cause rec movement
           TKMvmntProc,   ;Procedure which initiates movement key events
           TKChar,        ;ASCII value of last key pressed
           TKKeyType,     ;Type of key (R, I, E, M, S, D)
           TKKeyProc,     ;Procedure which monitors keyboard (in)activity
           TKUserKey,     ;Value of key before user's procedure was executed
           TKSeconds,     ;Number of seconds elapsed without a keypress
           TKBuffer,      ;ASCII value of key in keyboard buffer
           TKTime,        ;Time of last keypress
           TKTable,       ;Name and path of active table image
           TKPosKey,      ;ASCII (positive) key class assignments
           TKNegKey,      ;IBM extended key class assignments
           TKAction,      ;Array of field level procedure assignments
           TKArrive,      ;Array of field arrival procedures
           TKGoodDepart,  ;Array of field good departure procedures
           TKBadDepart,   ;Array of field bad departure procedures
           TKKeystroke,   ;Array of field keystroke procedures
           TKSpclProc,    ;Special key procedure
           TKInactiveProc,;Keyboard inactivity procedure
           TKTblArrive,   ;Table arrival procedure
           TKTblDepart,   ;Table departure procedure
           TKRecArrive,   ;Record arrival procedure
           TKRecDepart,   ;Record departure procedure
           TKNegMv,       ;Record level movement key types
           TKPosMv        ;Record level movement key types

   TKChar = BlankNum()    ;Initialize keystroke character
   TKBuffer = BlankNum()  ;Initialize single-key type-ahead buffer
   TKHoldCanvas = False   ;Unless specified otherwise in an arrival-level
                          ; procedure, remove PAL canvas just before
                          ; acceptance of first user keystroke

   ExecProc DPASet        ;Initialize DPA set
   TKKeyProc = "GetInactive"     ;Select key procedure
   If IsBlank(TKInactiveProc)
      Then TKKeyProc = "GetKey"
   Endif

   TKRecMvmnt = True
   If TKMvmntProc = "StdMvmnt"   ;Select record movement procedure
      Then TKRecMvmnt = False
   Endif

   NewField()
   If TKTblArrive <> ""   ;Call table arrival proc
      Then ExecProc TKTblArrive
           CheckHoldCanvas()
   Endif

   SysRecArrive()         ;Inform DoWait we've arrived at a new record--
                          ; Call record arrival procedure if assigned
   SysArrive()         ;Inform DoWait we've arrived in a new field--
                          ; Initialize field-dependent variables and call
                          ; field arrival procedure if assigned
   CheckMessage()         ; Check for a message to display
   ExecProc TKKeyProc     ;Read a key from the keyboard
   Echo Normal

   While True
      If TKChar > 0         ;Determine class of key we are about to process
         Then TKKeyType = Substr(TKPosKey,TKChar,1)   ;These statements are
         Else TKKeyType = Substr(TKNegKey,1-TKChar,1) ; necessary because max
      Endif                                           ; string length is 255
      Switch
         Case HelpMode() <> "None" or IsFieldView(): ;Do nothing special while
            Keypress TKChar                          ; in field view or help
         Case TKKeyType = "R":                       ;"Regular" key
            If Search("K",TKAction[TKFieldNum]) <> 0 ;Call keystroke proc, if
               Then CallProc(TKKeystroke[TKFieldNum]); assigned
                    If TKKeyType = "X"             ;Immediate eXit from DoWait
                       Then CheckMessage()
                            Echo Off
                            Return TKChar
                    Endif
                    If Not Retval
                       Then Loop                   ;Key wasn't accepted, or
                    Endif                          ; was reset to a new value
            Endif
            Keypress TKChar
         Case TKKeyType = "I":                     ;"Illegal" key
            Beep                                   ;Beep and ignore key
         Otherwise:
            If Search(TKKeyType,"SD") <> 0    ;"Special" or "DepartSpecial"
               Then CallProc(TKSpclProc)      ;Call appropriate procedure
                    If TKKeyType <> "X"
                       Then If Not Retval     ;Key wasn't accepted, or was
                               Then Loop      ; reset to a new value
                            Endif
                    Endif
            Endif
            Retval = True
            Switch
               Case Search(TKKeyType,"XS") <> 0 : ;Processed next Switch stmnt
               Case IsValid() :                   ;Good Depart
                  If Search("D",TKAction[TKFieldNum]) <> 0
                     Then TKChanged = [] <> TKFieldVal ;Changed? Set T/F
                          CallProc(TKGoodDepart[TKFieldNum])
                  Endif
               Otherwise:                         ;Bad Depart
                  If Search("F",TKAction[TKFieldNum]) <> 0
                     Then CallProc(TKBadDepart[TKFieldNum])
                  Endif
            Endswitch
            Switch
               Case TKKeyType = "X" :   ;TKKeyType set to "X" by Special key,
                  CheckMessage()        ; Good Depart, or Bad Depart proc
                  Echo Off              ;Exit immediately
                  Return TKChar
               Case Not Retval :        ;Good Depart or Bad Depart rejected
                  Loop                  ; or reassigned TKChar.  Reprocess it.
               Case TKKeyType = "S" :
                  Keypress TKChar
               Case IsValid() :         ;Field data is valid, pending key is
                  ExecProc TKMvmntProc  ; a movement key ("S" or "M")
                  If Search(TKKeyType,"EX") <> 0
                     Then CheckMessage()  ;Movement-initated proc or pending
                          Echo Off        ; key requested exit from DoWait
                          Return TKChar
                  Endif
                  If Not Retval         ;Movement-initiated proc rejected
                     Then Loop          ; pending key
                  Endif
               Otherwise :     ;Data is still invalid, can't move out of it
                 If (TKChar = -83 or TKChar = 21 or TKChar = 0) and
                    TKKeyType <> "E"   ;If Del, Undo, or Cancel is an Exit key
                    Then BadDelUndo()  ; reject it since data is invalid
                         If Search(TKKeyType,"EX") <> 0
                            Then CheckMessage()
                                 Echo Off
                                 Return TKChar
                         Endif
                         If not Retval
                            Then Loop
                         Endif
                    Else If IsBlank(TKMessage)  ;Display standard Paradox
                            Then Keypress -72   ; message unless specified
                         Endif                  ; otherwise in user procedure
                 Endif
            Endswitch
      Endswitch
      CheckMessage()          ; Check for message to display
      ExecProc TKKeyProc      ; Read next key
      Echo Normal
   Endwhile

Endproc
