; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  MJP 5/31/87, DCY 12/15/88
; ****************************************************************************
; LookupWait is an enhanced version of the LookupSelect procedure.  It is
; more versatile than LookUpSelect in that it allows you to specify a message
; to display at the beginning of the wait and also allows you to designate a
; set of keys which end the wait interaction.
;
; LookupWait requires two arguments:
;  
;         Msg: String to display in message window on entry into wait
; KeycodeList: String containing keycodes (separated by commas) of
;              keys which can terminate the wait condition.
;
; For example, calling:
;
;     LookupWait("","-60,27")
;
; is the functional equivalent of calling LookUpSelect.  The help [F1] key
; defaults to Paradox help.  To create your own help or to deactivate the help
; key, simply put its keycode (-59) in KeycodeList and process it yourself.
;
; See also LookupSelect for more information.
;
; IMPORTANT:  LookupWait uses to ImageRights ReadOnly command to prevent a
;             user from making changes to the current image.  Thus if you have
;             previously placed an image restrictions on the current table you
;             will need to restore them after invoking LookupWait.
;
Proc LookupWait(Msg,KeycodeList)
; Private Msg,              ;Message to be displayed at the start of WAIT
;         KeycodeList       ;List of keycodes to terminate WAIT

   KeycodeList = "," + KeycodeList + ","
   ImageRights ReadOnly
   Echo Normal              ; Display the Lookup table
   If Msg <> ""             ; Display initial message if defined
      Then Echo Off
           Synccursor
           Message Msg
   Endif
   Retval = GetChar()
   Echo Normal
   While Search(","+Strval(Retval)+",",KeycodeList) = 0 ; Continue until
      or MenuChoice() <> "Error"                        ; exit, zoom, help,
                                                        ; or menu key
      If Menuchoice() = "Error"                         ; Ctrl-Break, Esc,
          and (Retval = 0 or Retval = 27 or Retval = -60) ; or Do-It! pressed
         Then Beep                                      ; from within table
         Else If (Retval < -60 and Retval > -71)  ;Disable keys which would
                  or Retval = -110 or Retval = -111 ; allow a user to leave
                  or Retval = -100                  ; or clear the image
                Then Beep
                Else Keypress Retval
              Endif
      Endif
      Retval = GetChar()
   Endwhile
   Echo Off
   SyncCursor
   If Retval = 0
      Then Retval = 27
   Endif
   ImageRights
   Return Retval
Endproc