; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  MJP 5/14/87, DCY 12/13/88
; ****************************************************************************
; Although presenting a highly-simplified version of an editing session menu,
; EditMenu demonstrates how to incorporate a Paradox-style menu into a DoWait
; application.  More specifically, it shows how to reassign and reject keys in
; using TKChar and TKAccept, respectively.
; 
Proc EditMenu()
;  Private;Choice  ;Menu item selected

   Echo Off  ;ShowMenu raises canvas--first freeze current workspace on canvas
   While True
      ShowMenu
         "Undo"   : "Undo the last change.",
         "Help"   : "Help with data entry.",
         "DO-IT!" : "Complete data entry, save changes to table.",
         "Cancel" : "Stop data entry, cancel all changes."
      To Choice
      ; NOTE:  TKChar is (assuming EditMenu was invoked by a Special key
      ;        procedure assigned to the [F10] key) -68 (Menu) at this point
      ;        and will be passed to and acted upon by Paradox (displaying
      ;        the standard Paradox menu) unless we reset TKChar to some
      ;        other value or set TKAccept to False.  As in all but arrival
      ;        procedures, resetting TKChar to a different value instructs
      ;        DoWait to act upon the new value (remember?).
      Switch
         Case Choice = "Undo" :
            TKChar =  21        ;Tell DoWait to loop around and press [Undo]
         Case Choice = "Help" :
            TKChar = -59        ;Tell DoWait to loop around and press [Help]
         Case Choice = "DO-IT!" :
            TKChar = -60        ;Tell DoWait to loop around and press [DO-IT!]
         Case Choice = "Cancel" :
            ShowMenu
               "No"  : "Do not stop, resume data entry.",
               "Yes" : "Go ahead and cancel data entry, discard all changes."
            To Choice
            Switch
               Case Choice = "No" :  ;Menu/Cancel/No- Nothing should happen.
                  TKAccept = False   ; Specify not to accept the current key
                                     ; in TKChar ([Menu]).
               Case Choice = "Yes" : ;Menu/Cancel/Yes- Cancel the editing
                  TKChar = 0         ; session.  Since [Ctrl][Break] is
                                     ; (presumably) assigned as an "Exit"
                                     ; key, this will exit DoWait.
               ; NOTE: Setting TKChar to 0 will activate field, record, and
               ;       table departure events (if assigned) before actually
               ;       exiting DoWait.  Setting TKKeyType = "X" would cause
               ;       immediate exit from DoWait.
               Otherwise :           ;Menu/Cancel/Esc-
                  Loop               ; Re-display the previous (edit) menu
            Endswitch
         Otherwise:
            TKAccept = False ;Esc pressed from menu-  Instruct DoWait to
                             ; not to pass the key on to Paradox
      Endswitch
      Quitloop
      ; NOTE:  The interaction between TKAccept and TKChar is subtle but
      ;        important.  Setting TKAccept to False instructs DoWait not
      ;        to allow Paradox to act upon the key.  Reassigning TKChar
      ;        to a different key (value) instructs DoWait to act as if a
      ;        user had actually pressed the new key.  Note, however, that
      ;        setting TKAccept to False takes precedence over changing the
      ;        value of TKChar, i.e., if you set TKAccept False, DoWait
      ;        will ignore the value of TKChar even if you have changed it.
      ;        In addition, changing the value of TKChar does not guarantee
      ;        that Paradox will actually act upon the new key.  DoWait will
      ;        reprocess the key exactly as if a user had actually typed it
      ;        on the keyboard, meaning that it must pass through any event
      ;        procedures it might activate before being passed on to Paradox.
   Endwhile
Endproc
