; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  DCY 12/15/88
; ****************************************************************************

DemoLib = SDir()+"DoW8Demo"     ;Name of demonstration library
Createlib DemoLib

; ****************************************************************************
;  NAME: DataEntry
; NOTES: This procedure initiates a sample data entry session under the
;        control of DoWait.  Because data entry is typically an independent
;        subsystem of an application, we have defined DataEntry() as a closed
;        procedure.  To begin the demonstration, you need simply execute the
;        following two commands:
;
;              Readlib SDir()+"DoW8Demo" DataEntry
;              DataEntry(Commentary)
;
;              where Commentary is a logical variable specifying whether or
;                    not to display commentary during the demonstration
;
;        DEMO.SC allows you to run the DoWait demonstration outside of the
;        TKMenu menu.  Refer to it for more information on running the
;        demonstration.
;
Proc Closed DataEntry(Commentary)
;  Private;Commentary     ;Specifies whether or not to display commentary

   AutoLib = SDir()+"Toolkit,"+ ;Library containing Toolkit utility procedures
             SDir()+"DoW8Demo"  ;Library containing demonstration procedures

   SetPopup("Payment")          ;Prepare popup-style menu based on first
                                ; field of records in Payment table
   SetKeyCodes()                ;Define mnemonic Paradox keycode variables

   InitWait(4,"2,1,4","Invoice,Cust,Orders")  ;Initialize DoWait

   ; Note that although there are actually four images on the workspace
   ; during this demonstration, only three are used with DoWait. Thus we
   ; need only include three tables in the InitWait argument list.  Note
   ; also that numbers in the "image no." list need not be in numerical
   ; sequence--what's important is that their order corresponds exactly
   ; to the order of tables in the "table name" list.  Finally, the first
   ; InitWait argument ("max image no.") should be equal to the highest
   ; image number value of all tables to be monitored by DoWait.

   Release Procs InitWait,      ;Release procs no longer needed
                 SetPopup,
                 SetKeycodes

   AreaCode = "(415)"           ;Initialize additional variables
   TaxRate = 7.5

   Setswap 28000                ;Ensure enough memory available to
                                ; view necessary table images

   Reset               ;Clear workspace

   View "Cust"
   View "Invoice"

   If RecNo() = 0      ;If the table is empty, Paradox will open up a new
      Then CoEditKey   ; record for us automatically
           FormKey     ;Display multi-table form
      Else End
           FormKey     ;Display multi-table form
           CtrlHome
           CoEditKey
           CtrlPgDn    ;Open up a new master invoice record
   Endif

   DoWait("")          ;Call DoWait

   Clear
   Prompt                  ;Restore Paradox system prompt
   If Retval <> TKDo_It!   ;Did user cancel out of session?
      Then RequiredCheck Off ; Yes-delete dependent records
           If not IsValid()
              Then CtrlBackSpace
           Endif
           Moveto "Orders" 
           While NImageRecords() <> 1 ;Delete linked order records
              Del
           Endwhile
           Del
           Moveto "Invoice"
           Del           ;Delete master record
   Endif
   Do_It!                ;Post changes
   Reset                 ;Clear workspace

Endproc
Writelib DemoLib DataEntry
Release Procs DataEntry

Play "Ordrdpa"      ;Define DPA proc for Orders table
Writelib DemoLib TKOrders_F
Release Procs TKOrders_F

Play "Custdpa"      ;Define DPA proc for Cust
Writelib DemoLib TKCust_F
Release Procs TKCust_F

Play "Invdpa"       ;Define DPA proc for Invoice
Writelib DemoLib TKInvoice_F
Release Procs TKCust_F

Release Vars TableName, FormId, BorrowFile

Play "InvDemo"      ;InvDemo contains custom procedures for the Invoice table
Play "CustDemo"     ;Contains procedures for Cust
Play "OrdrDemo"     ;Contains procedures for Orders
Play "HelpDemo"     ;Contains inactivity commentary procedures
