#!/bin/sh
#	mm-imap		@(#)DRS/NX MM-IMAP - 1.0 	11 Jun 1993
#
#	Copyright International Computers Limited 1993.
#	This Module contains Proprietary Information of
#	International Computer Limited, and should be
#	treated as Confidential.
#
################################################################################
#
#	Program name: install.mm for Solaris 1
#
################################################################################

SVR4=no
DRS=no

PARENT_DIR=/opt
INSTALL_DIR=$PARENT_DIR/mm-imap
ICL_ADD=/usr

#### verify we have enough disk space for install
#
MIN_USAGE=600 				# PC-MM Server software (200 Kbytes)
MIN_USAGE=`expr $MIN_USAGE / 2 ` 	# convert from block to KB

YES=yes
NO=no

INETDCONF=/etc/inetd.conf
tmp="/tmp/imap$$."

if [ "$SVR4" = "$YES" ]; then
    if [ "$DRS" = "$YES" ]; then
       PRODNAME="Mail Manager 1.0 - imap daemon for DRS/NX"
    else
       PRODNAME="Mail Manager 1.0 - imap daemon for Solaris 2"
    fi
    PATH=/sbin:/usr/sbin:/usr/bin:/etc
else
    PRODNAME="Mail Manager 1.0 - imap daemon for Solaris 1"
    PATH=/usr/5bin:/usr/bin:/etc:/usr/ucb:/usr/etc
fi


# Initialize variables
_THIRDPARTY=true

# Define return values
: ${OK=0} ${FAIL=1} ${STOP=10} ${HALT=11}

trap "cleanup $FAIL" 1 2 3 15

# ************************************************************************
# Print an error message
#
# Usage: error "message"
# Argument is a quoted error message
# Notes: error always returns 1.
#
# ************************************************************************
error() {
        echo "\nError: $*" >&2
        return 1
}


# ************************************************************************
# Print an error message and exit
#
# Usage: fail "message"
# Argument is a quoted error message
#
# ************************************************************************
fail() {
        error "$*"; exit $FAIL
}


# ************************************************************************
# Stops until a key is pressed
# ************************************************************************
pause() {
   echo "Press <Enter> to continue.\c"
   read pAUSE; unset pAUSE
}


# ************************************************************************
# start of ed
# ************************************************************************
EDIT() { /usr/bin/ed - $1 >>/tmp/ture; }


# ************************************************************************
# Guess !!
# ************************************************************************
yes_no() {
  case `echo $1 | tr "[A-Z]" "[a-z]"` in
    yes|no)
      return 0
    ;;
    *)
     echo "Please answer yes or no"
     return 1
    ;;
  esac
}


# ************************************************************************
# prompt varname prompt predicate initial
#  - cannot read a null value
# ************************************************************************
prompt_val() {
  readval=$4
  until [ -n "$readval" ] && $3 "$readval" && eval $1=\""$readval"\";
  do
    echo "$2: \c"
    read readval || exit 1
  done
  readval=""
}


# ************************************************************************
# Prompt for yes or no answer - returns non-zero for no
#
# Usage: getyn "question"
# Argument is a quoted question
# Notes: getyn returns 0 if the answer is y or Y and 1 if
#        the answer is n or N.
#
# ************************************************************************
getyn() {
        while   echo "\n$* (y/n) \c" >&2
        do      read yn rest
                case $yn in
                [yY])   return 0                                ;;
                [nN])   return 1                                ;;
                *)      echo "\nPlease answer y or n" >&2       ;;
                esac
        done
}


# ************************************************************************
# prompt_default varname prompt predicate nulls default_value
# ************************************************************************
prompt_default() {
  default=$4; readval=""
  until [ -n "$readval" ] && $3 "$readval" && eval $1=\""$readval"\";
  do
    echo "$2 [$default]: \c"
    read readval || readval=$default
    case "$readval" in
      \"\")
         eval $1=""; return 0
      ;;
      ?*)
         :  # non-empty value - check later
      ;;
      *)
         if [ "$default" = '""' ]; then
           return 0             # default was 'null'
         else
           readval=$default
         fi
      ;;
    esac
  done
  readval=""; default=""
}


# ************************************************************************
# Remove temp files and exit with the status passed as argument
#
# Usage: cleanup status
# References: $tmp indicates prefix of files to remove
# Notes: cleanup exits with whatever value it is passed.
#
# ************************************************************************
cleanup() {
        trap '' 1 2 3 15
        [ "$tmp" ] && rm -f $tmp*
        exit $1
}


# ************************************************************************
# Check if $2 is included in $1
# ************************************************************************
in_path() {
   TMP=`echo "$2" | sed "s!$1.*!$1!"`
   [ "$1" = "$TMP" ] && return 0
   return 1
}


#****************************************************************************
# Find user
#****************************************************************************
is_user() {
  echo is_$1 > $tmp
  if ls -l $tmp | grep "[ 	]$1[ 	]" >/dev/null; then
    rm $tmp; return 0
  fi
  rm $tmp; return 1
}


#****************************************************************************
# check if user have access
#****************************************************************************
check_user() {
  is_user "$1" || { echo "$1 access required"; exit 1; }
}


# ************************************************************************
# Check access to /usr and /opt, called by main
# ************************************************************************
check_software () {
if [ ! -d $ICL_ADD/bin ]
then
   cat <<EOM
$ICL_ADD is not mounted, mount $ICL_ADD and
start the installation of $PRODNAME again
EOM
   cleanup $HALT
fi

if [ ! -d $PARENT_DIR ]
then
   cat <<EOM
$PARENT_DIR is not mounted, mount or create $PARENT_DIR
and start the installation of $PRODNAME again
EOM
   cleanup $HALT
fi
}


#****************************************************************************
# Check whether NIS is used or not
#****************************************************************************
NIS_used () {
   if [ "$SVR4" = "$YES" ]; then
      if [ `ypwhich 2> /dev/null | wc -c` = 0 ]; then
         NIS=$NO
      else
         NIS=$YES
      fi
   else
      if ypwhich 2> /dev/null |grep ypbind >/dev/null; then
         NIS=$NO
      else
         NIS=$YES
      fi
   fi
}


# ************************************************************************
# check /etc/services. Called by main.
# ************************************************************************
check_services() {
	if [ $NIS = yes ]; then
		# NIS used
		ypcat services.byname | grep imap2 2> /dev/null > /dev/null
		if [ "$?" = "0" ]; then
			# service names seem to be already defined
			return 0
		fi
		# imap2 is not included in the NIS database
		ypcat services.byname | grep 143/tcp 2> /dev/null > /dev/null
		if [ "$?" = "0" ]; then
			cat <<EOM

ERROR: port 143/tcp needed by imap2 already defined in NIS database

To be able to run $PRODNAME,
the imap2 daemon needs the port 143/tcp entry in your NIS database. 
$PRODNAME is not installed. 

EOM
		else
			cat <<EOM

To be able to run $PRODNAME, 
ask the network administrator to include 

   imap2		143/tcp

into the NIS database usually in /etc/services.
$PRODNAME is not installed. 

EOM
		fi
		exit 1
	else
		# NIS not used
		if grep "^imap2" $1 >/dev/null; then
			# service names seem to be already defined
			return 0
		fi
		if grep "[     ][      ]*143/tcp" $1; then
			cat <<EOM

ERROR: port 143/tcp needed by imap2 already defined in '$1'

To be able to run $PRODNAME,
the imap2 daemon needs the port 143/tcp entry in '$1'. 
$PRODNAME is not installed. 

EOM
			exit 1
		fi
	fi
}


# ************************************************************************
# Check available space for the installation, called by main
# ************************************************************************
avail_space () {
AVAIL=`/bin/df $PARENT_DIR | tail -1 | awk '{ print $4 }'`

echo ""
echo "Available space in $PARENT_DIR = $AVAIL Kbytes."

if expr $MIN_USAGE \> $AVAIL > /dev/null; then
   cat << EOM

The disk space of $PARENT_DIR is not enough.
To install $PRODNAME
the minimum amount of disk space is $MIN_USAGE Kb. 
Move $PARENT_DIR to another partition, establish a link from root to
the new $PARENT_DIR directory and restart this installation.

EOM
   pause
   cleanup $HALT
fi

test -d $INSTALL_DIR || {
   mkdir $INSTALL_DIR 2>/dev/null
   chown -R root $INSTALL_DIR
   chgrp -R other $INSTALL_DIR
}

}


# ************************************************************************
# Put the software in a appropriate place, called by main
# ************************************************************************
install_software() {
cd /
echo ""
echo "Moving files to $INSTALL_DIR"
echo ""

( cd $INSTALL_DIR; zcat < /tmp/mmimap.taz | tar xf - )
rm -f /tmp/mm-imap.taz
rm -f /tmp/deinstall.mm

# test -d $ICL_ADD/man || mkdir $ICL_ADD/man >/dev/null
# test -d $ICL_ADD/man/man8 || mkdir $ICL_ADD/man/man8 >/dev/null
# ln -s $PCNFS_DIR/man/man8/imapd.8c $ICL_ADD/man/man8/imapd.8c 2>/dev/null

}


#****************************************************************************
# Check whether NIS is used or not
#****************************************************************************
NIS_used () {
   if [ "$SVR4" = "$YES" ]; then
      if [ `ypwhich 2> /dev/null | wc -c` = 0 ]; then
         NIS=$NO
      else
         NIS=$YES
      fi
   else
      if ypwhich 2> /dev/null |grep ypbind >/dev/null; then
         NIS=$NO
      else
         NIS=$YES
      fi
   fi
}


# ************************************************************************
# edit /etc/services. Called by main.
# ************************************************************************
edit_services() {
	if [ $NIS = yes ]; then
		# NIS used
		ypcat services.byname | grep imap2 2> /dev/null > /dev/null
		if [ "$?" = "0" ]; then
			# service names seem to be already defined
			return 0
		fi
		# imap2 is not included in the NIS database
		ypcat services.byname | grep 143/tcp 2> /dev/null > /dev/null
		if [ "$?" = "0" ]; then
			cat <<EOM

ERROR: port 143/tcp needed by imap2 already defined in NIS database

EOM
			return 2
		fi
		cat <<EOM

To be able to run $PRODNAME, 
ask the network administrator to include 

   imap2		143/tcp

into the NIS database usually in /etc/services.

EOM
	else
		# NIS not used
		if grep "^imap2" $1 >/dev/null; then
			# service names seem to be already defined
			return 0
		fi
		if grep "[     ][      ]*143/tcp" $1; then
			cat <<EOM

ERROR: port 143/tcp needed by imap2 already defined in '$1'

EOM
			return 2
		fi
		# Add as a last line
		EDIT $1 <<\EOS
G
A
imap2		143/tcp
.
w
q
EOS
		return $?
	fi
}
# ************************************************************************
# edit /etc/inetd.conf. Called by main.
# ************************************************************************
edit_inetd() {
	DOHUP=no
	if [ `grep -c "imapd" $INETDCONF` != "0" ]; then
		mv  $INETDCONF  $INETDCONF.mm
		grep -v imap $INETDCONF.mm >$INETDCONF
	else
		cp $INETDCONF $INETDCONF.mm
	fi

	echo "imap2\tstream\ttcp\tnowait\troot\t/opt/mm-imap/bin/imapd\timapd" >>$INETDCONF
	
	if [ `diff $INETDCONF $INETDCONF.mm | wc -c` != "0" ]; then
		DOHUP=yes
	fi
	/bin/rm -f $INETDCONF.mm 2>/dev/null

	#### reconfig inetd
	echo "Activating IMAPD"
	if [ "$SVR4" = "$YES" ]; then
		idpid=`/bin/su root -c "ps -ef " | grep inetd | awk '{print $2}' | head -1`
	else
		idpid=`/bin/su root -c "ps -ax " | grep inetd | awk '{print $1}' | head -1`
	fi
	if [ "$DOHUP" = "$YES" ]; then
#		sync
#		sleep 10
		kill -HUP $idpid 2> /dev/null || echo "Failed to activate IMAPD."
	fi
}


# ************************************************************************
#
# main()
#
# ************************************************************************

# Check that user is root
check_user root

test -f /tmp/mmimap.taz || {
   echo "Cannot find /tmp/mmimap.taz, installation aborted"
   cleanup $HALT
}

echo ""
echo "$PRODNAME" 
echo "(c) Copyright International Computers Limited 1993.\n"

echo "$PRODNAME server installation.\n"

#### Check that needed directory structure is present
#
check_software

#### Check if NIS is used.
#
NIS_used

#### check /etc/services
#
check_services /etc/services

   cat <<\EOM
To install $PRODNAME,
TCP/IP and NFS should be installed.
EOM

#### Inform about the $INSTALL_DIR directory structure.
#

cat <<EOM

The files needed by $PRODNAME
will be copied to $INSTALL_DIR. This file system must have enough space
for the installation.
EOM

#### Find out where to install
#
avail_space

set -f          # no file name generation prevents surprises

#### Install software for Solaris 1
#
install_software

#### Check if NIS is used.
#
NIS_used

#### edit /etc/services
#
echo ""
echo "Adding IMAPD to /etc/services"

edit_services /etc/services

#### edit /etc/inetd.conf
#  Enable imapd
#
   echo "Adding IMAPD to /etc/inetd.conf"
   edit_inetd

cat <<EOF

Installation of $PRODNAME 
server software is complete.

EOF
# pause

#
cleanup $OK
