/*      

			ADELIB.C


      (C) Copyright 1993 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      11993 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.



*/


#include <stdio.h>
#include "adslib.h"
#include "adelib.h"

static char *ade_funcerr = "\nADE LIBRARY ERROR: Invoking function.";
static char *ade_memerr  = "\nADE LIBRARY ERROR: Out of memory.";


int
ade_opendwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeopendwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_defquery(char *uir, char *type, char *mode, char *pmode, char *incrs, struct resbuf *plst)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedefquery",RTSTR,uir,RTSTR,type,RTSTR,mode,RTSTR,
	pmode,RTSTR,incrs,0);
    for(rbt=rb; rbt->rbnext!=NULL; rbt=rbt->rbnext);
    rbt->rbnext=plst;
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_savedwgs(char *dwgs, char *mode)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesavedwgs",RTSTR,dwgs,RTSTR,mode,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_exequery(char *mode, char *dwgs, char *fname, char *ftmpl)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeexequery",RTSTR,mode,RTSTR,dwgs,RTSTR,fname,RTSTR,ftmpl,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_clrquery(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeclrquery",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_showdwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeshowdwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_qviewdwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeqviewdwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_closedwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeclosedwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_deffea(char *fea, char *str)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedeffea",RTSTR,fea,RTSTR,str,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_clrfea(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeclrfea",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_idxdwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeidxdwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_config(char *var, char *val)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeconfig",RTSTR,var,RTSTR,val,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_zextents(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adezextents",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_setdbf(char *dbf)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetdbf",RTSTR,dbf,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

struct resbuf *
ade_getevar(ads_name ename, char *var)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adegetevar",RTENAME,ename,RTSTR,var,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

int
ade_delevar(ads_name ename, char *var)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedelevar",RTENAME,ename,RTSTR,var,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_setevar(ads_name ename, char *var, char *val)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetevar",RTENAME,ename,RTSTR,var,RTSTR,val,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_setdrv(char *drv)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetdrv",RTSTR,drv,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_exesql(char *stmt)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeexesql",RTSTR,stmt,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_settab(char *tab)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesettab",RTSTR,tab,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_closedbf(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeclosedbf",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_defcen(ads_name ename, ads_point pt)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedefcen",RTENAME,ename,RTPOINT,pt,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_setuser(char *usr, char *pwd)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetusr",RTSTR,usr,RTSTR,usr,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_setsearch(char *wcond)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetsearch",RTSTR,wcond,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_setlink(ads_name ename)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesetlink",RTENAME,ename,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_settlink(char *linkkey)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adesettlink",RTSTR,linkkey,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int 
ade_servdwgs(char *dwgs, char *mode)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeservdwgs",RTSTR,dwgs,RTSTR,mode,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

struct resbuf *
ade_dbfftr(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfftr",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbffbr(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfftr",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbffet(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbffet",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbffbk(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbffbk",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbfcurrow(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfcurrow",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbfdel(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfdel",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbfrowqty(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfrowqty",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbfcds(void) {
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfcds",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_dbfcvl(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adedbfcvl",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return(NULL); }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return(NULL); }
    ads_relrb(rb);
    return(rbt);
}

int 
ade_termsql(void)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adetermsql",0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

struct resbuf *
ade_proplist(char *prop)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_proplist",RTSTR,prop,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return NULL; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return NULL; }
    ads_relrb(rb);
    return(rbt);
}

int
ade_prodwgs(char *dwgs, char *pro)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeprodwgs",RTSTR,dwgs,RTSTR,pro,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

int
ade_reldwgs(char *dwgs)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adereldwgs",RTSTR,dwgs,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return RTERROR; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return RTERROR; }
    ads_relrb(rb); ads_relrb(rbt);
    return RTNORM;
}

struct resbuf *
ade_projpt(char *fromcrdsys, char *tocrdsys, ads_point pt)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adeprojpt",RTSTR,fromcrdsys,RTSTR,tocrdsys,RTPOINT,pt,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return NULL; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return NULL; }
    ads_relrb(rb);
    return(rbt);
}

struct resbuf *
ade_getcfg(char *var)
{
    struct resbuf *rb,*rbt;

    rb=ads_buildlist(RTSTR,"c:_adegetcfg",RTSTR,var,0);
    if(rb==NULL) { ads_printf(ade_memerr);  return NULL; }
    if(RTNORM!=ads_invoke(rb,&rbt)) { ads_printf(ade_funcerr);  return NULL; }
    ads_relrb(rb);
    return(rbt);
}
