// Next available MSG number is 490 
// MODULE_ID ACE_DCL_
/***************************************************************************
 ******************************* K-POSS-A **********************************
 ****************  Code for "Define/Main" dialogue boxes  ******************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                     < DESCRIPTION >
 **
 ** define_button
 **    define                     define retirement button
 **
 ** execute_button
 **    execute                    execute retirement button
 **
 ** gisquery
 **    gislbx                     query display list box
 **    gissld                     list box slider
 **    gisdel                     list box delete
 **    gisclr                     list box clear
 **    ggeo                       geographic
 **    gprop                      properties
 **    gsql                       SQL
 **    gisand                     and
 **    gis_or                     or
 **    gisrem                     remove
 **    gisfea                     set features
 **    gisaqk                     execute all quick
 **    gisarl                     execute all real
 **    gisafl                     execute all file
 **
 ** geographic
 **    geobrc1                    1st boxed radio column
 **    geoall                         all
 **    geobuf1                        1st bufferfence
 **    geocir                         circle
 **    geofen1                        1st fence
 **    geopnt                         point
 **    geogon1                        1st polygon
 **    geoplin                        polyline
 **    geowin1                        1st window
 **
 **    geobrc2                    2nd boxed radio column
 **    geowin2                        2nd window
 **    geocro                         crossing
 **
 **    geobrc3                    3rd boxed radio column
 **    geogon2                        2nd polygon
 **    geofen2                        2nd fence
 **    geobuf2                        2nd bufferfence
 **
 ** properties
 **    prorc1                     1st boxed radio column
 **    proare                         area
 **    problk                         block name
 **    procol                         color
 **    proatt                         attribute
 **    proeed                         eed
 **    proele                         elevation
 **    proent                         entity type
 **    prolay                         layer
 **    prolen                         length
 **    prolin                         linetype
 **    prosty                         style
 **    prothi                         thickness
 **    proval                         value
 **
 **    provar                     variable boxed column
 **    provnm                     variable name
 **    provlis                    variable list button
 **
 **    prosbc                     string boxed column
 **    pronam                     string name
 **    prolis                     string list button
 **
 **    pronum                     number boxed column
 **    pronpl                     number popup list
 **                                  list = " = \n > \n < \n != \n >= \n <= \n"
 **    proneb                     number edit box
 **
 ** features
 **    feabxc                     boxed column
 **    fealb1                         list box
 **    feaedi                         edit item
 **    feadel                         delete
 **    feaclr                         clear list
 **    fearc1                     1st boxed radio row
 **
 **    feablk                         block name
 **    feacol                         color
 **    feaele                         elevation
 **    feafil                         fill
 **    feahgt                         height
 **
 **    fealay                         layer
 **    fealin                         linetype
 **    fearot                         rotation
 **    feascl                         scale
 **    feasty                         style
 **
 **    featxt                         text
 **    featht                         theight
 **    feathk                         thickness
 **    featvl                         tvalue
 **    feawid                         width
 **
 **    feaebr                     expression boxed_row
 **    feanam                     expression edit_box
 **
 **    feaadd                     add to list
 **
 ** sgis_generic
 **    gentitl                    generic title      dialog
 **    tolbox                     File:              boxcolumn
 **    tolsld                                        list box
 **    tolsll                     Select All         button
 **    tolcll                     Clear All          button
 **    botedt                     Name:              editbox
 **
 ** eed_select
 **    esltitl                    eed select titl    dialog
 **    eslbxc                     File:              boxcolumn
 **    esllbx                                        list box
 **    esledt                     Name:              editbox
 **
 ** sgis_block_name - replaced by sgis_generic
 **
 ** sgis_att - replaced by sgis_generic
 **
 ** sgis_eed - replaced by sgis_generic
 **
 ** sgis_entity_type - replaced by sgis_generic
 **
 ** sgis_layer_name - replaced by sgis_generic
 **
 ** sgis_linetype - replaced by sgis_generic
 **
 ** sgis_style - replaced by sgis_generic
 **
 ***************************************************************************/

execute_button : retirement_button {
    label    = /*MSG1*/"Execute...";
    key      = "execute";
    mnemonic = "";
    is_default = false;
}

build_button : retirement_button {
    label    = /*MSG2*/"Build...";
    key      = "execute";
    mnemonic = "";
    is_default = false;
}

define_button : retirement_button {
    label    = /*MSG3*/"Define <";
    key      = "define";
    mnemonic = "";
    is_default = true;
}

define_cancel : column {
    : row {
        alignment = centered;
        fixed_width = true;
        define_button;
        : spacer { width = 2; }
        cancel_button;
    }
}

gisquery : dialog {
    label = /*MSG4*/"Define Query";
    : boxed_column {
        label = /*MSG5*/"Query Display";
        : list_box {
            label = "";
            key = "gislbx";
            width = 47;
            height = 3;
        }
        : slider {
            key = "gissld";
            value = "0";
            min_value = 0;
            max_value = 256;
            small_increment = 1;
            big_increment = 10;
        }
        : row {
            alignment = centered;
            fixed_width = true;
            : button {
                label = /*MSG6*/"Delete";
                key = "gisdel";
                mnemonic = /*MSG7*/"D";
                width = 12;
            }
            : spacer { width = 1; }
            : button {
                label = /*MSG8*/"Clear List";
                key = "gisclr";
                mnemonic = /*MSG9*/"C";
                width = 12;
            }
        }
    }
    : row {
        alignment = centered;
        fixed_width = true;
        : column {
            spacer_1;
            : button {
                label = /*MSG10*/"Location...";
                key = "ggeo";
                mnemonic = /*MSG11*/"L";
                width = 16;
            }
            : button {
                label = /*MSG12*/"Properties...";
                key = "gprop";
                mnemonic = /*MSG13*/"P";
                width = 16;
            }
            : button {
                label = /*MSG14*/"SQL...";
                key = "gsql";
                mnemonic = /*MSG15*/"S";
                width = 16;
            }
        }
        : spacer { width = 6; }
        fixed_height = true;
        : column {
            : boxed_radio_column {
                label = " ";
                key = "";
                alignment = top;
                fixed_height = true;
                width = 16;
                : radio_button {
                    label = /*MSG16*/"Intersect(And)";
                    key = "gisand";
                    mnemonic = /*MSG17*/"I";
                }
                : radio_button {
                    label = /*MSG18*/"Union(Or)";
                    key = "gis_or";
                    mnemonic = /*MSG19*/"U";
                }
                : radio_button {
                    label = /*MSG20*/"Remove";
                    key = "gisrem";
                    mnemonic = /*MSG21*/"R";
                }
            }
            spacer;
            : button {
                label = /*MSG22*/"Set Features...";
                key = "gisfea";
                mnemonic = /*MSG23*/"F";
                width = 16;
            }
            : button {
                label = /*MSG24*/"Clear Features";
                key = "gisclf";
                mnemonic = /*MSG25*/"C";
                width = 16;
            }
        }
    }
    spacer;
    : row {
        alignment = centered;
        fixed_width = true;
        : boxed_row {
            label = /*MSG26*/"Execute as:";
            fixed_width = true;
            : button {
                label = /*MSG27*/"Show";
                key = "gisaqk";
                mnemonic = /*MSG28*/"h";
            }
            spacer_1;
            : button {
                label = /*MSG29*/"Draw";
                key = "gisarl";
                mnemonic = /*MSG30*/"w";
            }
            spacer_1;
            : button {
                label = /*MSG31*/"Extract";
                key = "gisael";
                mnemonic = /*MSG32*/"E";
            }
            spacer_1;
            : button {
                label = /*MSG33*/"File";
                key = "gisafl";
                mnemonic = /*MSG34*/"F";
            }
            spacer_1;
            execute_button;
        }
    }
    spacer;
    ok_cancel_help;
}

geographic : dialog {
    label = /*MSG35*/"Location Criteria";
    :column {
        : row {
            fixed_width = true;
            : boxed_radio_column {
                label = "";
                key = "geobrc1";
                width = 15;
                : radio_button {
                    label = /*MSG36*/"All";
                    key = "geoall";
                    mnemonic = /*MSG37*/"A";
                }
                : radio_button {
                    label = /*MSG38*/"Bufferfence";
                    key = "geobuf1";
                    mnemonic = /*MSG39*/"B";
                }
                : radio_button {
                    label = /*MSG40*/"Circle";
                    key = "geocir";
                    mnemonic = /*MSG41*/"C";
                }
                : radio_button {
                    label = /*MSG42*/"Fence";
                    key = "geofen1";
                    mnemonic = /*MSG43*/"F";
                }
                : radio_button {
                    label = /*MSG44*/"Point";
                    key = "geopnt";
                    mnemonic = /*MSG45*/"t";
                }
                : radio_button {
                    label = /*MSG46*/"Polygon";
                    key = "geogon1";
                    mnemonic = /*MSG47*/"P";
                }
                : radio_button {
                    label = /*MSG48*/"PolyLine";
                    key = "geoplin";
                    mnemonic = /*MSG49*/"L";
                }
                : radio_button {
                    label = /*MSG50*/"Window";
                    key = "geowin1";
                    mnemonic = /*MSG51*/"W";
                }
            }
            : spacer { width = 2; }
            : column {
                : boxed_radio_column {
                    label = "";
                    key = "geobrc2";
                    width = 15;
                    : radio_button {
                        label = /*MSG52*/"Inside";
                        key = "geowin2";
                        mnemonic = "";
                    }
                    : radio_button {
                        label = /*MSG53*/"Crossing";
                        key = "geocro";
                        mnemonic = "";
                    }
                }
                spacer_1;
                : boxed_radio_column {
                    label = "";
                    key = "geobrc3";
                    width = 15;
                    : radio_button {
                        label = /*MSG54*/"Polygon";
                        key = "geogon2";
                        mnemonic = "";
                    }
                    : radio_button {
                        label = /*MSG55*/"Fence";
                        key = "geofen2";
                        mnemonic = "";
                    }
                    : radio_button {
                        label = /*MSG56*/"Bufferfence";
                        key = "geobuf2";
                        mnemonic = "";
                    }
                }
            }
        }
        spacer;
    }
    define_cancel;
}

properties : dialog {
    label = /*MSG57*/"Properties Criteria";
    : row {
        alignment = centered;
        fixed_width = true;
        : boxed_radio_column {
            width = 16;
            key = "prorc1";
            : radio_button {
                label = /*MSG58*/"Area";
                key = "proare";
                mnemonic = /*MSG59*/"A";
            }
            : radio_button {
                label = /*MSG60*/"Attribute";
                key   = "proatt";
                mnemonic = /*MSG61*/"i";
            }
            : radio_button {
                label = /*MSG62*/"Block Name";
                key = "problk";
                mnemonic = /*MSG63*/"B";
            }
            : radio_button {
                label = /*MSG64*/"Color";
                key = "procol";
                mnemonic = /*MSG65*/"C";
            }
            : radio_button {
                label = /*MSG66*/"EED";
                key = "proeed";
                mnemonic = /*MSG67*/"D";
            }
            : radio_button {
                label = /*MSG68*/"Elevation";
                key = "proele";
                mnemonic = /*MSG69*/"n";
            }
            : radio_button {
                label = /*MSG70*/"Entity Type";
                key = "proent";
                mnemonic = /*MSG71*/"E";
            }
            : radio_button {
                label = /*MSG72*/"Layer";
                key = "prolay";
                mnemonic = /*MSG73*/"r";
            }
            : radio_button {
                label = /*MSG74*/"Length";
                key = "prolen";
                mnemonic = /*MSG75*/"t";
            }
            : radio_button {
                label = /*MSG76*/"Linetype";
                key = "prolin";
                mnemonic = /*MSG77*/"L";
            }
            : radio_button {
                label = /*MSG78*/"Style";
                key = "prosty";
                mnemonic = /*MSG79*/"S";
            }
            : radio_button {
                label = /*MSG80*/"Text Value";
                key = "proval";
                mnemonic = /*MSG81*/"V";
            }
            : radio_button {
                label = /*MSG82*/"Thickness";
                key = "prothi";
                mnemonic = /*MSG83*/"h";
            }
        }
        spacer_1;
        : column {
            spacer_1;
            fixed_height = true;
            : boxed_column {
                label = /*MSG84*/"Variable";
                key = "provar";
                fixed_height = true;
                : edit_box {
                    label = /*MSG85*/"Name:";
                    key = "provnm";
                    edit_width = 23;
                }
                spacer;
                : button {
                    label = /*MSG86*/"List...";
                    key = "provlis";
                    alignment = centered;
                    fixed_width = true;
                    width = 8;
                }
            }
            spacer_1;
            : boxed_column {
                label = /*MSG87*/"String";
                key = "prosbc";
                fixed_height = true;
                : edit_box {
                    label = /*MSG88*/"Name:";
                    key = "pronam";
                    edit_width = 23;
                }
                spacer;
                : button {
                    label = /*MSG89*/"List...";
                    key = "prolis";
                    alignment = centered;
                    fixed_width = true;
                    width = 8;
                }
            }
            spacer_1;
            : boxed_column {
                label = /*MSG90*/"Number";
                key = "pronum";
                : row {
                    : popup_list {
                        label = /*MSG91*/"Range:";
                        key = "pronpl";
                        list="=\n>\n<\n!=\n>=\n<=";
                        edit_width = 5;
                    }
                    : edit_box {
                        label = "";
                        key = "proneb";
                        edit_width = 15;
                    }
                }
            }
        }
        spacer_1;
    }
    ok_cancel;
}

features : dialog {
    label = /*MSG92*/"Features Alteration";
    spacer;
    : column {
        alignment = centered;
        fixed_width = true;
        : boxed_column {
            label = /*MSG93*/"Features Display";
            key = "feabxc";
            : list_box {
                label = "";
                key = "fealb1";
                width = 0;
                height = 5;
            }
            : row {
                alignment = centered;
                fixed_width = true;
                : button {
                    label = /*MSG94*/"Edit Item";
                    key = "feaedi";
                    mnemonic = /*MSG95*/"E";
                    width = 12;
                }
                : spacer { width = 1; }
                : button {
                    label = /*MSG96*/"Delete";
                    key = "feadel";
                    mnemonic = /*MSG97*/"D";
                    width = 12;
                }
                : spacer { width = 1; }
                : button {
                    label = /*MSG98*/"Clear List";
                    key = "feaclr";
                    mnemonic = /*MSG99*/"C";
                    width = 12;
                }
            }
        }
        : boxed_row {
            width = 0;
            key = "fearc1";
            : radio_column {
                : radio_button {
                    label = /*MSG100*/"Block Name";
                    key = "feablk";
                    mnemonic = /*MSG101*/"B";
                }
                : radio_button {
                    label = /*MSG102*/"Color";
                    key = "feacol";
                    mnemonic = /*MSG103*/"C";
                }
                : radio_button {
                    label = /*MSG104*/"Elevation";
                    key = "feaele";
                    mnemonic = /*MSG105*/"E";
                }
                : radio_button {
                    label = /*MSG106*/"Fill";
                    key = "feafil";
                    mnemonic = /*MSG107*/"F";
                }
                : radio_button {
                    label = /*MSG108*/"Height";
                    key = "feahgt";
                    mnemonic = /*MSG109*/"H";
                }
            }
            spacer_1;
            : radio_column {
                : radio_button {
                    label = /*MSG110*/"Layer";
                    key = "fealay";
                    mnemonic = /*MSG111*/"r";
                }
                : radio_button {
                    label = /*MSG112*/"Linetype";
                    key = "fealin";
                    mnemonic = /*MSG113*/"L";
                }
                : radio_button {
                    label = /*MSG114*/"Rotation";
                    key = "fearot";
                    mnemonic = /*MSG115*/"o";
                }
                : radio_button {
                    label = /*MSG116*/"Scale";
                    key = "feascl";
                    mnemonic = /*MSG117*/"a";
                }
                : radio_button {
                    label = /*MSG118*/"Style";
                    key = "feasty";
                    mnemonic = /*MSG119*/"S";
                }
            }
            : spacer { width = 2; }
            : radio_column {
                : radio_button {
                    label = /*MSG120*/"Text";
                    key = "featxt";
                    mnemonic = /*MSG121*/"x";
                }
                : radio_button {
                    label = /*MSG122*/"THeight";
                    key = "featht";
                    mnemonic = /*MSG123*/"T";
                }
                : radio_button {
                    label = /*MSG124*/"Thickness";
                    key = "feathk";
                    mnemonic = /*MSG125*/"h";
                }
                : radio_button {
                    label = /*MSG126*/"TValue";
                    key = "featvl";
                    mnemonic = /*MSG127*/"V";
                }
                : radio_button {
                    label = /*MSG128*/"Width";
                    key = "feawid";
                    mnemonic = /*MSG129*/"W";
                }
            }
        }
        : boxed_row {
            label = "";
            key = "feaebr";
            : edit_box {
                label = /*MSG130*/"Expression:";
                key = "feaval";
                edit_width = 0; /* 28 */
            }
        }
    }
    spacer_1;
    : row {
        alignment = centered;
        fixed_width = true;
        : button {
            label = /*MSG131*/"Add to List";
            key = "feaadd";
            mnemonic = /*MSG132*/"A";
        }
        : spacer { width = 2; }
        ok_button;
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
}

features_unix : dialog {
    label = /*MSG133*/"Features Alteration";
    spacer;
    : column {
        alignment = centered;
        fixed_width = true;
        : boxed_column {
            label = /*MSG134*/"Features Display";
            key = "feabxc";
            : list_box {
                label = "";
                key = "fealb1";
                width = 0;
                height = 5;
            }
            : row {
                alignment = centered;
                fixed_width = true;
                : button {
                    label = /*MSG135*/"Edit Item";
                    key = "feaedi";
                    mnemonic = /*MSG136*/"E";
                    width = 12;
                }
                : spacer { width = 1; }
                : button {
                    label = /*MSG137*/"Delete";
                    key = "feadel";
                    mnemonic = /*MSG138*/"D";
                    width = 12;
                }
                : spacer { width = 1; }
                : button {
                    label = /*MSG139*/"Clear List";
                    key = "feaclr";
                    mnemonic = /*MSG140*/"C";
                    width = 12;
                }
            }
        }
        : boxed_row {
            width = 0;
            key = "fearc1";
            : column {
                : toggle {
                    label = /*MSG141*/"Block Name";
                    key = "feablk";
                    mnemonic = /*MSG142*/"B";
                }
                : toggle {
                    label = /*MSG143*/"Color";
                    key = "feacol";
                    mnemonic = /*MSG144*/"C";
                }
                : toggle {
                    label = /*MSG145*/"Elevation";
                    key = "feaele";
                    mnemonic = /*MSG146*/"E";
                }
                : toggle {
                    label = /*MSG147*/"Fill";
                    key = "feafil";
                    mnemonic = /*MSG148*/"F";
                }
                : toggle {
                    label = /*MSG149*/"Height";
                    key = "feahgt";
                    mnemonic = /*MSG150*/"H";
                }
            }
            spacer_1;
            : column {
                : toggle {
                    label = /*MSG151*/"Layer";
                    key = "fealay";
                    mnemonic = /*MSG152*/"r";
                }
                : toggle {
                    label = /*MSG153*/"Linetype";
                    key = "fealin";
                    mnemonic = /*MSG154*/"L";
                }
                : toggle {
                    label = /*MSG155*/"Rotation";
                    key = "fearot";
                    mnemonic = /*MSG156*/"o";
                }
                : toggle {
                    label = /*MSG157*/"Scale";
                    key = "feascl";
                    mnemonic = /*MSG158*/"a";
                }
                : toggle {
                    label = /*MSG159*/"Style";
                    key = "feasty";
                    mnemonic = /*MSG160*/"S";
                }
            }
            : spacer { width = 2; }
            : column {
                : toggle {
                    label = /*MSG161*/"Text";
                    key = "featxt";
                    mnemonic = /*MSG162*/"x";
                }
                : toggle {
                    label = /*MSG163*/"THeight";
                    key = "featht";
                    mnemonic = /*MSG164*/"T";
                }
                : toggle {
                    label = /*MSG165*/"Thickness";
                    key = "feathk";
                    mnemonic = /*MSG166*/"h";
                }
                : toggle {
                    label = /*MSG167*/"TValue";
                    key = "featvl";
                    mnemonic = /*MSG168*/"V";
                }
                : toggle {
                    label = /*MSG169*/"Width";
                    key = "feawid";
                    mnemonic = /*MSG170*/"W";
                }
            }
        }
        : boxed_row {
            label = "";
            key = "feaebr";
            : edit_box {
                label = /*MSG171*/"Expression:";
                key = "feaval";
                edit_width = 0; /* 28 */
            }
        }
    }
    spacer_1;
    : row {
        alignment = centered;
        fixed_width = true;
        : button {
            label = /*MSG172*/"Add to List";
            key = "feaadd";
            mnemonic = /*MSG173*/"A";
        }
        : spacer { width = 2; }
        ok_button;
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
}

sgis_generic : dialog {
    label = "";
    key = "gentitl";
    : boxed_column {
        label = "";
        key = "tolbox";
        fixed_width = true;
        : list_box {
            label = "";
            key = "tolsld";
            multiple_select = true;
            width = 31;
            height = 6;
        }
        spacer;
        : row {
            alignment = centered;
            fixed_width = true;
            : button {
                label = /*MSG174*/"Select All";
                key = "tolsll";
                mnemonic = /*MSG175*/"S";
                width = 12;
            }
            : spacer { width = 2; }
            : button {
                label = /*MSG176*/"Clear All";
                key = "tolcll";
                mnemonic = /*MSG177*/"C";
                width = 12;
            }
        }
    }
    : column {
        spacer_1;
        : edit_box {
            label = /*MSG178*/"Name:";
            key = "botedt";
            mnemonic = /*MSG179*/"D";
            value = "*";
            edit_width = 0;
        }
        spacer_1;
        ok_cancel;
    }
}

eed_select : dialog {
    label = "";
    key = "esltitl";
    : list_box {
        label = "";
        key = "esllbx";
        width = 31;
        height = 6;
    }
    spacer;
    : column {
        spacer_1;
        : edit_box {
            label = /*MSG180*/"Name:";
            key = "esledt";
            mnemonic = /*MSG181*/"D";
            value = "";
            edit_width = 0;
        }
        spacer_1;
        ok_cancel;
    }
}

sgis_att : dialog {
    label = /*MSG182*/"ATT Edit";
    spacer;
    topoflistbox;
    botoflistbox;
}

sgis_eed : dialog {
    label = /*MSG183*/"EED Edit";
    spacer;
    topoflistbox;
    botoflistbox;
}

sgis_block_name : dialog {
    label = /*MSG184*/"Block Name";
    topoflistbox;
    botoflistbox;
}

sgis_entity_type : dialog {
    label = /*MSG185*/"Entity Type";
    topoflistbox;
    botoflistbox;
}

sgis_layer_name : dialog {
    label = /*MSG186*/"Layer Name";
    topoflistbox;
    botoflistbox;
}

sgis_linetype : dialog {
    label = /*MSG187*/"Linetype";
    topoflistbox;
    botoflistbox;
}

sgis_style : dialog {
    label = /*MSG188*/"Style";
    topoflistbox;
    botoflistbox;
}

/***************************************************************************
 ***************************************************************************
 ***********************   Code for "Config" Dialog  ***********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                     < DESCRIPTION >
 **
 ** gisconfig
 **    cfgsen                     toggle-case sensitive text match
 **    cfgdqt                     toggle-draw quick text as text
 **    cfgdqb                     toggle-draw quick blocks as blocks
 **    cfgflk                     toggle-file locking
 **
 **    cfgmmu                     edit box - max memory to use
 **    cfgccf                     edit box - color for crossing fences
 **    cfgcwf                     edit box - color for window fences
 **    cfghsz                     edit box - hatch size
 **    cfgapp                     edit box - application name
 ** 
 ***************************************************************************/

gisconfig : dialog {
    label = /*MSG189*/"Configuration";
    spacer_1;
    : row {
        : column {
            alignment = centered;
            fixed_height = true;
            : toggle {
                label = /*MSG190*/"Case sensitive text match";
                key = "cfgsen";
            }
            : toggle {
                label = /*MSG191*/"Draw show text as text";
                key = "cfgdqt";
            }
            : toggle {
                label = /*MSG192*/"Draw show blocks as blocks";
                key = "cfgdqb";
            }
            : toggle {
                label = /*MSG193*/"File and entity locking";
                key = "cfgflk";
            }
            : toggle {
                label = /*MSG194*/"Force user login";
                key = "cfguli";
            }
        }
        : spacer { width = 2; }
        : column {
            alignment = top;
            fixed_height = true;
            : edit_box {
                label = /*MSG195*/"Maximum memory to use:";
                key = "cfgmmu";
                edit_width = 0;
                edit_limit = 9;
                allow_accept = true;
            }
            : edit_box {
                label = /*MSG196*/"Color for removal fences:";
                key = "cfgccf";
                edit_width = 0;
                edit_limit = 3;
                allow_accept = true;
            }
            : edit_box {
                label = /*MSG197*/"Color for adding fences:";
                key = "cfgcwf";
                edit_width = 0;
                edit_limit = 3;
                allow_accept = true;
            }
            : edit_box {
                label = /*MSG198*/"Hatch size for fills:";
                key = "cfghsz";
                edit_width = 0;
                edit_limit = 9;
                allow_accept = true;
            }
            : edit_box {
                label = /*MSG199*/"Application name:";
                key = "cfgapp";
                edit_width = 0;
                edit_limit = 31;
                allow_accept = true;
            }
        }
    }
    spacer_1;
    : row {
        fixed_width=true;
        alignment=centered;
        : edit_box {
            label = /*MSG200*/"Coordinate system code:";
            key = "cfgtrn";
            edit_width = 8;
            edit_limit = 8;
            allow_accept = true;
        }
        spacer_1;
        : button {
            label = /*MSG201*/"List...";
            key = "cfglst";
            width = 8;
            fixed_width=true;
        }
    }
    spacer_1;
    ok_cancel_help;
    errtile;
}

/***************************************************************************
 ***************************************************************************
 *********************  Code for "DWG Name" Dialogs  ***********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                     < DESCRIPTION >
 **
 ** dwg_select
 **    selbxc                     boxed column
 **    sellbx                         list box
 **    selsel                         select all button
 **    selclr                         clear all button
 **
 **    selebx                     edit box
 **
 ** dwg_execute
 **    exebxc                     boxed column
 **    exelbx                         list box
 **    exesel                         select all button
 **    execlr                         clear all button
 **
 **    exedeb                     drawings edit box
 **
 **    exebc2                     Entities: boxed column
 **    exeqck                         "quick" radio button
 **    exerea                         "real" radio button
 **    exetxt                         "file" radio button
 **
 **    exefeb                         "file" edit box
 **    exeteb                         "template" edit box
 **
 ****************************************************************************/

dwg_select : dialog {
    label = /*MSG202*/"Select Open Drawing";
    : boxed_column {
        label = /*MSG203*/"File:";
        key = "selbxc";
        fixed_width = true;
        : list_box {
            label = "";
            key = "sellbx";
            multiple_select = true;
            width = 31;
            height = 6;
        }
        spacer;
        : row {
            alignment = centered;
            fixed_width = true;
            : button {
                label = /*MSG204*/"Select All";
                key = "selsel";
                mnemonic = /*MSG205*/"S";
                width = 12;
            }
            : spacer { width = 2; }
            : button {
                label = /*MSG206*/"Clear All";
                key = "selclr";
                mnemonic = /*MSG207*/"C";
                width = 12;
            }
        }
    }
    : column {
        spacer_1;
        : edit_box {
            label = /*MSG208*/"Drawings:";
            key = "selebx";
            mnemonic = /*MSG209*/"F";
            value = "*";
            edit_width = 0;
        }
        spacer_1;
        ok_cancel;
    }
}

dwg_execute : dialog {
    label = /*MSG210*/"Run Query";
    : boxed_column {
        label = /*MSG211*/"File:";
        key = "exebxc";
        alignment = centered;
        fixed_width = true;
        : list_box {
            label = "";
            key = "exelbx";
            alignment = centered;
            fixed_width = true;
            multiple_select = true;
            width = 31;
            height = 6;
        }
        spacer;
        : row {
            alignment = centered;
            fixed_width = true;
            : button {
                label = /*MSG212*/"Select All";
                key = "exesel";
                mnemonic = /*MSG213*/"S";
                width = 12;
            }
            : spacer { width = 2; }
            : button {
                label = /*MSG214*/"Clear All";
                key = "execlr";
                mnemonic = /*MSG215*/"C";
                width = 12;
            }
        }
    }
    spacer_1;
    : column {
        : edit_box {
            label = /*MSG216*/"Drawings:";
            key = "exedeb";
            mnemonic = /*MSG217*/"F";
            value = "*";
            edit_width = 0;
        }
        spacer_1;
        : boxed_column {
            label = /*MSG218*/"Entities:";
            key = "exebc2";
            : radio_row {
                alignment = centered;
                fixed_width = true;
                : radio_button {
                    label = /*MSG219*/"Show";
                    key = "exeqck";
                    mnemonic = /*MSG220*/"Q";
                }
                : spacer { width = 2; }
                : radio_button {
                    label = /*MSG221*/"Draw";
                    key = "exerea";
                    mnemonic = /*MSG222*/"R";
                }
                : spacer { width = 2; }
                : radio_button {
                    label = /*MSG223*/"Extract";
                    key = "exeext";
                    mnemonic = /*MSG224*/"E";
                }
                : spacer { width = 2; }
                : radio_button {
                    label = /*MSG225*/"File";
                    key = "exetxt";
                    mnemonic = /*MSG226*/"T";
                }
            }
            spacer;
            : edit_box {
                label = /*MSG227*/"    File:";
                key = "exefeb";
                edit_width = 31;
            }
            spacer;
            : edit_box {
                label = /*MSG228*/"Template:";
                key = "exeteb";
                edit_width = 0;
            }
        }
        spacer_1;
        ok_cancel_help;
    }
}

/***************************************************************************
 ***************************************************************************
 *******************  Code for "Saving Query" dialogs  *********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TILE >
 **
 ** save_query
 **    savocd                   "open current drawings"    toggle
 **    savfea                   "save features"            toggle
 **    savpts                   "save selected points"     toggle
 **    savexe                   "auto execute"             toggle
 **
 **    savbxc                   entities                   boxed column
 **    savqck                       quick                  radio button
 **    savrea                       real                   radio button
 **    savtxt                       file                   radio button
 **    savfeb                       "file"                 edit box
 **    savteb                       "template"             edit box
 **
 **    savbx2                   Drawings                   boxed column
 **    savdeb                   "open dwg name"            edit box
 **    savlst                   "list dwg names"           button
 **
 ****************************************************************************/

save_query : dialog {
    label = /*MSG229*/"Query Save Options";
    initial_focus = /*MSG230*/"savdeb";
    spacer_1;
    : column {
       alignment = centered;
       fixed_width = true;
       : toggle {
            label = /*MSG231*/"Open Current Drawings";
            key = "savocd";
            mnemonic = /*MSG232*/"O";
            value = "1";
        }
        : toggle {
            label = /*MSG233*/"Save Features";
            key = "savfea";
            mnemonic = /*MSG234*/"F";
            value = "1";
        }
        : toggle {
            label = /*MSG235*/"Save Selected Points";
            key = "savpts";
            mnemonic = /*MSG236*/"P";
            value = "0";
        }
        : toggle {
            label = /*MSG237*/"Auto Execute";
            key = "savexe";
            mnemonic = /*MSG238*/"E";
            value = "1";
        }
    }
    spacer_1;
    : boxed_column {
        label = /*MSG239*/"Entities:";
        key = "savbxc";
        : radio_row {
            alignment = centered;
            fixed_width = true;
            : radio_button {
                label = /*MSG240*/"Show";
                key = "savqck";
                mnemonic = /*MSG241*/"S";
                value = "1";
            }
            : spacer { width = 2; }
            : radio_button {
                label = /*MSG242*/"Draw";
                key = "savrea";
                mnemonic = /*MSG243*/"D";
            }
            : spacer { width = 2; }
            : radio_button {
                label = /*MSG244*/"Extract";
                key = "savext";
                mnemonic = /*MSG245*/"E";
            }
            : spacer { width = 2; }
            : radio_button {
                label = /*MSG246*/"File";
                key = "savtxt";
                mnemonic = /*MSG247*/"T";
            }
        }
        spacer;
        : edit_box {
            label = /*MSG248*/"    File:";
            key = "savfeb";
            edit_width = 31;
            is_enabled = false;
        }
        spacer;
        : edit_box {
            label = /*MSG249*/"Template:";
            key = "savteb";
            edit_width = 0;
            is_enabled = false;
        }
    }
    spacer_1;
    : boxed_column {
        label = /*MSG250*/"Open Drawing(s) to Query From:";
        key = "savbx2";
        : edit_box {
            label = /*MSG251*/"Name(s):";
            key = "savdeb";
            mnemonic = /*MSG252*/"F";
            value = "*";
            edit_width = 0;
        }
        spacer;
        : button {
            label = /*MSG253*/"List...";
            key = "savlst";
            mnemonic = "";
            width = 8;
            alignment = centered;
            fixed_width = true;
        }
    }
    spacer_1;
    ok_cancel_help;
}

/***************************************************************************
 ***************************************************************************
 **********************  Code for "EED Edit" Dialog  ***********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                     < DESCRIPTION >
 **
 ** eed_edit
 **    eeebc1                     boxed column
 **    eeelb1                         list box
 **    eeesld                         horizontal slider
 **    eeedel                         delete button
 **    eeeadd                         add button
 **    eeeebx                         edit box
 **
 ** eed_var
 **    eevchr                     Character radio button
 **    eevnum                     Numeric radio button
 **    eevbc1                     boxed column
 **    eevvnm                         edit box
 **    eevlis                         list button
 **
 ***************************************************************************/

eed_edit : dialog {
    label = /*MSG254*/"EED Edit";
    : column {
        : boxed_column {
            label = "";
            key = "eeebc1";
            : list_box {
                label = "";
                key = "eeelb1";
                width = 41;
                height = 5;
            }
            : slider {
                layout = horizontal;
                key = "eeesld";
                min_value = 0;
                max_value = 256;
                small_increment = 1;
                big_increment = 10;
            }
            spacer;
            : row {
                alignment = centered;
                fixed_width = true;
                fixed_height = true;
                : button {
                    label = /*MSG255*/"Delete";
                    key = "eeedel";
                    mnemonic = /*MSG256*/"D";
                }
                : spacer { width = 2; }
                : button {
                    label = /*MSG257*/"Add...";
                    key = "eeeadd";
                    mnemonic = /*MSG258*/"A";
                }
            }
        }
        spacer_1;
        : boxed_column {
            label = /*MSG259*/"Edit";
            : edit_box {
                label = /*MSG260*/"Value:";
                key = "eeeebx";
                edit_width = 0;
            }
        }
    }
    spacer_1;
    ok_cancel_help;
}

eed_var : dialog {
    label = /*MSG261*/"Add Variable";
    spacer;
    : list_box {
      label  = "";
      key    = "eevlb1";
      width  = 23;
      height = 8;
    }
    spacer;
    : radio_row {
        alignment = centered;
        fixed_width = true;
        : radio_button {
            label = /*MSG262*/"Character";
            key = "eevchr";
            mnemonic = /*MSG263*/"C";
        }
        : spacer { width = 2; }
        : radio_button {
            label = /*MSG264*/"Numeric";
            key = "eevnum";
            mnemonic = /*MSG265*/"N";
        }
    }
    spacer;
    : boxed_column {
        label = /*MSG266*/"Variable";
        key = "eevbc1";
        fixed_height = true;
        : edit_box {
            label = /*MSG267*/"Name:";
            key = "eevvnm";
            edit_width = 23;
        }
    }
    spacer_1;
    ok_cancel;
}

/***************************************************************************
 ***************************************************************************
 **********************  Code for "Edit SQL" Dialogs  **********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TYPE >
 **
 ** sql_ok_cancel_err
 **    sqlerr                   "sql edit" errtile         text
 **
 ** l_slider
 **    sldlst                   "sql edit" slider list     slider
 **
 ** currentsettings_2
 **    curset2                  current settings - 2       boxed column
 **    text_1                   1st line of text in box    text
 **    text_2                   2nd line of text in box    text
 **
 ** currentsettings_3
 **    curset3                  current settings - 3       boxed column
 **    text_1                   1st line of text in box    text
 **    text_2                   2nd line of text in box    text
 **    text_3                   3rd line of text in box    text
 **
 ** open_dbase
 **    odbsbc                   Current Settings           boxed column
 **    text_1                       1st line of text       text
 **
 **    odblst                   Attached Databases         list box
 **    odbdat                   Database:                  edit box
 **
 ** open_table
 **    tbllst                   Attached Tables            list box
 **    tbltab                   Table:                     edit box
 **
 ** sql_edit
 **    edtsro                   Selected Row Options:      boxed row
 **    edtkey                       Key...                 button
 **    edtlks                       Linkables...           button
 **    edtgph                       Graphical <            button
 **
 **    edttxt					sql info				   text
 **    edtsld					sql info				   slider
 **
 **    edtrow                   current row number         text
 **    edtlst                   edit values - list         list box
 **    edtedt                   edit values - edit         edit box
 **
 **    edtnxt                   Next:                      button
 **    edtprv                   Previous                   button
 **    edt1st                   First                      button
 **    edtlast                  Last                       button
 **    edthlt                   Highlight                  button
 **    edtuhl                   Unhighlight                button
 **    edtsel                   Select Set                 button
 **    edtdel                   Delete                     button
 **    edtlnk                   Link <                     button
 **    accept                   Exit                       button
 **    help                     Help...                    button
 **
 ** sql_setvalue
 **    curset                   Current Linkable Settings  boxed column
 **    text_1                                                  text
 **    text_2                                                  text
 **    text_3                                                  text
 **    text_4                                                  text
 **    lstval                   edit values                list box
 **    edtedt                   edit values                edit box
 **
 ** sql_driver
 **    drvlst                   driver - list              list box
 **    drvedt                   driver - edit              edit box
 **
 ** sql_linkable
 **    lnklst                  linkable - list             list box
 **
 **    lnkkey                  Linkable:                   edit box
 **    lnktab                  Table(s):                   edit box
 **    lnkcol                  Column(s):                  edit box
 **
 **    lnkdel                  Delete                      button
 **    lnkedt                  Edit                        button
 **    lnkadd                  Add                         button
 **    lnkset                  Set                         button
 **
 ** sql_editlink
 **    elklst                  Values                      list box
 **
 ** sql_warn
 **    wrntxt1                 Warning first line          text
 **    wrntxt2                 Warning second line         text
 **    wrnyes                  YES                         button
 **    wrn_no                  NO                          button
 **
 ***************************************************************************/

dcl_settings : default_dcl_settings { audit_level = 0; }

sql_bldqry : dialog {
    label=/*MSG268*/"Build SQL Statement";
    : row {
        : boxed_column {
            : list_box {
                label=/*MSG269*/"SELECT:";
                key="bldslb";
                multiple_select=true;
              /*  fixed_width=true;
                width=20; */
                height=5;
            }
        }
        : boxed_column {
            : list_box {
                label=/*MSG270*/"FROM:";
                key="bldflb";
                multiple_select=true;
              /*  fixed_width=true;
                width=20; */
                height=5;
            }
        }
    }
    : boxed_row {
        : column {
            : list_box {
                label=/*MSG271*/"WHERE:";
                key="bldwlb";
                fixed_width=true;
                fixed_height=true;
                alignment=top;
                width=20;
                height=5;
            }
            : button {
                label=/*MSG272*/"Undo WHERE clause";
                key="bldunw";
                fixed_width=true;
                alignment=centered;
            }
        }
        spacer_1;
        : column {
            spacer_1;
            : row {
                : button {
                    label=/*MSG273*/"And";
                    key="bldbt1";
                    mnemonic=/*MSG274*/"A";
                    width=8;
                }
                : button {
                    label=/*MSG275*/"Or";
                    key="bldbt2";
                    mnemonic=/*MSG276*/"O";
                    width=8;
                }
                : button {
                    label=/*MSG277*/"Not";
                    key="bldbt3";
                    mnemonic=/*MSG278*/"N";
                    width=8;
                }
                : button {
                    label=/*MSG279*/"Order by";
                    key="bldbt9";
                    mnemonic=/*MSG280*/"r";
                    width=11;
                }
            }
            : row {
                : button {
                    label=/*MSG281*/"Between";
                    key="bldbt4";
                    mnemonic=/*MSG282*/"B";
                    width=8;
                }
                : button {
                    label=/*MSG283*/"In";
                    key="bldbt5";
                    mnemonic=/*MSG284*/"I";
                    width=8;
                }
                : button {
                    label=/*MSG285*/"Is";
                    key="bldbt6";
                    mnemonic=/*MSG286*/"s";
                    width=8;
                }
                : button {
                    label=/*MSG287*/"Descending";
                    key="bldbt10";
                    mnemonic=/*MSG288*/"D";
                    width=11;
                }
            }
            : row {
                : button {
                    label="(";
                    key="bldbt7";
                    mnemonic="(";
                    width=8;
                }
                : button {
                    label=")";
                    key="bldbt8";
                    mnemonic=")";
                    width=8;
                }
                : button {
                    label=/*MSG289*/"Like";
                    key="bldbt11";
                    mnemonic=/*MSG290*/"L";
                    width=8;
                }
                : popup_list {
                    label="";
                    key="bldopl";
                    list="=\n>\n<\n<>\n>=\n<=";
                    edit_width=8;
                }
            }
            spacer;
            : edit_box {
                label=/*MSG291*/"Value:";
                key="bldveb";
            }
        }
    }
    spacer_1;
    : boxed_column {
        label=/*MSG292*/"SQL Statement:";
        : text {
            key="bldtxt";
        }
        : slider {
            layout = horizontal;
            key = "bldsld";
            min_value = 0;
            max_value = 256;
            small_increment = 1;
            big_increment = 10;
        }
    }
    spacer_1;
    : row {
        fixed_width=true;
        alignment=centered;
        : button {
            label=/*MSG293*/"Clear";
            key="bldclr";
            mnemonic=/*MSG294*/"C";
            width=8;
        }
        : spacer {width=2;}
        ok_cancel_help;
    }
}

sql_password : dialog {
    label = /*MSG295*/"Connecting to Database";
    initial_focus = /*MSG296*/"passnam";
    currentsettings_2;
    value = /*MSG297*/"Database Access";
    : edit_box {
        label = /*MSG298*/"Username:";
        key = "passnam";
        mnemonic = /*MSG299*/"U";
        edit_limit = 19;
    }
    : edit_box {
        label = /*MSG300*/"Password:";
        key = "passpas";
        mnemonic = /*MSG301*/"P";
        edit_limit = 19;
        allow_accept = true;
    }
    ok_cancel;
}


sql_ok_cancel_help_err : column {
    ok_cancel_help;
    : text {
        label = "";
        key = "sqlerr";
        width = 0;
        is_error_tile = true;
    }
}

l_slider : column {
    width = 50;
    is_enabled = false;
    : slider {
        key = "sldlst";
        value = "0";
        min_value = 0;
        max_value = 256;
        small_increment = 1;
        big_increment = 10;
    }
} 

currentsettings_2 : boxed_column {
    label = /*MSG302*/"Current Settings";
    key = "curset2";
    width = 50;
    : text {
        label = "";
        key = "text_1";
        value = "";
    }
    : text {
        label = "";
        key = "text_2";
        value = "";
    }
}

currentsettings_3 : boxed_column {
    label = /*MSG303*/"Current Settings";
    key = "curset3";
    width = 50;
    : text {
        label = "";
        key = "text_1";
        value = "";
    }
    : text {
        label = "";
        key = "text_2";
        value = "";
    }
    : text {
        label = "";
        key = "text_3";
        value = "";
    }
}

open_dbase : dialog {
    label = /*MSG304*/"Open Database";
    initial_focus = /*MSG305*/"odbdat";
    : boxed_column {
        label = /*MSG306*/"Current Settings";
        key = "odbsbc";
        width = 50;
        : text {
            label = "";
            key = "text_1";
            value = "";
        }
    }
    : column{
        : list_box {
            label = /*MSG307*/"Attached Databases";
            key = "odblst";
            height = 4;
            mnemonic = /*MSG308*/"D";
        }
        :edit_box {
            label = /*MSG309*/"Database:";
            key = "odbdat";
            edit_limit = 18;
            mnemonic = /*MSG310*/"b";
        }
    }
    sql_ok_cancel_help_err;
}

open_table : dialog {
    label = /*MSG311*/"Open Table";
    initial_focus = /*MSG312*/"tbltab";
    currentsettings_2;
    : column{
        : list_box {
            label = /*MSG313*/"Attached Tables";
            key = "tbllst";
            height = 4;
            mnemonic = /*MSG314*/"T";
        }
        :edit_box {
            label = /*MSG315*/"Table:";
            key = "tbltab";
            edit_limit = 18;
            mnemonic = /*MSG316*/"b";
        }
    }
    sql_ok_cancel_help_err;
}

sql_edit : dialog {
    label = /*MSG317*/"Edit SQL";
    initial_focus = /*MSG318*/"edtlst";
    currentsettings_3;
    : row {
        : column {
            : boxed_row {
                label = /*MSG319*/"Select Row Options:";
                key = "edtsro";
                width = 50;
                : button {
                    label = /*MSG488*/"SQL Statement..";
                    key = "edtsql";
                    width = 12;
                }
                spacer_1;
                : button {
                    label = /*MSG320*/"Search..";
                    key = "edtgph";
                    width = 12;
                }
//              spacer_1;
//              : button {
//                  label = /*MSG489*/"Table link keys..";
//                  key   = "edtlks";
//                  width = 12;
//              }
            }
            :text {
				key = "edttxt" ;
				value = "" ;
				label = "" ;
				width = 50 ;
				horizontal_alignment = centered ;
            }
            : slider {
				key = "edtsld" ;
				value = "0" ;
				min_value = 0 ;
                max_value = 256 ;
				width = 50 ;
				height = 1 ;
                small_increment = 1 ;
                big_increment = 10 ;
            }
            : text {
                label = "";
                key = "edtrow";
                value = "";
            }
            : list_box {
                label = "";
                key = "edtlst";
                mnemonic = /*MSG321*/"V";
                width = 50;
                height = 8;
                value = "0";
            }
            l_slider;
            spacer;
            : edit_box {
                key = "edtedt";
                label = /*MSG322*/"Edit:";
                edit_limit = 255;
                mnemonic = /*MSG323*/"E";
                horizontal_alignment = left;
            }
            ase_errtile;
        }
        : cluster {
            children_fixed_height = true;
            children_alignment = centered;
            : column {
                alignment = centered;
                horizontal_alignment = centered;
                vertical_alignment = centered;
                spacer_1;
                : button {
                    key = "edtprv";
                    label = /*MSG324*/"Previous";
                    mnemonic = /*MSG325*/"P";
                }
                : button {
                    key = "edtnxt";
                    label = /*MSG326*/"Next";
                    mnemonic = /*MSG327*/"N";
                }
                : button {
                    key = "edt1st";
                    label = /*MSG328*/"First";
                    mnemonic = /*MSG329*/"F";
                }
                : button {
                    key = "edtlast";
                    label = /*MSG330*/"Last";
                    mnemonic = /*MSG331*/"L";
                }
                : button {
                    key = "edtdel";
                    label = /*MSG332*/"Delete";
                    mnemonic = /*MSG333*/"D";
                    alignment = centered;
                }
                spacer_1;
                spacer;
                : button {
                    key = "edtlnk";
                    label = /*MSG334*/"Link <";
                    mnemonic = /*MSG335*/"L";
                    alignment = centered;
                }
                spacer_1;
                spacer;
                : button {
                    label = /*MSG336*/"Help...";
                    key = "help";
                    width = 11;
                    alignment = centered;
                    mnemonic = /*MSG337*/"H";
                }
                : button {
                    label = /*MSG338*/"Exit";
                    key = "accept";
                    width  = 11;
                    alignment = centered;
                    is_cancel = true;
                    is_default  = true;
                    mnemonic = /*MSG339*/"x";
                }
            }
        }
    }
}

sql_setvalue : dialog {
    label = /*MSG340*/"Set Search Criteria";
    initial_focus = /*MSG341*/"edtedt";
    : boxed_column {
        label = /*MSG342*/"Current Table Link Key Settings";
        key = "curset";
        width = 50;
        : text {
            label = "";
            key = "text_1";
            value = "";
        }
        : text {
            label = "";
            key = "text_2";
            value = "";
        }
        : text {
            label = "";
            key = "text_3";
            value = "";
        }
        : text {
            label = "";
            key = "text_4";
            value = "";
        }
    }
    : list_box {
        key = "lstval";
        label = /*MSG343*/"Values";
        mnemonic = /*MSG344*/"V";
        width = 50;
        height = 3;
        value = "0";
    }
    l_slider;
    : row {
        : edit_box {
            key = "edtedt";
            label = /*MSG345*/"Edit:";
            edit_limit = 255;
            mnemonic = /*MSG346*/"E";
            horizontal_alignment = left;
        }
    }
    sql_ok_cancel_help_err;
}

sql_driver : dialog {
    label = /*MSG347*/"Set DBMS Driver";
    initial_focus = /*MSG348*/"drvedt";
    : column{
        : list_box {
           label = /*MSG349*/"DBMS Drivers";
           key = "drvlst";
           height = 4 ;
           width = 30 ;
           mnemonic = /*MSG350*/"B" ;
        }
        :edit_box {
           key = "drvedt" ;
           label = /*MSG351*/"Driver:" ;
           edit_limit = 32 ;
           mnemonic = /*MSG352*/"D" ;
        }
    }
    sql_ok_cancel_help_err ;
}


sql_linkset : dialog {
    label=/*MSG353*/"Set Table Link";
    : column {
        : list_box {
            key="lnklst";
            width=40;
            height=5;
            value=0;
        }
        l_slider;
        spacer_1;
        ok_cancel_err;
    }
}


sql_linkable : dialog {
    label = /*MSG354*/"Edit Table Link";
    : column {
        : list_box {
            label  = "";
            key    = "lnklst";
            width  = 40;
            height = 5;
            value  = 0;
        }
        l_slider;
        spacer_1;
        : row {
            alignment = centered;
            fixed_width = true;
            : boxed_column {
                label = /*MSG355*/"Variables";
                key = "";
                alignment = top;
                fixed_height = true;
                : edit_box {
                    label = /*MSG356*/"        Driver: ";
                    key ="lnkdrv";
                    edit_width = 23;
                    edit_limit=23;
                }
                : edit_box {
                    label = /*MSG357*/"      Database: ";
                    key ="lnkdat";
                    edit_width = 23;
                    edit_limit=23;
                }
                : edit_box {
                    label = /*MSG358*/"Table link key: ";
                    key ="lnkkey";
                    edit_width = 12;
                    edit_limit = 12;
                    fixed_width = true;
                }
                : edit_box {
                    label = /*MSG359*/"      Table(s): ";
                    key ="lnktab";
                    edit_width = 23;
                    edit_limit = 120;
                    fixed_width = true;
                }
                : edit_box {
                    label = /*MSG360*/"     Column(s): ";
                    key ="lnkcol";
                    edit_width = 23;
                    edit_limit = 120;
                    fixed_width = true;
                }
            }
            spacer_1;
            : column {
                fixed_width = true;
                : button {
                    label = /*MSG361*/"Delete";
                    key = "lnkdel";
                    mnemonic = /*MSG362*/"D";
                    width = 8;
                }
                : button {
                    label = /*MSG363*/"Edit";
                    key = "lnkedt";
                    mnemonic = /*MSG364*/"E";
                    width = 8;
                }
                : button {
                    label = /*MSG365*/"Add";
                    key = "lnkadd";
                    mnemonic = /*MSG366*/"A";
                    width = 8;
                }
                : button {
                    label = /*MSG367*/"Set";
                    key = "lnkset";
                    mnemonic = /*MSG368*/"S";
                    width = 8;
                }
            }
        }
        ok_cancel_err;
    }
}

sql_editlink : dialog {
    label = /*MSG369*/"Edit Link" ;
    initial_focus = /*MSG370*/"elklst" ;
    link_path ;
    spacer_1;
    : column {
        width = 0;  /* 50 ; */
        : list_box {
            label = /*MSG371*/"Values" ;
            key = "elklst" ;
            mnemonic = /*MSG372*/"V" ;
            height = 3 ;
            value = "0" ;
        }
    }
    l_slider;
    spacer_1;
    : row {
        alignment = centered;
        fixed_width = true;
        ok_button ;
        : spacer { width = 2; }
        cancel_button;
        : spacer { width = 2; }
        help_button;
    }
}

sql_warn : dialog {
    label = /*MSG373*/"ADE Message";
    fixed_width=true;
    width=50;
    spacer;
    : column {
        : text {
            label = "";
            key = "wrntxt1";
        }
        : text {
            label = "";
            key = "wrntxt2";
        }
        spacer_1;
        : row {
            alignment = centered;
            fixed_width = true;
            : retirement_button {
                label = /*MSG374*/"YES";
                key = "wrnyes";
                mnemonic = /*MSG375*/"Y";
                width = 4;
                fixed_width = true;
                is_default = true;
            }
            : spacer { width = 2; }
            : retirement_button {
                label = /*MSG376*/"NO";
                key = "wrn_no";
                mnemonic = /*MSG377*/"N";
                width = 4;
                fixed_width = true;
                is_cancel = true;
            }
        }
        spacer_1;
    }
}

/***************************************************************************
 ***************************************************************************
 ************************  Code for "SQL" Dialog  **************************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TYPE >
 **
 ** gis_sql
 **    gsqlhst                  History                    list box
 **    gsqlebx                  Enter SQL Statement        edit box
 **
 ***************************************************************************/

gis_sql : dialog {
    label = /*MSG378*/"SQL Criteria";
    initial_focus = /*MSG379*/"gsqlebx";
    spacer;
    : boxed_column {
        label = /*MSG380*/"History";
        : list_box {
            label = "";
            key = "gsqlhst";
            width = 31;
            height = 5;
        }
        l_slider;
        : button {
            label = /*MSG381*/"Clear History";
            key = "gsqlclh";
            fixed_width=true;
            alignment=centered;
        }
    }
    spacer_1;
    : boxed_row {
        label = /*MSG382*/"Enter SQL Statement";
        : edit_box {
            label = /*MSG383*/"SQL:";
            key = "gsqlebx";
            edit_width = 40;
        }
    }
    spacer_1;
    : row {
        fixed_width=true;
        alignment=centered;
        build_button;
        : spacer {width=2;}
        ok_cancel_help;
    }
}

/***************************************************************************
 ***************************************************************************
 *******************  Code for "About ADE" Dialog  ********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TYPE >
 **
 ** sgis_about
 **    abtttl                   dialogue box title         title
 **    iclogo                   Landmark logo              image
 **    iclogo2                  IntelliCADD                image
 **    version                  Release:                   text
 **    serial                   Serial Number:             text
 **    owner                    Licensed to:               text
 **    abtlbx                   message list box           list box
 **
 ***************************************************************************/

sgis_about : dialog {
    label = /*MSG384*/"About ADE";
    key = "abtttl";
    : row {
        : spacer {width=12;}
        : paragraph {
            alignment = left;
            fixed_height = true;
            : text {
                key = "COPYRIGHT";
                width=40;
            }
            : text {
                key = "abtxt1";
                width=40;
            }
            spacer_1;
            : concatenation {
                : text_part {
                    label = /*MSG385*/"Version ";
                }
                : text_part {
                    label = "";
                    key = "version";
                    width = 50;
                }
            }
            : concatenation {
                : text_part {
                    label = /*MSG386*/"Serial Number:  ";
                }
                : text_part {
                    label = "";
                    key = "serial";
                    width = 40;
                }
            }
            : concatenation {
                : text_part {
                    label = /*MSG387*/"Licensed to:    ";
                }
                : text_part {
                    label = "";
                    key = "owner";
                    width = 40;
                }
            }
        }
    }
    : list_box {
        label = "";
        key = "abtlbx";
        width = 0;
        height = 10;
    }
    spacer_1;
    ok_button;
}

getcartsys : dialog {
    label = /*MSG388*/"Coordinate System Selection";
    : list_box { key="lbox"; height=15; width=70; }
    : edit_box {
        key="codeebox";
        label=/*MSG390*/"Coordinate System Code:";
        mnemonic=/*MSG391*/"C";
        is_tab_stop=true;
        fixed_width=true;
        alignment=left;
        edit_width=8;
        edit_limit=8;
        allow_accept=true;
    }
    ok_cancel_help;
}

/***************************************************************************
 ***************************************************************************
 ********************  Code for "Open Drawings" Dialog  ********************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TYPE >
 ** gis_opendwg
 **    opendir                  Directories                list box
 **    openfil                  Files                      list box
 **    opentyp                  Type it                    button
 **    opencle                  Clear all                  button
 **    opensel                  Select all                 button
 **
 ** gis_files_topdf
 **    filepat                  File pattern search        edit box
 **    fileedt                  Directory name             text
 **
 ** gis_files_bottomdf
 **    filefil                  File open                  edit box
 **
 ***************************************************************************/

gis_opendwg : dialog {
    label = /*MSG392*/"Open Drawings";
    key = "openman";
    initial_focus = /*MSG393*/"filefil";
    : column {
        : edit_box {
            label = /*MSG394*/"Pattern:";
            key = "filepat";
            mnemonic = /*MSG395*/"P";
            edit_width = 35;
        }
        : row {
            : text {
               label = /*MSG396*/"Directory: ";
            }
            : text {
               label = "";
               key   = "fileedt";
               width = 35;
            }
        }
        : row {
            : list_box {
                label = /*MSG397*/"Directories:";
                key = "opendir";
                mnemonic = /*MSG398*/"D";
                width = 15;
            }
            : list_box {
                label = /*MSG399*/"Files:";
                key = "openfil";
                mnemonic = /*MSG400*/"F";
                width = 15;
                multiple_select = true;
            }
            : column {
                alignment = bottom;
                fixed_height = true;
                : button {
                    label = /*MSG401*/"Type it";
                    key = "opentyp";
                    mnemonic = /*MSG402*/"T";
                }
                spacer_1;
                : button {
                    label = /*MSG403*/"Clear All";
                    key = "opencle";
                    mnemonic = /*MSG404*/"C";
                }
                spacer_1;
                : button {
                    label = /*MSG405*/"Select All";
                    key = "opensel";
                    mnemonic = /*MSG406*/"S";
                }
            }
        }
        spacer_1;
        : edit_box {
            label = /*MSG407*/"File:";
            key = "filefil";
        }
        ok_cancel_help;
        errtile;
    }
}

gis_opendwg_win : dialog {        /************ For Windows **************/
    label = /*MSG408*/"Open Drawings";
    key = "openman";
    initial_focus = /*MSG409*/"filefil";
    : row {
        : column {
            children_fixed_width=true;
            fixed_height=true;
            alignment=top;
            : text {
               label = /*MSG410*/"File Names:";
            }
            : edit_box {
                label = "";
                key = "filefil";
                edit_width = 19;
            }
            : list_box {
                label = "";
                key = "openfil";
                mnemonic = /*MSG411*/"F";
                multiple_select = true;
                fixed_height=true;
                width = 20;
                height = 6;
            }
            spacer_1;
            : text {
               label = /*MSG412*/"List Files of Type:";
            }
            : edit_box {
                label = "";
                key = "filepat";
                mnemonic = /*MSG413*/"P";
                edit_width = 19;
            }
        }
        spacer_1;
        : column {
            fixed_height = true;
            alignment = top;
            : text {
               label = /*MSG414*/"Directory: ";
            }
            spacer;
            : text {
               label = "";
               key   = "fileedt";
               width = 20;
            }
            spacer;
            : list_box {
                label = "";
                key = "opendir";
                mnemonic = /*MSG415*/"D";
                fixed_width=true;
                fixed_height=true;
                width = 20;
                height = 10;
            }
        }
        spacer_1;
        : column {
            fixed_height = true;
            alignment = top;
            spacer;
            : button {
                label = /*MSG416*/"OK";
                key = "accept";
                is_default=true;
            }
            : button {
                label = /*MSG417*/"Cancel";
                key = "cancel";
                is_cancel=true;
            }
            : button {
                label = /*MSG418*/"Help...";
                key = "help";
            }
            : spacer {height = 2;}
            spacer;
            : button {
                label = /*MSG419*/"Type it";
                key = "opentyp";
                mnemonic = /*MSG420*/"T";
            }
            : button {
                label = /*MSG421*/"Clear All";
                key = "opencle";
                mnemonic = /*MSG422*/"C";
            }
            : button {
                label = /*MSG423*/"Select All";
                key = "opensel";
                mnemonic = /*MSG424*/"S";
            }
        }
    }
    errtile;
}

/***************************************************************************
 ***************************************************************************
 *********************  Code for "Dialog Tour" Dialog  *********************
 ***************************************************************************
 ***************************************************************************/

dlgtour : dialog {
    label = /*MSG425*/"Dialogue Tour";
    spacer_1;
    : column {
        : text {
            label = /*MSG426*/"    This command will give you a tour though ADE's";
        }
        : text {
            label = /*MSG427*/"Dialogue Boxes.  The Dialogue Boxes you will see will not";
        }
        : text {
            label = /*MSG428*/"do anything, they are only for looking at.  Note that all";
        }
        : text {
            label = /*MSG429*/"commands in Dialogue boxes can be executed from the screen";
        }
        : text {
            label = /*MSG430*/"menu as well as from AutoLISP and ADE Query files.";
        }
    }
    spacer_1;
    ok_cancel;
}

/***************************************************************************
 ***************************************************************************
 ************************  Code for "User" Dialog  *************************
 ***************************************************************************
 ***************************************************************************
 **
 **     < KEY >                   < DESCRIPTION >           < TYPE >
 **
 ** edit_user
 **    usrbc1                                                boxed column
 **    usrlb1                      user names                list box
 **    usrdel                      Delete                    button
 **    usredt                      Edit                      button
 **    usradd                      Add                       button
 **
 **    usrnam                      User name:                edit box
 **    usrpas                      Password:                 edit box
 **
 **    usrdwq                      Draw query                radio button
 **    usrsav                      Save drawing              radio button
 **    usrspr                      Super user                radio button
 **
 ** user_login
 **    lognam                      User name:                edit box
 **    logpas                      Password:                 edit box
 **
 ** save_dwgs
 **    svdare                      Area                      radio button
 **    svdlay                      Layer                     radio button
 **    svdcam                      Came from                 radio button
 **    svdsel                      Selective                 radio button
 **
 **    svddgn                      Drawing name:             edit box
 **    svdlis                      List...                   button
 **
 ***************************************************************************/

edit_user : dialog {
    label = /*MSG431*/"Edit Users";
    : column {
        : boxed_column {
            label = "";
            key = "usrbc1";
            : list_box {
                label = "";
                key = "usrlb1";
                width = 41;
                height = 5;
            }
            spacer;
            : row {
                alignment = centered;
                fixed_width = true;
                fixed_height = true;
                : button {
                    label = /*MSG432*/"Delete";
                    key = "usrdel";
                    mnemonic = /*MSG433*/"D";
                }
                : spacer { width = 2; }
                : button {
                    label = /*MSG434*/" Edit ";
                    key = "usredt";
                    mnemonic = /*MSG435*/"E";
                }
                : spacer { width = 2; }
                : button {
                    label = /*MSG436*/" Add  ";
                    key = "usradd";
                    mnemonic = /*MSG437*/"A";
                }
            }
        }
        spacer_1;
        : edit_box {
            label = /*MSG438*/"User name:";
            key = "usrnam";
            edit_width = 31;
            edit_limit = 31;
        }
        : edit_box {
            label = /*MSG439*/" Password:";
            key = "usrpas";
            edit_width = 31;
            edit_limit = 31;
        }
        spacer_1;
        : row {
          : spacer { width = 3; }
          : column {
              : toggle {
                  label = /*MSG440*/"Draw query";
                  key = "usrdwq";
              }
              : toggle {
                  label = /*MSG441*/"Extract query";
                  key = "usrext";
              }
              : toggle {
                  label = /*MSG442*/"File query";
                  key = "usrfil";
              }
              : toggle {
                  label = /*MSG443*/"Save drawing";
                  key = "usrsav";
              }
              : toggle {
                  label = /*MSG444*/"Superuser";
                  key = "usrspr";
              }
          }
        }
        spacer_1;
        ok_cancel_help;
    }
}

user_login : dialog {
    label = /*MSG445*/"User Login";
    : column {
        spacer_1;
        : edit_box {
            label = /*MSG446*/"User name:";
            key = "lognam";
            edit_width = 30;
        }
        : edit_box {
            label = /*MSG447*/" Password:";
            key = "logpas";
            edit_width = 30;
        }
    }
    spacer_1;
    ok_cancel_help;
}

save_dwgs : dialog {
    label = /*MSG448*/"Save Drawings";
    spacer_1;
    : column {
        : row {
            alignment = centered;
            fixed_width = true;
            : boxed_radio_column {
                label = /*MSG449*/"Save by:";
                : radio_button {
                    label = /*MSG450*/"Area";
                    key = "svdare";
                    mnemonic = /*MSG451*/"A";
                    value = 1;
                }
                : radio_button {
                    label = /*MSG452*/"Layer";
                    key = "svdlay";
                    mnemonic = /*MSG453*/"L";
                }
                : radio_button {
                    label = /*MSG454*/"Came from ";
                    key = "svdcam";
                    mnemonic = /*MSG455*/"C";
                }
                : radio_button {
                    label = /*MSG456*/"Selective ";
                    key = "svdsel";
                    mnemonic = /*MSG457*/"S";
                }
            }
        }
        spacer_1;
        : boxed_column {
            label = /*MSG458*/"Drawings to save into:";
            fixed_height = true;
            : edit_box {
                label = /*MSG459*/"Drawing name:";
                key = "svddgn";
                edit_width = 23;
                value = "*";
            }
            spacer;
            : button {
                label = /*MSG460*/"List...";
                key = "svdlis";
                alignment = centered;
                fixed_width = true;
                width = 8;
            }
        }
        spacer_1;
        ok_cancel_help;
    }
}


feawarn : dialog {
    label = /*MSG461*/"ADE Alert";
    fixed_width=true;
    width=50;
    spacer;
    : column {
        : text {
            label = /*MSG462*/"WARNING: Extracting drawings with feature(s) set.";
        }
        : text {
            label = /*MSG463*/"This may modify data when saving back into drawings.";
        }
        spacer_1;
        : row {
            : retirement_button {
                label = /*MSG464*/"OK";
                key = "accept";
                width = 15;
                fixed_width = true;
                is_default = true;
            }
            : spacer { width = 2; }
            : retirement_button {
                label = /*MSG465*/"Cancel";
                key = "cancel";
                width = 15;
                fixed_width = true;
                is_cancel = true;
            }
            : spacer { width = 2; }
            : retirement_button {
                label = /*MSG466*/"Clear Features";
                key = "clrfea";
                mnemonic = /*MSG467*/"F";
                width = 15;
                fixed_width = true;
                is_cancel = true;
            }
        }
        spacer_1;
    }
}


lmarkalert : dialog {
    label = /*MSG468*/"ADE Alert";
    : column {
        alignment = centered;
        width=61;
        : text {
            key = "alert_text_1";
        }
        : text {
            key = "alert_text_2";
        }
    }
    ok_only;
}

extract_warn : dialog {
    label = /*MSG469*/"ADE Alert";
    fixed_width=true;
    width=64;
    spacer;
    : column {
        : text {
            label = "";
            key = "wrntxt1";
        }
        : text {
            label = "";
            key = "wrntxt2";
        }
        spacer_1;
        : row {
            alignment = centered;
            fixed_width = true;
            : retirement_button {
                label = /*MSG470*/"Continue";
                key = "accept";
                mnemonic = /*MSG471*/"t";
                is_default = true;
            }
            : spacer { width = 2; }
            : retirement_button {
                label = /*MSG472*/"Cancel";
                key = "cancel";
                mnemonic = /*MSG473*/"C";
                width = 8;
                fixed_width = true;
                is_default = true;
            }
        }
    }
}

handle_warn : dialog {
    label = /*MSG474*/"ADE Alert";
    fixed_width=true;
    width=53;
    spacer;
    : column {
	alignment = centered;
	: text {
	    label = /*MSG475/"ADE is extracting an entity with EED (Extended Entity Data) handles.";
	}
	: text {
	    label = /*MSG476*/"ADE cannot bring EED handles into the current drawing.";
	}
	: text {
	    label = /*MSG486*/"If you continue this operation (Extract All data) and then save back,";
	}
	: text {
	    label = /*MSG487*/"your drawing will be updated; however, you will lose the EED handles.";
	}
	: text {
	    label = /*MSG477*/"This EED data may be required by some 3rd party applications.";
	}
	: text {
	    label = /*MSG478*/"Please see the read-me documentation for further details.";
	}
	: text {
	    label = "";
	}
	: text {
	    label = /*MSG479*/"For this query, you can:";
	}
	spacer_1;
	: retirement_button {
	    label = /*MSG480*/"Stop extract now";
	    key = "cancel";
	    mnemonic = /*MSG481*/"S";
	    width = 45;
	    fixed_width = true;
	    is_default = true;
	}
	: retirement_button {
	    label = /*MSG484*/"Continue extract, Limited to entities without EED handles";
	    key = "accept";
	    mnemonic = /*MSG485*/"L";
	    width = 45;
	    fixed_width = true;
	}
	: retirement_button {
	    label = /*MSG482*/"Continue extract All data, and LOSE EED handles";
	    key = "continue";
	    mnemonic = /*MSG483*/"A";
	    width = 45;
	    fixed_width = true;
	}
    }
}
