@echo off
rem *** NOTE ***
rem PARAMETERS TO THIS BATCH FILES HAVE CHANGED SINCE 2.0a
rem
rem autrecov is a front end batch file used to clear
rem Defect Control System database sessions after a workstation
rem or file server has crashed.  This batch file should ONLY be
rem invoked automatically when the need for session
rem recovery has been detected.
rem

rem
rem Make sure arguments have been entered
rem
rem 1 - fully qualified bin path
rem 2 - fully qualified database path
rem 3 - project number
rem 4 - user id, including project/tool prefix
rem     Examples: i1Admin if MoreProjects=0
rem               00Admin if MoreProjects=1
rem 5 - lock manager character id
rem     g for General Lock Manager
rem     s for Novell SPX Lock Manager
rem     b for NetBIOS Lock Manager
rem 6 - lock manager name (default=lockmgr)
rem

if "%1" == "" goto missingargs
if "%2" == "" goto missingargs
if "%3" == "" goto missingargs
if "%4" == "" goto missingargs
if "%5" == "" goto missingargs
if "%6" == "" goto missingargs

rem
rem make sure we are in the project directory
rem

if not exist %2\p%3\dcdb.dbd goto badproject
if not exist %2\p%3\pname.txt goto badproject

rem
rem clear the user
rem

:doclearuser
set DBTAF=%2\p%3\taf\
set DBLOG=%2\p%3\taf\
%1\lmclear -u %4 -a %6 -m%5
set DBTAF=
set DBLOG=
goto cleardone

:cleardone
rem echo.
rem echo Recovery Operation Complete
rem echo.
pause

goto end

:missingargs
echo.
echo You are missing required arguments for the AUTRECOV command
goto usage

:usage
echo.
echo AUTRECOV should only be executed automatically by a Tracker
echo application.  Tracker applications programmatically launch
echo AUTRECOV whenever an application detects the need for
echo session recovery.
echo.
pause
goto end

:end
echo AUTRECOV is exiting now ...
echo.
