@echo off
rem
rem dcsswitch.bat
rem
rem Usage: DCSSWTCH [installation]
rem
rem Where installation is one of:
rem
rem dcsfin, dcsman, dcsrd, dcsper, dcsmktg 
rem
rem This batch file maintains several dcs.ini files to enable
rem switching between DCS installations.
rem
rem This batch file assumes 5 separate DCS installations.  Each
rem installation maintains an installation .ini file.  A "dummy"
rem ".dmy" file indicates the active installation.
rem
rem Installation	Installation	Installation
rem		.ini file	 dummy file
rem -----------------------------------------------
rem 
rem Finance	dcsfin.ini	dcsfin.dmy
rem Manufacturing	dcsman.ini	dcsman.dmy
rem R & D	dcsrd.ini	dcsrd.dmy
rem Personnel	dcsper.ini	dcsper.dmy
rem Marketing	dcsmktg.ini	dcsmktg.dmy
rem 
rem This batch file switches between DCS installations by copying
rem the current dcs.ini file to the current active installation.
rem
rem A new installation is made active, by copying its installation
rem .ini file to dcs.ini.  The active installation is remembered by
rem creating a dummy file.

rem
rem Make sure they entered a parameter
rem

if "%1" == "" goto badparam

rem
rem Validate parameter
rem

if not "%1" == "dcsfin" goto try2
goto valid

:try2
if not "%1" == "dcsman" goto try3
goto valid

:try3
if not "%1" == "dcsrd" goto try4
goto valid

:try4
if not "%1" == "dcsper" goto try5
goto valid

:try5
if not "%1" == "dcsmktg" goto badparam
goto valid

rem
rem Verify working directory is the windows directory
rem

:valid
if not exist win.ini goto baddir

rem
rem Determine which DCS last ran and copy/rename corresponding files
rem

if not exist dcsfin.dmy goto check2
echo Renaming dcsfin.dmy to %1.dmy.
ren dcsfin.dmy dcstemp.dmy
ren dcstemp.dmy %1.dmy
if exist dcs.ini echo Copying dcs.ini to dcsfin.ini.
if exist dcs.ini copy dcs.ini dcsfin.ini
goto run

:check2
if not exist dcsman.dmy goto check3
echo Renaming dcsman.dmy to %1.dmy.
ren dcsman.dmy dcstemp.dmy
ren dcstemp.dmy %1.dmy
if exist dcs.ini echo Copying dcs.ini to dcsman.ini.
if exist dcs.ini copy dcs.ini dcsman.ini
goto run

:check3
if not exist dcsrd.dmy got check4
echo Renaming dcsrd.dmy to %1.dmy.
ren dcsrd.dmy dcstemp.dmy
ren dcstemp.dmy %1.dmy
if exist dcs.ini echo Copying dcs.ini to dcsrd.ini.
if exist dcs.ini copy dcs.ini dcsrd.ini
goto run

:check4
if not exist dcsper.dmy goto check5
echo Renaming dcsper.dmy to %1.dmy.
ren dcsper.dmy dcstemp.dmy
ren dcstemp.dmy %1.dmy
if exist dcs.ini echo Copying dcs.ini to dcsper.ini.
if exist dcs.ini copy dcs.ini dcsper.ini
goto run

:check5
if not exist dcsmktg.dmy goto dmy
echo Renaming dcsmktg.dmy to %1.dmy.
ren dcsmktg.dmy dcstemp.dmy
ren dcstemp.dmy %1.dmy
if exist dcs.ini echo Copying dcs.ini to dcsmktg.ini.
if exist dcs.ini copy dcs.ini dcsmktg.ini
goto run

rem
rem	No .dmy file was found so we will create one.
rem

:dmy
echo Creating new .dmy file for %1.
echo This is the dummy file for DCSSWTCH.BAT. > %1.dmy

rem
rem Make the new installation active. 
rem

rem
rem Verify .ini file for the specified DCS exists and copy
rem

:run
if not exist %1.ini goto noini
echo Copying %.ini to dcs.ini.
copy %1.ini dcs.ini

goto end

:badparam
echo.
echo ERROR: YOU ARE NOT USING DCSWITCH PROPERLY.
echo.
echo This batch file switches between DCS installations by copying
echo the current dcs.ini file to the current active installation.
echo.
echo A new installation must be specified as the first and only 
echo parameter.
echo.
echo DCSSWTCH is exiting now...
echo.
goto end

:baddir
echo.
echo Your windows directory should be specified as the working 
echo directory.  The working directory you specified is not correct.
echo.
echo Correct the problem and rerun DCSSWTCH.
echo.
echo DCSSWTCH is exiting now...
echo.
goto end

:noini
echo.
echo The selected Defect Control System installation has no ..INI.
echo.
echo Create the required .ini file and rerun DCSSWTCH.
echo.
goto end

:end
pause
