@echo off
rem  Check to ensure that EMC is not being run from the application menu
@IF NOT EXIST T:*.USE GOTO MSG
@IF %G%==GENERICS GOTO RUNPROG
@IF %G%==STUDENTS GOTO RUNPROG
@IF %G%==OFFICE GOTO MSG
@IF EXIST T:*.USE GOTO RUNPROG
:MSG
@echo You have either run EMC in a class that has no students or you have 
@echo tried to run it from an application menu.   EMC only works in classes
@echo that have students and must be run from an ICLAS student menu.
@pause
H:
%V%G
@GOTO exit

:RUNPROG
SET MC1200NET=TRUE
SET prog=EXPLORING MATH CONCEPTS LEVEL 1
rem talkram should run before netsnd to prevent memory fragmentation
talkram<clsyes
NETAUD /s=4dapi /c=emcl1.cfg

IF NOT %G%==TEACHERS GOTO run

IF EXIST H:CLSCLASS.LOG GOTO iclasfix
GOTO continue 

:iclasfix
rem This is to correct for an ICLAS bug in earlier versions
patch1_3 h:clsclass.log

:continue
rem mc1clsdt should be the last to execute before status checking begins
mc1clsdt
rem @echo back from mc1clsdt
if ERRORLEVEL == 6 goto exit3
if ERRORLEVEL == 5 goto exit2
if ERRORLEVEL == 4 goto exit1
if ERRORLEVEL == 3 goto clssplstV
if ERRORLEVEL == 2 goto clssplstV
if ERRORLEVEL == 1 goto clssplstS
if ERRORLEVEL == 0 goto mc1splst 

goto exit4

:mc1splst
rem echo. Executing mc1splst V option 
mc1splst /V=T:cls*.use >H:MC1CLSIN.NET
goto run

:clssplstS
rem echo. Executing clssplst /S 
clssplst /S=T:cls*.use >H:MC1CLSIN.NET
goto run

:clssplstV
rem echo. Executing clssplst /V 
clssplst /V=T:cls*.use >H:MC1CLSIN.NET
goto run

:exit1
@echo This batch file should only be run by ICLASS
goto exit

:exit2
@echo The CLSSPLST program is missing in the public directory
goto exit

:exit3
@echo ICLASS Version File is missing
goto exit

:exit4
@echo Unknown error returned by MC1CLSDT
goto exit

rem /** returns:                     **/
rem /**  0  - iclass version is 1.40 & clssplst date < mc1splst date **/
rem /**       execute mc1splst /V=               **/
rem /**  1  - iclass version is < 1.40             **/
rem /**       execute clssplst /S=               **/
rem /**  2  - iclass version is > 1.40  or is 1.40 & clssplst date > **/
rem /**       mc1splst date                  **/
rem /**       execute clssplst /V=               **/
rem /**  3  - iclass version is 1.40 & mc1splst isn't in the         **/
rem /**       product dir execute clssplst /V=            **/
rem /**  4  - not on net  or not student or teacher          **/
rem /**  5  - clssplst isn't in \public                              **/
rem /**  6  - iclass version file is missing          **/
rem /**                          **/

:run

logo \courses\mc1 l1 1 %1>nul

:loop

IF NOT %G%==TEACHERS GOTO exit
IF NOT %MC1200NET%==TRUE GOTO exit

rem   ERRORLEVEL==4 is set from within L1.EXE if it terminates normally.
rem   It is done using an 'exit(4)'  command or a 'return(4)' command from
rem   the main() function.
IF NOT ERRORLEVEL==4 GOTO exit

net \courses\mc1 l1

GOTO loop

:exit

SET MC1200NET=
SET PROG=
rem MAP A:=H:>NUL<CLSYES

IF NOT EXIST H:MC1CLSIN.NET GOTO outahere
del h:mc1clsin.net>nul

:outahere
NETAUD /s=4dapi /c=emcl1.cfg /R
