/****************************************************************************/
/* SAMPLE.c    : Sample program demonstrating the usage of OMS DLL          */   
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and distribute   */
/* the Sample (and/or any modified version) in any way                      */
/* you find useful, provided that you agree that Raindrop has no warranty,  */
/* obligation or liability for this.                                        */
/*                                                                          */
/****************************************************************************/

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <shellapi.h>
#include <commdlg.h>	

#include "sample.h"		    /* specific to this program		     */
#include "..\oms.h"   
#include "mail.h"   

extern char _szExtSection[]    ; 
extern char _szIniFile[]       ; // INI file name
extern char _szMailDLLSection[]; // Mail DLL section in INI file    
extern char _szMailDllEntry[]  ; // Mail DLL entry in INI file
extern char _szMAPIDLL[]       ; // Names of the supported DLL
extern char _szVIMDLL[]        ; //
extern char _szMHSDLL[]        ; //
extern char _szMailDeliveryAgentSection[];
extern char _szMHSSection[]    ; // MHS Section

char   _szMTA[]            = "MTA";  
char   _szCustomType[]     = "IPC.Avi.Type1";

long FAR PASCAL MainWndProc (HWND hWnd,UINT message,WORD wParam,LONG lParam);
int FAR PASCAL MailDlg (HWND hParent);
BOOL FAR PASCAL MailDlgProc (HWND hDlg,UINT msg,WORD wParam,LONG lParam);
void FAR PASCAL EnumMailInList (HWND hList);
LPSTR NEAR PASCAL GetMailIDFromList (HWND hList,LPSTR lpBuf);

HINSTANCE  hInst;			    /* current instance			     */
HWND       hMainWnd;
M_SESSION  Session;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;				     

    if (!hPrevInstance)			    /* Other instances of app running? */
 	 if (!InitApplication(hInstance))   /* Initialize shared things */
	    return (FALSE);		            /* Exits if unable to initialize     */

    /* Perform initializations that apply to a specific instance */

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    /* Acquire and dispatch messages until a WM_QUIT message is received. */

    while (GetMessage(&msg,	   /* message structure			            */
	                    NULL,	   /* handle of window receiving the message*/
	                    NULL,	   /* lowest message to examine		        */
	                    NULL))	   /* highest message to examine	        */
	 {
	     TranslateMessage(&msg);	   /* Translates virtual key codes	     */
	     DispatchMessage(&msg);	   /* Dispatches message to window	     */
    }

   return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication (HINSTANCE hInstance)
{
    WNDCLASS  wc;

    /* Fill in window class structure with parameters that describe the       */
    /* main window.                                                           */

    wc.style = NULL;                    /* Class style(s).                    */
    wc.lpfnWndProc = MainWndProc;       /* Function to retrieve messages for  */
                                        /* windows of this class.             */
    wc.cbClsExtra = 0;                  /* No per-class extra data.           */
    wc.cbWndExtra = 0;                  /* No per-window extra data.          */
    wc.hInstance = hInstance;           /* Application that owns the class.   */
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "GenericMenu";   /* Name of menu resource in .RC file. */
    wc.lpszClassName = "GenericWClass"; /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */

    return (RegisterClass(&wc));

}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

        This function is called at initialization time for every instance of 
        this application.  This function performs initialization tasks that 
        cannot be shared by multiple instances.  

        In this case, we save the instance handle in a static variable and 
        create and display the main program window.  
        
****************************************************************************/

BOOL InitInstance (HINSTANCE hInstance, int nCmdShow)
{
    HWND            hWnd;               /* Main window handle.                */

    /* Save the instance handle in static variable, which will be used in  */
    /* many subsequence calls from this application to Windows.            */

    hInst = hInstance;

    /* Create a main window for this application instance.  */

    hWnd = CreateWindow(
               "GenericWClass",                /* See RegisterClass() call.          */
               "Mail Aware App Sample",        /* Text for window title bar.         */
               WS_OVERLAPPEDWINDOW,            /* Window style.                      */
               CW_USEDEFAULT,                  /* Default horizontal position.       */
               CW_USEDEFAULT,                  /* Default vertical position.         */
               CW_USEDEFAULT,                  /* Default width.                     */
               CW_USEDEFAULT,                  /* Default height.                    */
               NULL,                           /* Overlapped windows have no parent. */
               NULL,                           /* Use the window class menu.         */
               hInstance,                      /* This instance owns this window.    */
               NULL                            /* Pointer not needed.                */
           );

    /* If window could not be created, return "failure" */

    if (!hWnd)
        return (FALSE);

    hMainWnd = hWnd;

    /* Make the window visible; update its client area; and return "success" */

    ShowWindow(hWnd, nCmdShow);  /* Show the window                        */
    UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
    return (TRUE);               /* Returns the value from PostQuitMessage */

}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

****************************************************************************/

long FAR PASCAL MainWndProc (HWND hWnd,UINT message,WORD wParam,LONG lParam)
{
   FARPROC lpProcAbout;		  /* pointer to the "About" function */
   int iErr;  

   switch (message) 
   {

   case WM_CREATE:
   {
       char   szBuf[80];
       int iRetVal;
       WORD wMailSystem;

       GetPrivateProfileString(_szMailDLLSection,_szMailDllEntry,"",szBuf,sizeof(szBuf),_szIniFile);

       if (lstrcmpi(szBuf,_szMAPIDLL) == 0)
       {
           wMailSystem = MAIL_SYS_MAPI;
       }
       else
       if (lstrcmpi(szBuf,_szVIMDLL) == 0)
       {
           wMailSystem = MAIL_SYS_VIM;
       }
       else
       if (lstrcmpi(szBuf,_szMHSDLL) == 0)
       {
           GetPrivateProfileString(_szMHSSection,_szMailDeliveryAgentSection,"",szBuf,sizeof(szBuf),_szIniFile);

           if (lstrcmpi(szBuf,_szMTA) == 0)
               wMailSystem = MAIL_SYS_MHS;
           else
               wMailSystem = MAIL_SYS_MHS_LOCAL;
       }

       iRetVal = InitOMS(wMailSystem);

       if (iRetVal != VM_SUCCESS)
       {
           char    szBuf[256];

           wsprintf(szBuf,"Mail could not be initialised. Error [%d].",(int)iRetVal);
           MessageBox(NULL,szBuf,"Error",MB_OK);
       }
       else
           PostMessage(hWnd,WM_COMMAND,IDM_LOGIN,0L);
   }
   break;

	case WM_INITMENUPOPUP:
   {
       if (LOWORD(lParam) == 2)
       {
           int     iMailType = GetMailType();
           CheckMenuItem(wParam,((iMailType == MAIL_SYS_MAPI) ? IDM_MAPI : (iMailType == MAIL_SYS_VIM) ? IDM_VIM : IDM_MHS),
                   MF_CHECKED|MF_BYCOMMAND);
       }
   }
   break;

	case WM_COMMAND:	   /* message: command from application menu */
	    if (wParam == IDM_ABOUT) 
       {
		    lpProcAbout = MakeProcInstance(About, hInst);

		    DialogBox(hInst,		 /* current instance	     */
		        "AboutBox",			 /* resource to use	     */
		        hWnd,			 /* parent handle	     */
		        lpProcAbout);		 /* About() instance address */

		    FreeProcInstance(lpProcAbout);

		    break;
	    }
	    else 
       if (wParam == IDM_LOGIN)
       {
           if ((iErr = OpenMailSession(NULL,NULL,NULL,&Session,TRUE,TRUE,TRUE)) != VM_SUCCESS)
           {
               char    szBuf[256];
           
               wsprintf(szBuf,"OpenMailSession Error [%d].",(int)iErr);
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
		    break;
       }
       else
       if (wParam == IDM_LOGOUT)
       {
           if ((iErr = CloseMailSession(Session)) != VM_SUCCESS)
           {
               char    szBuf[256];
           
               wsprintf(szBuf,"CloseMailSession Error [%d].",(int)iErr);
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
           else
               Session = NULL;

		    break;
       }
       else
       if (wParam == IDM_SENDDOC)
       {
           if ((iErr = SendDocuments(Session,"c:\\temp.doc;c:\\temp.txt")) != VM_SUCCESS)
           {
               char    szBuf[256];
           
               wsprintf(szBuf,"SendDocuments Error [%d].",(int)iErr);
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }

		    break;
       }
       else
       if (wParam == IDM_SENDMSG)
       {
           MAILMSG MailMsg;

           _fmemset(&MailMsg,0x00,sizeof(MAILMSG));

           if ((iErr = AddNewMail(Session,NULL,(VM_RESOLVE_ADDRESS|VM_ENABLE_UI))) != VM_SUCCESS)
           {
               char    szBuf[256];

               wsprintf(szBuf,"AddNewMail Error [%d].",(int)GetLastError(Session));
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
		    break;
       }
       else
       if (wParam == IDM_SENDMSG_NOUI)
       {
           MAILMSG MailMsg;

           _fmemset(&MailMsg,0x00,sizeof(MAILMSG));

           MailMsg.lpszNoteText = GetVMailString("Test Note");
           MailMsg.lpszSubject  = GetVMailString("IGNORE ____ Test Subject");
           ParseAddressesIntoMsgEx(&MailMsg,NULL,NULL,"AVI",",",VMAIL_ORIG,TRUE);
           ParseAddressesIntoMsgEx(&MailMsg,NULL,NULL,"JOHN,LEE,AVI",",",VMAIL_TO,TRUE);

           if ((iErr = AddNewMail(Session,&MailMsg,VM_RESOLVE_ADDRESS)) != VM_SUCCESS)
           {
               char    szBuf[256];

               wsprintf(szBuf,"AddNewMail Error [%d].",(int)GetLastError(Session));
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
		    break;
       }
       else
       if (wParam == IDM_VIEWMAIL)
       {
           MailDlg(hWnd);
		    break;
       }
       else
       if ((wParam == IDM_VIEWMAILONEBYONE) || (wParam == IDM_VIEWUNREADONEBYONE))
       {
           char    szMsgID[MAX_MSG_ID];
           char    szThisMsgID[MAX_POS_REFERENCE];
           char    szSubject[MAX_SUBJECT_LEN];
           ULONG   lflags = 0;
           MAILMSG MailMsg;

           if (wParam == IDM_VIEWUNREADONEBYONE)               
               lflags = VM_UNREAD;

           if (GetNextMailEx(Session,&MailMsg,szThisMsgID,NULL,szMsgID,NULL,lflags) == VM_SUCCESS)
           {
               while (TRUE)
               {
                   int retval;
                   char szBuf[255];

                   wsprintf(szBuf,"Recieved on %s.\n%s\n\n\nWant to see the next message ?",(LPSTR)MailMsg.lpszDateReceived,(LPSTR)MailMsg.lpszSubject);
                   retval = MessageBox(hWnd,szBuf,"Next Mail Message",MB_ICONQUESTION|MB_YESNO);

                   if (retval == IDNO)
                       break;

                   FreeVMailBuffer(&MailMsg);
                   _fmemset(&MailMsg,0x00,sizeof(MailMsg));

                   retval = GetNextMailEx(Session,&MailMsg,szThisMsgID,szMsgID,szMsgID,NULL,lflags);                                                 

                   if (retval != VM_SUCCESS)
                       break;
               }
           }
           break;
       }
       else
       if (wParam == IDM_STATS)
       {
           int iUnRead,iTotal;
           char    szBuf[256];

           if ((iErr = GetMailStatistics(Session,&iUnRead,&iTotal)) == VM_SUCCESS)
           {
               wsprintf(szBuf,"Total Messages : %d\nUnread Messages : %d\n",(int)iTotal,(int)iUnRead);
               MessageBox(hWnd,szBuf,"Info!",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION);
           }
           else
           {
               char    szBuf[256];

               wsprintf(szBuf,"GetMailStatistics Error [%d].",(int)GetLastError(Session));
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
		    break;

       }
       else
       if (wParam == IDM_MAILID)
       {
           LPSTR   lpMailSystems[] = {"Unknown !",
                                      "MAPI (MS Mail)",
                                      "VIM (Lotus cc:Mail)",
                                      "MHS (Global routing)",
                                      "MHS (Local routing)"
                                     }; 

           int     iMailType = GetMailType();
           char    szBuf[256];

           wsprintf(szBuf,"The underlying mail system is -- %s\n",(LPSTR)lpMailSystems[iMailType]);
           MessageBox(hWnd,szBuf,"Info!",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION);
		    break;

       }
       else
       if (wParam == IDM_EXIT)
       {
           if (Session)
           {
               int iResponse = MessageBox(hWnd,"Do you want to Logout from mail\nbefore quitting ?\n","Exit Mail",MB_YESNOCANCEL|MB_ICONQUESTION);

               if (iResponse == IDCANCEL)
                   break;
               else
               if (iResponse == IDYES)
                   SendMessage(hWnd,WM_COMMAND,IDM_LOGOUT,0L);
           }

	        PostQuitMessage(0);
           break;
       }
       else
       if ((wParam == IDM_MHS) || (wParam == IDM_VIM) || (wParam == IDM_MAPI))
       {
           WritePrivateProfileString(_szMailDLLSection,_szMailDllEntry,
               ((wParam == IDM_MHS) ? _szMHSDLL : ((wParam == IDM_MAPI) ? _szMAPIDLL : _szVIMDLL)),
               _szIniFile);

           if (MessageBox(hWnd,"Change will take effect only after you reboot Windows!\n\nReboot now ?",
                   "Mail",MB_YESNO|MB_ICONQUESTION) == IDYES)
           {
               ExitWindows(EW_RESTARTWINDOWS,0);
           }
       }
       else
       if (wParam == IDM_SEND_CUSTOM)
       {
           MAILMSG MailMsg;

           _fmemset(&MailMsg,0x00,sizeof(MailMsg));
           MailMsg.lpMessageType = (LPSTR)GetVMailString(_szCustomType);
           MailMsg.lpszSubject = (LPSTR)GetVMailString("Message type : Custom1");
           MailMsg.lpszNoteText = (LPSTR)GetVMailString("Custom1 type message !");

           ParseAddressesIntoMsgEx(&MailMsg,NULL,NULL,"AVI",",",VMAIL_ORIG,TRUE);
           ParseAddressesIntoMsgEx(&MailMsg,NULL,NULL,"AVI,JOHN,LEE",",",VMAIL_TO,TRUE);

           if ((iErr = AddNewMail(Session,&MailMsg,(VM_RESOLVE_ADDRESS))) != VM_SUCCESS)
           {
               char    szBuf[256];

               wsprintf(szBuf,"AddNewMail (Custom) Error [%d].",(int)GetLastError(Session));
               MessageBox(NULL,szBuf,"Error",MB_OK);
           }
       }
       else
       if (wParam == IDM_GET_CUSTOM)
       {
           char    szMsgID[MAX_MSG_ID];
           char    szThisMsgID[MAX_POS_REFERENCE];
           char    szSubject[MAX_SUBJECT_LEN];
           ULONG   lflags = 0;
           MAILMSG MailMsg;

           //if (wParam == IDM_VIEWUNREADONEBYONE)               
           //    lflags = VM_UNREAD;

           if (GetNextMailEx(Session,&MailMsg,szThisMsgID,NULL,szMsgID,_szCustomType,lflags) == VM_SUCCESS)
           {
               while (TRUE)
               {
                   int retval;
                   char szBuf[255];

                   wsprintf(szBuf,"Recieved on %s.\n%s\n\n\nWant to see the next custom message ?",(LPSTR)MailMsg.lpszDateReceived,(LPSTR)MailMsg.lpszSubject);
                   retval = MessageBox(hWnd,szBuf,"Next Mail Message",MB_ICONQUESTION|MB_YESNO);

                   if (retval == IDNO)
                       break;

                   FreeVMailBuffer(&MailMsg);
                   _fmemset(&MailMsg,0x00,sizeof(MailMsg));

                   retval = GetNextMailEx(Session,&MailMsg,szThisMsgID,szMsgID,szMsgID,_szCustomType,lflags);

                   if (retval != VM_SUCCESS)
                       break;
               }
           }
           break;
       }
       else
       {
           /* Lets Windows process it	     */
		    return (DefWindowProc(hWnd, message, wParam, lParam));
       }
       break;

   case WM_CLOSE :
       SendMessage(hWnd,WM_COMMAND,IDM_EXIT,0L);
       break;

   default:			  /* Passes it on if unproccessed    */
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }

    return (NULL);
}


/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
    switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
	    if (wParam == IDOK                /* "OK" box selected?	     */
                || wParam == IDCANCEL) {      /* System menu close command? */
		EndDialog(hDlg, TRUE);	      /* Exits the dialog box	     */
		return (TRUE);
	    }
	    break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

/**************************************************************************/
/**************************************************************************/

int FAR PASCAL MailDlg (HWND hParent)
{
    FARPROC     lpfn;
    BOOL        retval;

    lpfn = MakeProcInstance(MailDlgProc,hInst);
    retval = DialogBoxParam(hInst,"MAILDLG",hMainWnd,lpfn,NULL);
    FreeProcInstance(lpfn);

    return retval;
}

/*************************************************************************/
/* MailDlgProc                                                           */  
/*************************************************************************/
                                        
BOOL FAR PASCAL MailDlgProc (HWND hDlg,UINT msg,WORD wParam,LONG lParam)
{
    BOOL bProcessed = TRUE;
    static LPMAILMSG lpMailMsg;

    switch (msg)
    {
       case WM_INITDIALOG:
           //EnableWindow(GetDlgItem(hDlg,IDD_ATTACHMENTS_LAUNCH),FALSE);
           //EnableWindow(GetDlgItem(hDlg,IDD_ATTACHMENTS_RETRIEVE),FALSE);
           EnumMailInList (GetDlgItem(hDlg,IDD_MAILLIST));
           lpMailMsg = (LPMAILMSG)_fmalloc(sizeof(MAILMSG));
           if (lpMailMsg)
               _fmemset(lpMailMsg,0x00,sizeof(MAILMSG));
           else
               MessageBox(hDlg,"Insufficient memory!",NULL,MB_OK);
           break;

       case WM_DESTROY:
           if (lpMailMsg)
               _ffree(lpMailMsg);
           break;
   
       case WM_COMMAND:
       {
           if (wParam == IDOK)
               EndDialog(hDlg,TRUE);  
           else
           if (wParam == IDD_MAIL_DELETE)
           {
               char    szMailID[512];

               // For deleting a mail message, get its ID from the listbox,
               // and call the DeleteMail function with it.

               if (GetMailIDFromList(GetDlgItem(hDlg,IDD_MAILLIST),szMailID))
               {
                   // Get the mail message
                   if (DeleteMail(Session,szMailID))
                   {
                       int iCurSel = (int)SendMessage(GetDlgItem(hDlg,IDD_MAILLIST),LB_GETCURSEL,0,0L);
                       SendMessage(GetDlgItem(hDlg,IDD_MAILLIST),LB_DELETESTRING,iCurSel,0L);

                       SetDlgItemText(hDlg,IDD_MAIL_CONTENTS,"");
                       SetDlgItemText(hDlg,IDD_MAIL_SUB,"");
                       SetDlgItemText(hDlg,IDD_MAIL_RECIPS,"");
                       SetDlgItemText(hDlg,IDD_MAIL_ATTACHMENTS,"");

                   }
                   else
                   {
                       char    szBuf[256];

                       wsprintf(szBuf,"DeleteMail Error [%d].",(int)GetLastError(Session));
                       MessageBox(NULL,szBuf,"Error",MB_OK);
                   }
               }
           }
           else
           if (wParam == IDD_MAIL_MARKREAD)
           {
               char    szMailID[512];

               // For marking a mail message as read, get its ID from the listbox,
               // and call the MarkMailAsRead function with it.

               if (GetMailIDFromList(GetDlgItem(hDlg,IDD_MAILLIST),szMailID))
               {
                  if (!MarkMailAsRead(Session,szMailID))
                  {
                       char    szBuf[256];

                       wsprintf(szBuf,"MarkMailAsRead Error [%d].",(int)GetLastError(Session));
                       MessageBox(NULL,szBuf,"Error",MB_OK);
                  }
               }
           }
           else
           if ((wParam == IDD_MAILLIST) && (HIWORD(lParam) == LBN_SELCHANGE))
           {
               HWND        hAttachmentsList;
               LPFILEDESC  lpFDesc;
               char        szMailID[512];
               char        szAttachments[1024],szRecips[1024];

               // For displaying a mail message as read, get its ID from the listbox,
               // and call the GetMail function with it.

               if (GetMailIDFromList(GetDlgItem(hDlg,IDD_MAILLIST),szMailID))
               {

                   SetDlgItemText(hDlg,IDD_MAIL_CONTENTS,"");

                   // If any of the mail messages was already selected
                   // free the memory held by it.
                   if (lpMailMsg)
                       FreeVMailBuffer(lpMailMsg);

                   // Get the mail message
                   _fmemset(lpMailMsg,0x00,sizeof(MAILMSG));
                   if (GetMail(Session,szMailID,lpMailMsg,VM_PEEK|VM_SUPPRESS_ATTACH) != VM_SUCCESS)
                   {
                       char    szBuf[256];

                       wsprintf(szBuf,"GetMail Error [%d].",(int)GetLastError(Session));
                       MessageBox(NULL,szBuf,"Error",MB_OK);
                   }

                   // Show Contents
                   SetDlgItemText(hDlg,IDD_MAIL_CONTENTS,lpMailMsg->lpszNoteText);

                   // Show Attachments
                   szAttachments[0] = 0x00;
                   lpFDesc = lpMailMsg->lpFiles;       
                   hAttachmentsList = GetDlgItem(hDlg,IDD_ATTACHMENTS_LIST);
                   SendMessage(hAttachmentsList,LB_RESETCONTENT,0,0L);
                   while (lpFDesc)
                   {
                       SendMessage(hAttachmentsList,LB_ADDSTRING,0,(LONG)(LPSTR)(lpFDesc->lpszFileName));
                       lpFDesc = lpFDesc->pNextAttachment;
                   }

                   // Show Recipients
                   ParseAddressFromMsg(lpMailMsg,szRecips,sizeof(szRecips),",",VMAIL_ORIG);
                   SetDlgItemText(hDlg,IDD_MAIL_RECIPS_FROM,szRecips);

                   ParseAddressFromMsg(lpMailMsg,szRecips,sizeof(szRecips),",",VMAIL_CC);
                   SetDlgItemText(hDlg,IDD_CC_LIST,szRecips);
               }
           }
           else
           if (wParam == IDD_ATTACHMENTS_RETRIEVE)
           {
               int iSel = (int)SendDlgItemMessage(hDlg,IDD_ATTACHMENTS_LIST,LB_GETCURSEL,0,0L);
               if (iSel != LB_ERR)
               {
                   char szName[128];
                   char szFileName[128];
                   char szDirName[128];
                   char szFileTitle[128];
                   char szFilter[8] = "*.*";   
                   char szMailID[128];

                   OPENFILENAME ofn;

                   GetSystemDirectory(szDirName,sizeof(szDirName));
                   szFileName[0] = '\0';
                
                   SendDlgItemMessage(hDlg,IDD_ATTACHMENTS_LIST,LB_GETTEXT,iSel,(LONG)(LPSTR)szName);

                   memset(&ofn,0,sizeof(ofn));
                   ofn.lStructSize = sizeof(ofn);
                   ofn.hwndOwner = hDlg;
                   ofn.lpstrFilter = szFilter;
                   ofn.nFilterIndex = 1;
                   ofn.nMaxFile = sizeof(szFileName);
                   ofn.lpstrFileTitle = szFileTitle;
                   ofn.lpstrInitialDir = szDirName;
                   ofn.lpstrFile = szFileName;
                   ofn.Flags = OFN_PATHMUSTEXIST;

                   if (GetSaveFileName(&ofn))
                   {
                       if (GetMailIDFromList(GetDlgItem(hDlg,IDD_MAILLIST),szMailID))
                       {

                           // If any of the mail messages was already selected
                           // free the memory held by it.
                           if (lpMailMsg)
                               FreeVMailBuffer(lpMailMsg);

                           // Get the mail message
                           _fmemset(lpMailMsg,0x00,sizeof(MAILMSG));
                           if (GetMail(Session,szMailID,lpMailMsg,VM_PEEK|VM_SUPPRESS_ATTACH) != VM_SUCCESS)
                           {
                               char    szBuf[256];

                               wsprintf(szBuf,"GetMail Error [%d].",(int)GetLastError(Session));
                               MessageBox(NULL,szBuf,"Error",MB_OK);
                           }
                           else
                           {
                               int j=0;

                               LPFILEDESC  lpFDesc = lpMailMsg->lpFiles;
                               while ((j<iSel) && (j<lpMailMsg->nFileCount) && lpFDesc)
                               {
                                   lpFDesc = lpFDesc->pNextAttachment;
                                   j++;
                               }

                               if (!GetAttachment(Session,szMailID,lpFDesc,szFileName,0L))
                               {
                                   char    szBuf[256];

                                   wsprintf(szBuf,"GetMail Error [%d].",(int)GetLastError(Session));
                                   MessageBox(NULL,szBuf,"Error",MB_OK);
                               }
                           }
                       }
                   }
               }
           }
           else
           if (wParam == IDD_ATTACHMENTS_LAUNCH)
           {
               int iSel = (int)SendDlgItemMessage(hDlg,IDD_ATTACHMENTS_LIST,LB_GETCURSEL,0,0L);
               if (iSel != LB_ERR)
               {
                   char szTmpPath[128];
                   char szMailID[128];

                   char szAttachmentName[128],szExt[6],szApp[128];

                   lstrcpy(szTmpPath,"");

                   // Make a temporary file on the first available hard-disk
                   // Note that the temporary file is not deleted as we do not
                   // know (in this sample program) that when the launched 
                   // application is terminated.
                   GetTempFileName(0,"OM",0,szTmpPath);

                   if (GetMailIDFromList(GetDlgItem(hDlg,IDD_MAILLIST),szMailID))
                   {
                       
                       // If any of the mail messages was already selected
                       // free the memory held by it.
                       if (lpMailMsg)
                           FreeVMailBuffer(lpMailMsg);

                       // Get the mail message
                       _fmemset(lpMailMsg,0x00,sizeof(MAILMSG));
                       if (GetMail(Session,szMailID,lpMailMsg,VM_PEEK|VM_SUPPRESS_ATTACH) != VM_SUCCESS)
                       {
                           char    szBuf[256];

                           wsprintf(szBuf,"GetMail Error [%d].",(int)GetLastError(Session));
                           MessageBox(NULL,szBuf,"Error",MB_OK);
                       }
                       else
                       {
                           int j=0;

                           LPFILEDESC  lpFDesc = lpMailMsg->lpFiles;
                           while ((j<iSel) && (j<lpMailMsg->nFileCount) && lpFDesc)
                           {
                               lpFDesc = lpFDesc->pNextAttachment;
                               j++;
                           }

                           if (!GetAttachment(Session,szMailID,lpFDesc,szTmpPath,0L))
                           {
                               char    szBuf[256];

                               wsprintf(szBuf,"GetMail Error [%d].",(int)GetLastError(Session));
                               MessageBox(NULL,szBuf,"Error",MB_OK);
                           }
                           else
                           {
                               lstrcpy(szAttachmentName,lpFDesc->lpszFileName);
                               _splitpath(szAttachmentName, NULL, NULL, NULL, szExt);

                               if (lstrlen(szExt))
                               {
                                   LPSTR lpTemp;
                                   char  szCmdLine[128];
                                   GetProfileString(_szExtSection,(LPSTR)(&szExt[1]),"",szApp,sizeof(szApp));

                                   lpTemp = (LPSTR)szApp;
                                   while (*lpTemp && (*lpTemp != ' '))
                                       lpTemp++;

                                   *lpTemp = 0x00;

                                   wsprintf(szCmdLine,"%s %s",(LPSTR)szApp,(LPSTR)szTmpPath);
                                   WinExec(szCmdLine,SW_SHOWNORMAL);
                               }
                           }
                       }
                   }
               }
           }
       }
       break;

       default:
           bProcessed = FALSE;
    }
    return bProcessed;
}

///////////////////////////////////////////////////////////////////////////////
//
// Mail Message Enumeration Procedure
//
///////////////////////////////////////////////////////////////////////////////

BOOL FAR PASCAL MailEnumProc (LPSTR lpszMsgID,LPSTR lpszSubject,LONG lParam)
{
   char    szTxt[1024];

   szTxt[0] = 0x00;

   lstrcat(szTxt,(LPSTR)lpszSubject);
   lstrcat(szTxt,(LPSTR)"\t\t\t\t\t\t\t");
   lstrcat(szTxt,(LPSTR)lpszMsgID);

   AddString((HWND)LOWORD(lParam),(LONG)(LPSTR)szTxt);
   return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
//
// Enumerate all the mail messages in the given listbox.
//
///////////////////////////////////////////////////////////////////////////////

void FAR PASCAL EnumMailInList (HWND hList)
{
   FARPROC lpMailEnumProc = MakeProcInstance(MailEnumProc,hInst);

   if (lpMailEnumProc)
   {
       if (!EnumMail(Session,lpMailEnumProc,NULL,0,MAKELONG(hList,0)))
       {
           char    szBuf[256];
           
           wsprintf(szBuf,"EnumMail Error [%d].",(int)GetLastError(Session));
           MessageBox(NULL,szBuf,"Error",MB_OK);
       }

       FreeProcInstance(lpMailEnumProc);
   }
}

///////////////////////////////////////////////////////////////////////////////
//
// Parse the Mail Id from the currently selected mail item in the listbox
//
///////////////////////////////////////////////////////////////////////////////

LPSTR NEAR PASCAL GetMailIDFromList (HWND hList,LPSTR lpBuf)
{
   
   LPSTR   lpTok;
   char szTmp[1024];
   int iCurSel = (int)SendMessage(hList,LB_GETCURSEL,0,0L);

   if (iCurSel != LB_ERR)
   {
       SendMessage(hList,LB_GETTEXT,iCurSel,(LONG)(LPSTR)szTmp);
   
       lpTok = _fstrtok(szTmp,"\t");
       if (lpTok)
       {
           lpTok = _fstrtok(NULL,"\t");
           if (lpTok)
           {
               lstrcpy(lpBuf,lpTok);
               return lpBuf;
           }
           else
               return NULL;
       }
       else
           return NULL;
   }
   else
       return NULL;
}


