#include <windows.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#include <oms.h>

#define BLKSIZE 1024

/**************************************************************************/
/* INI file MAP - needed for all the modules.                             */
/**************************************************************************/

char       _szExtSection[]     = "Extensions";
char       _szIniFile[]        = "OMS.INI";  // INI file name
char       _szMailDLLSection[] = "SYS";        // Mail DLL section in INI file    
char       _szMailDllEntry[]   = "MailDLL";    // Mail DLL entry in INI file
char       _szMAPIDLL[]        = "MAPI.OMS"; // Names of the supported DLL
char       _szVIMDLL[]         = "VIM.OMS";  //
char       _szMHSDLL[]         = "MHS.OMS";  //
char       _szMHSSection[]     = "MHS";        // MHS Section
                                               // MHS Delivery Agent entry
char       _szMHSEntry[]       = "MHS";        // MHS Entry

char       _szMailDeliveryAgentSection[]="Delivery Agent";


int FAR PASCAL CopyFile (LPSTR pSourceFileName,LPSTR pDestFileName)
{
   int         fhSrc,fhDest;//,nSizeChunk;
   //long      lBytesLeft;
   //char      *pBuffer;

   int         iRetVal = VM_SUCCESS;

   fhSrc = _open(pSourceFileName,_O_RDONLY | O_BINARY);
   if (fhSrc != -1)
   {
       fhDest = _open(pDestFileName,_O_RDWR | _O_CREAT | O_BINARY);
       if (fhDest != -1)
       {
           // Copy in chunks of 2K blocks    
           char Buffer[BLKSIZE];
           int iBytes;

           iBytes = _read(fhSrc,&Buffer,BLKSIZE);
           while (iBytes>0)
           {
               _write(fhDest,&Buffer,iBytes);
               iBytes = _read(fhSrc,&Buffer,BLKSIZE);
           }

           _close(fhDest);

           _chmod(pDestFileName,_S_IWRITE|_S_IREAD);
       }
       else
           iRetVal = VMERR_IO_ERROR;

      _close(fhSrc);
   }
   else
       iRetVal = VMERR_IO_ERROR;

   return iRetVal;
}

LPSTR FAR PASCAL GetTempFilePath (LPSTR lpPartialPath)
{
   _asm
   {
       push ds
       lds dx,lpPartialPath

       mov ah,5ah      ;; Create Temporary File interrupt
       mov cx,0h       ;; File attributes
       int 21h;
       pop ds
   }

   return lpPartialPath;
}


