/****************************************************************************/
/* File         :  omsc.h                                                   */
/* Date Created :  June 2 1994                                              */
/*                                                                          */
/* (c) Copyright 1993-1994 by Raindrop Software Corporation.                */
/* All Rights Reserved.                                                     */
/* This material is proprietary, confidential and a trade secret.           */
/* Rights to use must be granted in writing by Raindrop Software            */
/* Corporation.                                                             */
/*                                                                          */
/* A C++ shell around the virtual Mail API for mail-aware Windows           */
/* Application                                                              */
/****************************************************************************/

#ifndef __OMSCLIB_H__ 
#define __OMSCLIB_H__ 

//////////////////////////////////////////////////////////////////////////////
// includes
//////////////////////////////////////////////////////////////////////////////

extern "C"
{               
#include <oms.h>
}

typedef LPVOID POS;

class COmsRecipient;
//  Mail Users Enumeration callback
typedef BOOL (FAR PASCAL * USERENUMPROC)(COmsRecipient __far *pMailRecip, LONG lParam);

//////////////////////////////////////////////////////////////////////////////
// class COmsRecipient
//////////////////////////////////////////////////////////////////////////////
class __far COmsRecipient {

private:  // Data Members
   MAILRECIPDESC  recipdesc;   // Mail Recipient Descriptor Structure

public:     
// Constuctors
   COmsRecipient() __far;

   COmsRecipient(LPCSTR lpAddress, ULONG ulRecipClass = VMAIL_TO, LPCSTR lpName = NULL, LPCSTR lpFullName = NULL) __far;
   
// Destructor
   ~COmsRecipient() __far;
   
// Member functions
   ULONG GetClass(void) __far;

   void  SetClass(ULONG uClass) __far;

   int   GetNameLength(void) __far;

   LPSTR GetName(LPSTR lpName, int nNameLen) __far;

   void  SetName(LPCSTR lpName) __far;

   int   GetFullNameLength(void) __far;

   LPSTR GetFullName(LPSTR lpFullName, int nFullNameLen) __far;

   void  SetFullName(LPCSTR lpFullName) __far;

   int   GetAddressLength(void) __far;

   LPSTR GetAddress(LPSTR lpAddress, int nAddressLen) __far;

   void  SetAddress(LPCSTR lpAddress) __far;
   
private:     
   LPSTR GetName() __far;
   LPSTR GetFullName() __far;
   LPSTR GetAddress() __far;
   void  SetReservedBit(ULONG ulreserved) __far;

// friend class COmsRecipientList - needs access to private members
friend class COmsRecipientList;
};


//////////////////////////////////////////////////////////////////////////////
// class COmsRecipientList
//////////////////////////////////////////////////////////////////////////////
class __far COmsRecipientList {

private:  // Data Members
   LPMAILRECIPDESC  lpHeadMailRecipDesc;    // pointer to head of list

public:
// Constuctors
   COmsRecipientList() __far;

   COmsRecipientList(LPCSTR lpDelimiter, LPCSTR lpRecipAddresses, ULONG ulClass = VMAIL_TO) __far;

   void AddRecipients(LPCSTR lpDelimiter, LPCSTR lpRecipAddresses, ULONG ulClass, BOOL bReset);

// Destructor
   ~COmsRecipientList() __far;

// Member functions
   int  GetCount (void) __far;

   int  Add (COmsRecipient __far * pNewRecipient) __far;

   int  DeleteRecipientClass (ULONG uClass) __far;

   void FreeAll (void) __far;

   POS GetHead () __far;

   COmsRecipient __far * GetNext ( POS __far & pos ) __far ;

// friend class COmsMessage - needs access to private members
friend class COmsMessage;

} ;


// Forward declaration
class COmsSession;


//////////////////////////////////////////////////////////////////////////////
// class COmsAttachment
//////////////////////////////////////////////////////////////////////////////

class __far COmsAttachment {

private:  // Data Members
   FILEDESC		filedesc;   // Attachment Description structure
   M_SESSION       OmsSession;
   LPSTR           lpszMsgID;
   
public :
// Constuctor
   COmsAttachment(LPCSTR lpPathName = NULL) __far;                 

// Destructor
   ~COmsAttachment() __far;

// Member functions
   ULONG  GetFlags(void) __far;

   void   SetFlags(ULONG uFlags) __far;

   ULONG  GetPosition(void) __far;

   void   SetPosition(ULONG uPos) __far;

   int    GetPathNameLength(void) __far;

   LPSTR  GetPathName(LPSTR lpPath, int nPathLen) __far;

   void   SetPathName(LPCSTR lpPathName) __far;

   int    GetFileNameLength(void) __far;

   LPSTR  GetFileName(LPSTR lpFileName, int nFileLen) __far;

   void   SetFileName(LPCSTR lpFileName) __far;

   LONG   GetFileType() __far;

   void   SetFileType(LONG lFileType) __far;

   HICON  GetIcon(void) __far;

   void   SetIcon(HICON hAppIcon) __far;

   int    SaveAttachment ( LPCSTR lpDestinationFile) __far;

private:
   LPSTR  GetOnlyFileName(void) __far;

   void   SetOnlyFileName(LPCSTR lpName) __far;

   LPSTR  GetParcelName(void) __far;

   void   SetParcelName(LPCSTR lpName) __far;

   LPSTR  GetTempName(void) __far;

   void   SetTempName(LPCSTR lpTempName) __far;

   void   SetReservedBit(ULONG ulreserved) __far;

// friend class COmsAttachmentList - needs access to private members
friend class COmsAttachmentList;

};


//////////////////////////////////////////////////////////////////////////////
// class COmsAttachmentList
//////////////////////////////////////////////////////////////////////////////

class __far COmsAttachmentList {

private:  // Data Members
   LPFILEDESC  lpHeadFileDesc;     // pointer to head of list
   M_SESSION   OmsSession;
   LPSTR       lpszMsgID;

public:
// Constuctors
   COmsAttachmentList() __far;

   COmsAttachmentList(LPCSTR lpDelimiter, LPCSTR lpAttachFileNames) __far;

   void AddAttachments (LPCSTR lpDelimiter, LPCSTR lpAttachFileNames, BOOL bReset) __far;

// Destructor
   ~COmsAttachmentList() __far;

// Member functions
   int  GetCount (void) __far;

   int  Add (COmsAttachment __far * pNewAttachment) __far;

   void FreeAll (void) __far;

   POS GetHead () __far;

   COmsAttachment __far * GetNext (POS __far & pos) __far;

// friend class COmsMessage - needs access to private members
friend class COmsMessage;

};


//////////////////////////////////////////////////////////////////////////////
// class COmsMessage
//////////////////////////////////////////////////////////////////////////////]

class __far COmsMessage  {

private:  // Data Members
   MAILMSG     OmsMailMessage;    // Mail Message structure
   M_SESSION   OmsSession;
   LPSTR       lpszMsgID;
   BOOL        bRecipientListAttached;
   BOOL        bAttachmentListAttached;

public:
// Constuctor
   COmsMessage(LPCSTR lpSubject = NULL, LPCSTR lpNote = NULL) __far;
   
// Destructor
   ~COmsMessage() __far;

// Member functions
   int    GetTypeLength() __far;
   LPSTR  GetType (LPSTR lpType, int nTypeLen) __far;
   void   SetType (LPCSTR lpMsgType) __far;

   int    GetDateLength () __far;
   LPSTR  GetDateReceived (LPSTR lpDateReceived, int nDateLen) __far;

   int    GetConversationIDLength () __far;
   LPSTR  GetConversationID (LPSTR lpConvID, int nConvLen) __far;
   void   SetConversationID (LPCSTR lpConvID) __far;

   LONG   GetFlags () __far;
   void   SetFlags (LONG lFlags) __far;

   ULONG  GetRecipientCount() __far;

   ULONG  GetFileCount() __far;

   int    GetPriority() __far;
   void   SetPriority(int nPriority) __far;

   int    GetSubjectLength() __far;
   LPSTR  GetSubject(LPSTR lpSubject, int nSubjectLen) __far;
   void   SetSubject(LPCSTR lpSubject) __far;

   int    GetNoteTextLength(void) __far;
   LPSTR  GetNoteText(LPSTR lpNoteText, int nNoteTextLen) __far;
   void   SetNoteText(LPCSTR lpNoteText) __far;

   void   AttachRecipientList (COmsRecipientList __far * cRecipientList) __far;
   void   DeleteRecipientList () __far;

   void   AttachAttachmentList (COmsAttachmentList __far * cAttachList) __far;
   void   DeleteAttachmentList () __far;

   COmsAttachmentList __far * GetAttachmentList() __far;
   COmsRecipientList __far * GetRecipientList() __far;
   COmsRecipient __far * GetOriginator () __far;

   void   SetMessageEmpty() __far;

private:
   void   SetFileCount(ULONG lFileCount) __far;

   void   SetRecipientCount(ULONG lRecipCount) __far;

   void   SetDateReceived(LPCSTR lpDate) __far;
   
   void   FreeAttachedAttachments () __far;

   void   FreeAttachedRecipients () __far;

// friend class COmsMessage - needs access to private members
friend class COmsSession;
};


//////////////////////////////////////////////////////////////////////////////
// class COmsSession
//////////////////////////////////////////////////////////////////////////////

class __far COmsSession {

private:  // Data Members
   M_SESSION   OmsSession;

public:
// Constuctors
   COmsSession() __far;
   
// Destructor
   ~COmsSession() __far;
   	
// Member functions
   static int  Init (WORD wMailSystemType) __far;

   int  DeInit (void) __far;

   int  Logon (LPCSTR lpLoginName,
                           LPCSTR lpPassword = NULL,
                           LPCSTR lpPathName = NULL,
                           BOOL fEnableUI = TRUE,
                           BOOL fNewSession = TRUE,
                           BOOL fForceDownLoad = FALSE) __far;

   int  Logoff (void) __far; 
   
   BOOL IsValid (void) __far;
                                 
   int  GetMailType() __far;
   	                                       
   int  GetLastError (void) __far;

   int  GetLastNativeError (void) __far;

   int  GetErrorDescription (int iErr,LPSTR lpErrDesc,int iSize) __far;

   int  GetMailStatistics (LPINT lpUnread,LPINT lpTotal) __far;

   int  GetVersion (void) __far;

   LONG GetMailMetrics(int iParameter) __far;

   M_SESSION GetNativeSession (M_SESSION Session) __far;

   int  GetSessionAttributes (LPSTR lpszUserName, LPSTR lpszPassword, LPSTR lpszPostOffice) __far;

   static BOOL IsMailSystemAvailable (int iMailSystem) __far;
 
   int  DeleteMail (LPCSTR lpszMsgID) __far;
        
   int  MarkMailAsRead (LPCSTR lpszMsgID) __far;

   int  GetNextMail (LPSTR lpszSubject,LPSTR lpszMsgID,LPVOID lpPrevMsgID,LPVOID lpMsgID,LPCSTR lpszType,LONG lFlags) __far;

   int  GetNextMailEx (COmsMessage __far * pMsg,LPSTR lpszMsgID,LPVOID lpPrevMsgID,LPVOID lpMsgID,LPCSTR lpszType,LONG lFlags) __far;

   int  EnumUsers (USERENUMPROC lpEnumProc,LONG lParam = 0L) __far;

   int  EnumMail (MAILENUMPROC lpEnumProc,LPVOID lpMessageType = NULL,LONG lFlags = 0L,LONG lParam = 0L) __far;

   int  SendMail (COmsMessage __far * pMsg,ULONG ulflags = 0L) __far;

   int  GetMail (LPCSTR lpszMsgID,COmsMessage __far * pMsg,LONG lFlags) __far;

   BOOL ValidateUser(LPSTR lpStr) __far;

};

#endif // __OMSCLIB_H__
