/****************************************************************************/
/* File         :  oms.h                                                    */
/* Date Created :  August 28 1993                                           */
/*                                                                          */
/* (c) Copyright 1993-1994 by Raindrop Software Corporation.                */
/* All Rights Reserved.                                                     */
/* This material is proprietary, confidential and a trade secret.           */
/* Rights to use must be granted in writing by Raindrop Software            */
/* Corporation.                                                             */
/****************************************************************************/
#include <stdlib.h>

#define VM_UNSUPPORTED                  99   // Unsupported function
#define VM_SUCCESS                     100   // No Error.
#define VMERR_NATIVE_TO_MAIL_SYS       101   // Error native to mail system
                                             // Cannot be described.

                                             // All other explainable errors.

#define VMERR_CANNOT_LOAD_DLL          102   // DLL Could not be loaded   .
#define VMERR_MAIL_NOT_INITIALISED     104   // Mail functions called without 
                                             // initialisation.
#define VMERR_NO_VALID_SESSION         105   // Trying to close session 
                                             // without opening one.
#define VMERR_INSUFFICIENT_MEMORY      106   // Insufficient memory to complete
                                             // the specified operation

#define VMERR_TOO_MANY_SESSIONS        107   // User has too many sessions 
                                             // open at once
#define VMERR_TOO_MANY_FILES           108   // Too many file attachments
#define VMERR_TOO_MANY_RECIPIENTS      109   // Too many message recipients
#define VMERR_ATTACHMENT_NOT_FOUND     110   // Specified attachment was not found
#define VMERR_ATTACHMENT_OPEN_FAILURE  111   // Could not open attachment
#define VMERR_ATTACHMENT_WRITE_FAILURE 112
#define VMERR_UNKNOWN_RECIPIENT        113   // The recipient does not appear
                                             // in the address list
#define VMERR_BAD_RECIPTYPE            114   // Type of recipient was not TO,
                                             // CC or BCC.
#define VMERR_NO_MESSAGES              115   //
#define VMERR_INVALID_MESSAGE          116   //
#define VMERR_TEXT_TOO_LARGE           117   // Text in the message was too 
                                             // large to be sent
#define VMERR_INVALID_SESSION          118   // No valid session is in progress
#define VMERR_TYPE_NOT_SUPPORTED       119   // 
#define VMERR_LOGON_FAILED             120   // User failed to successfully logon
#define VMERR_DISK_FULL                121   // Disk is full
#define VMERR_ACCESS_DENIED            122   // Access Denied :-(

#define VMERR_AMBIGUOUS_RECIPIENT      123
#define VMERR_MESSAGE_IN_USE           124
#define VMERR_NETWORK_FAILURE          125
#define VMERR_INVALID_EDITFIELDS       126
#define VMERR_INVALID_RECIPS           127
#define VMERR_NOT_SUPPORTED            128
#define VMERR_SESSION_NOT_STARTED      129   // No session started yet
#define VMERR_USER_ENUM_INTERRUPT      130   // User App interrupted 
                                             // enumeration by returning FALSE
#define VMERR_NO_DOCS_SPECIFIED        131   // Called send documents with no
                                             // document names at all  
#define VMERR_COULDNOT_CREATE_MESSAGE  132   // Could not open the file for
                                             // writing the message (MHS)
#define VMERR_USER_ABORTED             135   // User aborted the process
#define VMERR_CORRUPT_MSG              136   // MAILMSG structure is corrupt !

#define VMERR_INIT_FAILURE             138   // Could not initialize mail

#define VMERR_CANNOT_OPEN_MSG          139   // Could not open msg 
#define VMERR_IO_ERROR                 140
#define VMERR_NULL_PARAMETERS          141   // One of the required parameters passed
                                             // is NULL  

#define VMERR_INVALID_TO_RECIP         300   // Invalid TO Recipient
#define VMERR_INVALID_CC_RECIP         301   // Invalid CC Recipient
#define VMERR_INVALID_BCC_RECIP        302   // Invalid BCC Recipient
#define VMERR_INVALID_ORIG_RECIP       303   // Invalid BCC Recipient

#define VMERR_INVALID_PRIORITY         304   // Invalid Subject
#define VMERR_INVALID_SUBJECT          305   // Invalid Subject
#define VMERR_INVALID_NOTE_ATTACH      306   // Invalid Note Attachment
#define VMERR_INVALID_FILE_ATTACH      307   // Invalid File Attachment

#define VMERR_INVALID_OBJECT           308   // Invalid Session Parameter

#define VMERR_NATIVE_MAIL_DLL_NOT_LOADED 310 // The native mail DLL file could not be loaded.  

#define VMERR_CANNOT_READ_MAIL         311   // Specified Mail message cannot be read
#define VMERR_NO_MORE_MSG              312
#define VMERR_INVALID_MSG_TYPE         313   // Invalid custom message type
#define VMERR_MSG_TYPE_NOT_SUPPORTED   314   // custom message type not supported
#define VMERR_COULD_NOT_RESOLVE_NAME   315   // Could not resolve the name to a non-ambiguous
                                             // recipient.
#define VMERR_NO_USERS                 316   //
#define VMERR_INVALID_ADDRESSBOOK      317   //

#define VMERR_INVALID_PARM             318   //
#define VMERR_CANNOT_SET_DRAFT         319   // Cannot set the draft attribute
                                             // for this message.
#define VMERR_CANNOT_DELETE_TEMPORARY_FILES    320 // The temporary files created for
                                             // retrieving attachments could not
                                             // be deleted.
#define VMERR_CANNOT_OPEN_TEMPORARY_FILES    321 // The temporary files created for
                                             // retrieving attachments could not
                                             // be opened.
#define VMERR_CANNOT_GENERATE_TEMPORARY_FILENAME    322 // The temporary name files created for
                                             // retrieving attachments could not
                                             // be opened.
#define VMERR_WINEXEC_FAILED        323
#define VMERR_FAILURE					400	  // General failure


/***************************/
/* Mail System Identifiers */
/***************************/

#define MAIL_SYS_UNKNOWN   0
#define MAIL_SYS_MAPI      1
#define MAIL_SYS_VIM       2
#define MAIL_SYS_MHS       3
#define MAIL_SYS_MHS_LOCAL 4
//#define MAIL_SYS_CSERVE    5
//#define MAIL_SYS_SMTP      6  

/************************************/
/* extended Mail System Identifiers */
/************************************/
#define EXT_MAIL_SYS_CCMAIL 1
#define EXT_MAIL_SYS_NOTES  2

/*******************************/
/* Flags for recipient types   */
/*******************************/

#define VMAIL_TO    0x0001
#define VMAIL_CC    0x0002
#define VMAIL_BCC   0x0004
#define VMAIL_ORIG  0x0008

/***************************/
/* flFlags for MailMsg     */
/***************************/

/***************************/
/* Priorities for MailMsg  */
/***************************/
#define PRIORITY_HIGH      0x0001
#define PRIORITY_MEDIUM    0x0002
#define PRIORITY_LOW       0x0003
#define PRIORITY_DONT_CARE 0x0000     // Don't care priority

/***************************/
/* Flags for various API's */
/***************************/

#define VM_PEEK            (0x00000001)
#define VM_SUPPRESS_ATTACH (0x00000002)
#define VM_UNREAD          (0x00000004)
#define VM_RECEIPT         (0x00000008)      // Return receipt required
#define VM_ENABLE_UI       (0x00000010)
#define VM_RESOLVE_ADDRESS (0x00000020)
#define VM_SAVE_DRAFT      (0x00000040)
#define VM_SENDSELF        (0x00000080)

/***************************/
/* Flags for Mail Metrics  */
/***************************/
#define MM_NAMELEN                 (1)
#define MM_FULLNAMELEN             (2)
#define MM_ADDRESSLEN              (3)
#define MM_SUBJECTLEN              (4)
#define MM_CONTENTSLEN             (5)
#define MM_MAXAPPMSGTYPES          (6)
                                     
/****************************/       
#define MAX_SUBJECT_LEN            (512)
#define MAX_MSG_ID                 (64)
#define MAX_POS_REFERENCE          (64)
#define MAX_USER_LEN               (128)
#define MAX_PASSWORD_LEN           (64)
#define MAX_POSTOFFICE_LEN         (255)

/*******************************/
/* Flags for attachment types (flFlags) */
/* Used in FILEDESC structs    */
/*******************************/

#define FD_ENUM_TYPE    0x0001 // if set then lpFileType is a number 
                               // other wise it points to a string that 
                               // is protocol dependent

/************************************/
/* OMS defined types of attachments */
/************************************/

#define AT_UNKNOWN     0
#define AT_OLE         1
#define AT_OLE_STATIC  2

/************************************/
/* Various UI parameter indices     */
/* For usage with SetUIParam and    */
/*                GetUIParam        */
/************************************/
#define HWND_UI_PARENT     (1)
#define ADDR_DLG_NUM_EDITS (2)
#define USE_NATIVE_UI      (3)

/***************************************************************************/
/* Mail Specific Data types                                                */
/***************************************************************************/

typedef unsigned long       ULONG;
typedef unsigned long FAR * LPULONG;
typedef unsigned long       M_SESSION;
typedef unsigned long FAR * LPM_SESSION;
typedef unsigned long       HADDRESSBOOK;
typedef unsigned long FAR * LPHADDRESSBOOK;

// Attachment Description structure
typedef struct AttachDesc
{
  ULONG   ulReserved;       // Reserved for future/internal use
  ULONG   flFlags;		     // Flags
  ULONG   nPosition;        // character in text to be replaced by attachment
  LPCSTR  lpszPathName;     // Full path name of attachment file
  LPCSTR  lpszFileName;     // Original file name 
  LPCSTR  lpszTempName;     // Temporary name (dependent upon native mail system)
  LONG    lFileType;        // Attachment file type (optional)

  char   szOnlyFileName[15];// Only the filename without path
  HICON  hIcon;           // Icon of the server application

  char   szParcelName[128];

  struct AttachDesc FAR* pNextAttachment;
} FILEDESC, FAR * LPFILEDESC, FAR * PFILEDESC;

// Mail Recipient Descriptor Structure
typedef struct MailRecipDesc
{
  ULONG ulReserved;           // Reserved for future use
  ULONG ulRecipClass;         // Recipient class
                              // VMAIL_TO, VMAIL_CC, VMAIL_BCC, VMAIL_ORIG
  LPCSTR lpszName;             // Recipient name
  LPCSTR lpszFullName;         // Recipient fullname
  LPCSTR lpszAddress;          // Recipient address (optional)

  struct MailRecipDesc FAR *pNextRecip;
 
} MAILRECIPDESC, FAR *LPMAILRECIPDESC, FAR * PMAILRECIP;

// Mail Message structure
typedef struct MailMessage
{
  ULONG    ulReserved;            // Reserved for future use (M.B. 0)
  LPVOID   lpMessageType;         // Message Class
  LPCSTR   lpszDateReceived;      // Date received in YYYY/MM/DD HH:MM format   
  LPCSTR   lpszConversationID;	   // conversation thread ID
  LONG     flFlags;               // unread,return receipt

  ULONG nRecipCount;              // Number of recipients
  LPMAILRECIPDESC lpRecips;       // Recipient descriptors

  ULONG nFileCount;               // # of file attachments
  LPFILEDESC lpFiles;             // Attachment descriptors

  int   Priority;                 // Priority of this message
  LPCSTR lpszSubject;             // Message Subject
  LPCSTR lpszNoteText;            // Message Text

  LONG  lReserved1;               // Reserved for internal use
  LONG  lReserved2;               // Reserved for internal use
  LONG  lReserved3;               // Reserved for internal use

} MAILMSG, FAR * LPMAILMSG, FAR * PMAILMSG;


//  Mail Messages Enumeration callback
typedef BOOL (FAR PASCAL * MAILENUMPROC)(LPSTR lpszMsgID,LPCSTR lpszSubject,LONG lParam);

//  Mail Users Enumeration callback
typedef BOOL (FAR PASCAL * MAILUSERENUMPROC)(LPMAILRECIPDESC lpMailUser,LONG lParam);

/***************************************************/
/* User App Interface                              */
/***************************************************/

WORD       FAR    PASCAL GetMailType (void);
int        FAR    PASCAL InitOMS (WORD wMailSystemType);
int        FAR    PASCAL DeInitOMS (void);
int        FAR    PASCAL OpenMailSession (LPCSTR lpLoginName,LPCSTR lpPassword,LPCSTR lpPathName,
					  LPM_SESSION lpSession,BOOL fEnableUI,BOOL fNewSession,BOOL fForceDownLoad);
int        FAR    PASCAL CloseMailSession (M_SESSION Session);
int        FAR    PASCAL AddNewMail (M_SESSION Session,LPMAILMSG lpMailMsg,ULONG ulflags);
int        FAR    PASCAL EnumUsers (M_SESSION Session,MAILUSERENUMPROC lpEnumProc,LONG lParam);
int        FAR    PASCAL EnumMail (M_SESSION Session,MAILENUMPROC lpEnumProc,LPVOID lpMessageType,LONG lFlags,LONG lParam);
int        FAR    PASCAL GetMail (M_SESSION Session,LPCSTR lpszMsgID,LPMAILMSG lpMsg,LONG lFlags);
int        FAR    PASCAL GetAttachment ( M_SESSION Session,LPCSTR lpszMsgID,LPFILEDESC lpAttachDesc,
                                  LPCSTR lpDestinationFile,LONG lFlags);
int        FAR    PASCAL DeleteMail (M_SESSION Session,LPCSTR lpszMsgID);
int        FAR    PASCAL MarkMailAsRead (M_SESSION Session,LPCSTR lpszMsgID);
int        FAR    PASCAL GetLastError (M_SESSION Session);
int        FAR    PASCAL GetLastNativeError (M_SESSION Session);
int        FAR    PASCAL GetErrorDescription (M_SESSION Session,int iErr,LPSTR lpErrDesc,int iSize);

int        FAR    PASCAL SendDocuments (M_SESSION Session,LPSTR lpszFilePathNames);
int        FAR    PASCAL GetMailStatistics (M_SESSION Session,LPINT lpUnread,LPINT lpTotal);
WORD       FAR    PASCAL GetOMSVersion (void);
LONG       FAR    PASCAL GetMailMetrics(int iParameter);  
int        FAR    PASCAL GetNextMail (M_SESSION Session,LPSTR lpszSubject,LPSTR lpszMsgID,LPVOID lpPrevMsgID,LPVOID lpMsgID,LPCSTR lpszType,LONG lFlags);
int        FAR    PASCAL GetNextMailEx (M_SESSION Session,LPMAILMSG lpMailMsg,LPSTR lpszMsgID,LPVOID lpPrevMsgID,LPVOID lpMsgID,LPCSTR lpszType,LONG lFlags);
int        FAR    PASCAL GetSessionAttributes (M_SESSION Session,LPSTR lpszUserName,LPSTR lpszPassword,LPSTR lpszPostOffice);
BOOL       FAR    PASCAL IsMailSystemAvailable (int iMailSystem);
int        FAR    PASCAL ResolveName (M_SESSION Session,LPCSTR lpszUserName,LONG fFlags,LPMAILRECIPDESC lpRecip);
M_SESSION  FAR    PASCAL GetNativeSession (M_SESSION Session);
int        FAR    PASCAL ShowAddressBook (M_SESSION Session,HWND hParent,LPMAILRECIPDESC FAR * lplpRecips,int FAR *lpCnt);
int        FAR    PASCAL SaveMail (M_SESSION Session,ULONG ulUIParam,LPMAILMSG lpMailMsg,ULONG ulFlags,LPSTR lpszMsgId,ULONG ulReserved);

int        FAR    PASCAL OpenAddressBook (M_SESSION Session,LPHADDRESSBOOK lpHAddressBook);
int        FAR    PASCAL GetNextAddressBookEntry (M_SESSION Session,HADDRESSBOOK hAddressBook,LPMAILRECIPDESC lpMailRecipDesc);
int        FAR    PASCAL CloseAddressBook (M_SESSION Session,HADDRESSBOOK hAddressBook);

/***************************************************/
/* Helper routines to create and manipulate Mail   */
/* Message structure                               */
/***************************************************/

LPSTR      FAR PASCAL ParseAddressFromMsg (LPMAILMSG lpMailMsg,LPSTR lpBuf,
                                       int iBufSize,LPSTR lpDelimiter,ULONG ulParseWhat);
int        FAR PASCAL ParseAddressesIntoMsg (LPMAILMSG lpMailMsg, LPSTR lpBuffer,
                                       LPSTR lpDelimiter,ULONG ulParseWhat,BOOL bReset);
int        FAR PASCAL AddFileToAttachments (LPMAILMSG lpMailMsg,LPSTR lpFileName,BOOL bExtractIcon);

int        FAR PASCAL ParseAttachmentsIntoMsg (LPMAILMSG lpMailMsg, LPSTR lpBuffer,
                                       LPSTR lpDelimiter,BOOL bReset);
int FAR PASCAL ParseAttachmentsIntoMsgEx (LPMAILMSG lpMailMsg, LPCSTR lpBuffer,
                       LPCSTR lpTempNames,LPCSTR lpDelimiter,BOOL bReset);
LPFILEDESC FAR PASCAL GetAttachmentDesc (LPMAILMSG lpMailMsg,int iIndex);
void       FAR PASCAL DeleteAttachmentDesc (LPMAILMSG lpMailMsg,int iIndex);
LPCSTR      FAR PASCAL GetVMailString (LPCSTR lpSrcStr);
LPCSTR      FAR PASCAL GetVMailnString (LPCSTR lpSrcStr,size_t size);
BOOL       FAR PASCAL FreeVMailString (LPCSTR lpStr);
void       FAR PASCAL FreeVMailBuffer (LPMAILMSG lpMailMsg);
LPSTR      FAR PASCAL GetTempFilePath (LPSTR lpPartialPath);
int        FAR PASCAL ParseAddressesIntoMsgEx (LPMAILMSG lpMailMsg, LPCSTR lpNames,
                                        LPCSTR lpFullNames,LPCSTR lpAddresses,
                                        LPCSTR lpDelimiter,ULONG ulParseWhat,
                                        BOOL bReset);
LPSTR FAR PASCAL ParseAddressFromRecips (LPMAILRECIPDESC lpRecips,LPSTR lpBuf,
                               int iBufSize,LPSTR lpDelimiter,ULONG ulParseWhat);
int FAR PASCAL ParseAddressesIntoRecipsEx (LPMAILRECIPDESC FAR *lplpMailRecips,
                           LPCSTR lpNames,LPCSTR lpFullNames,LPCSTR lpAddresses,
                           LPCSTR lpDelimiter,ULONG ulParseWhat,BOOL bReset);

void FAR PASCAL FreeOmsRecip (LPMAILRECIPDESC lpOld);

void FAR PASCAL FreeOmsAttachment (LPFILEDESC lpAtts);

int FAR PASCAL ParseAttachmentsIntoAttachmentListEx (LPFILEDESC FAR *lpFileDesc,
                   LPCSTR lpBuffer,LPCSTR lpDelimiter,BOOL bReset);

int   FAR PASCAL SetUIParam (M_SESSION Session,int iParam,ULONG ulParamValue);
ULONG FAR PASCAL GetUIParam (M_SESSION Session,int iParam);




/***************************************************/
/* These are new functions in OMS ver 1.5          */
/***************************************************/



PMAILMSG FAR PASCAL OpenMessageSession (LPCSTR lpLoginName,LPCSTR lpPassword,
                                         LPCSTR lpPostOfficeName,BOOL fEnableUI,
                                         BOOL   fNewSession,BOOL fForceDownLoad,HWND hParent);

// Mail Message related functions
            
int         FAR PASCAL AddNewMessage (M_SESSION Session,PMAILMSG msg,DWORD Flags,HWND hParent);
int         FAR PASCAL GetNextMessage(M_SESSION Session,PMAILMSG msg);

PMAILMSG    FAR PASCAL AllocMessage ();
int         FAR PASCAL FreeMessage (PMAILMSG pMsg);

int         FAR PASCAL GetMessageNote (PMAILMSG pMailMsg,LPSTR lpNote,int nNote);
int         FAR PASCAL SetMessageNote (PMAILMSG pMailMsg,LPCSTR lpNote);

int         FAR PASCAL GetMessageSubject (PMAILMSG pMailMsg,LPSTR lpSubj,int nSubj);
int         FAR PASCAL SetMessageSubject (PMAILMSG pMailMsg,LPCSTR lpSubj);

int         FAR PASCAL SetMessagePriority (PMAILMSG pMailMsg,int Priority);
int         FAR PASCAL GetMessagePriority (PMAILMSG pMailMsg);

int         FAR PASCAL SetMessageDate (PMAILMSG pMailMsg,LPCSTR lpDateStr);
int         FAR PASCAL GetMessageDate (PMAILMSG pMailMsg,LPSTR lpDateStr,int nDate);

int         FAR PASCAL SetMessageConversationID (PMAILMSG pMailMsg,LPCSTR lpConversationID);
int         FAR PASCAL GetMessageConversationID (PMAILMSG pMailMsg,LPSTR lpConversationID,int nConvID);

int         FAR PASCAL AddMessageAttachment(PMAILMSG pMailMsg,PFILEDESC pFileDesc);
PFILEDESC   FAR PASCAL GetMessageAttachment(PMAILMSG pMailMsg,int i);
int         FAR PASCAL GetMessageAttachmentCount(PMAILMSG pMailMsg);

int         FAR PASCAL AddMessageRecipient(PMAILMSG pMailMsg,PMAILRECIP pRecip);
PMAILRECIP  FAR PASCAL GetMessageRecipient(PMAILMSG pMailMsg,int i);
int         FAR PASCAL GetMessageRecipientCount(PMAILMSG pMailMsg);








