/*****************************************************************************
** SAMPLE.PRG
**
** Clip-2-VO conversion sample
** Main sample program module, should be compiled with /n option
**
** Copyright 1995 SofDesign International, Inc.
** All rights reserved
**
*****************************************************************************/

#include "sample.ch"

/*****************************************************************************
** Main() --> NIL
**
** Main module of Clip-2-VO sample
**
*****************************************************************************/
function main( )

   local cScreen
   local nRow := row()
   local nCol := col()

   SaveFullScreen( cScreen )

   SetColor( "W/N,W+/N,,,N+/N" )
   CLEAR SCREEN

   FillScreen( )

   OpenFiles( )

   SELECT Customer

   Browse( 5 , 5 , 20 , 75 , 2 )

   CloseFiles( )

   RestFullScreen( cScreen )
   DevPos( nRow , nCol )

return nil


/*****************************************************************************
** FillScreen() --> NIL
**
** Fills screen with selected background color and pattern
**
*****************************************************************************/
function FillScreen( )

   local cSaveColor

   @ 0 , 0 , MAXROW() , MAXCOL() BOX "" COLOR "BG/N+"

   cSaveColor := SETCOLOR( "N/W" )

   @ 0 , 0 SAY SPACE( 80 )
   @ 0 , 2 SAY "  Clip-2-VO Demo v1.00"

   SETCOLOR( cSaveColor )

return nil
