// TCP Server Custom Control
// (C) Copyright 1994 by Distinct Corporation
// All rights reserved

// actions
#define ACTION_NONE             0
#define ACTION_LISTEN           1
#define ACTION_ACCEPT           2
#define ACTION_DISCONNECT       3
#define ACTION_CLOSE            4

// address conversions
#define CONVERT_NONE            0
#define CONVERT_TO_NAME         1
#define CONVERT_TO_ADDRESS      2

// protocol and service conversions
// CONVERT_NONE is as defined above
#define PROTO_NAME_TO_NUMBER       1
#define PROTO_NUMBER_TO_NAME       2
#define SVC_NAME_TO_PORT           3
#define SVC_PORT_TO_NAME           4

//options
#define OPTION_NONE             0
#define OPTION_LINGER_ON        1
#define OPTION_LINGER_OFF       2
#define OPTION_KEEPALIVE_ON     3
#define OPTION_KEEPALIVE_OFF    4

// error codes
#define ERR_IN_ACTION               1
#define ERR_CHANGE_LOCAL_PORT       2
#define ERR_CHANGE_RECV_SIZE        3
#define ERR_CHANGE_SEND_SIZE        4
#define ERR_CANNOT_GET_SOCKET       5
#define ERR_CANNOT_BIND_SOCKET      6
#define ERR_CANNOT_SETUP_SOCKET     7
#define ERR_CANNOT_LISTEN_SOCKET    8
#define ERR_NOT_LISTENING           9
#define ERR_CANNOT_ACCEPT           10
#define ERR_CANNOT_RECV             11
#define ERR_CANNOT_RECV_COUNT       12
#define ERR_CANNOT_SEND             13
#define ERR_NO_OPTION_VALUE         14
#define ERR_CANNOT_GET_LOCAL        15
