// Socket Custom Control
// (C) Copyright 1993, 1994 by Distinct Corporation
// All rights reserved

// actions
#define ACTION_NONE             0
#define ACTION_CONNECT          1
#define ACTION_LISTEN           2
#define ACTION_ACCEPT           3
#define ACTION_DISCONNECT       4

// address conversions
#define CONVERT_NONE            0
#define CONVERT_TO_NAME         1
#define CONVERT_TO_ADDRESS      2

// protocol and service conversions
// CONVERT_NONE is as defined above
#define PROTO_NAME_TO_NUMBER       1
#define PROTO_NUMBER_TO_NAME       2
#define SVC_NAME_TO_PORT           3
#define SVC_PORT_TO_NAME           4

// protocols
#define PROTOCOL_TCP            0
#define PROTOCOL_UDP            1
#define PROTOCOL_ICMP           2

// options
#define OPTION_NONE                0
#define OPTION_BROADCAST_ON        1
#define OPTION_BROADCAST_OFF       2
#define OPTION_LINGER_ON           3
#define OPTION_LINGER_OFF          4
#define OPTION_KEEPALIVE_ON        5
#define OPTION_KEEPALIVE_OFF       6
#define OPTION_REUSEADDR_ON        7
#define OPTION_REUSEADDR_OFF       8
#define OPTION_ASYNC_CONNECT_ON    9
#define OPTION_ASYNC_CONNECT_OFF   10

// error codes
#define ERR_CHANGE_PROTOCOL         1
#define ERR_CHANGE_LOCAL_PORT       2
#define ERR_CHANGE_REMOTE_PORT      3
#define ERR_CHANGE_RECV_SIZE        4
#define ERR_CHANGE_SEND_SIZE        5
#define ERR_CHANGE_HOST_ADDR        6
#define ERR_NO_HOST_ADDR            7
#define ERR_CANNOT_GET_SOCKET       8
#define ERR_CANNOT_BIND_SOCKET      9
#define ERR_CANNOT_CONNECT_SOCKET   10
#define ERR_CANNOT_SETUP_SOCKET     11
#define ERR_CANNOT_LISTEN_SOCKET    12
#define ERR_ALREADY_CONNECTED       13
#define ERR_ALREADY_LISTENING       14
#define ERR_LISTENING_REMOTE_PORT   15
#define ERR_LISTENING_HOST_ADDR     16
#define ERR_NOT_LISTENING           17
#define ERR_CANNOT_ACCEPT           18
#define ERR_CONNECT_TO_RECV         19
#define ERR_CONNECT_TO_RECV_COUNT   20
#define ERR_CONNECT_TO_SEND         21
#define ERR_CANNOT_SEND             22
#define ERR_NO_OPTION_VALUE         23
#define ERR_CANNOT_GET_LOCAL        24
