// NNTP Custom Control
// (C) Copyright 1994 by Distinct Corporation
// All rights reserved

// article retrieval options
#define ARTICLE_ALL     1
#define ARTICLE_BODY    2
#define ARTICLE_HEAD    3
#define ARTICLE_STAT    4

// article position options
#define POSITION_PREV   1
#define POSITION_NEXT   2
#define POSITION_SET    3

// new item options
#define NEW_GROUPS      1
#define NEW_NEWS        2

// actions
#define ACTION_NONE             0
#define ACTION_CONNECT          1
#define ACTION_DISCONNECT       2
#define ACTION_LIST             3
#define ACTION_POST             4
#define ACTION_FORWARD          5
#define ACTION_NEW              6
#define ACTION_POSITION         7
#define ACTION_RETRIEVE         8
#define ACTION_HELP             9
#define ACTION_SLAVE            10
#define ACTION_ABORT            11

// error codes
#define ERR_HOST_NOT_DEFINED            1
#define ERR_NOT_CONNECTED               2
#define ERR_IN_ACTION                   3
#define ERR_CANNOT_CONNECT              4
#define ERR_NEW_TYPE_NOT_DEFINED        5
#define ERR_INVALID_ARTICLE_ID          6
#define ERR_POSITION_NOT_DEFINED        7
#define ERR_ACCESS_TYPE_NOT_DEFINED     8
#define ERR_GROUP_NOT_DEFINED           9
#define ERR_INVALID_GROUP               10
#define ERR_CANNOT_ABORT                11

// return values
#define NNTP_SUCCESS                    1001
#define NNTP_FAILURE                    1002
#define NNTP_CANNOT_INITIALIZE          1003
#define NNTP_CANNOT_INIT_WINSOCK        1004
#define NNTP_OUT_OF_MEMORY              1005
#define NNTP_UNKNOWN_HOST               1006
#define NNTP_CANNOT_ALLOC_SOCKET        1007
#define NNTP_CANNOT_BIND_SOCKET         1008
#define NNTP_HOST_NOT_RESPONDING        1009
#define NNTP_CANNOT_SEND_COMMAND        1010
#define NNTP_TIMED_OUT                  1011
#define NNTP_INVALID_HANDLE             1012
#define NNTP_INVALID_OPTION             1013
