

                TAXPREP ON-LINE HELP

                Personal Taxprep 92.2 Notesǚ 
                Taxprep III User's GuideǴ  
                Personal Taxprep Application Guide' 
                EFILEU 


                Pull-Down Menu Indexa  


How to Use the On-line Help

Press TAB to move down the list of topics and Shift+TAB to move up the list. Once you have selected a topic, press ENTER or F9 to view the help.

When you select a topic from the Main Help Menu, you will be presented with a more detailed list of topics. Keep making selections until you view the Help information itself. Use the arrow keys or press PgUp or PgDn to scroll through the Help if it is longer than one screen.

If you wish to view other topics, press Shift+F9 to reverse the selections you made. If you wish to return directly to the Main Help Menu, go to the bottom of the Help section and press ENTER or F9 on the words:

                 <Main Help Menu>

In some Help sections you will see words underlined, bold, or in colour (depending on the monitor). You can expand on these words (F9) to get more information about that item.

Press ESC at any time to leave the On-line Help.



                Taxprep III User's Guide

                Preface  
                The Taxprep III InterfaceǼ  
                Basic Operations  
                Printing	  
                Special Features  
                Customizing TaxprepK
  
                Appendix  
                            <Main Help Menu>   





                Preface

                Our Philosophyǖ  
                About The HelpZ!  
                            <Main Help Menu>   



                The Taxprep III Interface

                General Screen LayoutǾ$  
                The Pull-Down Menus*  
                Point and Click Menusǘ3  
                Dialog Boxes;  
                The Forms ManagerEA  
                Standard FormsǒT  
                            <Main Help Menu>   



                Basic Operations

                Accessing ReturnsZ  
                Moving On a Form6e  
                Moving Between Forms9k  
                Input Conventions{  
                Editing InputǑ  
                Editing Input - Tutorial-  
                Setting Applicable Formsۖ  
                Attaching Your Own Forms<  
                Completing a Return  
                            <Main Help Menu>   



                Printing

                Printing FormsǱ  
                Printing Returns  
                Print Formatsǁ  
                Print Formats - TutorialǨ  
                Batch Printingǀ  
                Type of Output  
                Laser Facsimile Printing  
                Fonts 
                Using Pre-printed Forms^% 
                Printing to a File 
                            <Main Help Menu>   



                Special Features

                Multiple Returns, 
                Special Windowsi3 
                Split Windows7 
                File Locking< 
                Estimates@ 
                Compare6D 
                UtilitiesSS 
                Turning Off CalculationsI 
                            <Main Help Menu>   





                Customizing Taxprep

                Using a Model ReturnY 
                Configuring a File Path` 
                Configuring Ports and Printers
c 
                Changing the Forms ManagerǨp 
                Optimize Optionsht 
                Change Featuresǹ} 
                Changing the Cursor Display 
                Saving Your Configurationǃ 
                            <Main Help Menu>   



                Appendix

                Sample Print Formats! 
                Improving Performance< 
                CONFIG.SYSR 
                Using SET Commands 
                File Naming Conventionsǖ 
                Troubleshooting 
                            <Main Help Menu>   



                Pull Down Menus

                Fileǈ  
                Edit	  
                Search  
                OptionsǢ  
                Viewǭ  
                Configure  
                UtilitiesSS 
                            <Main Help Menu>   



                File

                NewZ  
                OpenZ  
                Close  
                Save  
                Save As  
                Revert to Saved  
                Print FormǱ  
                Print Return  
                Print Batchǀ  
                Quit  
                            <Main Help Menu>   



                Edit

                UndoǑ  
                CutǑ  
                CopyǑ  
                PasteǑ  
                ClearǑ  
                Select Specific CellsǑ  
                Select Entire FormǑ  
                Attach Schedule<  
                Duplicate<  
                OverrideǒT  
                Set as Estimate@ 
                            <Main Help Menu>   



                Search

                Jump to Schedule9k  
                Expand9k  
                Last Form9k  
                Next Applicable Form9k  
                            <Main Help Menu>   



                Options

                Lock< 
                Compare6D 
                Newǿ 
                Removeǿ 
                Turn Calcs OffI 
                Re-calculateI 
                            <Main Help Menu>   



                View

                Windowsi3 
                Split Window7 
                Next Window7 
                Next Return, 
                Previous Return, 
                Choose Return, 
                            <Main Help Menu>   



                Configure

                File Path, 
                Model ReturnY 
                Port/Printer
c 
                Load Print Formatǁ  
                Save Print Formatǁ  
                Forms ManagerǨp 
                Optimizeht 
                Change featuresǹ} 
                Save Configurationǃ 
                Reset Configurationǃ 
                            <Main Help Menu>   



OUR PHILOSOPHY

Our Users

The Taxprep applications are "for tax professionals, by tax professionals". The applications assume that you are already familiar with the preparation of tax forms and returns.

Our Aim

Our aim is to automate the preparation of tax forms, so you can deal with more complicated tax issues and planning opportunities. By automating the process, we also hope to reduce the number of mechanical errors that otherwise can occur.

Our Design

Taxprep applications all follow the same design principle: "What You See Is What You Get" or WYSIWYG for short (pronounced Wiz'-ee-wig). This means that what you see on the screen is what you will see on your printout. Therefore, what you see on the screen is the applicable tax form. Exceptions occur with certain returns where the government requires special print formats to help them in keying in the information.

Where there is no existing government form, we provide forms based on commonly used formats. We have also designed some forms to help capture detailed information that is often grouped together on the government forms.

Reviews

As the output is only as good as the input, there is no substitute for a thorough review of your tax returns. To encourage this, we provide diagnostics, summaries, compare features, and so on to help you with your reviews.

Keeping Pace with Tax Changes

The Taxprep applications are very sophisticated, with a great deal of intelligence built into them. No computer program, however, can replace you, the tax professional.

Nevertheless, Taxprep recognizes the difficulties you face trying to keep pace with the myriad of changes that occur each year, both at a federal and provincial level. We try, wherever possible, to make you aware of potential errors and opportunities. We accomplish this by automating calculations where possible, providing diagnostics, and documenting recent changes.

<Pull-Down Menu Index>a                      <Main Help Menu>   

ABOUT THE HELP

Typographical Conventions

Keystrokes or special keys that you must press are shown in boldface.

For many commands, the levels in the pull-down menu are separated by a "/". For example, File / New represents the command File followed by the command New.

Symbols similar to these appear throughout the help:

F1 represents function key F1.

Ctrl+N means hold the Ctrl key and press N.

Alt+F means hold the Alt key and press F.

Shift+F8 means hold the Shift key and press the function key F8.

Technical Support

If you have a question or problem that you cannot resolve, please contact Taxprep Technical Support.

For English Technical Support, call (416) 236-2466. For Bilingual Technical Support, call (416) 236-4392.

You may also fax your question to (416) 236-9162.

<Pull-Down Menu Index>a                      <Main Help Menu>   

GENERAL SCREEN LAYOUT

Throughout the Taxprep applications, the same general screen layout appears.

Menu Bar

Across the top of the screen is the menu bar. The menu bar lists the main commands available to you. Each main command has a pull-down menu*   containing more specific commands. To access the menu bar, press F10 or Alt.

When you press F10, the File function will be highlighted in reverse video. This reverse video portion is the highlight, or cursor. When you start the program, the menu bar is automatically active, and File is highlighted.

To exit from the menu bar, press Esc.

Help Line

Across the bottom of the screen is the help line. The help line lists some commands and hotkeys available to you, depending on where you are in the program.

The right side of the help line displays the time. The time is set by your computer, not by the program.

While the program performs commands, the time display may momentarily freeze. It will continue, with the correct time, when the command is finished.

Scroll Bars

Down the right side and across the bottom of most screens are the vertical and horizontal scroll bars. The thumb mark on a scroll bar (the small solid box) shows your relative position in a form that has more information than can fit on one screen.

Form Title, File Name and File Identifier

The current form name, the file name and the file identifier   appear at the top centre of the screen, separated by a colon.

<Pull-Down Menu Index>a                      <Main Help Menu>   

THE PULL-DOWN MENUS

You can invoke all the program commands from the pull-down menus. You access the pull-down menus from the menu bar.

Accessing

To access a pull-down menu:

 - activate the menu bar (press F10 or Alt).

 - highlight a main command on the menu bar with the left and right arrow keys or by typing the first letter of the command.

 - press <ENTER>.

The pull-down menu for that main command will then appear.

You can also access pull-down menus by holding the Alt key while you press the first letter of the main command on the menu bar.

Example:

There are three ways to access the Edit menu:

press F10 or Alt, press to highlight Edit, and press <ENTER>,press F10, and then press E; press Alt+E.

Choosing a Command

To access a specific command in a pull-down menu:

 - highlight the command with the up and down arrow keys.

 - press <ENTER>.

As well as using the arrow keys to move on the menu bar and the pull-down menus, you can access a command by pressing its highlighted letter.

If you choose a command that is followed by three periods, (e.g., File / Open..., View / Windows...), a dialog box then appears, where you make additional choices before the command is executed. If the command is not followed by three periods, the command is executed immediately.

Hotkeys

You can directly choose most commands in the pull-down menus with hotkeys or hotkey combinations. The hotkeys are displayed on the pull-down menus beside the command name. As you learn the hotkeys, you will find that their use can really speed up operating the program. A reference list of the commands and their hotkeys is in the Appendix.

Example:

To print a return, you can either press F10, then F, and then R, or just press the hotkey combination Ctrl+R.

Exiting a Menu

To return to the menu bar from a pull-down menu, press Esc.

Disabled Commands

Command names will occasionally appear shaded, with no letter highlighted, and the cursor will skip past them. These are disabled commands. Commands are disabled when they are not valid commands for a given situation. For example, when you start the program, many commands are disabled until you open or create a return.

<Pull-Down Menu Index>a                      <Main Help Menu>   

POINT AND CLICK MENUS

Overview

Selecting options within Taxprep is similar to pointing with a mouse and clicking the mouse button. The program provides every available option for you in its menus and lists, similar to Windows-based programs that use a mouse.

To select an option from a point and click menu:

 - highlight the option.

 - press [ENTER].

To highlight an option, you can either move the cursor with the arrow and Tab keys or use the input box as described below.

Point and click menus reduce the learning curve when you switch from keyboard to mouse, or vice versa, and reduce the number of keystrokes you must make. They also prevent typing errors, since all the valid choices are listed by the program.

Vertical Lists

When you select many commands within Taxprep, the program provides vertical lists of the available choices, such as returns or file paths. These lists operate as point and click menus. They also contain vertical scroll bars to show you your relative position within a list. Most dialog boxes contain such lists.

Horizontal Lists

Some screens list options horizontally. They work as point and click menus with one difference: you can select an item by highlighting it and then pressing the up or down arrow key.

Input Boxes

As well as listing the items in a vertical list, many screens display an input box when you move the cursor into a list. The title of the input box corresponds to the location of the cursor.

When an input box is on the screen, you can highlight a selection by typing in its name rather than moving the cursor. As you type, your keystrokes appear in the input box. At the same time, the program tries to match your keystrokes with one of the items in the list. If a match is found, that item is highlighted.

As with other parts of the interface, to select the highlighted item, press <ENTER>.

TIP

This can be very useful when there are many items in a list. If you know the name of the item, simply type in its name, rather than scrolling through a long list trying to find it.

<Pull-Down Menu Index>a                      <Main Help Menu>   

DIALOG BOXES

When you select many commands within Taxprep, the program displays a dialog box in the middle of the screen. This dialog box prompts you to enter information required to perform the command. Default answers are usually provided. Simply put, dialog boxes ask for more information so the program can correctly do what you want it to do.

Most dialog boxes contain point and click menus.

Moving

To move between lists or options, press Tab or Shift+Tab.

To select an option:

 - highlight the option.

 - press <ENTER>.

When you select an option, your choice will be underlined, bold, or in colour (depending on your monitor), or it will appear beside the title of the list.

Accepting

To accept the choices you have made in a dialog box:

 - highlight the Ok button.

 - press <ENTER>.

The function will then be performed and you will leave the dialog box, returning to the form you came from.

TIP

If there are many lists or options to move through, you can bypass them and accept your choices by pressing Ctrl+<ENTER>.

Cancelling

To cancel a command:

 - highlight the Cancel button.

 - press <ENTER>.

The program then ignores any choices you made while in the dialog box and returns you to the form you came from.

TIP

To cancel a function immediately, press Esc.

<Pull-Down Menu Index>a                      <Main Help Menu>   

THE FORMS MANAGER

The Forms Manager is a master list of the forms in the program. It also displays the current print format for each form. The Forms Manager is the focal point of the program, from where you select and move to forms, and perform many other functions.

When you first open or create a return after starting the program, you start at the Forms Manager.

While on the Forms Manager, the cursor (identified by the highlighted bar) will change size as you move between columns. The cursor's size equals the size of the column. The input box appears near the bottom of the screen only when the cursor is in certain columns.

Accessing

To access the Forms Manager, press F5. You can also access the Forms Manager with the Search / Jump to Schedule command.

You can also access the Forms Manager by pressing ESC. If you have used the Expand function, you will first return to the form you expanded from. Continue to press ESC to return to the Forms Manager.

Note: If you are using the Express Jumpht   feature, pressing F5 or selecting the Jump command will display the Jump Code dialog box. The forms Manager can be accessed from this dialog box by selecting the <Forms Mgr> button.

You can access the Forms Manager from any form within Taxprep or while in the pull-down menus. However, you cannot access the Forms Manager from a dialog box.

Columns

Depending on your Setup, the Forms Manager will have up to seven columns. Some columns may extend off the right side of the screen, while some columns may not appear at all.

The JumpCode column is always the first column. The jump codes9k   are unique to each form, and are used to move quickly between forms.

The Title column gives the Revenue Canada schedule number of the prescribed forms. For example, for corporate tax returns, the Reconciliation of Net Income is the T2S(1). Forms that are not prescribed have relevant titles such as Diagnostics and Help.

The Description column contains the name or description of the forms. Some descriptions are not actual forms, but are headers that identify a group of related forms. Headers are identified by a long dashed line.

The Applic column indicates which forms are applicable for the current return.

The Output  , Copies  , and Print   Columns display the current print format.

Moving Vertically

To move between lines of the Forms Manager, use the up and down arrow keys. To move one screen at a time, use the PgUp and PgDn keys.

To move to the top of the Forms Manager, press Home. To move to the end of the Forms Manager, press End.

As you move, the cursor highlights your position. As well, the thumb on the vertical scroll bar indicates your relative vertical position in the Forms Manager.

Moving Horizontally

To move between columns, use the left and right arrow keys or Tab and Shift+Tab.

The cursor will then move from column to column. As well, the thumb on the horizontal scroll bar displays your relative horizontal position within the Forms Manager.

If columns extend off the right side of your screen, simply press Tab until those columns appear. As you tab across, the first columns will be replaced by the other columns. However, the Jump Code column always appears on the Forms Manager as the first column on the left.

Mini Windows

When the cursor enters the Applic., Output, Copies or Print columns, a mini window will appear on the screen beside that column. This mini window shows the options available for that form for the particular column. You choose options as you would in any point and click menu.

To move up and down between rows of the Forms Manager while a mini window is displayed, use Ctrl+PgUp and Ctrl+PgDn.

Hiding Forms

Some forms (or headers) in the Forms Manager have a + symbol beside their jump code. This indicates that you can hide the forms associated with it. The titles of these associated forms are indented in the Title column for quick identification.

When forms are hidden, they do not appear on the Forms Manager for that particular return. If there are some forms that you won't use in a return, you may wish to hide them so you can move more quickly through the Forms Manager's comprehensive list.

To hide forms:

 - highlight the form that has the - symbol.

 - press F9.

The associated forms will no longer appear on the Forms Manager. Also, the program replaces the - symbol with a + symbol, indicating there are hidden forms.

Show Forms

To show hidden forms:

 - move the highlight onto the form with the + symbol.

 - press F9.

You must show hidden forms before you can access them.

Accessing Forms

You can access and display forms9k   in several ways from the Forms Manager. You can either move the cursor onto the form and press <ENTER>, or you can type the form's jump code, title, or description into the input box and press <ENTER>.

<Pull-Down Menu Index>a                      <Main Help Menu>   

Standard Forms

Standard forms include the prescribed tax forms, Taxprep-designed worksheets, and other forms.

When you are on a standard form, your location is indicated by the small flashing cursor (a thick, short underline). You move the cursor between cells on the form. See "Moving on a Form" for details.

In many standard forms within Taxprep, symbols identify special types of cells.

Updated Cells

An arrow beside a cell means that the amount in the cell updates from another form.

Calculated Cells

A c symbol beside a cell means that the amount in the cell is calculated by the program automatically.

Override Cells

A << symbol beside a cell means that the cell has been overridden. You can override updated cells and calculated cells.

To override a cell, enter information into an updated or calculated cell as you would any regular input cell. When you press <ENTER>, a dialog box will then ask if you want to override the cell.

To remove an override, place the cursor in the overridden cell, and press Ctrl+U. You can also use the Edit / Remove Override command.

Roll Forward Cells

A u symbol beside a cell means that the contents of the cell update from a prior year. Data will only appear in roll forward cells if you used the Roll Forward command on the previous year's return.

Cell with an Inverted Triangle

In certain forms you will see an inverted triangle next to a cell. The triangle is a prompt to press F9 to display a small menu of cell input values. Use the [Tab] or arrow keys and press [Enter] to select a value.



<Pull-Down Menu Index>a                      <Main Help Menu>   

ACCESSING RETURNS

Creating a New Return

To create a new return, use the File / New command or the Ctrl+N hotkey.

A new file is immediately given a temporary name (untitle1, untitle2, and so on). You must provide an actual filename (and the storage location) when you save a return.

Opening a Return

To open an existing return, use the File / Open... command or the Ctrl+O hotkey.

When you select File / Open..., a dialog box appears. In this dialog box, you select the location of the file (the file path) and the particular data file name.

Opening Returns with Identical Names

When you choose File / Open, only returns which are not currently open are listed. The program will not list returns in other subdirectories with the same name as a return already open. This prevents you from accidentally overwriting your returns.

If you want to open a file of the same name, you must close the first one. If you want both returns open at once, you will have to save one of them under a different name using the File / Save As command.

File Path

You can open a file from any available file path. The program defaults the file path to the one that appears under the Configure / File Path... command. However, you may change the file path to open a file without disturbing the configured file path.

All available file paths are displayed in the dialog box, including network file paths.

Data Files

All Taxprep III data files in the current file path are shown in the dialog box. The list of files is sorted alphabetically. If you change the file path, the data files in the new file path will appear.

When you highlight a data file name, the identifying field   for that data file appears in the dialog box.

Example:

In Corporate Taxprep, the identifying field is the name of the corporation.

Return Status

Below the client's name and SIN # is the Return Status. Return Status can be set for individual returns using Options / Set Return Status. A return can be set for: In Progress, Waiting, Review, Ready, Printed, and Complete. Return Status information is provided solely for the benefit of the preparer. A Return's Status will not affect or limit any operation performed on the return. For example, a return set for Printed can be reprinted at any time.

Express Openht 
When the Express Open feature is used, the dialog box does not display the sorted list of files or the list of available file paths. To use this feature, you must know the name of the data file and it must reside in the current data directory.



<Pull-Down Menu Index>a                      <Main Help Menu>   

MOVING ON A FORM

As with many features of Taxprep III, you can move around on the forms in several ways. Your position is always tracked by the cursor (the small thick flashing underline).

Input Cells

To move to the next cell that accepts input, press <ENTER>.

You can move this way between numeric or text input cells, and override cells. The cursor will skip past other cells (since they do not accept input). The cursor will move to the input cell to the right (if there is one) before moving down to the next cell below.

To move back to the previous input or override cell, press F4.

Any Cells

To move to the next or previous cell of any type, use the arrow keys.

Through a Form

 - PG;To move one screen at a time, use the PgUp and PgDn keys. The last line on the current screen will be at the top of the next screen after you press PgDn.

 - HOME;To move to the first line of a form, press Home. To move to the last line of a form, press End.

 - F8;Line by Line

You can also scroll up and down a form, leaving the cursor stationary.

To advance the form one line at a time towards the bottom of the form, press F8. To move the form one line at a time back towards the top, press Shift+F8.

The cursor will remain in the same cell, while the form will move.

Sectional Jumps

While in a form with multiple sections, pressing Ctrl+PgUp or Ctrl+PgDn will move your cursor to a new section. Sections begin where their titles have been bolded.



<Pull-Down Menu Index>a                      <Main Help Menu>   

MOVING BETWEEN FORMS

Forms Manager

The forms manager is the focal point of Taxprep III, and is the best place to start from if you need to move to a form.

To move to a form:

 - press F5 (or use the Search / Jump to Schedule command).

 - highlight the form in the Jump Code, Title, or Description column.

 - press <ENTER>.

The form will then appear on your screen.

Remember that to highlight a form you can either move the cursor with the Tab and arrow keys, or use the input box.

Choosing a Form with the Input Box

Suppose you know a form's title, but don't know its jump code. Then you can move the cursor into the Title column and type in the government form number to highlight it. If you knew the description of a form but neither its title or jump code, you should move the cursor into the Description column and begin typing the description. If you still can't find the form, you would scroll through the list of forms until you see it.

The Forms Manager's input boxes ignore brackets, dashes, and other special characters. For example, to highlight the T2S(8) in the Title column of Corporate Taxprep, instead of typing T2S(8), just type T2S8.

You can input at most 10 characters into the Description column's input box. The program will stop matching after 10 characters.

Jump Codes

As you become more experienced with Taxprep, you will learn the jump codes and use them often to move between forms. This is because using jump codes requires the least number of keystrokes.

For example, if you are on some form and need to move to the jacket, you can get there with only three keystrokes: F5, J, <ENTER>.

Express Jump

Once you know the jump codes, you may find it even easier to use the Express Jumpht  feature. When Express Jump is on, the Forms Manager is not automatically displayed when the Jump command is selected. You cannot, therefore, locate the form on the Forms Manager by entering only part of the jump code. The entire jump code must be entered in the Express Jump dialog box.

Last Form

Taxprep provides you with a simple method of toggling, or reversing a jump, between two forms.

If you have more than one return open, this command will take you to the last form displayed regardless of which return you were in.

Example:

Suppose you have the returns for both spouses open in Personal Taxprep. You access the T1 jacket of one spouse, then switch to the other spouse and access Schedule 2. If you press F6, the program will return you to the T1 jacket of the first spouse.

To move to the last form displayed, press F6.

You can also use the Search / Last Form command from the pull-down menus.

Expanding

Another way of moving between some forms is with the Expand command. This allows you to move from one form to another without first going to the Forms Manager. You can expand from any updated cell (a cell with a  symbol beside it) to display that cell's source form.

To expand from an updated cell:

 - move the cursor into the updated cell.

 - press F9.

You can also use the Search / Expand command.

Undoing an Expand

To return to the form you expanded from, press Esc.

If you have used several expands to move through a return, the Esc key allows you to retrace your steps through each form you accessed.

Example:

Suppose you are using Corporate Taxprep and you access the T2 Jacket. From there you expand to the T2S(1), and from there you expand to the T2S(8).

If you now press Esc, you will move back to the T2S(1). Press Esc again and you will move back to the T2 Jacket.

Next Applicable Form

Whenever forms are marked with a Y or an * in the Applic. column of the Forms Manager, you can use the Search / Next Applicable Form command to move to the next marked form. The forms will be accessed in the order they appear in the Forms Manager. This allows you to process every applicable form for a return without the chance of missing any.

You can also use the Ctrl+G hotkey to move to the next applicable form.

If you jump to another form using F5, and then choose Next Applicable Form again, the program will pick up where you left off (i.e., you will move to the form that follows the one you jumped from).

<Pull-Down Menu Index>a                      <Main Help Menu>   

INPUT CONVENTIONS

Entering Data

To enter data in a cell (numeric or text), type in the numbers or characters and press <ENTER>.

Until you press <ENTER>, you may change the information you have typed by backspacing or by using the arrow keys within the cell.

TIP

You can also type in the data and then press the up or down arrow key. The program will accept the data and move to the next or previous cell.

Negative Numbers

To enter a negative number, precede your numbers with a minus sign.

Dollars and Cents

Personal Taxprep displays amounts to the nearest cent. Corporate Taxprep displays amounts to the nearest dollar.

Do not enter $, , or , symbols in numeric cells.

To enter cents, precede the amount of cents with a period (a decimal point). If you enter only one digit after the decimal point, the program will assume a zero for the second digit. If you don't enter a decimal point, the program will assume all of the digits represent whole dollars.

Example:

To enter the amount $1,214.55, type 1214.55 <ENTER>.

To enter the amount $1,214.50, type 1214.5 <ENTER>.

To enter the amount (1,200.00), type -1200 <ENTER>.

Corporate Taxprep ignores decimal points and decimal values unless the cell represents a percentage.

Large Numbers

The program automatically inserts commas so you can easily read thousands, millions, and so on. If you enter very large numbers, the program will not show commas so the number will fit in the cell.

Dates

Dates are shown in the format DD-MM-YY unless otherwise required by the applicable government form. You must enter them in the format that is shown in the cell.

You only need to enter the correct digits that correspond to the day, month, and year. The program automatically adds the dashes.

Taxprep will only accept valid dates.

Deleting Dates

To delete a date from a date cell, use the Edit / Clear command.

Yes/No

Where there is a question that requires an answer of Yes or No, you must enter Y or N. You may enter it in lower or upper case. The program automatically converts it to upper case.

Defaults

Taxprep often provides a default answer to a question (or a default amount or date). The answer defaults to the most likely response, but will not be correct for every return. You must review all the defaulted answers to ensure they are correct for your return.

Edit Checks

A number of cells have edit checks associated with them to ensure that the data you enter is valid (for example, the province of self-employment cell in the T1 jacket). If you wish to remove a value from one of these cells and a zero or a blank is not a valid entry, use the Edit / Clear command.

<Pull-Down Menu Index>a                      <Main Help Menu>   

EDITING INPUT

The Cut, Copy, Clear, and Paste commands allow you to delete, copy, or move information within a form, from one form to another, or between returns.

You can cut, copy, clear, and paste individual cells, a selection of cells, or entire forms. The selected cells can be all in one form or across multiple forms.

Selecting Data

To use the Cut, Copy, or Clear commands, you must first select the cells that you wish to edit.

Selecting One Cell

If you wish to Cut, Copy, or Clear just one cell, select that cell by simply moving the cursor into it. Then you can choose the Cut, Copy, or Clear commands.

Selecting Multiple Cells

To Cut, Copy, or Clear several cells at once, you must first select the cells with the Edit / Select Specific Cells command, the Edit / Select Entire Form command.

To edit part of a form (e.g., the cells for an address) choose Edit / Select Specific Cells (or press F7). Then move the cursor to each cell you wish to select and press the Insert key. Each cell that you select in this way will be marked with a flashing symbol. To unselect a cell (and remove the symbol), press the Insert key again on that cell.

To select every cell in a form, choose Edit / Select Entire Form while in that form. Every cell in the form will then be marked with the flashing symbol. The hotkey to select an entire form is Ctrl+F7.

Selection Complete

After selecting the cells, you can then choose the appropriate command: Cut, Copy, or Clear. The symbols will disappear afterwards.

If you decide not to cut, copy, or clear the data, you must use the Edit / Cancel Selection command to exit from edit mode. The hotkey to cancel the selection is F7.

Cut

To cut the selected cells, choose the Edit / Cut command. The selected information is then deleted from the form and copied into the clipboard.

The hotkey to cut data is Ctrl+X.

Copy

To copy the selected cells, choose the Edit / Copy command. The selected information is then copied into the clipboard.

The hotkey to copy data is Ctrl+C.

Clear

To delete the selected cells, choose the Edit / Clear command. This command does not affect the clipboard.

The hotkey to clear data is Ctrl+B.

The Clipboard

The clipboard is a file that temporarily stores information that has been cut or copied. The information in the clipboard stays there until you cut or copy another selection of cells (when it is replaced by the new information), or until you quit from the program.

Paste

To insert the contents of the clipboard  into a form, choose the Edit / Paste command. You must position the cursor in the first cell of the location where you wish to insert the data.

The hotkey to paste data is Ctrl+V.

Pasting Mismatched Data

When you paste data, the layout of the cells in the new location must match the layout of the cells in the original location. Text may be truncated if the target cell is not as long as the source cell.

Summary

To move data from one location to another, use Cut and Paste.

To duplicate data in another location, use Copy and Paste.

To delete data, use Clear.

Undo

The Undo command is not implemented in this version.

<Pull-Down Menu Index>a                      <Main Help Menu>   

EDITING INPUT: TUTORIAL

Copying an entire form's data from one return to another.

1.  Enter the data in the form.

2.  Select the form by pressing Ctrl+F7.

3.  Copy the data to the clipboard by pressing Ctrl+C.

4.  Open the other return by pressing Ctrl+O, and access the same form.

5.  Paste the data by pressing Ctrl+V.

Repeat steps 4 and 5 for each additional return that requires the same data in the form.

Application

Some of the common forms that you may need to copy between returns are:

 - business schedules for a partnership.

 - T2S(9) or T2013 for a corporate group.

 - your own attached schedules.

TIP

In Personal Taxprep, spousal coupling can be used to automatically transfer business and farm statements, rental schedules, T5 slips, etc. between spouses. Consult the Personal Taxprep Application Guide for more information on coupling.

<Pull-Down Menu Index>a                      <Main Help Menu>   

SETTING APPLICABLE FORMS

Applicable

The Applicable Column (Applic) in the Forms Manager indicates the forms that you should file with the current return.

Set Automatically

As you enter information into a return, the program automatically determines which forms are applicable. The program places an * in the Applicable column for each form that it determines to be necessary.

Some forms are always set to be applicable (e.g. diagnostics, federal jacket, keypunch summary). Forms flagged as applicable, however, will only print if there is a "Y" in the Print column  .

Set Manually

You may manually pre-select which schedules will be applicable for a return before entering any data in the return. You could use this to help an inexperienced preparer complete a return using the Next Applicable Form command.

To set applicable forms manually, move the Active Field to the form you wish to select and then Tab across to the Applic column. A mini window will appear with the options Yes and No. To set that form as applicable, select Yes. The program then places a Y in the Applicable Column for that form.

If you set a form as applicable, and the program subsequently also determines it is applicable (e.g., after you enter data in the return), the program will replace the Y with an *.

<Pull-Down Menu Index>a                      <Main Help Menu>   

Attaching Your Own Forms

You can attach a schedule or a note to any input cell to support the data in the cell. This is useful to provide more detailed information than the form allows, or to explain an unusual amount or entry.

There are two types of attached schedules: forms with totals and simple notes.

Forms with Totals

Attached forms with totals have a title area and two columns: one for text and one for numbers.

The total of the numeric column will update the cell the schedule is attached to.

Forms with totals should only be attached to numeric cells.

Simple Notes

Simple notes have no numeric column. They are used to provide additional text for a description.

The Attach Command

To attach a schedule or note to a cell:

 - place the cursor in the cell.

 - select the Edit / Attach command.

A dialog box will appear on your screen. Select either a form with a total of a simple note. Additional types of attachments will be available in future versions.

A second dialog box will then appear, where you give a description for the attached schedule.

A special symbol will appear beside the cell, indicating there is an attached schedule. The attached schedule also appears at the bottom of the Forms Manager, with the title and description that you have given it.

Accessing

Once an attached schedule has been created, it can either be accessed directly from the cell it was attached to, or from the Forms Manager.

To access an attached schedule from its cell:

 - move the cursor into the cell marked with the  symbol.

 - press F9.

Cell Value

When you attach a schedule to a cell, edit checks that that program would normally make (e.g., is the input a positive number?) are bypassed. You must therefore make sure that the total of the attached schedule is a valid input for that cell.

Do not attach a schedule to a date cell.

Printing Attached Schedules

Attached schedules will be printed with the form to which it is attached.

Removing Attached Schedules

You can un-attach a schedule from a cell by moving the cursor into the cell and choosing Edit / Remove Attached Schedule. The attached schedule will be removed from the Forms Manager. The total from the attached schedule will remain in that cell.

Master Attached Schedules

The first schedule with totals (jump code ATTS) and the first attached note (jump code ATTN) which appear at the bottom of the Forms Manager are master forms. All other attached schedules are created from these two masters. Do no enter information into these master forms unless you wish that information to appear in all subsequently created attached schedules.

Unattached Schedules

Schedules have been provided at the bottom of the Forms Manager which are not attached to any specific form. These schedules can only be accessed from the Forms Manager. An unattached schedule will be automatically flagged as Applicable whenever information is entered into it.

<Pull-Down Menu Index>a                      <Main Help Menu>   

COMPLETING A RETURN

Saving the First Time

To save a file for the first time, select the File / Save command or the Ctrl+S hotkey.

The program will recognize that the file hasn't been saved before, and will display the Save As... dialog box. You must then provide a File Name. You can also select a file path other than the default data file path if you wish.

The dialog box also displays the identifying field. You may change this field to whatever you wish. This identifying field will be displayed in the Open File dialog box to help you identify particular returns.

File Names

You must give all your files unique names. The program will warn you if you give a duplicate name that would overwrite an existing data file.

Do not enter file name extensionsǖ . Taxprep automatically gives your files an extension, depending on the application.

Saving Files

To save a file, use the File / Save command or the Ctrl+S hotkey.

If you save a file after you have already given the file a name and location (i.e., if you saved the file at any prior time), the program will automatically save the file with the same name to the same location.

Save As

If you wish to save a file with a different name or identifying field, or save a file in another drive or subdirectory, use the File / Save As... command.

The program will then prompt you to select a new name and drive or subdirectory. Note that the previously-named file will still exist.

This command is useful for what-if planning, keeping backup files, and so on.

If you wish to change the identifier field for a file, you must use the File / Save As... command.

Closing Files

If you are finished with a particular data file and want to exit from that file but still want to remain in the program, choose the File / Close command. You can also use the Ctrl+W hotkey to close a file. If you have changed the return but haven't saved those changes, the program will ask you if you want to save it.

You will probably use File / Close command only when you have multiple returns,  loaded in memory. Note that you don't have to close a file to open or create another one.

Exiting

To exit from Taxprep, use the File / Quit command or the Ctrl+Q hotkey.

If you choose to exit when files are open, the program will automatically close the files. If you haven't saved any open files, you will be asked if you wish to save them before they are closed.

<Pull-Down Menu Index>a                      <Main Help Menu>   

PRINTING FORMS

To print a form that is currently displayed on the screen, use the File / Print Form command. You can also use the Ctrl+P hotkey.

No Restrictions

When you use Print Form, the form will print even if the Applicable column or Print column in the Forms Manager contains an N.

Type of Output

The form will print according to the type of output currently displayed in the Forms Manager (e.g., pre-printed, laser facsimile, plain paper, or letter). If you want to print a different type of output, you must change this selection in the Forms Manager.

Printer and Printer Port

You can select the printer port you wish to use in the Print Form dialog box.  You can also change the printer type by selecting Printer
c .

Copies

If you are using the Print Form command, you do not have to modify the Forms Manager to get multiple copies of that form. Simply enter the number of copies you desire in the Print Form dialog box.

Using Print Form

Print Form is most useful when you require printouts of only one or two forms in the return. For example, if you make a last minute change to a form that does not affect any of the return's calculations, you could simply print that one form rather than reprinting the whole return.

<Pull-Down Menu Index>a                      <Main Help Menu>   

PRINTING RETURNS

To print the entire current tax return, use the File / Print Return command. The hotkey combination is Ctrl+R.

You must be on the Forms Manager to use the Print Return command.

What Gets Printed

Each applicable form in the return (i.e., those forms with a "*" or "Y" in the Applicable column) will print as long as there is a corresponding "When Applicable" in the Print column. If you do not want a form to print, even if applicable (e.g., diagnostics), choose "Never" in the Print column of the Forms Manager. If you want a form to always print, regardless of the Applicable column's setting, select "Always" in the Print column.

Type of Output

As with the Print Form command, each form will print according to the type of output currently displayed in the Forms Manager (e.g., pre-printed, laser facsimile, plain paper or letter). To change the type of output, you must change the selection in the Forms Manager.

When you move the cursor into the Output column, a mini window will appear showing the choices for that form. Only the valid output choices for that form will appear (see the section "Output Types").

Copies

The Copies column of the Forms Manager shows how many copies of that specific form will print. If you request multiple copies of each form, they will not be sorted. For example, if you set the print of Schedule 1 for three copies, and Schedule 2 for three copies, you will get three copies of Schedule 1 followed by three copies of Schedule 2.

If you want more than one copy of the entire return, set the number of copies in the Print Return Dialog Box to more than one. This will produce sorted copies of the return.

Print Options

Depending on the application, special print options may be available. For example, in the production version of Personal Taxprep, you can choose to print returns in EFILE format. For more information, see the Application Guide.

Printers and Printer Ports

You can change the printer ports or printers by selecting Ports in the Print Return dialog box. You can also select them prior to printing using the Configure / Port/Printer...
c  command. The most recent selection will be used.

Saving Your Changes

If you have changed any of the above options (printers, ports, output, copies, or form inclusion), and you wish the changes to be in effect the next time you run the program, choose Configure / Save Print Format. See Print Formats for more information.

TIP

If you find yourself constantly switching back and form between different print formats, you may find it easier to print your returns using the Print Batch command.

<Pull-Down Menu Index>a                      <Main Help Menu>   

PRINT FORMATS

Overview

Print formats contain all the information on how your returns will print. Print formats contain:

- the output type (e.g., plain, pre-printed) for each form.

- the number of copies of each form.

- the choice of printing or not printing a form (i.e., a Y or N in the Print column) if it is applicable.

- the printer port for each output type (plain, pre-printed, laser or letter).

- the type of printer for each output type.

The settings you make in the Output, Copies, and Print columns of the Forms Manager and the Configure / Ports/Printer... command combine to make up a print format.

The print format is a "global" setting: the currently loaded print format applies to the printouts of every return.

For example, if you load a certain print format and subsequently open and print five different returns, every one of those returns will print in the same print format.

Print formats are stored independently of your returns. Several pre-defined print formats are provided with the program, which you can modify to create your own print formats. Each print format has a unique name and an identifying field.

Multiple Print Formats

Depending on your needs, one common print format may be all you need to print your returns. You may not have any need to set up multiple print formats. However, the flexibility of this feature does allow you to create complex print formats.

See the Tutorial in the next section for some examples on setting up multiple print formats.

Default

When you start the program for the first time after installing it, the program automatically loads the print format called FULL (this pre-defined print format sets all forms to print on plain paper).

When you start the program subsequently, the program loads the print format in use the last time you saved the configuration. If you want the program to always load a specific print format, load that format and choose Configure / Save Configuration.

TIP

On a network you can customize each user's configuration to default to a specific print format.

Loading

At any time, you can load a different print format. To load a print format, choose the Configure / Load Print Format... command and select one of the print formats from the list.

If you change print settings and then load a different print format, you will be asked if you want to save those changes.

There are several pre-defined print formats that you can load from the list (a description of each appears in the Appendix). If you save your own print formats, they will appear in the list too.

Changing

When you change any print format setting, the print format remains changed that way until you load another print format or quit from the program. In either case, the program will ask you if you want to save your changes to the print format.

Creating

To create your own print formats, modify the settings for the current print format and save it under a new name. Be sure to type in a new description in the identifying field.

Saving

If you have made changes to the Forms Manager columns (other than the Applicable column) or to the selected ports or printers, you must save the  settings if you want them to be in effect the next time you run the program. To save the print format use the Configure / Save Print Format... command.

File Names

When you choose the Configure / Save Print Format... command, the dialog box displays the name of the current print format. If you always use a single print format, save the print format with the same name. However, if you want to keep the old format and save your changes as a new print format, enter a new name (and a new description).

Format names can be up to eight characters long. Do not enter an extension. The program adds the extension .FMT automatically.

Identifying Field

Print format files have identifying fields just like returns. Enter a clear description of the print format so you and other users can quickly identify which print format to load.

To avoid having the same description for different print formats, type in a new description when you save a print format.

Print Formats - Tutorial

Selecting Laser Facsimiles

This example illustrates how you can use print formats in different ways to get the same result. The method you use will depend on the kind of printer you have and if  you plan to use more than one print format (see below for reasons to use more than one print format).

You can change your print format to always include laser facsimiles in three ways:

Method 1: Modify the default print format FULL.

Load the print format FULL. Change the output on the Forms Manager to be laser instead of plain where applicable. Save your changes by selecting Configure / Save Print Format...

Method 2: Use the print format FINAL.

Load the print format FINAL.

In this print format, the applicable laser facsimiles are already selected. The printer selected is the HP LaserJet Series II or compatible.

If you are printing with a different laser printer, select the appropriate printer with the Configure / Port/Printer... command. Then save your print format settings with the Configure / Save Print Format... command.

If you want to automatically load the print format FINAL when you start the program, select Configure / Save Configuration.

Method 3: Create your own print format.

To create your own print format, start by loading either FULL or FINAL. If you are using an HP LaserJet Series II or compatible, it will be simpler to start with FINAL. Make the necessary changes to output and printer selection. Select Configure / Save Print Format..., even if you haven't changed anything. Enter a new name and identifying field for the new print format, tab to OK, and press ENTER.

To default to your new print format when you start the program, select Configure / Save Configuration.

Application

Print formats allow you to set up and save many alternate print settings. You would need several print formats in the following circumstances:

- Multiple Network Printers - If you have network printers of different types, use print formats to define the type and printer port.

- Multiple Local Printers - If you use a switch box to switch between printers of different types, use print formats to define the settings for each printer.

- Draft vs. Final - You can save different print formats to include different forms (e.g., client letter), or to use different output types (e.g., laser) in your draft and final return printouts.

- Special Batches - If you regularly print certain forms in a separate batch (e.g., pre-printed forms), you can define a print format for each batch.

When using multiple print formats, be sure to use the identifier field to describe your print formats.

Note:

Do not confuse Save Print Format and Save Configuration.

Save Print Format saves changes to the Output, Copies, and Print columns as well as the printer and port.

Save Configuration records which print format you will start with when you next start the program (as well as colour, file path, and so on).

<Pull-Down Menu Index>a                      <Main Help Menu>   

BATCH PRINTING

To print several returns at once, use the File / Print Batch... command. You can also use the F2 hotkey.

Closing Files

All returns must be closed when batch printing. When you select the File / Print Batch... command, the program will ask you to confirm before automatically closing all open files. You may cancel your batch request at this point. As well, the program will prompt you to save any files that have been altered.

Then the program will display the Batch Print dialog box.

Selecting Returns

To select a return for the batch print, first move the cursor into the Path column and choose the file path that contains the return.

When you choose a file path, all eligible files in that path will list under the Return column.

To select a return, move the cursor into the Return column, highlight the return you wish to select, and press the Insert key.

When you press Insert, that return will also appear in the Batched column.

Select All

The option Select All will select all of the returns in the directory for printing.

Unselecting Returns

To unselect a return for the batch print, move the cursor into the Batched column, highlight the return you wish to unselect, and press the Delete key.

When you press Delete, that return will disappear from the Batched column.

Print Format

You may choose any available print format for the batch print. Once you have selected the format you wish to use, you can customize it for your ports and printer if you have not already done so. However, the choice of output and what forms will print must be made prior to batch printing.

All the returns that you print in batch will print with the same print format.

Select Ports to change printer ports or printer types. If you wish to retain the changes, select Configure / Save Print Format when the batch print is complete.

The print format chosen for batch printing becomes the current format for any subsequent returns opened.

Cancelling Batch Printing

If you cancel the batch printing, your list of returns to include will not be saved (this will be added in a future version).

<Pull-Down Menu Index>a                      <Main Help Menu>   

TYPE OF OUTPUT

The Output column in the Forms Manager shows the kind of printout for each form in the current print format. The options are Plain, Pre-printed, Laser Facsimile and Letter.

When you move the cursor into the Output column, a mini window will appear showing the choices for that form. Only the relevant output choices for that form will appear.

Plain

The Plain paper option is for standard 8 1/2" x 11" paper on either a dot matrix or laser printer. Where applicable the format has been approved by the appropriate government body. In the few cases where the government does not accept a plain paper version of a specific form, a disclaimer will be printed at the top of the printout.

All forms have the plain paper option.

Pre-printed

The Pre-printed^%  option is for special continuous-feed pre-printed forms for dot matrix printers. Depending on the application and the form, this paper may be available free of charge from the government or must be purchased from a Taxprep/Informatrix office. Please refer to the Application Guide for more information.

Laser

The Laser Facsimile   option is for use on standard 8 1/2" x 11" paper with a laser printer that uses special fonts. This option generates a high-quality printout.

Letter

Note: the letter option is not available in this version.

The letter option is only available on certain non-prescribed forms. Choose this option if you wish the form to be printed on special paper (e.g., company letterhead). The standard header which prints at the top of all forms (e.g., taxpayer name and account number) can be suppressed on letters. You can also configure your letters to start printing a specific number of lines from the top of the form to allow for letterhead.

If you are printing letters and plain paper forms to the same printer, the program will pause after the plain paper print to allow you to change paper before proceeding with the letters.

<Pull-Down Menu Index>a                      <Main Help Menu>   



            Downloading Laser Forms

            About Downloading Laser Forms  
            List Boxes)  
            Selecting FormsK  
            Send*  
            Cancelǂ  
            Test  
            When to use Sendǔ  
            Assume Downloaded  
            Networks 
            Download Size 
            Facsimiles Not Resident	 
            Resident Pages Lost from Printer Memory
 
            Macro Number
 
                <Main Help Menu>   

About Downloading Laser Forms

Configure / Download forms is allows you to send laser facsimile forms to the printer and have them remain resident in the printer's memory.

Versions before 92.2 have always sent the facsimile data (that is, the information on how to "draw" the form) and a form's cells data each time a laser form was printed. Print out time is significantly decreased by maintaining a form's laser facsimile data in printer memory and having Personal Taxprep simply send the cell data.

Because of the volatile nature of printer memory and the fact that a the cell data have to be matched up with the proper form in the printer memory, the process is more complicated than simply sending the two together.

Three main steps are involved in having the facsimiles printer resident:

1. Select the forms and/or the individual pages you wish printer resident.

2. Send the facsimile data to the printer at "the beginning of the day".

3. Enable Assume Downloaded from Configure / Change features.

Steps 1 and 3, in general, have to be done only once as Personal Taxprep will save this information like any other change performed from the Configure menu. Step 2 is, at minimum, a daily task. See "When to Use Send" later in this section.

    <Facsimile Printing>          <Main Help Menu>   

List Boxes

The Form list box displays all the forms that have laser facsimiles. The Page list box displays all the possible pages that make up the form. The Selected page list box displays the pages selected for each form.

    <Facsimile Printing>          <Main Help Menu>   

Selecting Forms

If you want all of the form's pages to remain resident in the printer, highlight the form in the Form list box and press [Enter].

If you do not want the entire form but only certain pages, move to the Page list box, highlight a page and press [Enter] to select it.

If you include a page by mistake, you can remove it by highlighting the page in the Selected page list box and pressing [Enter].

    <Facsimile Printing>          <Main Help Menu>   

Send

Once you have selected all the desired pages, [Tab] to Send and press [Enter]. The pages will be sent to the printer via the laser form port indicated under Configure / Port/Printer.

After using Send, the selected pages are saved in a configuration file called _T1DOWN.CFG. Each time Personal Taxprep is loaded, this file is loaded as well. Personal Taxprep will not, however, automatically download these forms to the printer. You have to use Send each time you run Personal Taxprep (see "When to use Send" on the next page).

    <Facsimile Printing>          <Main Help Menu>   

Cancel

Cancel will only cancel whatever changes you have made since the last time you selected Send. If you have already used Send to download form information to the printer, Cancel will not remove the resident information. Turning your printer off and waiting approximately ten second before you turn it on should clear its memory.

    <Facsimile Printing>          <Main Help Menu>   

Test

You can use Test at any time to ensure a selected page is still printer resident. Highlight the desired form and page and then [Tab] to Test. The correct page should output if it is still resident. If the page is not printed correctly, you should re-download the contents of the Selected page list box with Send.

    <Facsimile Printing>          <Main Help Menu>   

When to use Send

Below are the three most likely times you will have to use Configure / Download forms / Send, although you may encounter other circumstances that require you to use it.

Beginning of the day.

Although the program loads the configuration file containing the pages you have selected, it will not automatically download the selected facsimiles' data to the printer. You should do this immediately, with Send, after loading the program at the beginning of the day.

Printer on/off.

If the printer has been turned off and on for any reason after using Send, you will have to download the facsimiles again.

Printer used by another application.

If another application (e.g., a word processing program) has used the printer, you might have to download the facsimiles again.

    <Facsimile Printing>          <Main Help Menu>   

Assume Downloaded

Enabling Assume Downloaded (under Configure / Change features) tells Personal Taxprep to use the facsimile data downloaded to the printer via Configure / Download forms / Send.

If Assume Downloaded HAS NOT BEEN ENABLED, Personal Taxprep will download the same facsimile data each time it prints.

If Assume Downloaded HAS BEEN ENABLED and Configure / Download forms / Send HAS NOT BEEN used prior to printing, Personal Taxprep will download the same facsimile data each time it prints. However, the outputted page might be missing the bullets that Revenue Canada requires for keying in the return.

Hence, output time can only be minimized by using Configure / Download forms / Send and enabling Assume Downloaded.

    <Facsimile Printing>          <Main Help Menu>   

Networks

The network administrator should ensure all workstations are configured for Assume Downloaded and that only one computer (any computer connected to the network) actually downloads the facsimiles to the printer. Individual workstations have to create identical _T1DOWN.CFG files (i.e., use Configure / Download forms ) or have access to a common _T1DOWN.CFG file.

    <Facsimile Printing>          <Main Help Menu>   

Download Size

Configure / Download forms maintains a cumulative estimate of the printer memory required for your resident pages. The figure displayed next to "Total size of items to be downloaded:" is only an approximation. The actual size can be higher in a few cases but, in most instances, should be smaller.

In most cases it is not necessary to download every form and page to the printer. You should determine, based on your printer's memory and client base, what is the optimum number and kind of forms to download. For example, if the majority of your clients are Ontario residents, having facsimile data in your printer for other provinces won't improve output time by much. In fact, on printers with 512 K, it may increase your chances of a memory overflow error.

    <Facsimile Printing>          <Main Help Menu>   

Facsimiles Not Resident

If a facsimile's page (or pages) has not been downloaded via Send (i.e., has not been included in the _T1DOWN.CFG file), Personal Taxprep will detect this and download the correct data every time that page is encountered. Hence, you can add only the most often printed facsimiles to the configuration file (_T1DOWN.CFG) without fear that a less used page or form will print out blank.

    <Facsimile Printing>          <Main Help Menu>   

Resident Pages Lost from Printer Memory

If a page is part of the _T1DOWN.CFG file and somehow it gets removed from the printer's memory, Personal Taxprep will download the facsimile data every time the missing page is encountered in the print job (eliminating the time savings for the missing page). However, the outputted page might be missing the bullets that Revenue Canada requires for keying in the return. If this is the case, then Send should performed and the print job re-started.

    <Facsimile Printing>          <Main Help Menu>   

Macro Number

Each page is given an HP macro number. It is this macro that matches the return's cell data with the appropriate printer resident form. If conflicts occur with other programs (i.e., each program's printer download shares the same macro number), you can use the "Macro number for selected page:" field to change the page's macro number (valid numbers range between 1 and 999).

Do not duplicate a number already used by another page in your download list. Try selecting a number considerably higher or lower than the range your download list is covering. For example, if your download list seems to be using the 140 to 271 range, select a number between 800 and 900.



    <Facsimile Printing>          <Main Help Menu>   



FONTS

Approved Fonts

Revenue Canada has approved the use of either a san serif (e.g., Helvetica, Univers, Arial, Swiss) or serifed (e.g., Times Roman, CG Times, Dutch) font for filing. These fonts are memory resident in many laser printers (such as the HP LaserJet Series III, HP III compatibles, and postscript printers). Entry-level laser printers (usually billed as HP II compatible) and the older HP LaserJet Series II do not have these fonts resident in memory. The HP II and compatibles have only a "courier" font (which is employed whenever a form is set to Plain in the Forms Manager's Output column). Your printer manual should tell you which fonts are resident.

Download Fonts

If a serifed and/or san serif font does not reside in your printer's memory then you must download these fonts at some time (typically at the beginning of the day) before you print laser facsimiles.

Once downloaded, the fonts stay in the printer memory until you turn the printer off, or until some other fonts are downloaded which overwrite the Taxprep fonts.

The same fonts are used for both the Personal and Corporate Taxprep programs. Therefore, once you have downloaded the Taxprep laser fonts, you do not need to download again regardless of which program you are using.

Downloading Fonts

Taxprep has supplied a downloading utility (as well as approved fonts) with the laser facsimile disk. To download the fonts, ensure that your printer is properly connected and on-line (if you are on a LAN, you must issue the CAPTURE command), then access the subdirectory in which the program is stored and type FONTS [Enter].

Removing Fonts

If you download fonts more than once in succession, some fonts may be lost from the printer's memory. If you need to download fonts again, or if you are unsure if the fonts were already downloaded, you should first remove any existing fonts before downloading.

To remove the fonts from the printer's memory, either turn the printer off or access the subdirectory in which the program is stored and type FREMOVE [Enter].

Using DL.EXE

You can also download and remove fonts using the DL.EXE program. Access the subdirectory in which the program is stored and type DL [Enter].

Printer Ports 2 and 3

The batch files FONTS.BAT and FREMOVE.BAT send or remove the fonts for printer port 1 only. If you need to send or remove fonts for printer port 2 or 3, use the DL.EXE program.

Cartridge Fonts

Taxprep III is not compatible with HP cartridge fonts. If you encounter problems with your download fonts, try removing the cartridge (make sure the printer is turned off) and re-downloading the fonts.

                <Main Help Menu>   

PRINTING TO A FILE

Selecting

You can print to a file by choosing FILE as your destination instead of a printer port in the Port/Printer dialog box or the Print Form dialog box. To ensure that the print file contains the correct escape sequences for your printer, you must also select the type of printer you will ultimately print the file with.

Print Form and Print Return

When the Print Form or Print Return commands are used, the program creates a separate file each time you print. The print file will have the same name as the data file but with the extension .P00. If use the print command a second time for the same return, a new print file will be created with the extension .P01, etc.

Batch Printing

When you batch print to a file, a single print file is created called BATCH.P00. If the file BATCH.P00 already exists in the directory, the program will call the file BATCH.P01, etc.

Location

Print files are created in the subdirectory being used for temporary files.

Printing the Files

To actually print the file (i.e., get a hard copy), you must send the print file to the printer. There are several ways to do this:

- Copy the file to the printer. At the DOS prompt, type COPY  "filename".P01  PRN. If you are on a local area network, you will have to capture before entering that command.

- Print the file with a text editing program. For example, you can load the print file into your text editor and use its normal print command.

- On a LAN, use the NPRINT command. Certain local area networks have a command NPRINT (or similar command) which you can use to send a file to a network printer.

Deleting Print Files

The program does not delete your print files. If you are using print files extensively, you should periodically delete old files from u=your directory.

Using Print Files

You may find print files useful in the following circumstances:

- With a print station: If your printer is connected to another computer and your computers are not networked, you can print files to a floppy disk, bring the disk to the print station, and print the file from there with the DOS COPY command. The benefit is that you don't have to load another copy of the program on the print station.

- If your printer is unavailable: If you are ready to print your return but your printer is unavailable, you may find it easier to print to a file now and send the file to the printer later, rather than restarting the program later and printing directly.

- In place of the CAPTURE command: On a local area network, you normally need to type a Capture command before printing to a network printer. Instead of capturing, you can print to a file and send the file to the printer later.

<Pull-Down Menu Index>a                      <Main Help Menu>   

USING PRE-PRINTED FORMS

Multiple Copies

The program will automatically print all copies of a given pre-printed form before proceeding with the rest of the print job. If you are using the batch print for multiple returns, the pre-printed forms for all returns selected will be printed first if there is more than one print type being sent to the same printer.

Example:

Suppose you are printing pre-printed T2 jackets and plain paper schedules to a single printer. The program will first print the pre-printed jackets for all of the returns selected. The program will then prompt you to change paper and signal when ready. It will then print sorted copies of the plain paper schedules for each return.

Aligning Forms

To use pre-printed forms, you must align the forms so the data prints in the correct place.

Aligning Taxprep Forms

Pre-printed forms purchased from Taxprep have five alignment boxes at the top of the form. When printing pre-printed forms, the Alignment Dialog box will display before printing.

If you select Test, XXX will be printed at the top of the form. If the XXX is not aligned properly in the box, adjust the paper and select Test again.  This time the XXX will be printed in the second box. Every time the alignment procedure is repeated, the next alignment box will be used. Once the XXX is properly aligned, select Done to print the form.

Aligning Government Forms

Continuous feed forms obtained from the federal or provincial government do not have alignment boxes. You must align the forms with reference to specific text on the form. Please refer to your Application Guide for details.

<Pull-Down Menu Index>a                      <Main Help Menu>   

Multiple Returns

Taxprep allows you to have more than one return loaded at the same time. This makes it easy to transfer data between related returns, allows you to work simultaneously on related returns, and helps in tax planning.

When several returns are open, the terms current return and active return are used. The current or active return is the return that currently accepts input.

Limitations

You can open or create as many returns as you like as long as you have sufficient disk space. If you run out of disk space, the program will not allow you to open or create any more returns without closing some of the returns already open or otherwise freeing up additional disk space.

Viewing Multiple Returns

If you have more than one return open, you can view each return separately or two at a time. To view returns two at a time, see the section Split Windows. To view returns sequentially, use the View / Next Return, View / Previous Return, or View / Choose Return... commands.

To view the next open return, use the View / Next Return command. You can also use the Ctrl+M hotkey.

To view the previous open return, use the View / Previous Return command. You can also use the Ctrl+J hotkey.

When you use either command, the current return on screen will be replaced by the next or previous return that was loaded into memory. The open return's name will then appear at the top of the window so you can keep track of which return is open.

If you have many returns open at once, it may be faster to go directly to a particular return rather than scrolling through them all with the Next or Previous Return commands. To make a particular file active, use the View / Choose Return... command. Taxprep will then list all the returns you have in memory. Simply select the one you wish to make active.

<Pull-Down Menu Index>a                      <Main Help Menu>   

SPECIAL WINDOWS

Profile Window

To display the Profile Window, use the View / Windows... command and select Profile.

The Profile Window will then display in the four lines above the help line. The profile window includes basic identification information about the current tax return, depending on the application you are using.

Example:

In Corporate Taxprep, the profile window displays the corporation name, year end, and so on.

Monitor Window

To display the monitor window, use the View / Windows... command and select Monitor.

The Monitor Window will then display in the four lines above the help line. The Monitor Window includes key tax information about the current tax return, depending on the application you are using.

Closing the Special Windows

To close either the Profile or Monitor windows, use the View / Windows... command and select Normal.

<Pull-Down Menu Index>a                      <Main Help Menu>   

SPLIT WINDOWS

This feature allows you to split the screen into two windows. You can use the split windows to display different parts of the same form, different forms in the same return, or even different forms in different returns.

To split the window, use the View / Split Window command. You can also use the Ctrl+H hotkey.

To unsplit the window, use the View / Unsplit Window command. You can also use the Ctrl+H hotkey.

The Active Window

When the screen is split into two windows, you can only enter information into the active window. However, any information you enter in one window will be automatically reflected in the other window (for example, if you have two related forms in the same return displayed in separate windows).

The current, or active, window contains the flashing cursor.

To make the other window active, use the View / Next Window command. You can also use the Ctrl+T hotkey.

Accessing the Forms Manager

When you access the Forms Manager, the screen automatically changes to a full screen display. However, once you go to a form, the screen will return to a split display. The jump affects only the active window. The other window will remain unchanged.

<Pull-Down Menu Index>a                      <Main Help Menu>   

FILE LOCKING

Please note: This feature is not available in this version.

Two levels of file locking are available in Taxprep. You can lock data, and you can lock files.

To lock either data or a file, use the Options / Lock command. The program will then display a dialog box prompting you to enter the type of locking and a password.

If you do not wish to assign a password, leave the password line blank.

WARNING

If you assign a password, you must remember the password to unlock the file. Assign passwords with caution.

Data Locking

Data locking prevents any further changes to a return.

When you lock a file using the Data option, input will no longer be accepted in any cell. You will be unable to re-save the file. If you do attempt to save the file, the message YOU HAVE READ ONLY RIGHTS will appear. However, you may still view, print, or roll forward the return.

Full File Locking

The file lock option allows you to prevent unauthorized access to a file.

When you lock a return with this option, it can only be accessed with the password you have assigned. If you don't know the password, you will be unable to access the return in any way.

<Pull-Down Menu Index>a                      <Main Help Menu>   

ESTIMATES

Flagging

In Taxprep III, you can flag input cells as estimates. This is helpful when you need to approximate numbers to get a result. The estimate flags will show you precisely which numbers are estimates.

To flag an estimate:

 - move the cursor into a cell containing a number that is an estimate.

 - select the Edit / Set as Estimate command.

When you do this, a e symbol will appear to the right of that cell. Furthermore, every cell in the return that is based on that figure will be flagged with an E symbol.

Removing Flags

To remove an estimate flag:

 - move the cursor into a cell flagged with an E symbol.

 - select the Edit / Remove Estimate command.

This will remove the flag from that cell and will remove all the related estimate flags.

<Pull-Down Menu Index>a                      <Main Help Menu>   

COMPARE

    Please Note:  The Compare command will be available in a future version.

With the Compare command, you can compare the data of two open returns, one cell at a time. Both returns must be open, and one must be active (i.e., one must be on your screen).

Starting Compare

To start the comparison:

 - ensure that one return is active and the other return is open.

 - choose the Options / Compare... command.

The Compare dialog box will then appear, listing all your open returns. Choose the return that you wish to compare, and confirm your choice by selecting Ok.

The help line will then change--instead of displaying the usual available commands, it will show the name of the return and a number or some text. This data corresponds to the data in the cell containing the cursor. So you can see the value of each cell in the active return and in the other return at once.

You can move anywhere within the active return to compare its data with the data of the open return displayed on the help line.

Turning Off Compare

To turn off compare, choose the Options / Compare Off command. This restores the help line to its usual function.

<Pull-Down Menu Index>a                      <Main Help Menu>   

TURNING OFF CALCULATIONS

Automatic Re-calculation

In regular mode, the program automatically re-calculates the current form and, if necessary, the entire return, every time a number is entered. You can, however, continue to enter your data in that form while the computer is re-calculating the return. The results of your changes will be displayed after you have finished typing.

While the program is waiting to re-calculate, the time displayed in the bottom right corner of the screen is suspended. It resumes when the calculation is complete.

Calcs Off

If you are simply entering data and do not need to see the results immediately, you may wish to turn off the automatic re-calculation of the return. This will allow you to move between forms or returns quicker.

To turn off the automatic re-calculation, select the command Options/Turn Calcs Off or use the hotkey Ctrl+L.

When this command is selected, the words "CALC OFF" replace the time display in the bottom right corner of the screen.

To re-instate the automatic calculations, select Options/Turn Calcs On or again press Ctrl+L. When Turn Calcs On is selected, the return will be immediately re-calculated.

Re-Calculate

When Calcs Off is selected, the program only re-calculates the return when it is saved or when you specifically request a re-calculation. To do this, select the command Options/Re-calculate or by use the hotkey Ctrl+F9.

The program will not automatically re-calculate the return when you select the File/Print Form command. Therefore, if you are printing any schedules individually, be sure that the return has been re-calculated first.

Duration of Calcs Off

Once the calculations have been turned off, they will stay that way for any subsequent returns you open or create until you turn it off or quit the program.  Calcs Off is not, however, saved as part of the return or the configuration. You must turn it on every time you wish to use the feature.

When to use Calcs Off

The speed of the automatic calculations depends on the speed and memory of the computer you are using. If your computer has an 80386 or higher processor and you are making use of all available memory, the automatic calculations will only take a few seconds. The amount of time saved will therefore be minimal. The Calcs Off feature is normally only of real benefit when you are using computer with an 80086 (e.g. an XT) or 80286 processor.

Defaulting Calcs Off

If you wish to always have Calcs turned off, see Chapter 7's (Customizing Taxprep) "Configure / Change features" section.

<Pull-Down Menu Index>a                      <Main Help Menu>   

UTILITIES

Calculator

To display the on-screen calculator, choose the Utilities / Calculator command.

The calculator functions like an adding machine. It even stores a running tape of all entries made. To carry out basic operations (addition, subtraction, multiplication and division):

 - Enter a number.

 - Enter a function (+ - * /).

 - repeat.

The current total is always displayed at the bottom of the calculator.

The entries are stored chronologically in the running tape. Press the up arrow key to move backwards through the tape and the down arrow key to move forwards.

You can also store numbers in the calculator memory:

 - To place the current total in memory, press M.

 - To recall the number in memory, press R.

 - To subtract a number from the total in memory, press B.

 - To add a number to the total in memory, press N.

To hide the calculator, press Esc.

Calculator Value

To insert the calculator total into the current cell, choose Utilities / Calculator Value.

The hotkey to insert the calculator value is Alt+I.

Notepad

To display a five screen pop-up notepad, choose the Utilities / Notepad command.

Move through the pages of the Notepad by pressing PgDn and PgUp.

Pressing the End key will take you to the end of your line of text.

Pressing the Home key will take you to the start of your line of text.

The up and down arrow keys move you up or down one line.

To delete a page in the Notepad, press Del.

Press Esc to leave the Notepad. The contents of the Notepad is saved automatically in a file with the same name as your data file and the extension .NPD.

<Pull-Down Menu Index>a                      <Main Help Menu>   

USING A MODEL RETURN

You can select a return to be used as a model for all new returns created.

However, in Personal Taxprep, most of the information you would need to default for any new return is in the Preparer Profile. There are therefore very few instances where a model return should be used.

Creating the Model Return

Create the model return in the same manner as any other return. You may want to save it in a different subdirectory from your other returns to reduce the possibility of it being accidentally changed. You can use the identifier field to note that it is a model return.

Once you have saved the model return, choose Configure / Model Return and select the return.

Information to Enter

Enter any information in the model return that you think would be applicable to most of your returns, such as standard attached schedules.

Automatic Defaults

The program automatically defaults certain information in all new returns. This will still apply when you are using a model return unless you have specifically changed the defaulted cells.

Model Returns from Prior Versions

If a new version of the Taxprep program converts data files from the prior version, then the model return should be re-accessed and saved. If this is not done, every time a new return is created, the model return will have to be converted from the old version.

Removing a Model Return

If a model return has been accidentally configured, it can be removed by pressing ESC from the Model Return dialog box.

<Pull-Down Menu Index>a                      <Main Help Menu>   

CONFIGURING A FILE PATH

Configure/File Path

Sometimes you may want to change the File Path that you selected when you installed Taxprep. You can do this with the Configure / File Path... command.

Selecting

To select a file path:

 - move the cursor into the path list.

 - highlight the desired drive or subdirectory.

 - press <ENTER>.

Note

File Paths must already exist. You cannot create new subdirectories with the Configure / File Path... command.

File Path Symbols

The following symbols represent specific file paths:

[.] = parent subdirectory.

<name> = child subdirectory (i.e., subdirectories of the current directory).

A-Z: = disk drive or network drive.

<Pull-Down Menu Index>a                      <Main Help Menu>   

CONFIGURING PORTS AND PRINTERS

Choose Configure / Port/Printer... to select printer ports and printers.

Choosing Ports and Printers

To choose a port or printer, select the Configure / Port/Printer... command. The Configure Ports/Printer dialog box will then be displayed.

Each print quality type (e.g., plain paper, pre-printed) can be sent to a different printer port or printed to a file.

To select the printer for each print quality type, select Printer. A list of supported printers then displays. Highlight your type of printer and select Ok to confirm your choice.

You must select a printer even if printing to a file to ensure the print file has the correct printer codes.

Saving the Selection

If you have selected your ports and printers and you want the selection to be in effect the next time you run the program, choose Configure / Save Print Format.

The Save Print Format dialog box will display. Leave the print format name unchanged and select Ok to save the changes unless you are using multiple print formats.

Supported Printers

The program lists printers that produced acceptable output when tested with the application. Some equivalent models and other makes that emulate the listed printers are also supported. The Appendix lists the printers which have been tested with the program and the printer type which you should select.

Precede/Follow

At the top of the Configure Ports/Printer dialog box are two options: Precede with Batch File/Command and Follow with Batch File/Command.

If you enter a command or batch file name to precede, the program will execute it before printing. The command or batch file entered to follow will be executed when the print is finished.

This is primarily of use on a Network when you must issue network commands to direct the printout to a network printer.

If you wish to run a command with parameters (e.g., CAPTURE NA NB NT NFF), create a batch file containing the command.

Example:

On a Novell network, you must issue the CAPTURE command before printing to a network printer, and ENDCAP afterwards. Therefore, your Precede command might be CAPTURE (or a batch file CAP) and your Follow command would be ENDCAP.

Multiple Print Formats

If you are using Multiple Print Formatsǁ   your printer must be configured in each print format.  You will not, however, have to configure your printer, if you created your print format from an existing one in which the printer was already configured.

TIP

If you use more than one type of printer with the same printer port (e.g., by using a switch box), create a different print format for each printer.

Network Printers

If you have local printers and network printers of different types, you can create different print formats (as described above) to print to each printer.

If, however, you wish to print to the local and network printers at the same time, you can treat the network printer as port 2 or port 3, and configure it that way in the application.

You must then add the parameter L=2 or L=3 to the CAPTURE command when you spool to the network (assuming you are using a Novell network). Select the type of printer for port 2 or 3 to correspond to the network printer.

Note:

If you have multiple network printers, the printer number you specify in the CAPTURE command (e.g., P=2) represents the network-specified printer number for spooling purposes, not the port number.

<Pull-Down Menu Index>a                      <Main Help Menu>   

CHANGING THE FORMS MANAGER

If you want only certain columns of the Forms Manager to display, you can use the Configure / Forms Manager... command. A dialog box will appear where you can specify which listed columns will appear. An X means that the column will display.

Hiding Columns

To hide a column:

 - highlight the column name.

 - press <ENTER>.

The X will then disappear, and that column will no longer appear on the Forms Manager.

Revealing Columns

To reveal a hidden column:

 - highlight the column name.

 - press <ENTER>.

The X will then appear, and that column will appear on the Forms Manager.

TIP

If you are familiar with the titles of the forms in the application (e.g., T776, T2S(1)), you may have no need to display the Description column. You can therefore hide the Description column to streamline your screen. Also, you will then be able to see all the remaining columns of the Forms Manager without scrolling to the right.

OPTIMIZE OPTIONS

Display Mode

The normal Taxprep screen display consists of 25 lines. However, if you are using an EGA monitor, you can now choose to view your Taxprep screens in 43 line mode. For a VGA monitor, you can choose 50 line mode. This allows you to view twice as much of a form on the screen at once. This is especially useful when using split screens.

Number of Monitors

If your computer supports both a monochrome and VGA monitor, you can choose to use both monitors in conjunction with Taxprep. When the screen is split using the View / Split Window command, the top window will use the entire VGA screen and the bottom window will use the monochrome screen. You can then toggle between full size windows.

Your screen display must be set to 25 lines when using multiple monitors.

Data File Size

By selecting Packed as the Data File Size, the data files will automatically be packed whenever the return is saved. A packed data file will be approximately 72% smaller than a normal data file.

These files are unpacked automatically when the return is opened or printed.

It will take approximately 10% longer to save a packed file as compared to a normal file.

Express Open

The Express Open is a faster way to retrieve a return in your configured data directory when you already know the file name. When you select File / Open... with Express Open on, the program displays a simple dialog box in which you input the name of the file you wish to open.

The time saved using the Express Open will depend on the number of returns in your directory and the speed of your hard disk or network drive. The more returns in the directory and the slower the disk access, the more time you will save using the Express Open.

Express Jump

The Express Jump feature allows you to enter a jump code without having to view the Forms Manager. When you use the Jump command with Express Jump on, a dialog box prompts you to enter the jump code and displays a list of the available jump codes. If you don't know the jump code for a particular form, you can display the Forms Manager by selecting the "Forms Mgr" button. Pressing ESC after jumping will also return you to the Forms Manager.

Users already familiar with the jumps codes and using older computers will benefit most from this feature.

<Pull-Down Menu Index>a                      <Main Help Menu>   



Change Features

        Enable Auto End CapJ 
        Calcs on at startP 
        Assume DownloadingI 
        Network File LockÃ 
        Alt key disabled j 
        Print Service OnɅ 
        Program Clock On҆ 
        Use EMS/XMS MemoryǾ 
        Limit Open FilesK 
        File Sort OptionsǍ 


Selecting Configure / Change features from the menu will allow you to enable or disable certain program features. Pressing [Enter] will toggle a box between being X'd on or X'd off.

Ok accepts the feature changes, Cancel rejects the changes.

                                            <Main Help Menu>   


Enable Auto End Cap

If you are on a network and normally have to enter DOS and type ENDCAP to end a print queue capture, you can choose this feature to automatically send the ENDCAP command.



<Change Features>ǹ}                 <Main Help Menu>   

Calcs on at start

Disabling Calcs on at start will allow you to enter figures without recalculation. On slower computers (i.e., a PC or XT), this will speed data entry.

<Configure / Change features>ǹ}                 <Main Help Menu>   

Assume Downloading

If Assume Downloading is enabled, the program will assume that the laser facsimile forms have already been downloaded to the printer and reside in the printer memory. The laser facsimile forms will therefore not be downloaded to the printer each time you print, improving printing speed.

<Change Features>ǹ}                 <Main Help Menu>   



Network File Lock

When this feature is set, more than one user is prevented from accessing a file.

<Change Features>ǹ}                 <Main Help Menu>   

Alt key disabled

Using the Alt key when running Taxprep under DESQview's multi-tasking environment activates DESQview's system menu. DESQview users may therefore wish to disable the Alt key and use F10 to access Taxprep's menu bar. Alt key combination such as Alt-F will still work.

<Change Features>ǹ}                 <Main Help Menu>   

Print Service On

Enables the generation of a print service record for use with Taxprep's Print Service. The print service record is generated in the same directory in which your returns are saved.

<Change Features>ǹ}                 <Main Help Menu>   

Program Clock On

On a slower computer (i.e., PC or XT) you may want to turn off the clock that appears at the bottom of the screen to speed up the screen refresh rate.

<Change Features>ǹ}                 <Main Help Menu>   

Use EMS memory & Use XMS memory

When loading, the program checks for EMS or XMS memory and uses it if it is available. In a multi-tasking environment (i.e., Windows, OS/2, or DESQVIEW), Taxprep might encounter a memory conflict. If this is the case, turning off expanded and/or extended memory use should eliminate the conflict.

<Change Features>ǹ}                 <Main Help Menu>   

Limit Open Files

On loading, the T1 program does a check of your available conventional, expanded, and extended memory and computes the maximum number of returns that can be safely opened at any one time. If you try to open more than the maximum number, you will be prompted to close one of your open files.

If you wish to limit the number of files that can be open to less than the maximum, enable the Limit Open Files option and enter a new limit in the cell provided. The minimum limit you can enter is 2.

<Change Features>ǹ}                 <Main Help Menu>   

File Sort Options

Disabling sorting will display files in the order that DOS records them to disk. This is usually an approximation of the order in which they were created.

Having sorting and Subdirs first enabled will list subdirectories before the drive letter in the Path List. This option is particularly useful if you are on a network with several drives, thus saving you the need to scroll through numerous drive letters to find subdirectories.

Having sorting and Reverse Order enabled will display files in reverse alphabetic order.



<Change Features>ǹ}                 <Main Help Menu>   

CHANGING THE CURSOR DISPLAY

To facilitate seeing the cursor on a variety of monitors, the size and location of the cursor can be modified.

Changing the Size

The cursor display can be made bigger by pressing Alt+F4.

The cursor display can be made smaller by pressing Alt+F3.

Changing the Location

The cursor can be moved to the top of the cell by pressing Alt+F6. Pressing Alt+F6 again will move the cursor back to the bottom of the cell.

Saving Your Changes

Once you have chosen the best cursor display for your monitor, select the command Configure/Save Configuration.

<Pull-Down Menu Index>a                      <Main Help Menu>   

SAVING YOUR CONFIGURATION

When to Save

Whenever you change any of the items under Configure, your changes remain in effect until you quit the program. If you want the same configuration to be in affect the next time you run the program, save it with the Configure / Save Configuration command.

Resetting the Configuration

If you choose Configure / Reset Configuration, the program will use the default configuration file.

Network Configuration Files

If you are installing the program on a network, you may wish to have different configurations for different workstations. You can do this by placing the configuration file on the hard disk of the user's workstation instead of in the network drive.

If separate configuration files are used, the program must be directed where to look for the file. This is done by using a SET command .

<Pull-Down Menu Index>a                      <Main Help Menu>   

SAMPLE PRINT FORMATS

The following print formats have been provided with the application. All of these print formats, unless otherwise indicated, have plain paper selected as the output for all forms.  Formats with the letters EP (e.g., FULL-EP) have Epson compatible selected as the printer, otherwise the default printer is the the HP LaserJet Series II.

FULL/FULL-EP

This is the default print format. All forms are set to print. The output type is plain paper.

FINAL/FINAL-EP

T1 Jacket laser facsimile form is selected. Also includes all forms which would normally be included in a final copy (e.g. client letter). Does not include diagnostics.

FINAL-L

All laser facsimile forms are selected. Also includes all forms which would normally be included in a final copy (e.g. client letter). Does not include diagnostics.

EFILE/EFILE-EP

This includes the T1 jacket outline, Form T183, Client Letter, and only forms which may require a signature to be printed.

DRAFT/DRAFT-EP

Includes all forms which would normally be required for review including the Taxpayer Summary and Diagnostics. The output type for all forms selected is plain paper.

EMPTY/EMPTY-EP

Print = N for all forms. This format has been provided to help you create a print format which includes only a few forms.

PREPRE

Same as FINAL except T1 Jacket output will be pre-printed.

Tip

When using FULL or EMPTY to create your own formats, enter a new name when saving to avoid changing these formats.

<Pull-Down Menu Index>a                      <Main Help Menu>   

Improving Performance

Taxprep is a sophisticated application, so you need as much computing power as you can get to run it most effectively.

Recommended Hardware

While the program can be run on most IBM-compatible computers, we recommend a computer with a 80386 or 80486 processor, a speed of at least 20MHz, and at least 2 Meg of expanded memory.

RAM

If your computer has expanded memory, the regular Taxprep program will make use of it automatically. Additional RAM can speed up the operation of the program.

If you have memory above 640K and DOS 5.0, run the device drivers in high memory to free up conventional RAM.

Hard Disk Speed

The faster the hard disk, the faster certain disk dependent operations will be, such as opening and saving files and switching between returns.

Hard Disk Organization

Taxprep III allows you to open files from any subdirectory on your hard disk. You can therefore organize your data files in a manner which optimizes disk access speed (e.g., store your data files in several subdirectories instead of one). DOS recommends that no more than 512 files be stored in any one subdirectory.

You can also improve disk access time by ensuring that your hard disk is not fragmented (i.e. files are stored randomly throughout the hard disk instead of sequentially). There are a number of inexpensive utilities on the market which can be used to unfragment your disk.

Re-directing the Temporary File

While you are running Taxprep, a temporary file is created for the returns which have been opened. This file is normally created in the program subdirectory. You can specify an alternative location for these files, but you should normally create the temporary file where you will achieve the fastest access time. For example, if you have expanded memory, you can create a RAM drive and have the program create the temporary file in the RAM drive instead of on disk. This could be especially effective if the program is being run from a network drive.

<Pull-Down Menu Index>a                      <Main Help Menu>   

CONFIG.SYS

The CONFIG.SYS file is found in the root directory of your hard disk (or on a floppy boot disk).

File Handles

The CONFIG.SYS file specifies the number of file handles available in RAM when you start your computer. Personal Taxprep opens 7-8 files when the program is running and therefore requires the same number of file handles.

If you are installing Taxprep on the computer for the first time, the INSTALL program will automatically set FILES = 40 in your CONFIG.SYS so that program will have enough file handles while still leaving file handles for DOS and other programs to use. You may set a higher FILES setting yourself, but do not reduce the number of file handles below 15. If FILES is set too low, you may get the error message Error Loading Client or Error Creating Client when you try to open multiple returns.

<Pull-Down Menu Index>a                      <Main Help Menu>   

Using SET Commands

Taxprep uses several environment variables to communicate information on how you wish to configure the program. In order to use an environment variable, you must type the DOS command SET followed by the variable and it's value. To check the values of your environment variables, simply type SET. DOS will display all of the current values. For more information on environment variables, consult your DOS manual.

SET TAX = [path]

The TAX variable is used to identify the location of your configuration files. If there is no SET TAX command, the configuration files will be located in the program subdirectory. You would normally only need to re-locate your configuration file when there is more than one person using the program. By having the configuration file in a separate directory, each user can maintain different configurations.

SET TEMPTAXPREP = [path]

The TEMPTAXPREP variable is used to identify where Taxprep will create the temporary file. If there is no SET TEMPTAXPREP command, the temporary file will be created in the program subdirectory. The location of the temporary file should be specified if it will speed up the performance of the program. (see the previous section "Improving Performance").

SET TPCONV = [allocated conventional memory]

If you are using EMS and/or XMS, you can use SET TPCONV to reduce the buffer the program reserves in convetional memory for overlays. To maximum the number of clients that can be open, reduce TPCONV to 64 (64 K).

SET LASER = [File Path]

Use SET LASER = in the each workstation's AUTOEXEC.BAT to allow network users access to a common _T1DOWN.CFG.

Running the SET Command

Environment variables can be set at any time by typing the appropriate SET command at the DOS prompt. The value assigned to that variable will stay in effect until it is changed by another set command or the computer is re-booted.

To avoid having to type the SET command every time the computer is re-booted, the command is normally placed in the AUTOEXEC.BAT file. In this way it will be executed automatically everytime the computer is booted.

Alternatively the SET command can be put in a batch file which can also be set up to launch the program.

The INSTALL Program

Both the TAX and TEMPTAXPREP variables can be put into your AUTOEXEC.BAT file by using the INSTALL program.

Environment Space

Only a certain amount of computer memory is allocated for environment variables such as TAX and TEMPTAXPREP. If you have alot of them, you may have insufficient environment space. In this case, the message "Out of Environment Space" may appear when you re-boot your computer. The environment space can be expanded by adding a line your CONFIG.SYS file. See your DOS manual for details.

If you use the INSTALL program to add the SET commands to your AUTOEXEC.BAT file, it will modify the CONFIG.SYS if necessary to expand the environment space.

<Pull-Down Menu Index>a                      <Main Help Menu>   

FILE NAMING CONVENTIONS

Data Files

One data file is created for each return saved. The file extension varies with the application:

 - .The extension for the Personal Taxprep data files is based on the taxation year (e.g.. .91 and .92).

 - .TT is used for Corporate Taxprep.

Temporary Files

Taxprep creates a temporary file while the program is running. The  temporary file is deleted when the program is finished using it. The temporary file starts with the letters TP followed by six numbers and a three digit extension.

If you are on a network, one temporary file will be created for each workstation using the program. Do not delete any temporary files unless you are sure there are no users running the program.

Configurations File

The 1991 Personal Taxprep configuration file was named _TO.CFG.

There are two Personal Taxprep configuration files for 1992: _T1.C92 and _T1.D92.

Corporate Taxprep configuration files are named _TT.CFG.

Program Files

The program files vary by application. Generally they consist of one or more .EXE files, several .RES files and a T1.EXE or T2.EXE.

Special Files

The following special files are located in the program subdirectory.

 - Print Format files have the file extension .FMT.

 - Notepad files will have the same name as the data file but the file extension .NPD.

<Pull-Down Menu Index>a                      <Main Help Menu>   

TROUBLESHOOTING

Error Messages

Not enough memory

There is insufficient memory to run the program. Check if you are running any memory-resident programs. You may have to increase your available RAM by modifying your CONFIG.SYS file to reduce BUFFERS or remove device drivers or TSRs.

Error Loading Client, or Error Creating New Client

This message normally occurs when the program there is insufficient file handles. Ensure that the CONFIG.SYS file contains a FILES= command, where the number of files is 15 or greater.

Out of Temp File Disk Space or Not Enough Space in Temp Directory

The program does not have sufficient disk space to open more files. You can either free up additional disk space for the temp file, or if you have numerous returns open, close some of the returns you are not currently using.

Accessing Floppy Drives

If you select a new file path in Configure / Filepath, File / Open, or File / Print Batch, the program checks the selected drive for more subdirectories. If the selected drive is a floppy drive (e.g., A: or B:), the screen display may be distorted if there is no disk in the floppy drive. To correct this, insert a disk into the floppy drive.

Network Rights

If you are running Taxprep on a network, all users must have rights to read, write, delete and create files. If these rights have not been assigned, the following error messages may occur:

Access Denied

This message will appear when entering T1 or T2 if you do not have rights to delete files.

Could not open primary resource file.

This message will appear when trying to load the program if you do not have rights to write to files.

Output Appearance

Forms printing incorrectly could be caused by any of the following situations:

 - Correct printer not selected. Choose Configure / Port/Printer to check the port and printer selected. If your printer is not specifically listed, the printer that you have selected may not use the same printer codes. It is also possible that your printer is not capable of the special printing required to produce government approved printouts. Contact Technical Support for assistance.

 - Fonts not downloaded for laser facsimile forms. On HP LaserJet Series II and III printers, you can produce a font printout to check if the fonts are downloaded.

 - Laser facsimile forms printed to a non-laser printer. Check the output type selected.

 - Incorrect printer mode. Certain printers have specific print modes, especially for emulating other printers. Check your printer manual to more information.

Forms Not Printed

For a form to be included in the return, there must be a "Y" or "*" in the Applicable column and a "Y" in the Print column of the Forms Manager.

Command Disabled

Commands are disabled when they are not valid in a given situation. Common situations in which commands are disabled are:

 - Edit, Search, View, and Options. These menus are disabled when there are no returns open.

 - Print Form. This command is disabled when you are on the Forms Manager. To use Print Form, you must have the form on the screen.

 - Print Return. This command is only available when you are on the Forms Manager.

 - Split Window, Attach. These commands are disabled when you are on the Forms Manager.

 - Next Return, Previous Return, Choose Return. These commands are only available when there is more than one return open.

 - New, Remove. These commands are only used for Tslips, CCA and ITC. They are disabled when not in a Tslip, a CCA schedule or the T2038sum.

<Pull-Down Menu Index>a                      <Main Help Menu>   



                Personal Taxprep Application Guide

                PrefaceJ 
                Taxpayer's Profile 
                T1 Jacket5( 
                Information SlipsS 
                T1 SchedulesǑ 
                Provincial Forms۫ 
                Income and Deduction SummariesǺ 
                Self-Employment Schedules 
                Workcharts and Other Summaries) 
                Federal FormsO 
                Optional Forms and Reportsa 
                Appendix 


Preface

Personal Taxprep Overview

Personal Taxprep is a software application that processes Federal T1 returns.

Versions

A preliminary planner, a first production version, and then a final production version are released for each year. Each version is based on the tax laws and interpretations in effect at the time of release.

Application Guide

The Application Guide highlights procedures which differ from the manual preparation of a personal tax return. The Guide also explains how the more complex forms are handled by the program and how to complete them.

Release Notes

For more details on a particular version, please read the Release Notes that accompany each version of Personal Taxprep.

User's Guide

For instructions on how to use the program, and for other technical details, read the User's Guide.

<Application Guide Menu>'                     <Main Help Menu>   





        Taxpayer's Profile

        Identificationǎ 
        Family Profile. 
        Coupling - An OverviewO 
        Coupling Procedures 
        Family Profile: Coupling Process Informationǹ 
        Family Profile Part 1: Spouse Profile 
        Family Profile Part 2: Dependants Profileǫ	 
        Family Profile Part 3: Misc. Coupling and Credit Information 
        Additional Workchartsv$ 


Identification

Important Information

Before you prepare any other schedules, you should complete the Identification Section. You must enter the birth date and province of residence for new returns, or the taxpayer is assumed to be a resident of British Columbia (province code 1) born in 1950.

Modifying Defaults

The default province of residence, discounter information, and other filing information can be changed in the Preparer's Profile.

Emigrants

For emigrants, enter the province of residence at the time of leaving Canada. Do not enter the taxpayer as a non-resident.

Part Year Residents

The program prorates non-refundable tax credits of immigrants and emigrants depending on their date of entry or departure. If substantially all the taxpayer's income for the year originates in Canada and he or she is eligible to claim the full non-refundable tax credits, then turn off the prorating of the credits.

The program calculates the eligible capital gains deduction for an emigrant taxpayer under the assumption that he or she resided in Canada for the whole preceding year. However, an immigrant taxpayer's capital gains deduction is not calculated. For further details, see T657-Capital Gains Deduction.

Non-Residents

If the taxpayer is filing as a non-resident, you can choose between no personal exemptions credits (code 13) or full personal exemptions credits (code 14). If you choose code 14, the date of entry or departure will not cause proration of exemptions credits.

If you want to calculate tax for a non-resident taxpayer as if he or she is resident in a particular province, enter the taxpayer as a non-resident and enter the province code in the Province of Self-employment cell.

Deemed Residents

If a taxpayer is a deemed resident of Canada, you must determine if income from office or employment is considered to be earned in a province. If income is determined to be earned in a province, then you should code the taxpayer as a resident of that province as at December 31. This generally applies to a sojourned working in Canada for more than 182 days.

If a deemed resident has no income earned in a province, you should code the taxpayer as code 15. The non-resident surtax would be calculated in place of provincial tax. An example would be Canadian Armed Forces personnel stationed overseas.

Deceased Taxpayers

If you enter a date of death, the appropriate CPP calculations will be prorated. Non-refundable tax credits will not be prorated. The program assumes that these credits will not be claimed in a return for Rights or Things.

The program claims the maximum net capital losses carried forward to apply against other income.

Bankruptcy Returns

An individual filing a pre-bankruptcy return is not eligible to claim the Child Tax Credit or Goods and Services Tax Credit. Also, CPP is not payable on self-employed earnings, and CPP overpayments will not be refunded.

A post-bankruptcy return filed by a trustee in accordance with paragraph 128(2)(e) is not eligible for certain non-refundable tax credits or any Division C deductions except for claims of previous years' losses as permitted under Sec. 111. Error diagnostics will appear if you make an inappropriate claim.

If an RRSP deduction was claimed in a pre-bankruptcy return, reduce the RRSP earned income limit and the amount that can be transferred into a spousal plan by that prior claim in the post-bankruptcy return. Adjust net income, as it applies to certain non-refundable tax credits, to include income from the pre-bankruptcy period. Also adjust the calculation of CPP payable or overpayment to include applicable pre-bankruptcy amounts.

<Application Guide Menu>'                     <Main Help Menu>   

Family Profile

Overview

The Family Profile is comprised of the following:

 - Coupling Process Information (i.e., the name of the return to couple, and when coupling will occur).

 - Part 1  - Spouse Profile. - Part 2 - ǫ	 Dependants' Profile. - Part 3  - Miscellaneous Coupling and Credit Claim Information (e.g., whether T5 slip information should be transferred between spouses).

Purpose.

The family profile is used to:

 - enter information on the members of the taxpayer's family.

 - decide how the dependants will be claimed.

 - indicate how the information will be transferred between spouses' returns (i.e., coupling).

 - specify what information will be shared between spouses' returns (e.g., the business schedules).

 - decide which spouse will claim various provincial tax credits.

When Used

The Family Profile should be used whenever the taxpayer has dependants.

If a married taxpayer has no dependants, the Family Profile is still useful if:

 - one of the spouses may be eligible to transfer unused refundable credits to the other spouse.

 - you have not yet created the spouse's data file.

 - the taxpayer is in business with his or her spouse or shares common investments (e.g., T5 slips).

<Coupling>O    <Application Guide Menu>'   <Main Help Menu>   

Coupling - An Overview

What is Coupling?

Coupling is a process that links together the returns of a taxpayer and spouse. The returns remain separate files and are treated separately for purposes of saving, closing, printing, and so on, but coupled returns are special in that they share some information.

Shared Information

The shared information can include:

 - identification information such as surname, address, and marital status.

 - dependants.

 - commonly owned rental properties.

 - shared investment income.

 - commonly owned businesses.

You only enter the common information in one of the returns. You do not need to enter the same information twice. For example, all the information in the Family Profile will be transferred to the spouse's return when you couple.

Existing vs. New Returns

You can couple two existing returns, i.e., two returns that you have already created, or you can let the program create the spouse's return automatically. In either case, common information will update from each return to the other.

"Taxpayer" vs. "Spouse"

Coupling transfers all the information in the Family Profile, the Dependant Amount workchart, and the Non-taxable items workchart to the other spouse's return. Wherever "Taxpayer" is indicated in the originating return, "Spouse" is indicated in the coupled return.

<More on Coupling>    <Application Guide Menu>'    <Main Help Menu>   

Coupling Procedures

The are a number of different ways to approach coupling returns. The method you choose may depend on:

- the complexity of the returns you are preparing.

- the completeness of the information available.

- the order the information is entered.

- the speed of the program on your hardware configuration.

Here is one suggestion of how to approach coupling returns:

1) Complete the Taxpayer's ID Section

Enter all the necessary information regarding the taxpayer and the spouse into the taxpayer profile (jump code ID).

2) Complete the Family Profile

As described in the following sections, enter all of the necessary information regarding the taxpayer, spouse, dependants, and any other supporting person in the Family Profile.

3) Complete Remainder of Taxpayer's Return

If any of the self-employment or rental statements are shared between the spouses, ensure that the appropriate information is entered in the partnership share sections of the relevant statement.

4) Save the Return

If the return is new and has never been saved, you must save the return before invoking coupling. Coupling cannot be performed on an Untitled return.

5) Invoke Complete Coupling

Invoke complete coupling by pressing the hotkey Alt+F7. A "Wait" message will display while the returns are coupled.

6) Switch to Spouse's Return

When a return is coupled, the spouse's return is automatically opened if it is not already open. You can then view the spouse's return by using one of the View commands: Next Return, Previous Return, or Choose Return. The hotkeys for viewing the Next Return or Previous Return are Ctrl+M and Ctrl+J.

If you wish, you can leave the taxpayer's return on the screen by splitting the window using the View / Split Window command prior to switching returns.

7) Complete Remainder of Spouse's Return

Enter the spouse's employment income, pension income, non-shared investment income, RRSP deductions, etc.

8) Invoke Coupling

Invoke coupling again to transfer the spouse's income information to the taxpayer's return.

Coupling Revised Returns

If not all of the information was entered in one of the returns at the time of coupling, or if changes are required, the returns can be coupled again.

If the new information is entered into the Family Profile, the Dependant Amount workcharts, or any of the shared business schedules or T-slips, coupling must be invoked from the return in which the changes were entered. If it is invoked from the other return, the newly entered information will be replaced with the old information.

If the new information is entered in another part of the return (e.g.,  employment income), the coupling can be invoked from either return.

When the program is configured to couple on switching returns, coupling will always be invoked from the correct return.

Rolled Forward Returns

If your files have been rolled forward from last year, the Identification section and Family Profile will already have most information completed. In this case, simply review the screens for any changes during the year (e.g., addition of a new dependant) and enter this year's income and expense amounts (e.g., family allowance).

<More on Coupling>ǹ    <Application Guide Menu>'   <Main Help Menu>   

Family Profile: Coupling Process Information

File Name

If the spouse's return already exists, enter the file name. (In rolled forward returns, this will already be completed.)

If the spouse's return does not already exist, enter the file name that you wish the program to use when creating the file. Taxprep will display a message saying "Cannot Open...". Press <ENTER>. Taxprep will then ask you to confirm that you want to create the return.

File Path

If the spouse's return does not exist yet, leave the file path blank. The program will automatically create the spouse's return in the same directory as the taxpayer's return.

The spouses' returns can be in different drives or directories unless you are using floppy disks. If your returns are stored on floppy disks, store both the husband's and wife's returns on the same disk.

Automatic Coupling

You can request that coupling be invoked automatically after every File / Save. When this option is selected, the spouse's return must be open for coupling to occur.

If you have changes to make to the taxpayer's return which you know will not affect the spouse's return, you can close the spouse's return and save time by avoiding unnecessary coupling when the file is saved.

If you invoke coupling using Alt+F7, the spouse's return will be automatically opened.

You can also have information automatically transferred every time you leave the taxpayer's return to view another return (e.g. the spouse's return). This ensures that you are viewing the most up-to-data in the spouse's return.

If you have requested that coupling occur when switching returns but the return you switch to is not the spouse's, the program will automatically open the spouse's return for you if it is not already open.

Full vs. Partial Coupling

If you wish to transfer data every time you switch to another return, you have the choice of invoking full coupling (the same procedures invoked by pressing F7) or partial coupling.

With partial coupling, you select specific types of information to transfer automatically. This allows you to speed up the coupling process. For example, if you have a shared rental schedule, you could remove Rental schedules from the list of items to include in partial coupling once the information has been initially transferred.

Coupling Prompt

You can also instruct the system to prompt you for confirmation before proceeding with the coupling process when you switch returns. This allows you to bypass coupling, for example if you know that there was no change made to the taxpayer's return that affects the spouse.

Coupling Defaults

To avoid having to select the same coupling options for each return you prepare, you can configure the coupling options in the Tax Preparer's Profile. If you decide to change the coupling options for a specific return, make the changes in the Family Profile. Changes made in the Family Profile will not affect the defaults set in the Tax Preparer's Profile.

Overwriting Spouse's Identification

If the spouse's return already exists with a completed identification section, answer N to the question "During Coupling should the Identification information in the spouse's return be overwritten by information in this worksheet?".

If the spouse's return doesn't exist, or if it is incomplete, answer Y to the question. Be sure that the Spouse Profile has been fully completed.

Uncoupling Returns

If you wish to "uncouple" the returns because you have entered the wrong file name for the spouse or you have changed the file name, delete the file name and enter a new one.

If you wish to "uncouple" the returns because all of the transfers of information are complete, you can simply turn off the automatic File/Save coupling. No further transfers or updates will occur between the returns.

<More on Coupling>    <Application Guide Menu>'   <Main Help Menu>   

Family Profile Part 1: Spouse Profile

When Used

This section is only required to be filled in when the taxpayer's and spouse's returns are being coupled.

Common-law Spouses

Indicate a common-law spouse by entering Code 6 for the marital status. Taxprep will treat the transfers between the Taxpayer's and Spouse's return for common-law situations in the same manner as for a married couple, except that Schedule 2 will only be updated for a married couple. You must manually make all the adjustments necessary for a common law situation.

Identification

Much of the spouse's identification is updated from the Taxpayer's Profileǎ  on the assumption that the spouse's birthdate and title (e.g. Mr., Mrs., etc.) will not be in the Taxpayer's Identification section. If you have chosen to have the Spouse Profile overwrite the Identification section of the spouse's return, be sure to complete these fields before coupling.

Net Income

The spouse's net income is updated from Schedule 2 in the taxpayer's return. Schedule 2 will be automatically filled in from information in the spouse's return during coupling. If you are not filing a return for the spouse, complete Schedule 2 in the taxpayer's return.

Schedule 2 is used to accumulate income information even if the spouse will not be claimed as a dependant. However, it will only be set as applicable if an amount is being transferred to the taxpayer. Therefore Schedule 2 will normally only be printed if the spouse is considered to be a dependant.

The spouse's net income which appears in this section of the Family Profile is used throughout the return whenever Family Income is calculated. If you wish to simply enter the amount of the spouse's net income (e.g. for planning purposes), be sure that you enter it here in the Family Profile. Otherwise you will have to enter it in all of the various credit forms.

<More on Coupling>ǫ	    <Application Guide Menu>'   <Main Help Menu>   

Family Profile Part 2: Dependants Profile

When Used

This section should be completed whether the return is being coupled or not (e.g., in the case of a single parent).

Number of Dependants

You can enter up to ten dependants (there are two sections with five dependants in each). If the taxpayer has more than ten dependants, you must override the dependant claim amount in the T1 jacket.

Type Codes

Indicate the type of claim for each dependant:

 - Type 1: equivalent-to-married.

 - Type 2: dependant children, nieces, or nephews not claimed as equivalent-to-married.

 - Type 3: parents, grandparents, brothers, sisters, aunts, or uncles.

 - Type 4: dependants who will be claimed by a supporting person other than the spouse.

Equivalent to Married

A dependant can be claimed as equivalent to married if the taxpayer is not legally married (i.e., single, legally separated, divorced, or living common-law). If the marital status changed in the year, the taxpayer or spouse may have the option of claiming a dependant as equivalent to married instead of claiming the married amount. However, the claim for equivalent to married cannot be split between spouses.

Dependant Claims

Dependants for which Family Allowance payments have been received must be claimed by the person reporting the Family Allowance payments (normally the spouse with the higher net income calculated before family allowance payments, child care expenses, and the social benefits repayment).

When coupling is invoked, the program will automatically determine which spouse has the higher income. The program will modify the dependant claim percentage in the Family Profile so that the dependants are claimed by the taxpayer with the higher adjusted net income. The family allowance will also automatically be reported in the return with the higher adjusted net income.

The dependant information can therefore be entered in either spouse's return regardless of who will ultimately be claiming the children. However, if dependant information is modified on the Family Profile, the coupling must be invoked from the return in which the changes were made.

Splitting Claims

If a couple has separated during the year, you can split the claims between the taxpayer and spouse by overriding the dependant claim percentage.

Third and Subsequent Dependants

The program doubles the claims for the third and subsequent dependants when a taxpayer has more than two dependants (including those dependants recorded in Schedule 6).

If the taxpayer has more than two dependants, the program maximizes the benefits by claiming the dependants with highest net income first.

Infirm Dependants

Dependants with an infirmity which would have enabled them to claim a disability amount in line [316] of their own returns should be classified as Infirm Type 1. These are generally dependants who qualify for a Disability Certificate (form T2201). Other infirm dependants should be classified as Infirm Type 2.

Dependants with Infirmity Type 1 will have the disability amount automatically updated to Line (7) of the Dependants Income and Non-Refundable Amounts workchart. They will also become eligible for a higher child care expenses limitation than dependants with Infirmity Type 2.

Dependants' Income

If there could be a transfer of education/tuition amounts or of the disability amount, the dependant's net income information should be entered in the Dependant Amount Workchart Child Care Expenses

Information in this section will automatically update to form T778. However, any information entered for ineligible dependants will not be updated (e.g., dependants over 14 years who are not infirm).

Who claims the child care expenses depends on the taxpayer's circumstances. For single parents, the expenses will be claimed by the taxpayer as the only supporting person. For two parent families, it is most likely the lower income spouse that will be allowed the claim. In certain circumstances, however, (e.g. when a spouse is infirm), the higher income spouse is allowed the claim. To indicate that these special circumstances apply, you must X the appropriate line for Box C on the T778. During the coupling process, the program will determine who is the lower and higher income spouse and indicate with an X on the Family Profile. The T778 will then calculate the claim in appropriate spouse's return.

Additional information entered in the T778 (e.g. concerning the caregiver) will be transferred to the other spouse's return if necessary during coupling.

<More on Coupling>    <Application Guide Menu>'    <Main Help Menu>   

Family Profile Part 3: Miscellaneous Coupling and Credit Claim Information

Other Supporting Person

Complete this section if there is a supporting person other than one of the spouses. The information is used to update the T778 Child Care Expense schedule as well as certain credit calculations (e.g., GSTC and various provincial credits).

Shared Information

This area asks questions about which forms will update between the returns and who will claim certain credits.

Answer Y if you want information to update the spouse's return for those areas or forms. This includes self-employment schedules, investment income slips, etc..

Personal Expenses

The home office expenses (carry-over and current year amounts) and other personal expenses deducted from the individual's share of partnership income are not transferred during the coupling process.

Self-Employment CCA

The detailed CCA information for self-employment workcharts cannot be transferred between spouses. The total CCA claim will be updated to the appropriate cell in the spouse's return with a system-invoked override.  To obtain a CCA schedule for the spouse, you can photocopy the CCA schedule from the Taxpayer's return or temporarily modify the ID section (name and SIN) in the Taxpayer's return and use the Print / Form command in the CCA Summary for that self-employment workchart to obtain a printout with the spouse's name and SIN.

Credit Claim Information

Indicate if the taxpayer or the spouse is eligible for or will be claiming various credits, including the GSTC and several provincial tax credits. The program does not automatically determine which return should claim these credits.

By default, the program tries to claim these credits for each taxpayer. By indicating which spouse will claim a specific credit, you can ensure that the credit is not inadvertently claimed by both spouses.

Equivalent to Married

If the spouses are living common-law or if the marital status changed in the year, one of the spouses may be able to claim a dependant as equivalent to married. If this is the case, indicate which spouse will be making the claim.

<More on Coupling>v$   <Application Guide Menu>'   <Main Help Menu>   

Dependants Income and Non-Refundable Amounts Workchart

This workchart is used in the calculation of adjusted net income and taxable income for purposes of various tax credit calculations.

It should be completed along with the Family Profile.

To access this workchart, expand (press F9) from the dependant's Net income, Disability transfer, or Ed./Tuition transfer lines in the Family Profile. You can also access this workchart from the Forms Manager.

The Non-Refundable Amounts from Dependants workchart serves three purposes:

1.    Calculation of dependants' adjusted net income for purposes of calculating the non-refundable tax credit dependant amount.

2.    Calculation of dependants' adjusted taxable income for purposes of calculating the transfer of unused non-refundable amounts.

3.    Calculation of the amount of tuition and disability non-refundable amounts transferable.

<Application Guide Menu>'     <Main Help Menu>   







                T1 Jacket

                IncomeI) 
                Deductions from Total IncomeH7 
                Other Deductions from Net Incomev= 
                Non-Refundable Tax CreditsǩC 
                Priority of Tax Calculations ChartǔP 


Income

Entitlement to the credit

The calculation to determine entitlement to the credit is done on the GSTC workchart. Press F9 to expand into the workchart.

Income

Earned Income

Total employment income is included as qualifying earned income for purposes of calculating the following year's RRSP deduction limit. If any amount does not qualify, you must enter it appropriately in the calculation of earned income on form T1023.

Old Age Security

The program will determine whether any old age security benefits are repayable in the Social Benefits Repayment (clawback) workchart. Enter amounts of OAS already repaid in the Other Deductions Summary4 .

Family Allowance Payments

Report family allowance payments received as income for the spouse with the higher net income before including family allowances and deducting child care expenses and social transfer repayments.

If a married couple was separated for more than 90 days, the taxpayer with the highest income should report family allowance payments for the months that the couple was together. For the rest of the months, family allowances must be reported by the taxpayer that received them.

The program determines if any family allowance payments are repayable in the Social Benefits Repayment (clawback) workchart. Enter family allowance amounts already repaid in the Other Deductions Summary4 .

UI Benefits

The program determines if any UI benefits are repayable in the Social Benefits Repayment (clawback) workchart. Enter any UI benefits already repaid in the Other Deductions Summary4 .

Limited Partnership Income

You can enter resource income or loss from limited partnerships in the statement of resource income/lossǗ? .

Enter film income or loss from limited partnerships in the statement of certified film productions.

Enter rental income from limited partnerships in form T776  or in the T5013ǜq  slip, if applicable.

Limited partnership income or loss from real property is considered earned for RRSP purposes, but is not considered pensionable earnings for CPP/QPP self-employment calculations. The program is able to recognize this income if it is entered through the rental income summary. You should adjust RRSP and CPP calculations accordingly if limited partnership income is reported in Box 10 of the T5013, or is entered directly in Schedule 5.

Enter other types of limited partnership income, which are not subject to adjustments for minimum tax purposes, in Part III of Schedule 5  or in the T5013ǜq  slip, if applicable.

Limited partnership losses may be subject to "at risk" limits. If so, the undeductible portion reported in the T5013 will update the Non-Capital Loss Carryforward schedule.

Capital Gains

If the taxpayer is deceased and has an allowable capital loss in the year from Schedule 3ɐ , the loss will update line [127] net of any losses carried backǹ3  and capital gains deduction claimed to date. The amount claimed is calculated in a separate workchart.

Restricted Farm Losses

If the farming loss is restricted, answer this question Y. The program will then calculate the allowable claim (if that cell has not been overridden).

Non-taxable income

Workers' Compensation payments and Social assistance payments are updated from the T5007 slip and Net federal supplements from box 21 of the T4A(OAS) slip.  These amounts are included in the calculation of net income, but are deducted (at line 250) in the calculation of taxable income.

<Application Guide Menu>'                     <Main Help Menu>   

Deductions from Total Income

RPP Contributions

The deduction for pre-1990 past service contributions (line [207]) is calculated in the RPP workchart-L . Indicate the amount of undeducted contributions from prior years, years of eligible service, and whether the taxpayer was a previous contributor in the RPP workchart.

Amounts designated on form T2097  for transfer into an RPP will also be claimed on this line.

RRSP Contributions

The RRSP deduction workchartXB  calculates the maximum allowable deduction based on the contributions made, the earned income deduction limit, and amounts designated on form T2097  for transfer into a RRSP. If you do not want to claim the maximum deduction, override the claim in the RRSP workchart or line [208].

Saskatchewan Pension Plan Contributions

The program calculates the maximum deduction allowed based on the amount of contribution entered and the maximum RRSP contribution limit after the RRSP contributed. To claim less than the maximum deduction, reduce the contribution amount.

Union and Professional Dues

Line [212a] is updated by amounts entered on T4 slips. Enter other amounts paid directly by the taxpayer in line [212b].

Only the portion of such payments which represents membership dues or dues required by law to be paid to a parity or advisory committee is deductible.

Moving Expenses

The unclaimed balance from the previous year's T1-Mǋ\  updates line [219b] in the roll forward. Otherwise, enter it manually.

<Application Guide Menu>'                     <Main Help Menu>   

Other Deductions from Net Income

Stock Options

Line [249a] is updated by one quarter of the Stock Option benefit entered in T4 slips.

Share Benefits

Enter Share Benefit Deductions in line [249b].

Losses of Other Years

The program calculates the maximum claim for each type of loss (except for Limited Partnership Losses: enter this claim in the continuity of losses carryforward workchartǹ3 ).

The automatic loss claim is restricted to the extent that non-refundable credits are fully used. Where applicable, a capital gains deduction will be claimed before capital losses.

To claim less than the maximum deduction (e.g., if the loss is not being applied against the top rate of tax), override the cell and enter the claim directly.

Losses of other years will be carried forward (by year of origin) to the Continuity of Losses Carryforward workchartǹ3  in the roll forward. If any amount is incorrect (perhaps as a result of reassessments) or the return was not rolled forward from the prior year, enter the correct amounts in that workchart.

The Net Capital Losses carried forward are separated into these categories: pre-May 23, 1985; May 23 to December 31, 1985; 1986/87; 1988/89. A maximum of $2,000 of losses incurred before May 23, 1985 can be deducted against non-capital income as calculated in the Continuity of Losses Carryforwardǹ3  schedule.

Capital Gains Deduction

The program will accept input up to the lesser of $375,000 and the amount of capital gains in line [127].

<Application Guide Menu>'                     <Main Help Menu>   

Non-Refundable Tax Credits

Age Amount

The age amount is calculated if the taxpayer is age 65 or older.

Married Amount

The spouse's net income updates from Schedule 2. If Schedule 2 is not completed but the taxpayer qualifies for a married amount credit, override the cell by entering the spouse's net income. Also enter the X where appropriate.

TIP

If the spouse has zero income, the program will be unable to distinguish between a workchart left blank (because it isn't applicable) and zeros that are entered. If this is the case, override the jacket cell and enter an X to indicate that the spouse's income was less than the minimum threshold amount.

Dependant Children

Enter information relating to dependant children in the Family Profile.  workchart. The program calculates the maximum claim based on the date of birth, net income, and infirm status.

CPP Employment Contributions

The program calculates this claim based on contributory earnings from the T4v\  slips and form T2204Ǩ .

CPP Self-Employment Contributions

Line [310] updates from the CPP Contribution on Self-Employment section for all provinces except Quebec. For Quebec residents, line [310] is calculated as the total claim in the TP1 less the claim for CPP Employment contributions in line [308].

UI Premiums

UI premiums update from the T4v\  and T4Fv\  slips and form T2204Ǩ .

The program calculates the claim based on insurable earnings in the T4 and T4F slips and the T2204.

Disability Amounts

The disability amount for dependants other than a spouse (line [318]) is updated from the Family Profile. . The number of dependants for which a claim on line [318] applies updates the T1C (Manitoba) .

If the taxpayer is claiming a disability amount for himself or herself, enter the maximum claim for the year in line [316].

The deduction is automatically prorated for part year residents.

Tuition Fees

The program will only accept tuition fees greater than $100. An official receipt must be filed to support any tuition fee claim. Tuition fees must be claimed on a calendar year basis.

The education amount is limited to $80 per month; in line [322] the program will only allow you to enter $80 or whole multiples of $80 to a maximum of $960.

An education deduction certificate (T2202 or T2202A) is issued by the educational institution to confirm full time attendance and enrollment in a qualifying program.

If an education amount is being claimed in respect of a dependant in line [324], the dependant's form T2202 or T2202A must be signed by the dependant and filed with the return.

Transfers from Spouse

The program will not accept an amount greater than the maximum possible transfer.

Schedule 2 updates the jacket if the taxpayer is married.

Donations and Gifts

The program restricts the charitable donations claim to 20% of net income.

Gifts to the Government of Canada or Canadian provinces can be deducted without limitation. The amount of such gifts not absorbed by income in the current year can be carried forwardi$  for five years. Amounts carried forward must be claimed before any gifts or charitable donations in the taxation year in which the carryforward is claimed.

<Application Guide Menu>'                     <Main Help Menu>   

Priority of Tax Calculations Chart

The chart on page 3-9 of the Personal Taxprep Application Guide shows the order of priority for which taxes payable and forward averaging tax and credits are calculated by the program. Refer to this chart if you want to know which form was used to calculate the values in the Summary of Tax and Credits area.

For example, if the T2011 is elected, it will override all other federal tax calculations in the T1 Jacket. Similarly, if the T81 is applicable, it will override all other provincial tax calculations for B.C.

<Application Guide Menu>'                     <Main Help Menu>   





                Information Slips

                Overview/T 
                T4 - Employment Earningsv\ 
                T4A - Pension, Retirement, Annuity, and Other Incomebb 
                T5 - Investment Incomeǐm 
                Other Information Slipsǜq 


Overview

Forms Manager

Each type of T-slip is listed as a form on the Forms Manager. There is also a summary form for each type of T-slip, which shows the totals of all the T-slips of that type.

Accessing the List of Slips

To access the list of slips of a particular type, highlight the T-slip type on the Forms Manager and press ENTER. If any T-slips of that type were already created, the list of those slips will then appear.

For newly created returns, an initial blank slip will appear.

This on-screen list shows only the first few boxes of each slip - enough to identify each one. When you print, this list is what will be printed, but the printout will of course include all the boxes for each slip.

Entering Data into a Slip

To enter or modify information in a slip, first access the list of slips. Then highlight the particular slip and press F9 or Enter. For newly created returns, use the initial blank slip that is provided.

When you press F9 or Enter, the whole slip (i.e., all the input cells with their descriptions) will appear on your screen. You can then freely enter or modify the amounts.

Creating Blank Slips

To create a new blank slip, select the Options / Create command (or use the Ctrl+K hotkey). You can do this either from the list of slips or from within a particular slip.

You can create an unlimited number of slips (except for the T600/T600B and T600C slips).

Moving Between Slips

While you are within a slip, you can move to the next slip in the list by pressing Ctrl+PgDn. To move to the previous slip in the list, press Ctrl+PgUp.

You can move to the first slip in the list by pressing Ctrl+Home. To move to the last slip in the list, pres Ctrl+End.

Press Esc at any time to return to the list of slips, from which you can also access any particular slip.

Deleting Slips

To delete a slip, you must first access the list of slips. Highlight the particular slip you want to delete, and select the Options / Remove command.

You cannot use this command if you are in a particular slip.

<Application Guide Menu>'                     <Main Help Menu>   

T4 - Employment Earnings

Insurable Earnings

The program defaults UI insurable earnings (Box 24) to be the same as employment income (Box 14). If the amount on the T4 differs from the default, override the amount.

Contributory Earnings

The program defaults CPP contributory earnings (Box 26) to be the same as employment earnings (Box 14). If the amount on the T4 differs from the default, override the amount.

If the taxpayer becomes age 18 or 70 in the year (based on the birth date in the Identification Section), the program will prorate these amounts.

Insurable Weeks

If the number of UI insurable weeks exceeds 52 because of an employer's pay period (e.g., 27 two week pay periods in the year), access the T2204 and enter the number of insurable weeks. This is necessary to adjust the maximum insurable earnings and required premiums.

Taxable Benefits

Certain taxable employment benefits included in Box 14 may be eligible for special deductions. Qualified employee stock option benefits are shown in Box 38 and home relocation loan benefits are indicated in a footnote to Box 36. Identify and enter these benefits in the cells provided so that applicable deductions can be calculated.

Quebec Income Tax

Enter the income tax deducted in a Relev 1 for a taxpayer who is not a resident of Quebec but has employment income earned in Quebec. This amount will then be accumulated with the federal tax deducted in the T4.

<Application Guide Menu>'                     <Main Help Menu>   

T4A - Pension, Retirement, Annuity, and Other Income

Pension and Retirement Income

Certain lump sum pension payments are eligible for transfer to a RRSP. In addition, periodic RPP and DPSP income may be transferred to a spousal RRSP to a maximum of $6,000. Income which qualifies for transfer is indicated on form T2097 as a reference. For a deduction to be claimed, the amount must be designated and a RRSP contribution must be made. A planning diagnostic will appear if a transfer of eligible pension and superannuation benefits is not claimed in the T2097.

Special Averaging

The program does not calculate Special Averaging for lump sum payments accrued to December 31, 1971. To take advantage of the special averaging provisions for this income, attach a note to the return when filing and Revenue Canada will do the necessary calculations.

Generally, this Special Averaging Tax is at the average effective federal rate of tax applicable to the taxpayer's income for the three years immediately preceding the year in which the payment is received.

Annuity income

Amount shown in Box 24 is either a general annuity or an IAAC. If the taxpayer qualifies for the Eligible Pension Income Amount of $1,000, then all or a portion of the annuity can be reported as eligible pension income. Otherwise, the amounts are considered other income.

Annuities which are taxable under paragraph 56(1)(d), net of 60(a) deduction, should be claimed as cumulative investment income on form T936.

The taxpayer will generally qualify for the pension income amount if he or she is age 65 or over. For taxpayers who are age 64 or under, the annuity will ONLY qualify if it was received due to the death of a spouse. If the taxpayer is under age 60 then he or she should also have received CPP or QPP survivor's or disability benefit. If such a benefit was not received, then the taxpayer is not eligible for the pension amount if a ss. 60(j) transfer was made into an RRSP or RPP (per T2097) other than the transfer of certain lump sum payments from a DPSP.

The amount of eligible pension income is calculated in the Eligible Pension Income Amount workchart.

Retiring Allowance

Box 26 is separated into two input cells. One is for entering a retiring allowance that is eligible for a 60(j.1) transfer to an RRSP, and the other is for the ineligible amount.

Designate the transfer on form T2097 if a RRSP contribution has been made in respect of such income. A planning diagnostic appears if a transfer of an eligible retiring allowance is not claimed in the T2097.

Other Income

Box 28 is split into separate cells so you can specify all the relevant types of income.

For scholarships, enter the full amount. The $500 exemption is automatically deducted in the Other Income Summary.

<Application Guide Menu>'                     <Main Help Menu>   

T5 - Investment income

Foreign Currency

If you enter foreign investment income in a foreign currency, enter the exchange rate so the program can convert it into Canadian dollars. The Canadian dollar equivalent appears in the column headed "YOUR SHARE". If the foreign investment income is stated in Canadian dollars, leave the exchange rate cell blank.

Splitting T5 Slips

Enter the taxpayer's share of the T5 slip if it is less than 100%. Enter the percentage with a decimal point (e.g., to enter 50%, type 50.0 [Enter]). If the spouse's percentage is entered, these percentages will update the spouse's return if the returns are coupled.

Dividend Tax Credit

It is not necessary to enter the Federal Dividend Tax Credit since the program calculates it automatically.

Pension Income

Pension Income (Box 19) is separated into two input cells to allow the program to distinguish income eligible for the pension income credit from ineligible income.

<Application Guide Menu>'                     <Main Help Menu>   

Other Information Slips

T3 - Statement of Trust Allocation

Box 25 is separated into several cells to allow the program to distinguish foreign non-business income which is investment type income (e.g., interest) from rental, property, or other type income (e.g., royalty).

Enter the taxpayer's share of the T3 slip it is less than 100%. Enter the percentage with a decimal point (e.g., to enter 50%, type 50.0 [Enter]). If the spouse's percentage is entered, these percentages will update the spouse's return if the returns are coupled.

If any Investment Tax Credits or other tax credits are indicated in Boxes 38, 41, and 42, enter the amounts where appropriate in schedule T2038 or directly on page 4 of the T1 Jacket.

T4A(P) - CPP/QPP Benefits

Amounts entered in Box 24 for OAS Pension payments will be added to any amounts entered in T4(OAS) slips to update to line [113] in the T1 Jacket.

Note:

Amounts entered in Box 15 (Survivor's Benefit) or Box 16 (Disability Benefit) enable a taxpayer under age 60 with pension income to claim the Eligible Pension Amount. The program calculates the eligible pension amount in the Eligible Pension Income Amount Workchart.

Enter the number of months that retirement or disability benefits were received to permit the calculation of CPP premiums payable on the T2204.

T4A(OAS) - Statement of Old Age Security

Box 21 (Net Federal Supplements) updates line [146] of the T1 jacket. Box 20 (OAS overpayment recovered) does not update any other form in the program.

T4PS - Profit Sharing Allocations and Payments

Boxes 37 and 38 (Foreign Non-business Income) has been combined into a single input field. We are assuming that the foreign capital gain is non-business income. However, if a capital gains deduction was claimed, box 38 must be reduced by the capital gains deduction that was claimed. Enter foreign non-business taxes paid in Box 39.

15% of the amount entered in Box 36 (the amount forfeited due to withdrawal) represents income tax deducted at source and is included in the Summary of Federal Tax Deducted from Information Slips.

T4RIF - RRIF Income

Box 16 has been split into two input cells. Enter the amount as pension income if it qualifies for the eligible pension income amount in the calculation of non-refundable tax credits. Otherwise, enter it as other income.

If Box 22 (other income and deductions) is entered as income, it will update the Other Income Summary. Otherwise it updates the Other Deductions Summary.

T4RSP - RRSP Income

Annuity benefits, Box 16, has been split into two input cells. Enter the annuity as pension income if it qualifies for the eligible pension income amount in the calculation of non-refundable tax credits. Otherwise, enter it as other income.

All income updates the Registered Retirement Savings Plan Summary, which in turn updates line [129] of the T1 Jacket. RRSP refund of premiums (Box 18) and RRSP commutation payments which are direct transfers (Box 22) are both eligible for roll-over into a RRSP in form T2097. A planning diagnostic will appear if there is no designation entered in form T2097.

Box 28, Other Income or Deductions, has been split into two input cells. The amount entered as other income updates the Registered Retirement Savings Plan Income Summary, while the amount entered as other deductions updates the Other Deductions Summary.

T600C - CSB Cash Bonuses

The total of the amounts entered updates Part II of Schedule 5. The program includes 50% of the total as taxable Canadian investment income.

T5007 - Statement of Benefits

Revenue Canada's T1 jacket for 1992 now requires the inclusion of non-taxable income to facilitate the proper calculation of net income. As a result, the non-taxable income workchart in previous versions has been eliminated. Information slip T5007 has been provided in its place. Amounts entered here will update the T1 jacket.

T5008 - Securities Transactions

Proceeds, cost and outlays from the disposition of shares and other securities are treated as capital gains or losses and are updated directly to Schedule 3. If foreign taxes were paid, the income and taxes paid updates the Foreign Tax Credit schedule for Country 1 as non-business income.

Proceeds, cost and outlays from the disposition of bearer debt obligations are treated as net interest income and are included as taxable Canadian investment income. If foreign taxes were paid, the net income will be reported as foreign investment income in Schedule 5. The net foreign income and taxes paid updates the Foreign Tax Credit schedule for Country 1 as investment income.

If the debt obligation was disposed before maturity and the interest rate has fluctuated since acquisition, the transaction may be considered a capital transaction. In this case, enter the disposition under shares and other securities.

Enter the taxpayer's share of the T5008 slip to be reported if it is less than 100%. Enter the percentage with a decimal point (e.g., to enter 50%, type 50.0 [Enter].

If the spouse's percentage is entered, these percentages will update the spouse's return if the returns are coupled.

T5013 - Statement of Partnership Income

To claim other allowable expenses which are not included in the net partnership income reported on the T5013, do not enter the net income reported on the T5013 in the T5013 slip. Instead, enter the amount in Area II of an appropriate self-employment or rental schedule. Since you can't enter gross income in the slip, enter it by overriding in the applicable self-employment summary.

Enter Actual Dividends in Box C of the T5013. The program will compute Taxable Dividends and update the appropriate amount to other schedules, such as the Summary of Investment Income from T-Slips.

T101/T102 - Renounced Resource Expenses

Amounts entered for CEE (Box 10), CDE (Box 11), and COGPE (Box 12), must be reduced by the portion of Government Assistance (Box 14) which relates to those expenses.

Amounts in Box 14 which are payable in the subsequent calendar year should not reduce the expense pools.

Enter Net Partnership Losses (Box I, T102) in any of the Resource Investment Schedules. Do not enter any renounced resource expense amounts already entered on the T101/T102 slip summaries in the Resource Investment Schedules.

<Application Guide Menu>'                     <Main Help Menu>   





    T1 Schedules

    Schedule 1 - Detailed Tax CalculationC 
    Schedule 3 - Dispositions of Capital Propertyɐ 
    Schedule 4 - Medical Expenses; 
    Schedule 5 - Investment Income 
    Schedule 6 - Additional Personal Amounts4 
    Schedule 7 - Child Tax Creditǆ 
    Schedule 8 - Self-Employment Reportǁ 
    GSTC, 
        <Application Guide Menu>'         <Main Help Menu>   



Schedule 1 - Detailed Tax Calculation

Tax Adjustments

Use the tax adjustments cell to enter additional federal taxes payable as the result of certain special tax provisions. The two most common adjustments arise from:

 - Special Averaging on lump sum pension payments accrued to Dec. 31, 1971.

 - Special medical expenses when claiming the medical expenses notch provision for a non-dependant as indicated on Schedule 4.

This cell will be updated from Schedule 4 for the special notch provision tax adjustment if the question at the bottom of Schedule 4 is set to Y.

Federal Dividend Tax Credit

The federal dividend tax credit is 13 1/3% of taxable dividends. The program calculates the total dividend tax credit based on the amount of dividends in line [120] of the jacket.

Refundable Quebec Abatement

The Refundable Quebec Abatement is adjusted if there are Forward Averaging Tax Credits for the year. By setting the update rule in the T541 to Y, the adjustments to the Refundable Quebec Abatement will be updated based on calculations in that form (if applicable).

<Application Guide Menu>'                     <Main Help Menu>   

Schedule 3 - Dispositions of Capital Property

Subsidiary Schedules

There is a separate form available for each type of capital asset where you can provide detailed listings of dispositions.

Principal Residence

There is a separate cell for gains on disposition of a Principal Residence (Form T2091). Form T2091 is not in the program; you must obtain it from Revenue Canada and attach it to the return in support of any amounts entered in Schedule 3.

Mortgage Foreclosures and Treaty Exempt Gains

Enter the non-taxable portion of total capital gains due to mortgage foreclosures and treaty exemptions at the bottom of the form. These amounts will update form T691 as a reduction in the calculation of adjusted taxable income. The taxable portion of mortgage foreclosures is excluded from net income for clawback purposes.

LPP Losses

Enter the amount of any LPP Loss carryforward where indicated (if not rolled forward form the prior year).

Non-eligible capital gains

A workchart to calculate the portion of capital gains which is not eligible for the capital gains deduction is shown at the bottom of this schedule.  The amount calculated updates line [536]  of Schedule 3.  The non-eligible portion is used to determine capital gains deduction (Form T657) and cumulative investment income (Form T936).

<Application Guide Menu>'                     <Main Help Menu>   

Schedule 4 - Medical Expenses

Type of Dependant

A cell is provided to identify what type of dependant the medical expense claims relates to. This enables the program to analyze the expenses and produce diagnostics with respect to optimizing the claim.

Notch Provision

If medical expenses are claimed in respect of a dependant not included in the taxpayer's claim for personal amounts, enter that dependant's net income where indicated for purposes of calculating the special notch provision tax adjustment.

The taxpayer should carefully evaluate the benefits of claiming such medical expenses against the special tax adjustment.

<Application Guide Menu>'                     <Main Help Menu>   

Schedule 5 - Investment Income

Foreign Income

Enter foreign source income and foreign source carrying charges in Canadian dollars. Foreign source income does not update the Foreign Income and Taxes Paid Workchart. You must enter such amounts directly in other appropriate schedules.

CSB Cash Bonus

CSB cash bonuses entered through the T600C information slips update Schedule 5 separately from the other information slips. 50% of the total is calculated as taxable investment income.

Limited Partnership / Non-Active Partner Income or Loss

Income or loss from limited partnerships or where the investor is an inactive partner updates Part III of Schedule 5 from the Tax Shelter Investments / AMT workchart. The Tax Shelter Investments / AMT workchart summarizes limited / non-active partnership income or loss from: real estate (updated from form T776), certified films (entered directly in the workchart), and resource before exploration and depletion expenses (updated from the Resource Income/Loss and Resource Expenses Pool workchart). Limited partnership income (loss) reported in Box 10 of the T5013 slip update directly to Part III without updating the AMT/tax shelter workchart. An additional input line allows you to enter additional income or loss of this nature.

The total of Part III updates line 122 of the T1 jacket and the CNIL calculation in T936.

Record interest expenditures incurred to acquire limited / non-active partnership investments separately in Part IV of Schedule 5.

<Application Guide Menu>'                     <Main Help Menu>   

Schedule 6 - Additional Personal Amounts

Equivalent to Married

An equivalent to married amount can be claimed instead of an amount for a dependant if the taxpayer meets certain requirements.

Make the claim in the Family Profile workchart. To calculate the allowable exemption, you must enter the dependant's:

    - date of birth.

    - net income ($CDN).

    - infirmity, if over 18 years old.

If an amount is being claimed in respect of a non-resident dependant, complete form T1E-NR along with Schedule 6.

<Application Guide Menu>'                     <Main Help Menu>   

Schedule 7 - Child Tax Credit

Child Tax Credit

Enter the number of eligible children and net incomes of the spouse and other supporting person (if any) in the Family Profile workchart.

As well, indicate the amount of child care expenses claimed relating to each eligible child in the Family Profile workchart.

Only the taxpayer who is entitled to receive family allowance payments (normally the wife) can claim this credit.

<Application Guide Menu>'                     <Main Help Menu>   

Self-Employment Report & Calculation of CPP Contributions on Self-Employment Earnings

Pensionable earnings are calculated by the program as the total of amounts from net self-employed income (lines [135] to [143], and [122] excluding the portion from real estate).

Deficient Contributions

If contributions through employment were deficient based on the pensionable earnings reported on the T4 slip, CPP payable will reflect deficient contributions from employment. In short, CPP payable will exceed 4.8% of self-employment earnings.  If you do not agree with this calculation, you may override line C with the required contribution.

Between Age 18 and 70

If the taxpayer is between the ages of 18 and 70 and received CPP/QPP retirement or disability benefits in the year, enter the number of months the benefits were received in the year on form T4A(P).

<Application Guide Menu>'                     <Main Help Menu>   

GSTC

The GST credit calculated in this form is for review and reference only. This calculation should not be filed with the T1 return.

Eligibility and entitlement

You can override the eligibility and entitlement question at the top of this form.  Taxpayers whose net income is too high to claim a credit (at line 20) will not be entitled to a claim.

Family Information

Family information is updated from other forms throughout the program: marital status from the Identification section; eligibility for equivalent-to-married credit from Schedule 6 unless an other supporting person is indicated in the Family Profile workchart (in this case, the dependent is claimed as a qualified child); and the number of qualified children from the Family Profile workchart.

Additional Credit

The calculation of an additional credit at line 14 may only be claimed if the taxpayer was not married or living common-law.

Under 19 Years

A taxpayer who was under 19 years old and not married at the end of the year will be deemed not eligible for the GSTC. However, if that taxpayer is a parent, change the eligibility to Y.

<Application Guide Menu>'                     <Main Help Menu>   



                Provincial Forms

                B.C., Alberta, and Saskatchewan Credits
 
                Manitoba Tax Credits 
                Ontario Tax CreditsǑ 
                Tax Credits for Atlantic ProvincesǏ 
                Resource Tax Rebate and Credit Schedulesq 
B.C., Alberta, and Saskatchewan Credits

British Columbia

The family net income amounts update from the Family Profile workchart. If any of these amounts are different for purposes of the B.C. renter's tax reduction, override the cell.

Enter B.C. political contributions and the Total B.C. Venture Capital Tax Credit (from Certificate FIN 565) in the applicable lines. The appropriate credit will then be calculated.

Alberta

Alberta income tax is calculated in T1C(ALTA.). The Alberta Royalty Tax Rebate Applied cell updates from the T79.

Saskatchewan Tax Credits

The Married Equivalent Tax Reduction is calculated if it is claimed in Schedule 6.

The Child Tax Reduction is calculated based on dependant children under the eligible age indicated in the T1 Jacket.

The senior citizen tax reduction is claimed depending on the taxpayer's age.

You must enter applicable Saskatchewan Tax Incentives directly. The unused Saskatchewan tax credit from previous years is updated by the roll forward. Unused labour sponsored venture capital tax credit will not be carried forward.

The amount of such credits is calculated on schedule T2C(SASK.), which is not in the program.

<Application Guide Menu>'                     <Main Help Menu>   

Manitoba Tax Credits

Cost of Living Credit

If the taxpayer is not eligible for the COL credit, set this question to N.

To claim a joint COL credit for married couples, set the question to Y and enter the amounts for the spouse's net income and the amounts claimable for age and disability credits.

The age credit will be claimed automatically depending on the taxpayer's age entered in the I.D. Section.

Coupled Returns

If the return is coupled, the spouses net income, age credit, and disability credit will be determined by the program based on the information in the Family Profile workchart and the spouse's return.

Other Credits

The equivalent to married credit can only be claimed if the spouse's credits are not claimed. The disability claims for the taxpayer and the taxpayer's dependants will be determined by the information in the T1 jacket.

Enter amounts for total rental payments, property taxes paid, and Residential Homeowner Tax Assistance and Shelter Allowance Benefits received. If the Property Tax Credit is not to be claimed, set the appropriate question to N.

Enter details of residences for the Property Tax Credit on the form as indicated. If you need more space, use the Edit / Attach command to create a separate schedule.

Enter political contributions in the appropriate cell so the program can calculate the credit.

<Application Guide Menu>'                     <Main Help Menu>   

Ontario Tax Credits

Claiming the Credits

If both spouses lived together at the end of the year, one spouse must claim the tax credits for both spouses. Either spouse can make the claim, regardless who had the higher income.

Property Tax Credit

The Property Tax Credit is not available to:

 - persons under age 16.

 - persons under age 19 who live at home and are claimed as a dependant by another taxpayer.

 - estates of deceased persons.

If the Property Tax Credit is claimed, enter amounts for total rental payments, property taxes paid, and the college residence amount.

Enter the details of residences as indicated. If you need more space, use the Edit / Attach command to create an additional schedule.

Sales Tax Credit

The Sales Tax Credit cannot be claimed by:

 - persons under age 16.

 - persons claimed for a sales tax credit by another resident of Ontario.

 - estates of deceased persons.

You must set the cell relating to eligibility for the Sales Tax Credit to N for the spouse who is not claiming the credits for both spouses.

Coupling

The coupling procedure will claim the Sales Tax Credit for the spouse specified and will update the number of dependant children specified in the Family Profile workchart.

OHOSP

If the taxpayer is not eligible for the Ontario Home Ownership Savings Plan tax credit, set this question to N.

The program limits contributions made by the taxpayer and his or her spouse to $2,000 each.

<Application Guide Menu>'                     <Main Help Menu>   

Tax Credits for Atlantic Provinces

New Brunswick

The amount entered in the T1C(N.B.) for the New Brunswick Stock Savings Plan Tax Credit will be limited to the lesser of New Brunswick Tax Payable less Political Contribution Tax Credit, and $3,000.

Nova Scotia

The amount entered in the T1C(N.S.) for the Nova Scotia Stock Savings Plan will be limited to the lesser of Nova Scotia Tax Payable less the Political Contribution Tax Credit, and $3,000.

If the taxpayer is not eligible for the Nova Scotia Home Ownership Savings Plan Tax Credit, set the question provided to N. The program limits the amount of contribution made by the taxpayer and spouse to $2,000 each.

Newfoundland

The program limits the total of the Newfoundland Stock Saving Plan Tax Credit and the Newfoundland Venture Capital Tax Credit to $3,000. Unused Newfoundland tax credits from prior years are carried forward in the roll forward.

<Application Guide Menu>'                     <Main Help Menu>   

Resource Tax Rebate and Credit Schedules

T78 - Manitoba Mineral Tax Rebate

To use this from, answer Y to the question "Is the taxpayer applying for a Manitoba Mineral Tax Rebate?".

This schedule calculates Manitoba provincial tax payable based on revised taxable income for tax rebate purposes. If the amount of tax is less than the tax based on normal taxable income, then that amount becomes the Manitoba tax payable.

Enter the percentage of resource profits earned in Manitoba to determine the Resource allowance allocated to Manitoba.

The T78 updates either the T1 Jacket or schedule T2203 if the question is answered Y.

T79 - Alberta Royalty Tax Rebate

This schedule calculates the amount of the Alberta Royalty Tax Rebate which is deductible from basic Alberta provincial tax payable.

Enter information not already updated from the Resource Investment Statements.

The T79 updates Schedule 1 and Form T2203.

T81 - B.C. Royalty and Deemed Income Rebate

This schedule calculates B.C. tax payable based on the portion of taxable income entered in the first input cell. The T81 will calculate only if you answer Y to the question "Is the taxpayer applying for a B.C. Royalty and Deemed Income Rebate?".

The T81 updates the T1 Jacket and form T2203 if the question is answered Y.

T82 - Saskatchewan Royalty Tax Rebate

If you answer Y to the question "Is the taxpayer applying for a Saskatchewan Royalty Tax Rebate?", this form calculates Saskatchewan tax payable including a Royalty Tax Credit (Line (R)).

Enter information not already updated from the Resource Investment Schedules. The program determines the credit and adjusts Saskatchewan Tax Payable accordingly.

If the question is answered Y, the T82 updates the T1 Jacket, T1C(SASK), and form T2203.

AT60 / AT78

These schedules are calculated from information entered on the Resource Investment Statements.

The Alberta Royalty Tax credits do not update the T1 return. These forms are to be filed separately to the Alberta Treasury, Corporate Tax Administration.

<Application Guide Menu>'                     <Main Help Menu>   



                Income and Deduction Summaries

                Other Pensions/Superannuation Summaryǹ 
                Other Income Summary 
                Other Deductions Summary4 
                Additional Deductions Summary# 
Other Pensions/Superannuation Summary

This schedule is a summary of pension income. that updates line [115] of the T1 Jacket. Pension and superannuation payments from a T3 and other life annuities except other pension benefits (entered directly on the last line) update the Eligible Pension Amount workchart.

Amounts in T3, T4A, T4(RIF), and T5 slips update this summary if such annuities are entered as "pension income". If a taxpayer is under age 65, then RRIF, DPSP, and general annuities qualify as pension income only if they were received as a result of the death of a spouse.

Foreign Pension Income

Additional cells allow you to enter foreign pension income. U.S. Social Security (retirement/survivor) benefits qualify for the Eligible Pension Amount. Other foreign pension income paid as a life annuity also qualifies as eligible pension income. Enter other foreign pension annuity income that does not qualify in the last line as "Other pension income, not eligible".

<Application Guide Menu>'                     <Main Help Menu>   

Other Income Summary

RRIF, DPSP, and general annuities not indicated as "pension income" in the appropriate slips update the Other Income Summary.

The total of Other Income in this summary updates line [130] of the T1 Jacket.

Enter any property income included in Total Other Income, excluding the recovery of Exploration and Development expenses, in the cell at the bottom of this form.

The property income and half of the recovery of Exploration and Development Expenses updates form T936 for the CNIL calculation.

<Application Guide Menu>'                     <Main Help Menu>   

Other Deductions Summary

This schedule is a summary of deductions from total income that are not identified elsewhere in the return.

Miscellaneous Amounts

Additional lines allow you to enter UI, OAS, and Taxable Family Allowance benefits repaid (required to calculate social transfer repayments payable in the clawback workchart), legal fees to collect salary/wages (required to calculate income/loss from employment), and transfers of qualifying income to RRIF, RPP, and qualifying annuities.

The summary updates line [232] of the T1 Jacket.

Property Income Expenses

Enter expenses to earn property income included in Total Other Income (excluding unclaimed foreign non-business tax credits (ss 20(11)/(12)) and Total Depletion Allowances) in the cell at the bottom of the form. This amount updates form T936 for the CNIL calculation.

Clergymen's Residence

Clergymen's residence allowance is exempt from CPP. A diagnostic will warn you to check if pensionable earnings on the T4 exclude this allowance.

Repayment of Shareholder Loans

To the extent the repayment exceeds employment income, the amounts entered here could create or increase a non-capital loss in the T1A.

<Application Guide Menu>'                     <Main Help Menu>   

Additional Deductions Summary

Enter deductions for exempt income under tax treaties and for vows of perpetual poverty in this form. The exempt portion of U.S. Social Security is automatically calculated from the gross amount entered in the Other Pension Income Summary. Enter the portion of other foreign income exempt under a tax treaty in the appropriate categories so the program can calculate the eligible pension income amount and income qualifying for 60(j) transfer.

This summary updates line [256] of the T1 jacket.

<Application Guide Menu>'                     <Main Help Menu>   



                Self-Employment Schedules

                Self-Employment Income and Expense Statements 
                Capital Cost Allowanceǿ 
                Fixed Assetsǁ 
                Leaseholds (Class 13) 
                Mandatory Inventory Adjustmente 
                Real Estate Rentals and CCA 


Self-Employment Income and Expense Statements

Each category of self-employed income has a workchart which summarizes gross and net income from the various reporting sources.

If financial statements already exist, you can use form T2130 to reconcile accounting income to taxable income. Two T2130's are provided for each type of self-employment category.

If financial statements do not exist, you can use the five approved format self-employment schedules for each type of self-employed income. There is also one commission statement.

Partnerships

Most partnerships with more than five partners must file their partnership information on a T5013. As a result, these types of self-employed income may be entered on the T5013 information slip. To claim additional allowable expenses or make adjustments to income as reported on a T5013 slip, report the income in one of the five prescribed format self-employment schedules instead of entering income on the T5013.

You can enter the appropriate percentage of the net income/loss from the business in the self-employment schedule.

Spousal Partnerships

If self-employed income is shared with a spouse, that information can be transferred to the spouse's return in the coupling process. See "Coupling".

Home Expenses

Information relating to the Business Use of Home Expenses may be entered if applicable. If self-employment income relates to a partnership, then such expenses will be automatically allocated to the taxpayer's portion of the partnership income/loss.

The program carries forward the unused portion of such expenses to the following year through the roll forward.

CCA

Full Capital Cost Allowance schedules with unlimited fixed asset records are available for each self-employment schedule.

The Capital Cost Allowance schedules are divided into regular classes, class 10.1 (passenger vehicles), and class 13 (leaseholds). See the next section in this Guide for details.

<Application Guide Menu>'                     <Main Help Menu>   

Capital Cost Allowance

Creating a CCA Class

To create a CCA class, access the applicable CCA schedule (e.g., T2124-CCA) and use the Options / New command (or use the Ctrl+K hotkey). A dialog box will then appear where you may choose the class number. Highlight the class you want and press <ENTER>.

Entering Information for a CCA Class

To access the input schedule for a class number that you have created, highlight that class and press F9. A detailed input screen for that class will then appear where you can enter information for that class.

Removing a CCA Class

To remove a class, access the CCA schedule and highlight that class (with the up and down arrow keys). Then select the Options / Remove command from the pull-down menu.

Additions and Disposals

For each class, you can either enter the total amount of additions and disposals or you can enter the details of each addition and disposal in a supporting schedule. To access the detailed fixed asset records, highlight the additions or disposals line and press F9. See the next section in this chapter for further information on entering fixed asset details.

Passenger Vehicles (Class 10.1)

You must enter the dates of all acquisitions. This allows the program to determine if the acquisition was made in the current year.

The acquisition cost used to determine the class of an automobile purchased after December 31, 1990 must not include GST or PST. The $24,000 addition to class 10.1 may then be adjusted for the portion of GST and PST, net of any refund, paid on $24,000.

If a Class 10.1 vehicle purchased in a previous fiscal year is disposed in the current year then half of the normal CCA claim is claimed. Based on the Draft Legislation of December 20, 1991, the program does not require that another class 10.1 automobile be acquired during the current year to qualify for the 50% CCA claim.

Leaseholds (Class 13)

Create a separate class 13 record for each leasehold interest regardless how many additions were made in the current or prior years for that leasehold interest.

For more information on entering leaseholds, see the section on Leaseholds later in this chapter.

<Application Guide Menu>'                     <Main Help Menu>   

Fixed Assets

Purpose

The fixed asset schedule can be used to maintain a complete record of all assets acquired and disposed of. The schedule can be used to record only current year additions, or both current and prior year additions.

When the appropriate investment tax credit code is given, this schedule can also be used to calculate the available ITC credits for the current year.

Entering Fixed Assets

To enter fixed asset information, expand from the additions (half-year or full year) or the disposals cell in the input schedule for the appropriate CCA class by pressing F9 or Enter. This will bring up the listing of all fixed assets entered for that class. To enter a new fixed asset, use the Options / New command (or use the Ctrl+K hotkey). The dialog box will ask you to select the appropriate ITC code. If the asset does not qualify for an investment tax credit, select N/A.

To enter or modify the fixed asset information, highlight the appropriate fixed asset in the listing and press F9 or Enter.

Removing Fixed Assets

To remove a fixed asset, highlight the asset in the CCA F/A listing and use the Options / Remove command.

Acquisition Date

The acquisition date is used to determine if the asset was acquired in the current taxation year, or a prior year. If the asset was not deemed to be put into use until a subsequent taxation year, enter the date the asset was put into use instead of the date of acquisition.

Investment Tax Credit

Through the roll forward procedure, the program will update the amount of ITC claimed in the prior year for each CCA class.

However, if you wish to use the fixed asset schedule to track the adjusted cost base of the individual asset, you must determine the portion of this amount which relates to each individual asset and enter it in the fixed asset input schedule.

Totals of Additions and Disposals

Because the listing of fixed assets includes both current and prior year additions, the total additions in the year is not simply a total of everything listed. The Note column has been provided to help quickly distinguish between current and prior years' additions as well as disposals.

Roll Forward

All additions which are still on hand at the end of the taxation year will be carried forward to next year as part of the roll forward procedure.

<Application Guide Menu>'                     <Main Help Menu>   

Leaseholds (Class 13)

When you select class 13 either by accessing an existing record in your CCA schedule or by creating a new class 13 record, the program displays a different input screen than the one used for other classes.

Termination Date

Enter the termination date for each leasehold interest in the cell provided so that the proper CCA can be calculated. The program defaults this cell to the current tax year end and provides a default amortization period for current year additions of five years (minimum amortization period).

Annual CCA Amount

The annual CCA on prior year additions can be:

 - rolled forward from the prior year.

 - calculated and entered by the preparer.

 - calculated by the program based on details of all prior year additions.

Entering Prior Year Additions

To enter prior year additions, expand from the Annual CCA on prior year additions cell in the CCA-L.I. schedule. This will bring up the Year By Year Listing of Leasehold Additions schedule. To enter a prior year addition, select the Options / New command (or use the Ctrl+K hotkey) to create a class 13 fixed asset record. Then press F9 to access this record and enter the details.

Use one leasehold additions input schedule for each prior year in which additions were made for that leasehold interest. The total CCA applicable to prior years will then be summarized in the year by year listing and updated to the CCA-L.I. schedule.

Date of Prior Taxation Year

Be sure to enter the first day of each prior year in which leasehold additions were made in the cell at the top of the prior years additions input schedule. The program uses this date to properly calculate the annual CCA for that year. If no date is entered, the amortization period for the prior year leasehold additions will default to 40 years (maximum amortization period).

<Application Guide Menu>'                     <Main Help Menu>   

Mandatory Inventory Adjustment

This workchart updates line [635] of the NISA - Statement A, farming income statement and T2042.

The mandatory inventory adjustment is only applicable when there is a net loss at line [630] of NISA - Statement A. The applicable fixed amount (under the Fixed Dollar Method) and the multiplier (under the Elective Method) is determined by the beginning of the fiscal period entered.

Selection of Method

The program calculates the mandatory inventory adjustment under both methods and selects the method which produces the lower value. You can override the selected method.

Short Year Ends

If the fiscal period is less than 51 weeks, the minimum designated inclusion rate for specified animals and the fixed dollar amount must be prorated manually.

<Application Guide Menu>'                     <Main Help Menu>   

Real Estate Rentals and CCA

Separate Statements

There are ten separate T776 Statements of Real Estate Rentals (each with a separate CCA Schedule). They are summarized for purposes of updating the T1 Jacket. The description cell in the summary updates from the first line in the Address of Property section of the particular statement.

T5013

Amounts in Box 11 of the T5013 slip update the summary of real estate rentals.

MURBs

Enter the portion of net income/loss and CCA claimed as a result of investments in MURBs in the cells provided at the bottom of the summary screen. These amounts update the Tax Shelter Investments/AMT Workchart.

Joint Ventures and Partnerships

Input cells are provided in each statement for the percentage of a Joint Venture or Partnership and percentage of total CCA claim. To enter amounts in these cells, enter the correct percentage amount with a decimal (e.g., to enter 50%, type 50.0 <ENTER>). To enter amounts directly for the taxpayer's share, leave the percentage cells blank. If a recaptured depreciation is calculated in a joint venture, the percentage of rental income apportioned to the taxpayer/joint venturer will exclude the recapture.

CCA Calculation

Each calculation requires a class number. The program determines the rate. Calculations are made using the normal half-year rule for additions and disposals.

If the class is not calculated on a percentage basis (e.g., Class 13), override the automatic CCA claim calculation and enter the correct amount.

Restrictions on CCA Claimed

The program restricts CCA claims to the total of net income/loss before CCA claimed plus recaptured CCA for all properties indicated as restricted. If CCA claimed is not to be restricted for any particular property, change the override rule at the end of the rental statement to N. That property will then be excluded from the CCA limitation calculations of the other restricted properties.

CCA Optimization

When CCA is restricted, the program does not necessarily optimize the CCA claim (i.e., CCA on larger rate classes should be reduced first to provide maximum benefit for future years). The program reduces CCA based on the order items were entered.

Separate Classes

Each rental building costing $50,000 or more acquired after 1971 must be shown as a separate CCA class.

<Application Guide Menu>'                     <Main Help Menu>   



                Workcharts and Other Summaries

                Information Slip Summaries
 
                Allowable Business Investment Losses Workchartk 
                AMT/Tax Shelter Investments WorkchartM 
                CSB (Compound Interest) Schedule 
                Donations Summaryi$ 
                Foreign Tax Credits and Sec.20(11/12) Deductionj* 
                Child Tax BenefitU2 
                Continuity of Loss Carryforwardsǹ3 
                Resource Income/Loss and Resource Expense Pools: 
                Resource Investment StatementsǗ? 
                RRSP Deduction WorkchartXB 
                RPP Deduction Workchart-L 


Information Slip Summaries

Federal Tax Deductions

The Summary of Federal Tax Deductions from Information Slips provides space to enter tax deductions from information slips that are not included in the program.

Foreign Income and Taxes

Foreign income and taxes paid reported on T3, T4PS, T5, T5013, and TB-D slips and the T626 update the Summary of Foreign Income and Taxes Paid from T-Slips.

If there is a single type of foreign income, the information in this summary updates the Foreign Tax Credits form.

If there is more than one type of foreign income, the information will not update the Foreign Tax Credits form. You must enter all of the foreign income and taxes paid information directly into the Foreign Tax Credits form. In this case, do not enter any other foreign information in this summary.

<Application Guide Menu>'                     <Main Help Menu>   

Allowable Business Investment Losses Workchart

An allowable business investment losses (ABIL) is a special type of capital loss of which three quarters can be deducted from other non-capital income in the year realized. Such losses generally result from the disposition of shares and certain debt obligations of Canadian controlled private corporations (CCPC) in an arms-length transaction or as a result of a bankruptcy.

The ABIL workchart updates line [217] of the T1 Jacket.

Capital Gains Deduction

To the extent that capital gains deductions were claimed in prior years, the ABIL must be reduced and the reduction treated as a regular capital loss. The program will update prior capital gains deduction claims from form T657 unless overridden. The capital loss attributable to the reduction of business investment losses updates line [535] of Schedule 3 (Summary of Capital Dispositions).

If capital gains deduction claims have reduced ABIL in prior years, the capital losses which resulted will offset the reduction of ABIL in the current year.

The allowable business investment loss must be reduced by certain other items; specify these in the line provided.

<Application Guide Menu>'                     <Main Help Menu>   

AMT/Tax Shelter Investments Workchart

This workchart summarizes information relating to investments in certain limited partnerships and partnerships in which the taxpayer is non-active (i.e., MURBs and other real estate investments, Canadian and Quebec Certified film investments, and Resource investments) for purposes of updating the T1 Jacket, Schedule 5, and the CNIL calculations in form T936.

It also summarizes information relating to MURB investments, Canadian and Quebec Certified film investments, and Resource Investments for purposes of updating minimum tax calculations in form T691.

Real Estate Investments

Real estate investments relating to limited/non-active partnerships and MURBs update from the analysis in the Summary of Real Estate Rentals (form T776). Information relating to MURBs is summarized for purposes of updating forms T691. Net income/loss from limited/non-active real estate investments updates the summary of net income (loss) for tax purposes at the top of the workchart.

Certified Film Investments

Investments in certified films are broken down between certified Quebec films and certified Canadian films. Information relating to these investments is updated from the film statements.

These types of film investments are summarized for purposes of updating form T691 and the T1 Jacket.

Resource Investments

Resource Investments update from the Resource Income/Loss and Resource Pools Workchart. Income or loss for tax purposes which resulted from the sale of foreign resource properties should also be entered in the cells provided.

Income is summarized to be from limited/non-active partnership and active business for purposes of updating to the T1 Jacket, Schedule 5 and form T691. The income/loss from such limited/non-active investments is calculated before any deduction for Exploration/development expenses or Depletion Allowances. These deductions are summarized near the bottom of the form.

Summary of Net Income/Loss from Tax Shelter Investments

A summary of net income/loss, exploration and development expenses, and depletion allowances from limited/non-active partnerships is provided for purposes of updating Schedule 5, Parts III, V, and VI. Another summary of net income/loss from active business related to such investments is also provided to update the Summary of Business Income (line [135] of the T1 Jacket).

<Application Guide Menu>'                     <Main Help Menu>   

CSB (Compound Interest) Schedule

The Canada Savings Bond (CSB) Schedule tracks and calculates the amount of interest to report on a "Bond Year" basis.

Note:

If bonds have been accrued on a calendar year basis, do not use this schedule. Calculate such calendar year accruals manually and enter them in Schedule 5.

A separate section for each series (year) allows you to enter up to eight separate compound interest (Series "C") bonds. Indicate the reporting method used for each bond. The face values of the bonds must be in even $100 amounts. The program calculates accrued interest for the current year (if applicable), interest reported in prior years, and interest to report for the year.

Cashed Bonds

If a bond was cashed during the year, enter the amount of interest received on form T600 or T600B. The program will then ignore interest accrued for the current year. Do not enter these same amounts in the summary of T600/B slips, or they will be double counted in Schedule 5.

Note:

If interest reported in prior years as calculated by the program does not agree with amounts actually reported, then the tax returns for those prior years have been filed incorrectly. Revenue Canada has requested that such errors be reported in writing, requesting an adjustment of the prior year returns.

Totals

Interest to report for the year is calculated separately for each bond as either: (i) interest accrued in the current year, or (ii) interest received in the current year less interest reported in prior years. Therefore, the totals for each series and the summary will not necessarily add across.

Post '89 Bonds

The three year accrual option is not available for bonds acquired after 1989.

The Bank of Canada will send holders of Series 45 "C" bonds and subsequent series a T5 information slip showing the interest to accrue.

<Application Guide Menu>'                     <Main Help Menu>   

Donations Summary

Calculated Claim

To claim less than the allowable claim calculated, override the amount in line [340] of the jacket.

U.S. Donations

To designate U.S. charitable donations, place an X in the U.S. column beside the amount.

Foreign Donations

Donations to certain foreign universities attended by contributing Canadian taxpayers (or their near relatives) are charitable donations (Code 1).

Donations to U.S. charitable organizations (which are recognized as such by U.S. law and which would have qualified in Canada if they had been Canadian organizations) are allowed, but only up to 20% of U.S. source income. Such donations are U.S. Other (Code 2). If any donations are indicated as Code 2, the amount of net U.S. source income must be entered where indicated.

Net Income Limitation

Net income includes certain non-taxable items for purposes of calculating the 20% limitation. Enter this income in the Non-Taxable Income Workchart.

Carryforwards

Be sure to enter donations carried forward from prior years (except those updated as part of the roll forward procedure).

Donations in excess of 20% of net income and the unused portion of the maximum allowable donations can be carried forward to the next taxation year.

Donations by Spouse

Donation receipts made out to a spouse can normally be claimed by the other spouse. When their combined donations exceed $250, it is advantageous for only one spouse to make the claim.

<Application Guide Menu>'                     <Main Help Menu>   

Foreign Tax Credits and Sec.20(11/12) Deduction

There are individual forms for five countries and a summary of all the countries.

If there is only one type of foreign income, the foreign income and taxes paid will update from the Summary of Foreign Income and Taxes Paid to the form for Country #1. If it was received from more than one country, override the amount and allocate the correct proportion to each country.

Breakdown by Country

The calculations for each country are divided into the following areas:

- Summary of Foreign Tax Credit Information.

- Federal Non-Business Foreign Tax Credit.

- Federal Business Foreign Tax Credit.

- Additional Federal Foreign Tax Credit.

- Provincial Foreign Tax Credit.

Automatic Calculation

By entering the information at the top of the form for each country, the program will calculate the non-business and business foreign tax credits (including Section 20(11) and optimized Section 20(12) deductions) for each country.

Type of Income

You can enter up to five amounts of foreign income and taxes paid/carried forward for each country. Identify each amount with a type code (1 to 5) so the program can calculate the credits and Section 20 deductions (if any).

S.S. 20(11) Deduction

For investment income where the subsection 20(11) deduction will be based on a percentage other than 15%, use type code 5 and enter the appropriate rate.

Non-Resident Surtax

In the calculation of business foreign tax credit, the amount of federal non-resident surtax paid is apportioned between countries based on net business income. No amount is allocated to countries with net business losses.

Foreign Tax Carryforward

The program calculates the business foreign tax credit to be carried forward.

Updating the Tax Calculation

The Foreign Tax Credit schedule updates Schedule 1, form T2203, and the various schedules calculating tax payable for certain provinces (e.g., schedule T541, T581).

<Application Guide Menu>'                     <Main Help Menu>   

Child Tax Benefit

This workchart calculates the benefit available to the taxpayer for the period from July 1993 to June 1994 based on the information contained in the return. This benefit will be of interest to low-income taxpayers and is incorporated in the Client Letter.

<Application Guide Menu>'                     <Main Help Menu>   



Continuity of Loss Carryforwards

Entering Prior Year Information

Enter the balance carried forward for net capital and limited partnership losses. Enter other losses (non-capital, restricted farming, farm/fish, other, and LPP) in the appropriate year column. The program will carryforward the balance at the end of the prior year as part of the roll forward. Carefully review the allocation of losses carried forward by taxation year and adjust them where necessary (in case of assessments, expired years, and so on).

The capital loss balance carried forward represents the allowable portion applicable to the year of origin. For example, for an actual capital loss of $1,000 in 1987 where a 50% inclusion rate was applicable, enter $500.

The program adjusts the balance of capital losses available and claimed in the year to take into account the change in inclusion rates.

Pre-86 Capital Losses

Enter the portion of capital loss incurred before May 23, 1985 if it was not carried forward during the roll forward. The program calculates the amount of this loss (up to a maximum of $2,000) that can be applied against non-capital income. Override the cell to claim less than the maximum.

The portion of capital losses incurred between May 23, 1985 and December 31, 1985 should be identified since it is relevant to Alternative Minimum Tax calculations (T691).

Limited Partnership Losses

You must enter the current year claim for limited partnership losses carried forward since it will depend on the future income from the specific limited partnership which resulted in the loss carried forward.

The amount of losses carried forward and the claim for limited partnership losses carried forward update the T1 Jacket and Schedule 3 (for LPP losses).

<Application Guide Menu>'                     <Main Help Menu>   

Resource Income/Loss and Resource Expense Pools

Resource information from this schedule is used in the AMT/Tax Shelter Investments workchart for updating the T1 Jacket, Schedule 5 (for limited/non-active partnerships), and form T691 (minimum tax).

Active Business

The analyses in the Federal and Quebec Summaries assume that information from the Statement of Resource Income/Loss and the Resource Expense Pools is from limited/non-active partnerships. If this is not the case, make the appropriate allocation to active business with respect to Net Resource Income/Loss and Exploration/Development expenses and Depletion. This allocation is necessary for the AMT/Tax Shelter workchart to properly update Schedule 5, line [135] of the T1 Jacket, and line 241 of the TP1.

Amount Claimed

The Resource Expense Pool claims the maximum for each type of pool by default. Use the override option to modify the calculated claim.

CCA

The separate CCA schedule allows you to record CCA on resource assets. The CCA claim from this schedule updates the calculation of Resource Profits for purposes of the Resource Allowance.

<Application Guide Menu>'                     <Main Help Menu>   

Resource Investment Statements

Complete as many Resource Investment Statements as you need. Information from these individual schedules is summarized and updated to the Summary of Resource Investment Statements. This summary in turn updates the Resource Income/Loss and the Resource Expense Pools workchart.

Royalty Tax and Rebates

Enter additional information on provincial tax rebates and credits on each Resource Investment Statement so the program will update the applicable Royalty Tax and Rebate schedules.

Forms T78, T79, T82, and AT60/AT78 will be updated for the accumulated amounts entered for each investment.

<Application Guide Menu>>'                     <Main Help Menu>   

RRSP Deduction Workchart

This workchart calculates the maximum RRSP deduction claimable on line [208] of the T1 Jacket. It also summarizes RRSP contributions and calculates any excess RRSP contributions and unused deduction limits to be carried forward to subsequent years.

Deduction Limit

The maximum RRSP deduction is based on the prior year's earned income, which is updated through the roll forward. However, you should confirm the deduction limit by comparing it with the Notice of Assessment sent by Revenue Canada for the previous year.

Past Service Pension Adjustments

You must enter any Net Past Pension Service Adjustments which relate to the previous year.  To calculate your 1992 deduction (which is based on 1991 earned income), you must deduct net P.S.P.A. for both 1991 and 1992.

Contributions

RRSP contributions carried forward from the prior year will be updated as part of the roll forward, but you can also enter the amount directly.  Contributions should be carefully allocated by date contributed so that Part X.1 tax and the income inclusion for participation in the Home Buyer's Plan may be properly calculated.

Home Buyer's Plan

If a taxpayer participates (withdraws eligible amounts) in the Home Buyer's Plan prior to March 2, 1993, a deduction claim for any contributions made after February 26, 1992 and prior to March 2, 1993 must be added back to income for 1992.

If a taxpayer did not withdraw eligible amounts prior to March 2, 1993, but does so prior to March 2, 1994, a deduction claim for contributions made after December 2, 1992 and prior to March 2, 1994 must be added back to income for 1993.

Carryforwards

RRSP contributions carried forward from the prior year will be updated as part of the roll forward, but you can also enter the amount directly. Amounts should be entered for contributions paid in the calendar year or 60 subsequent days.

Earned Income

The maximum RRSP deduction for the following year is based on the current year's earned income as determined in form T1023. The amounts for earned income are automatically updated from amounts in the T1 Jacket, Other Income Summary, and the RRSP Income Summary. Use the extra input cells to enter amounts affecting the determination of Earned Income which are not specifically identified.

The maximum contribution (excluding transfers) which could be made for the following taxation year is also summarized in form T1023.

<Application Guide Menu>'                     <Main Help Menu>   

RPP Deduction Workchart

The total RPP deduction claimed at line [207] of the T1 Jacket is summarized in this workchart. Contributions on T4 and T4A information slips update this summary automatically, as do amounts designated for transfer into a RPP on the T2097.

Pre-1990 Contributions

The workchart calculates the deduction for pre-1990 RPP contributions. Enter unused pre-1990 contributions carried forward from the prior year unless they were updated by the roll forward.

Member of a Plan

In the calculation of pre-1990 past services, the program assumes that the taxpayer was not a member of any RPP during the years to which the contributions relate. If the contributions were made before May 28, 1990, the program assumes that the taxpayer was not a member of that particular plan. If these conditions are not true, set the question at the bottom of the workchart to Y.

<Application Guide Menu>'                     <Main Help Menu>   



                Federal Forms

                NR6 - Non-Resident DeclarationU 
                T1A - Request for Loss CarrybackVW 
                T1E-NR - Support of Non-Resident DependantsvX 
                T1-M - Moving Expensesǋ\ 
                T541 - Forward Averaging Additions for Deceased Taxpayersc 
                T581 - Forward Averaging Tax Creditsj 
                T626 - Overseas Employment Tax Creditn 
                T657 - Capital Gains Deduction:v 
                T691 - Alternative Minimum TaxW} 
                T746 - Deduction for Refund of Excess RRSP Contributionsˇ 
                T777 - Statement of Employment ExpensesM 
                T778 - Child Care ExpensesǑ 
                T936 - Cumulative Net Investment Loss| 
                T2011 - Block Averagingמ 
                T2017 - Reserves on Capital DispositionsǑ 
                T2038 - Business Investment Tax Creditǎ 
                T2097 - Designation of Transfers to an RRSP or RPP 
                T2200 - Declaration of Conditions of Employment@ 
                T2203 - Multiple JurisdictionsE 
                T2204 - Overpayment of CPP Contributions and UI PremiumsǨ 
                T2222 - Northern Residents Deductiont 


NR6 - Non-Resident Declaration

This schedule must be filed by non-residents who elect to file a T1 to calculate tax payable on their Canadian source Rental Income and Timber Royalty income.

The form should be filed by January 1, but Revenue Canada generally accepts filings after that date.

Defaults

The name and address of the Agent default to the name and address of the tax preparer. The non-resident address defaults to that in the Identification section. Override these cells if necessary.

<Application Guide Menu>'                     <Main Help Menu>   

T1A - Request for Loss Carryback

This form is updated from the T1 Jacket and Schedule 3.

Enter any losses to be carried back to prior years. Losses carried back will update the Continuity of Losses schedule.

<Application Guide Menu>'                     <Main Help Menu>   

T1E-NR - Support of Non-Resident Dependants

This schedule must be filed to support a married amount, dependant child amount, married equivalent amount, or other dependant amount claimed in respect of non-residents.

Relative's Income

The relative's income should include income from all sources including pensions and benefits from either private or foreign government sources. If the non-resident is of pensionable age but is not indicated as having such income, the taxpayer may be asked by Revenue Canada to provide more details.

Students

If the non-resident was over 21 and in full time attendance at a school or university, a signed statement from the educational institution certifying that the dependant was in full time attendance should be filed.

Currency

Enter the taxpayer's payments in Canadian dollars.

Proof of Payment

Proof of support payments showing the amount, date, and name and address of the dependant must be attached to the return.

<Application Guide Menu>'                     <Main Help Menu>   

T1-M - Moving Expenses

You can claim moving expenses if the taxpayer moved within Canada to earn employment or self-employment income at a new work location. The distance from the new work location to the new residence must be at least 40km closer than the distance from the new work location to the old residence.

Qualifying moving expenses incurred outside Canada may also be claimed if the taxpayer is a deemed resident of Canada.

The net income earned in the new location must be entered at the bottom of the form since it is used as a limit to calculate the current year's claim.

Students

Students moving to attend full time at a post-secondary educational institution in Canada or abroad can claim moving expenses to the extent of the taxable portion of their income from scholarships, bursaries, fellowships, research grants, and similar awards. Students moving from full time attendance at a post-secondary educational institution to take a job or become self-employed are subject to the rules in the first paragraph.

Foreign students coming to Canada to study at a post-secondary educational institution can claim moving expenses against any income from scholarships, bursaries, and so on.

Eligible Expenses

Only moving expenses which are not reimbursed or paid by an employer are eligible. If any reimbursement or allowance is included in income (e.g., as a taxable benefit), that portion of the moving expenses would also be eligible.

If moving expenses exceed income earned at the new work location, the excess can be carried forward and deducted on line [219b] against income at the new work location in the following year.

Receipts

The taxpayer should retain all receipts and documentation relating to the moving expenses claimed since Revenue Canada may request them.

<Application Guide Menu>'                     <Main Help Menu>   

T541 - Forward Averaging Additions for Deceased Taxpayers

Election

This schedule calculates Forward Averaging tax in the year of death. To use it, you must answer Y to the question "Does the Estate elect to average income for the year of death" at the top of the form.

Integration with T581

The amount to be averaged as indicated in line (3) updates form T581 if a forward averaging withdrawal is made on line 6 in the T581. The accumulated averaging amount at the end of the year preceding the year of death (line 1) and the portion of line 1 withdrawn in the year of death (line 2) updates from the T581.

Prior Years' Assessments

The program calculates Revised Taxable Income and Federal and Provincial Forward Averaging tax based on amounts in line 4 for Taxable Income Assessed in each of the three prior years.

Deemed Residents

If the taxpayer is a deemed resident subject to federal surtax rather than provincial tax, indicate that the federal surtax is applicable at line 16 of Part I.

Provincial Tax

If the taxpayer is a resident of P.E.I., Nova Scotia, New Brunswick, British Columbia, or Ontario, provincial tax payable is calculated on form T541. If the taxpayer is subject to tax in multiple jurisdictions, the provincial forward averaging tax and provincial tax payable are calculated in form T2203.

Updating the Tax Calculation

When averaging has been elected, form T541 updates the T1 Jacket (as an adjustment to line [417]), Schedule 1 (federal surtax), and form T2203.

<Application Guide Menu>'                     <Main Help Menu>   

T581 - Forward Averaging Tax Credits

Prior Year Information

Enter the amounts for forward averaging deductions and withdrawals from prior years if they were not updated in the roll forward.

Provincial Tax

If the taxpayer is resident in Quebec, the program calculates the adjustment to Federal Forward Averaging tax or the Refundable Quebec Abatement.

If the taxpayer is a resident of P.E.I., Nova Scotia, New Brunswick, British Columbia, or Ontario, the provincial tax payable is calculated in T581 unless form T541 or form T2203 applies.

If the taxpayer is subject to tax in multiple jurisdictions, the provincial forward averaging tax credit is calculated on form T2203.

Deemed Residents

If the taxpayer is a deemed resident subject to federal surtax rather than provincial tax, indicate that the federal surtax is applicable at line 11.

Updating the Tax Calculation

Form T581 updates the T1 Jacket (lines [237] and [478]) and forms T541 and T2203.

<Application Guide Menu>'                     <Main Help Menu>   

T626 - Overseas Employment Tax Credit

Eligibility

An overseas employment tax credit is available to individuals resident in Canada working abroad for at least six consecutive months. The employer's activities must comply with those outlined in the Income Tax Act. To claim the credit, the employer must certify the period of employment in Step I.

Calculation

The tax credit is calculated in Step V. The amount of the credit is roughly the income taxes otherwise payable on 80% of the net overseas employment income to a maximum of $80,000. The $80,000 is prorated to the number of days of qualified employment in the current taxation year.

The total overseas remuneration should be reduced by any deductions to net income which may be wholly or partly attributable to the overseas employment. RPP and RRSP contributions based on earned income should be apportioned (based on the number of days) between qualified overseas employment and other earned income.

Alternative Minimum Tax

The claim calculated on form T626 updates Schedule 1 (or T2203 or T691). The Overseas Employment Tax Credit is a non-refundable amount used to reduce Basic Federal Tax and may result in Alternative Minimum Tax payable. It may be advantageous to claim less than the full amount and instead use available foreign tax credits.

Foreign Tax Credits

A foreign tax credit cannot be claimed on the portion of net foreign income on which the overseas employment tax credit is claimed. The portion of foreign income taxes paid and net foreign income eligible for a foreign tax credit is calculated. These amounts update the Summary of Foreign Income and Taxes Paid and subsequently to Schedule 1 (or T2203 or T691) where an employment foreign tax credit is calculated (type 4). However, if there is another type of income, Schedule 1 will not be updated and an error diagnostic will appear. If the FTC claim relates to more than one type of income or more than one country, use the Multiple Tax Credit Schedule.

<Application Guide Menu>'                     <Main Help Menu>   

T657 - Capital Gains Deduction

Carryforwards

If net taxable capital gains, allowable business investment losses, net capital losses of other years claimed, capital gains exemptions claimed against other property, and total capital gains deductions for prior years were not rolled forward, then enter them in the carryforward workchart. Check these carryforward amounts with Notices of Assessments if possible.

A previous capital gains deduction claimed against other property should be entered in both the other property column and the total claims column of the carryforward workchart. If you enter the amount only in the total column, the prior deduction is considered to have been claimed against qualified farm or small business.

Adjustments

An adjustment for non-farm reserves included in taxable capital gains from 1985-87 will have to be entered in the input cell provided if not updated during the roll-forward procedure.

The disposition of cumulative eligible capital in 1988 and 1989 for fiscal periods commencing after 1987 was subject to a 75% inclusion rate. Other types of capital gains in those years were subject to a 67% inclusion rate. Capital gains deductions claimed on the disposition of cumulative eligible capital should be entered in the cells provided so that it will not be subject to the same adjustment as other types of capital gains.

Amount Claimed

The program automatically reduces the amount of the deduction claimed if claiming the full amount would result in unused non-refundable credits. If you want to claim less than the full amount in other situations, override the claim directly on line [254] of the T1 Jacket. The amount you enter on the jacket will automatically be reflected on the T657.

<Application Guide Menu>'                     <Main Help Menu>   

T691 - Alternative Minimum Tax

Applicability

AMT is not applicable for returns filed on behalf of deceased taxpayers, or tax returns filed for bankruptcy purposes. If Block Averaging is elected for filing by farmers/fishermen, then AMT is also not applicable. The program will ignore AMT calculations if a date of death is entered in the Identification section or if you have elected block averaging on form T2011.

If there is no minimum amount from Part I, line 45 or if there is no excess in Part IV, line 73, or if there is no minimum tax carry-over in Part VIII, line 83, then AMT is not applicable.

Filing Requirements

File form T691 if there is a minimum tax liability or if there is a minimum tax carryover credit applied. The program will flag form T691 as applicable in these situations.

Capital Gains

The amount to be added back in respect of capital gains reported on line [127] of the T1 Jacket is only in respect of the current year, and post-1985 reserves brought into income in the current year. Therefore the total capital gains updated from Schedule 3 is amended for the net reserves in respect of pre-1986 dispositions from form T2017.

Capital gains resulting from mortgage foreclosures and the portion exempt under a tax treaty are not subject to minimum tax. The non-taxable portion of such gains as specified in Schedule 3 is therefore updated to reduce the adjusted taxable income.

Non-Capital Losses Carried Forward

A cell is available in line 22 of this section to enter any amount of post 1985 non-capital losses carried forward and claimed in line [252c] of the T1 Jacket which is attributable to: CCA claimed on MURBS, films and videos, and depletion and allowances claimed on resource investments.

A diagnostic will remind you to check this cell if any claim is made in line [252c] and there is no amount in line 22.

Capital Losses Carried Forward

Enter the amount of the loss due to Mortgage Foreclosures on line [97b]. Enter the amount due to exemption under a tax treaty on line [97c].

A diagnostic will remind you to check these cells if a claim is made in line [253b] but no claim is made in line [97b] or [97c].

Current Year Loss

Line 28 will be updated for the total non-capital loss from employment, business and property which is not fully applied in computing income for regular tax purposes. The unapplied portion of the loss (as calculated in form T1A) may be used to reduce taxable income for minimum tax purposes.

A diagnostic will tell you when a deduction is claimed on this line so that you can modify the reduction if necessary.

<Application Guide Menu>'                     <Main Help Menu>   

T746 - Deduction for Refund of Excess RRSP Contributions

A deduction may be claimed for excess RRSP contributions which have been refunded. The taxpayer would have received either a T4RSP or T4RIF. The program will identify the excess amounts and update them to the T746.

You must enter the taxation year to which the excess amount applies, the total contribution, and the amount claimed in that year. The form is divided between pre-1991 and post-1990 contributions.

The deduction calculated will be claimed as an other deduction on line 232 of the T1 jacket.

<Application Guide Menu>'                     <Main Help Menu>   

T777 - Statement of Employment Expenses

Form T777 calculates expenses which may be claimed against employment income. It includes CCA calculations for Class 10.1 automobiles.

Class 10.1

Automobiles purchased after June 17, 1987 for more than $20,000, or after August 31, 1989 for more than $24,000 are included in Class 10.1. Class 10.1 automobiles purchased in a prior year and disposed of in the current year can claim one-half of the normal CCA claim they would have been received if the automobile was not disposed of. There is no requirement to acquire another automobile in the year according to the Draft Legislation of December 20, 1991.

For purchases after January 1, 1991, the $24,000 limit for Class 10.1 excludes GST and PST. The portion of GST and PST which applies to the $24,000 should be added to the $24,000 limit. The program will calculate the acquisition cost based on the amounts entered. The amount calculated should then be reduced by any rebates or refunds received.

Automobile Expenses

The section of the form relating to automobile expenses is divided into three columns to allow calculations for three separate automobiles. Calculate the expenses and allowable amount separately for each automobile.

Vehicle Reference

Each column is designated by a vehicle reference number. This designation determines if CCA claims update from the Class 10.1 or the Class 10 calculations.

If you enter CCA directly for an automobile, ensure that none of the Class 10.1 or Class 10 calculations have the same vehicle reference number as that automobile.

Work Space in Home

Unclaimed expenses for work space in the home will be updated to next year's return as part of the roll forward procedure.

T1 Jacket

This form updates line [229] of the T1 Jacket.

<Application Guide Menu>'                     <Main Help Menu>   

T778 - Child Care Expenses

Eligibility

The program determines which spouse can claim child care expenses. The taxpayer must meet conditions (a), (b), or (c).

If (c) is applicable, indicate which condition [(i), (ii), (iii), or (iv)] was applicable to the other supporting spouse and enter the number of weeks the condition was applicable.

Enter the name, SIN, and net income of the other supporting person if applicable in the Family Profile workchart.

Earned Income

Child care expenses update the T1 Jacket. Earned income for Part 4 is calculated from information in the T1 Jacket.

Expenses

Enter child care expenses and the number of weeks in a camp or boarding school for each child in the Family Profile workchart.

The coupling process will update the children's names, birth dates, nature of infirmity if relevant, the number of weeks in a camp or boarding school, and child care expenses from the Family Profile workchart to the T778 of the spouse who should make the claim.

The details of the payments, name of the organization or individual, and SIN of the individual should only be entered after the program has determined which spouse should make the claim.

<Application Guide Menu>'                     <Main Help Menu>   

T936 - Cumulative Net Investment Losses

Prior Year Totals

The Calculation of CNIL is carried forward to the Cumulative Gains Limit in Part 2 of the Calculation of Capital Gains Deduction (T657). Since CNIL is a cumulative account, you must enter the total investment expense and the total investment income at the end of the previous year if the amounts are not updated during the roll forward process.

Components

The CNIL calculation is updated for interest expenses and carrying charges, 50% of resource expenses, limited/non-active partnership income/loss, net rental income/loss, dividend income, interest and other investment income, and recovery of exploration and development expenses. Also updated are the unclaimed foreign non-business tax deductions (ss 20(11)/(12)) and other property expenses identified in the Other Deductions Summary (line [232]), property income included in the Other Income Summary (line [130]), and other income from an employee profit sharing plan (T4PS Box 35).

Annuities

Annuity payments taxable under paragraph 56(1)(d) should be identified in either the Other Pension Income Summary (line [115]) or the Other Income Summary (line [130]). This amount should exclude the capital portion deductible under paragraph 60(a). A diagnostic will remind you to check this cell if annuities were entered in T4A Box 24.

Non-eligible Capital Gains

Subject to the Ways and Means Motion announced June 19, 1992, capital gains which are not eligible for capital gains deduction should be included in cumulative investment income. Likewise, any net capital loss of other years which are included with cumulative investment expenses should be reduced by the non-eligible capital gains.

Prior to March 1992, only reserves on property disposed before 1985 were not eligible for the capital gains deduction.  To the extent that pre-1985 reserves were realized between 1988 and 1991, CNIL carried forward from 1991 should be retroactively adjusted.  Chart 2 in Form T657 identifies pre-1985 reserves claimed between 1988 and 1991.

<Application Guide Menu>'                     <Main Help Menu>   

T2011 - Block Averaging

Election

To use this form, you must answer Y to the question "Does the taxpayer elect to average income under Sec. 119?".

Applicability

This form calculates federal and provincial tax for farmers and fishermen electing 5 year block averaging.

Province of Residence

The T2011 calculates provincial tax for all averaged years based on the taxpayer's province of residence.

Entering Prior Year Information

Enter the taxation years to be averaged in the column headings in ascending order from left to right. The year of averaging should be the current taxation year.

Enter other information relating to the years being averaged as indicated on the form. Certain amounts necessary to calculate federal and provincial taxes must be entered directly in the sections detailing the calculations of tax on average net income.

A section for entering additional information relating to the years being averaged is also available.

Foreign tax credits (federal and provincial) are not recalculated for prior years and must be entered directly.

Investment Tax Credits

The T2011 does not integrate with the T2038 for purposes of optimizing ITC in the year of averaging. To use the T2038 in the year in which you block average, follow these steps:

1.    In the adjustments column of the "Analysis of ITC/Carry forward by CCA Class" in form T2038, enter the amount of "ITC Pool available for carryforward" as calculated in form T2011.

2.    In the "Calculation of the Allowable Claim" in form T2038, override the Federal Tax Payable before ITC by entering the amount of tax payable as calculated in form T2011.

3.    In the "Calculation of Additional ITC to be deducted from Federal Surtax" in form T2038, override the federal surtax by entering the amount as calculated on form T2011.

4.    In form T2011, enter the current year's ITC claim as calculated in form T2038.

<Application Guide Menu>'                     <Main Help Menu>   

T2017 - Reserves on Capital Dispositions

Form T2017 summarizes pre-1985 reserves and allocates post-1984 reserves between qualified farm property, qualifying small business and other capital property. The roll forward carries the prior year's reserves into this year's T2017.

In a situation where a taxpayer re-acquires the property through a mortgage foreclosure or conditional sales repossession, the prior reserve may be adjusted under Section 79 and will not be updated as a taxable capital gain.

The non-taxable portion of net reserves from pre-1986 dispositions included as capital gains in Schedule 3 updates form T691.

This form updates Schedule 3, form T657, and form T691.

<Application Guide Menu>'                     <Main Help Menu>   

T2038 - Business Investment Tax Credit

Entering Expenditures

Complete the fixed assets additions for all the applicable self-employment forms, making sure you indicate the appropriate CCA Class and ITC type code. The ITC expenditures indicated update the Calculation of ITC - Current Taxation Year.

Partnerships

If the taxpayer is a member of a partnership and the expenditure relates to the whole partnership, enter his or her share of the current year ITC in the cell provided.

Carryback

If any ITC is being carried back to a previous year, prepare the Carryback Request. The amount entered in the carry back request will update the calculation of the ITC refund.

Refund

Any current year ITC not claimed or carried back will be eligible for refund. The program calculates the Refund of ITC.

Continuity of ITC Carryovers

Prior years' investment tax credits may be entered in the continuity schedule. The CCA class and the self-employment statement to which CCA pertains must be first identified. These balances will be carried forward during the roll forward.

<Application Guide Menu>'                     <Main Help Menu>   

T2097 - Designation of Transfers to an RRSP or RPP

This schedule designates the amount of qualifying income for transfer into the taxpayer's RRSP/RPP or the spouse's RRSP.

To claim a RRSP deduction on line [208] of the T1 jacket, the appropriate designation must be made in the T2097 and RRSP contributions must be entered in the RRSP deduction workchart.

To claim a RPP deduction on line [207] of the T1 jacket, the appropriate designation must be made and a RPP contribution indicated in the T2097.

Any income which may qualify for transfer will be flagged as qualifying income on the T2097. A diagnostic will remind you if certain income qualifies for transfer but has not been designated for transfer.

Spousal Transfers

The amount entered at line (10) relating to spousal transfers and claimed at line [208] of the jacket affects the calculation of the Eligible Pension Income Amount for line [314] of the T1 Jacket. This calculation occurs in the Eligible Pension Income workchart.

<Application Guide Menu>'                     <Main Help Menu>   

T2200 - Declaration of Conditions of Employment

This form must be filed if employment expenses are being claimed in form T777, which updates to line 229 of the T1 jacket.

The total kilometres driven and number of kilometres driven for employment are updated from form T776.

You can enter the conditions of employment, but these questions should be answered by the employer.

Certification

This form must be certified by the employer.

<Application Guide Menu>'                     <Main Help Menu>   

T2203 - Multiple Jurisdictions

Applicability

The T2203 and T2203A are for taxpayers with income from self-employment (business income) outside the province of residence.

Allocation of Income

The program allocates any excess self-employment income to the province of residence. Enter the self-employment income allocated to each jurisdiction in the column indicated. The amount allocated should equal the amount of self-employment income indicated in line 2. The program calculates the percentage allocation, Basic Federal Tax, and the Federal Tax Reduction.

Saskatchewan and Manitoba

If the province of residence is Saskatchewan, complete form T1C(SASK) with respect to the Child Tax Reduction (if overridden) and Saskatchewan Tax Incentives.

If the province of residence is Manitoba, complete form T1C(MAN)TC with respect to credits for surtax and provincial tax reduction.

Updating the Tax Calculations

If you allocate any to a province, the T2203/T2203A will update the T1 Jacket and integrate with the T2038, T78, T79, and T82.

<Application Guide Menu>'                     <Main Help Menu>   

T2204 - Overpayment of CPP Contributions and UI Premiums

This form will calculate CPP and UI overpayments for update to lines [448] and [450] of the T1 jacket respectively.

Calculations

If an individual received a retirement or disability pension under the Canada or Quebec Pension Plan, died, or became 18 or 70 years of age in the year, the maximum pensionable earnings on line (C) and basic exemption on line (D) will be prorated. The prorated amounts are obtained by dividing each amount by 12 and multiplying the result by the number of months in the year:

- after, but not including the month in which the 18th birthday occurred.

- prior to and including the month in which the 70th birthday occurred.

- in which CPP/QPP benefits was not received.

- prior to and including the month in which the death occurred (if the first three conditions do not apply).

The number of months CPP/QPP benefits received in the year will be updated from the T4A(P) information slip.

Total Insurable Earnings

For post-bankruptcy returns, you should override earnings, CPP contributions, and UI premiums to properly calculate claims and overpayments.

<Application Guide Menu>'                     <Main Help Menu>   

T2222 - Northern Residents Deductions

This schedule calculates the Northern Residents Deductions and updates line [255] of the T1 Jacket.

Entering Addresses

Residents of prescribed northern zones and prescribed intermediate zones may be eligible to claim northern residency and employee travel deductions. In Step 1, addresses must be entered exactly as indicated in the Northern Residents Deductions Tax Guide available from Revenue Canada. Enter the Zone Code (either "A" or "B") where indicated.

Residency Deductions

The maximum residency deductions are calculated in Step 2 for both prescribed northern zones (Part I) and prescribed intermediate zones (Part II). The number of days resident in the year is calculated from the dates entered in Step 1.

Travel Deductions

Step 3 calculates the deduction relating to employee travel benefits. The Appendix Code ("A" or "B") must be entered where indicated.

Allowable Deductions

Step 5 calculates the total allowable deductions for prescribed northern zones (Part II) and prescribed intermediate zones (Part III). The allowable claim for prescribed intermediate zones is one half of the deductions relating to that area.

<Application Guide Menu>'                     <Main Help Menu>   



                Optional Forms and Reports

                Comparative Review and Analysis Workchart 
                Taxpayer Summaryǻ 
                Summary of Carryforward Balances 
                Invoice 
                Instalments{ 
                Tax Preparer Profileǟ 
                Rates Table 
                Diagnosticsm 
                Client Letter[ 


Comparative Review and Analysis Workchart

This workchart summarizes key tax items from the T1 and provides a comparison with the balances from the prior year. The percentage change from the prior year is calculated.

Because of its overview nature, this workchart provides a meaningful starting point for a detailed review. It may also be useful in client discussions.

The prior year amounts can be entered or updated through the yearly roll forward routine. Space is provided for you to add comments (e.g., to explain large deviations).

You can print and maintain this workchart with your other working papers.

<Application Guide Menu>'                     <Main Help Menu>   

Taxpayer Summary

The Taxpayer Summary contains the same key data of the current year's T1 return as the Comparative Review and Analysis Workchart.

Since the Taxpayer Summary prints on a single page, it is a useful synopsis to keep on hand for reference throughout the coming tax year.

Suggested Uses

- a comparison of Taxpayer Summaries for different "what-if" scenarios can highlight the effect of changes on a taxpayer's situation.

- Taxpayer Summaries from successive re-runs of a return can be compared to ensure that only intended changes occurred.

- the Taxpayer Summary can provide the client with an overview of his or her tax position without having to refer to items throughout the return.

- clients may find the Taxpayer Summary useful as a tool for reviewing the accuracy of their returns.

- a copy of the Taxpayer Summary, appropriately appended with comments, could be given to the client to serve as a reminder of information to be gathered and/or deductions to be made throughout the current taxation year.

<Application Guide Menu>'                     <Main Help Menu>   

Summary of Carryforward Balances

All balances carried forward from the prior year or to be carried forward to the following year are summarized in this workchart. A summary of amounts from self-employment statements (i.e., CCA, inventory, business use of home expenses) is not provided due to its potentially large size.

This summary provides a useful reference for review. You can expand from the summary to the schedules which contain these balances.

Do not enter amounts in this workchart. It does not update the appropriate schedules.

This summary can be printed and maintained with other working papers.

<Application Guide Menu>'                     <Main Help Menu>   

Invoice

Printing

The invoice number only prints if something is entered in that cell.

The description line will only print if an amount is in the accompanying numeric cell. If you prefer a different wording, use the blank space provided.

GST Registration

You can enter the GST registration number and GST/PST rates in the Tax Preparer Profile workchart.

<Application Guide Menu>'                     <Main Help Menu>   

Instalments

The Instalments Workchart determines if instalments will be payable in the subsequent year. The workchart also provides the opportunity for you to anticipate if instalment penalties and interest may be deemed payable if no instalments had been made in the current year.

Beginning with the March 1992 instalment, Revenue Canada will inform taxpayers of the exact amount of instalments due. A notice will be mailed approximately one month before each quarterly payment is due.

The program assumes the subsequent year's taxable income will be at least equal to the current year's taxable income and that the proportion of income on which taxes are withheld will be the same.

The program considers income to have had tax deducted only if there is tax deducted on that specific slip. Diagnostics will be flagged if instalments are required, but the criteria is determined by excluding income from T-slips which has no tax was deducted.

Instalments Required

If instalments are required, quarterly instalment payments are calculated and defaulted to print as an attachment to the client letter.

Second Preceding Year Option

If you want to apply the option to pay the first two instalment payments based on the second preceding year, override both March 15 and June 15 payments. The program will then apply the balance to be paid equally on the 15th of September and December.

Transfer of Refund

A refund may be transferred to next year's instalment account if that option is chosen at the bottom of the T1 jacket.

Interest Charges

The program will not take into consideration interest charges when calculating the amount and timing of the catch-up instalment payment. You should calculate this manually if necessary.

Instalments Not Required

If instalments are not required but are to be made anyway, enter the total amount payable under the current year option.

Note:

In some cases, the program will determine that instalments aren't necessary but instalments will in fact be deemed required because of a change in income, deductions, or some other relevant situation.

You should monitor a client's situation closely to avoid penalties and charges since there is no way the program can know how the client's tax situation may change.

<Application Guide Menu>'                     <Main Help Menu>   

Tax Preparer Profile

The following information can be specified:

- tax preparer's address.

- disclaimer message on the T1 jacket.

- GST registration number.

- GST rate.

- PST rate (and whether it is calculated before or after GST).

- discounter code.

- receiving taxation centre for EFILE transmissions.

If you add or change any information in the Tax Preparer Profile, you should immediately do a Configure / Save Configuration to make those changes permanent.

<Application Guide Menu>'                     <Main Help Menu>   

Rates Table

Rates

The rates table is useful in planning for the effects of proposed rate changes (e.g., the subsequent year's tax position). If you override a rate, the program will recalculate the affected schedules based on the new rate.

The rates table also allows you to prepare returns for individuals subject to uncommon tax situations.

<Application Guide Menu>'                     <Main Help Menu>   

Diagnostics

Diagnostic Forms

Diagnostic messages may appear in the following forms:

    Diagnostics - Regular Schedules.

    Diagnostics - CCA/ITC Schedules.

    Diagnostics - EFILE.

    Diagnostics - Coupling.

Types

The types of diagnostics that can appear are:

     - missing information.

     - possible input errors.

     - tax planning possibilities.

     - filing reminders.

     - overridden areas.

Overrides

Override diagnostics are further divided as follows:

     - Quebec cells overridden from the corresponding federal cell.

     - Quebec opening balances overridden from the corresponding federal opening balance.

     - other overrides.

<Application Guide Menu>'                     <Main Help Menu>   





        Client Letter

        Print Preview 
        Edit Mode3 
        Paragraphs SelectedǙ 
        Optional ParagraphǄ 
        Preparer's Nameǖ 
        Setting Defaultsǥ 
        Letter Wording 
        Letter HeadǦ 
        Paragraph Exclusions 
        Optional Opening ParagraphP 
        Date 
        EFILE% 


                                            <Main Help Menu>   
Print Preview

The Client Letter now displays only the paragraphs which will be printed. Press F9 to see all of the possible paragraphs. Only paragraphs marked with an X are included in the Client Letter.



<Client Letter>[                     <Main Help Menu>   

Edit Mode

If you wish to make changes to the letter, you must enter Edit mode by pressing F9. Many of the normal Taxprep functions are not available when you are in Edit mode. For example, you cannot access the pull-down menu. To use any of these functions, press ESC to leave Edit mode.

<Client Letter>[                     <Main Help Menu>   

Paragraphs Selected

The program will determine which paragraphs are applicable based on the information in the return and defaults set in the Tax Preparer's Profile. To change the paragraphs chosen, override the appropriate paragraph include cell as follows: to include a new paragraph enter an "X"; to suppress a paragraph enter a space. To return to the original paragraph setting, press CTRL+U to remove the override.

<Client Letter>[                     <Main Help Menu>   

Optional  Paragraph

In Edit mode, you may create your own paragraph to insert before the final sentence. When you enter text for the paragraph, the program will automatically generate an X to include it.

<Client Letter>[                     <Main Help Menu>   

Preparer's Name

If selected in the Tax Preparer Profile, the name of the preparer will appear at the top of the letter. These are overridable fields and can therefore be modified for specific returns.

<Client Letter>[                     <Main Help Menu>   

Setting Defaults

To avoid having to make the same changes to the client letter for each of your returns, you can default certain aspects of your client letter in the Tax Preparer's Profile.

To save your selections, choose the command Configure / Save Configuration.

If you need to make changes for a specific return, make the change in the Client letter itself not in the Preparer's Profile. In this manner you will not affect the letter defaults for subsequent returns.

<Client Letter>[                     <Main Help Menu>   

Letter Wording

As in prior years, you can select in the Preparer's Profile whether the paragraphs used in your letter will use I (singular) or We (plural).

<Client Letter>[                     <Main Help Menu>   

Letter Head

If you are using your own letterhead, you can specify in the Preparer's Profile the number of lines to skip at the top and/or bottom of the page. Alternatively, you can specify that your firm's name and address be printed at the top of the letter.

<Client Letter>[                     <Main Help Menu>   

Paragraph Exclusions

In the Preparer's Profile, you can default the inclusion/exclusion of the following five paragraphs:

- GST credit entitlement.

- Child Tax Benefit.

- 1993 installment payment..

- RRSP contribution limits

- Instruction to mail the return by April 30th.



<Client Letter>[                     <Main Help Menu>   

Optional Opening Paragraph

An optional opening paragraph has been provided in the Preparer's Profile which may be used in lieu of the standard paragraph provided. The standard opening paragraph assumes that you will be enclosing two copies of the return. If it is not your policy to do so, you may compose your own opening paragraph in the Preparer's Profile and set it to be used.

<Client Letter>[                     <Main Help Menu>   

Date

The date on the client letter will be determined in a Print Return or a Batch Print if that printing option has been chosen. The program will default the system date automatically. If you want to print a date other than the defaulted date, you can change the date at print time in the Print Options menu. If you are printing the letter using the Print Form command, you will have to specify the date by expanding into the editable part of the letter.



<Client Letter>[                     <Main Help Menu>   

EFILE

Returns which have been filed electronically require a different letter because no paper return needs to be filed except for the Consent Form T1013 and miscellaneous election forms such as the Forward Averaging Election Form T581. When the return is selected for EFILE, the program defaults a different set of paragraphs in the client letter.

<Client Letter>[                     <Main Help Menu>   





<Application Guide Menu>'                     <Main Help Menu>   







                Appendix

                Filing Requirementsǝ 
                Filing Order of Attachments% 


Filing Requirements

Paper

The paper used for printing and filing your returns must meet the specifications required by Revenue Canada, as listed in Information Circular 92-5. Refer to that circular for complete details.

The paper must be (8 1/2" X 11") and at least 32 M weight.  White paper is acceptable for filing.

Approved paper can be purchased from Taxprep.

Keying Summary

The Keying Summary (form T1-KS) must be filed with the return even if there are no amounts on it. This form facilitates Revenue Canada's procedures for computer-generated returns.



<Application Guide Menu>'                     <Main Help Menu>   

Filing Order of Attachments

The program prints the required schedules in the order specified by Revenue Canada in Information Circular 92-5.

The order, from top to bottom, is:

1)    Tax Rebate Discounting form

2)    Quebec information slips

3)    T1-DD

4)    T1-KS

5)    T2222

6)    Schedule 1

7)    Schedule 7

8)    Schedule 3

9)    T2017

10)    T2038

11)    T1C-TC

12)    T1C

13)    TFA1

14)    ATC-1 - Child Tax Credit Prepayment

15)    T78,T79,T81 or T82

16)    T86

17)    T626

18)    T657

19)    T691

20)    T929

21)    T2201

22)    T778

23)    T541/T581

24)    T1A

25)    information slips (T4, followed by all others in any order)

26)    RRSP contribution receipts

28)    all other schedules and receipts in any order



                    

<Application Guide Menu>'                     <Main Help Menu>   



                Personal Taxprep 92.2 Notes

                About Version 92.2E 
                Forms Added and Revised7 
                Downloading Laser Formsǧ 
                RRSP Home Buyer's Plan1 
                EFILE Revisionsǵ6 
                EFILE - Data Files ReportN@ 
                Microsoft Windows and Personal TaxprepǲL 
                        <Main Help Menu>   



About Version 92.2

Version 92.2 is the final production version for this tax season.

Opening Existing Returns

You can use Version 92.2 to open returns that were rolled forward from 1991 as well as new returns created with Version 92.0 and 92.1.

Taxprep Print Service Clients

Taxprep Print Service Clients will be sent a special version by March 15.

T1C(ONT) - Seniors

The T1C(ONT) for Seniors form is integrated into the program. The appropriate T1C(ONT) form will be used depending on the Taxpayer's age (determined by the birth date entered in the Taxpayer's Profile). For clients 65 and over, the Seniors form will come up when the T1C(ONT) is selected from the Forms Manager.

    <Version Notes>ǚ         <Main Help Menu>   



Forms Added and Revised

            Preparer's Profile - Client LetterǬ 
            T1013 Consent Form 
            T2038& 
            Pre-printed T1 jacketǙ 
            T7DR(A)Ǌ 
            Film statements
 
            T5004Ǎ 
            NISA Statement A 
 
                <Version Notes>ǚ         <Main Help Menu>   



Preparer's Profile - Client Letter

The following defaults can be specified in the Client Letter section of the Preparer's Profile:

Letterhead.

In the Client Letter Default Information section a new cell has been added. If "Perform this skip on first page only" is left disabled, the line skip setting will be applied to every page of the Client Letter. This is of benefit if you use your company letterhead for every page of the Client Letter.

Optional Opening Paragraph.

You can now also specify the optional opening paragraph to be used for the regular letter, EFILE letter when EFILE is applicable, or all the time.

T1013 Consent Form.

If you are submitting the T1013 Consent Form, but do not wish to use the paragraph dedicated to this form in the Client Letter, you may suppress its output.

T183.

If it is your practice to obtain both signatures on the T183 before the printed return is forwarded to the taxpayer, you may now suppress the references to "signing and sending the second copy back to your office".

    <Version Notes>ǚ         <Main Help Menu>   

T1013 Consent Form

This form has been revised to allow "All taxation years" to be selected for the period which the authorization or cancellation of authorization applies. You can also set the T1013 authorization as a default in the Preparer's Profile.

    <Version Notes>ǚ         <Main Help Menu>   

T2038

This form has been finalized and can be filed.

    <Version Notes>ǚ         <Main Help Menu>   

Pre-printed T1 jacket

This version allows you to print under the pre-printed T1 jacket format.

Before printing, however, you must:

- load the PREPRE print format (Configure / Load Print Format).

- Move down the Forms Manger to the first form after the T1 jacket ("pre-printed pages 3 and 4 to accompany Pre-printed T1"). There is no Jump Code, however T1P can be entered from the Title column to move to it easily.

- select PrePrint under the Forms Manager's Output column (it is important to select it with the [Enter] key even though it appears to be the default).

- change the print column setting to When Applicable.

- save the PREPRE print format (Configure / Save Print Format).

    <Version Notes>ǚ         <Main Help Menu>   

T7DR(A)

This form has been added to this version.  You must obtain the pre-printed forms from Revenue Canada and print these forms on a dot matrix printer. Before printing, however, you must:

- load the EFILE print format (Configure / Load Print Format).

- select PrePrint under the Forms Manager's Output column (it is important to select it with the [Enter] key even though it appears to be the default).

- change the print column setting to When Applicable.

- save the EFILE print format (Configure / Save Print Format).

    <Version Notes>ǚ         <Main Help Menu>   

Film statements

This version allows you to prepare an unlimited number of film statements. You can enter either Certified Productions or Certified Quebec films. Use F9 to expand into a production's statement. Use Ctrl-K to create statements for additional films or videos. The statements' amounts update the AMT/Tax Shelter Investment Workchart.

The Jump Code is FILM STMT.

    <Version Notes>ǚ         <Main Help Menu>   

T5004

The Statement of Tax Shelter Loss or Deduction has been added to this version.

    <Version Notes>ǚ         <Main Help Menu>   

NISA Statement A

The NISA Statement A that was sent with Version 92.1 was based on a draft available at the time.  The form has since been finalized and included in Version 92.2.

The "Eligible Expenses" and "Non-Eligible Expenses" sections of Commodity Purchases and Expenses have been altered to allow the entry of more items.

    <Version Notes>ǚ         <Main Help Menu>   



            Downloading Laser Forms

            About Downloading Laser Forms 
            List Boxes 
            Selecting Forms6 
            Send 
            Cancelu 
            Test
 
            When to use SendǏ 
            Assume Downloaded! 
            Networks% 
            Download Size& 
            Facsimiles Not Resident* 
            Resident Pages Lost from Printer Memory+ 
            Macro Number'. 
                <Version Notes>ǚ         <Main Help Menu>   



About Downloading Laser Forms

Configure / Download forms is a new option that allows you to send laser facsimile forms to the printer and have them remain resident in the printer's memory.

Versions before 92.2 have always sent the facsimile data (that is, the information on how to "draw" the form) and a form's cells data each time a laser form was printed. Print out time is significantly decreased by maintaining a form's laser facsimile data in printer memory and having Personal Taxprep simply send the cell data.

Because of the volatile nature of printer memory and the fact that a the cell data have to be matched up with the proper form in the printer memory, the process is more complicated than simply sending the two together.

Three main steps are involved in having the facsimiles printer resident:

1. Select the forms and/or the individual pages you wish printer resident.

2. Send the facsimile data to the printer at "the beginning of the day".

3. Enable Assume Downloaded from Configure / Change features.

Steps 1 and 3, in general, have to be done only once as Personal Taxprep will save this information like any other change performed from the Configure menu. Step 2 is, at minimum, a daily task. See "When to Use Send" later in this section.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

List Boxes

The Form list box displays all the forms that have laser facsimiles. The Page list box displays all the possible pages that make up the form. The Selected page list box displays the pages selected for each form.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Selecting Forms

If you want all of the form's pages to remain resident in the printer, highlight the form in the Form list box and press [Enter].

If you do not want the entire form but only certain pages, move to the Page list box, highlight a page and press [Enter] to select it.

If you include a page by mistake, you can remove it by highlighting the page in the Selected page list box and pressing [Enter].

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Send

Once you have selected all the desired pages, [Tab] to Send and press [Enter]. The pages will be sent to the printer via the laser form port indicated under Configure / Port/Printer.

After using Send, the selected pages are saved in a configuration file called _T1DOWN.CFG. Each time Personal Taxprep is loaded, this file is loaded as well. Personal Taxprep will not, however, automatically download these forms to the printer. You have to use Send each time you run Personal Taxprep (see "When to use Send" on the next page).

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Cancel

Cancel will only cancel whatever changes you have made since the last time you selected Send. If you have already used Send to download form information to the printer, Cancel will not remove the resident information. Turning your printer off and waiting approximately ten second before you turn it on should clear its memory.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Test

You can use Test at any time to ensure a selected page is still printer resident. Highlight the desired form and page and then [Tab] to Test. The correct page should output if it is still resident. If the page is not printed correctly, you should re-download the contents of the Selected page list box with Send.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

When to use Send

Below are the three most likely times you will have to use Configure / Download forms / Send, although you may encounter other circumstances that require you to use it.

Beginning of the day.

Although the program loads the configuration file containing the pages you have selected, it will not automatically download the selected facsimiles' data to the printer. You should do this immediately, with Send, after loading the program at the beginning of the day.

Printer on/off.

If the printer has been turned off and on for any reason after using Send, you will have to download the facsimiles again.

Printer used by another application.

If another application (e.g., a word processing program) has used the printer, you might have to download the facsimiles again.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Assume Downloaded

Enabling Assume Downloaded (under Configure / Change features) tells Personal Taxprep to use the facsimile data downloaded to the printer via Configure / Download forms / Send.

If Assume Downloaded HAS NOT BEEN ENABLED, Personal Taxprep will download the same facsimile data each time it prints.

If Assume Downloaded HAS BEEN ENABLED and Configure / Download forms / Send HAS NOT BEEN used prior to printing, Personal Taxprep will download the same facsimile data each time it prints. However, the outputted page might be missing the bullets that Revenue Canada requires for keying in the return.

Hence, output time can only be minimized by using Configure / Download forms / Send and enabling Assume Downloaded.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Networks

The network administrator should ensure all workstations are configured for Assume Downloaded and that only one computer (any computer connected to the network) actually downloads the facsimiles to the printer. Individual workstations have to create identical _T1DOWN.CFG files (i.e., use Configure / Download forms ) or have access to a common _T1DOWN.CFG file.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Download Size

Configure / Download forms maintains a cumulative estimate of the printer memory required for your resident pages. The figure displayed next to "Total size of items to be downloaded:" is only an approximation. The actual size can be higher in a few cases but, in most instances, should be smaller.

In most cases it is not necessary to download every form and page to the printer. You should determine, based on your printer's memory and client base, what is the optimum number and kind of forms to download. For example, if the majority of your clients are Ontario residents, having facsimile data in your printer for other provinces won't improve output time by much. In fact, on printers with 512 K, it may increase your chances of a memory overflow error.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Facsimiles Not Resident

If a facsimile's page (or pages) has not been downloaded via Send (i.e., has not been included in the _T1DOWN.CFG file), Personal Taxprep will detect this and download the correct data every time that page is encountered. Hence, you can add only the most often printed facsimiles to the configuration file (_T1DOWN.CFG) without fear that a less used page or form will print out blank.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Resident Pages Lost from Printer Memory

If a page is part of the _T1DOWN.CFG file and somehow it gets removed from the printer's memory, Personal Taxprep will download the facsimile data every time the missing page is encountered in the print job (eliminating the time savings for the missing page). However, the outputted page might be missing the bullets that Revenue Canada requires for keying in the return. If this is the case, then Send should performed and the print job re-started.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   

Macro Number

Each page is given an HP macro number. It is this macro that matches the return's cell data with the appropriate printer resident form. If conflicts occur with other programs (i.e., each program's printer download shares the same macro number), you can use the "Macro number for selected page:" field to change the page's macro number (valid numbers range between 1 and 999).

Do not duplicate a number already used by another page in your download list. Try selecting a number considerably higher or lower than the range your download list is covering. For example, if your download list seems to be using the 140 to 271 range, select a number between 800 and 900.

    <Dowloading Laser Forms>ǧ         <Main Help Menu>   



Home Buyer's Plan

Form T1048 calculates the amount to be included in income from participation in the Home Buyer's Plan. This is included in Version 92.2 (and was included in Version 92.1)  at the bottom of the RRSP Workchart.  Some confusion persists regarding the required procedures to eliminate the income inclusion.

Contributions made after February 25, 1992 may have to be included in income if a withdrawal was made under the Home Buyer's Plan.  When an amount is to be included in income, Planning Diagnostic P72 is flagged.  It suggests that the RRSP deduction should be reduced to preserve the Contribution Room and the full amount of the income inclusion should be withdrawn as soon as possible.

- Override line (e) of the RRSP workchart to reduce the RRSP deduction claimed.  This will preserve the Contribution Room for future years.

- If the contributions made after February 25, 1992 are subsequently withdrawn, the amount withdrawn should be entered on line 2 of the T1048.  This will reduce the income inclusion in the year. The withdrawal receipt from the financial institution should be filed to support that claim.

- The contributions carried forward to next year will be reduced by the withdrawals entered on line 2.

- The T4RSP slip that will be issued for 1993 will be offset by a deduction for refund of RRSP excess contributions (Form T746).



    <Version Notes>ǚ         <Main Help Menu>   

EFILE Revisions

Additional Exclusion

If a taxpayer has a U.I. overpayment and insurable earnings are based on either 53 or 54 weeks, that return may not be EFILE'd.

Deficient CPP Contributions

If contributions through employment were deficient based on the pensionable earnings reported on the T4 slip and CPP on self-employment is payable, the amount payable calculated by the program will reflect deficient contributions from employment. In short, CPP payable will exceed 4.8% of self-employment earnings and the return may get rejected if Revenue Canada Assessment assumes that the excess contributions are being made under subsection 12(3) of the Canada Pension Plan.

If you are making an election to contribute CPP on exempt income (Form CPT20), indicate such in the additional information section of the EFILE Workchart at line 310 and enter the total pensionable self-employment income at field 661.

If you are not making this election, you may override line C of Schedule 8 with the required contribution. This will reduce the amount payable at lines 421 and 310.

If you do not agree with either treatment, do not EFILE the return. Contact Revenue Canada.

Restricted Farm Loss

An EFILE diagnostic will now be flagged if a farming loss is restricted under Section 31(1). Jump to the specific SFD2 record, override field 8243 with the loss reported at line 141 on the T1 jacket (enter a negative amount) and enter the difference between the loss on the farming statement and the loss reported on the jacket in field 8244 (enter a positive amount).

Error Code 417

Revenue Canada introduced a new error code, 417. If you receive this, it means that its computer is currently down and unable to process that return. You should re-transmit that return the next day.

Quick Transmit

Quick Transmit will now only transmit a return if it has been set for Quick Transmit. Returns are set for Quick Transmit under Options / Set Return Status. This prevents uncompleted returns - that otherwise meet EFILE eligibility requirements - from being transmitted .

Eligibility Status

If the return has been transmitted and rejected, you must now set the return status (under Options / Set Return Status) to EFILE eligible prior to re-transmission.

SFD

Amounts/items that cannot be determined by the program now appear as input fields. For example, CCA additions, postal code, etc.



    <Version Notes>ǚ         <Main Help Menu>   

EFILE - Data Files Report

A new report, Data Files, has been added to the list of reports that can be viewed and printed from the Generate Reports screen (Utilities / Transmit / Reports).

The Data Files report allows you to see the status of any return in the selected File Path. Unlike other reports (ACK, TSR) that are generated by receiving information from Revenue Canada, Data Files creates its report based on the returns as they exist on your own drive. It is  highly useful for tracking the status of individual returns along the preparation and EFILE process.

Viewing Data Files Reports

To view a Data Files report, select Utilities / Transmit / Reports to arrive at the Generate Reports screen. [Tab] to the horizontal list labeled Report and highlight Data Files. [Tab] View, press [Enter] and the Data File Report dialogue box will appear. Use the File Path box to locate your return files.Enable/disable desired information from the boxes on the right-hand side. [Tab] to Ok and press [Enter].

Show EFILE status.

Displays a return's current status as regards the entire EFILEing process. The codes the Data Files report uses to indicate the status are as follows:

Report Code and Explanation

Efile - The return meets the program's minimum criteria for EFILE eligibility (this does not imply that the return is complete for filing, however).

Added - The EFILE-eligible return has been added to an RTU but has not been transmitted.

Sent - The return has been transmitted to Revenue Canada but an acknowledgment (ACK) is still pending.

Accpt - The return has been transmitted and has been accepted for processing.

Rej - The return has been transmitted and has been rejected. Consult the error codes, make the necessary corrections, set the return to EFILE under Options / Set Return Status and re-transmit.

Show TAX status

Displays a return's current status as set by the preparer under Options / Set Return Status.

Note: Set Return Status is a utility to help you track the return through the entire preparation process. Personal Taxprep does not employ any diagnostics to determine if this status is true.

Below are the codes the Data Files report uses to indicate the status.

Report Code and Status

WIP - Work In Progress.

More - Awaiting More Information.

Review - Under Review.

Print - Ready to print.

Printed - Printed.

Complete - Complete.

Sort by Status

Enabling Sort by Status will display or print returns according their EFILE and/or TAX status.

Sort by File Name

Enabling Sort by File Name will display or print returns alphabetically by their DOS file name.

No page breaks.Normally this report will print with a page break (top and bottom margin). If No page breaks is enabled the report will print continuously (good for users with dot-matrix printers and fan-folded paper).

Default report

If you find you view and print Data Files reports more than ACKs or TSRs, you can save yourself the step of having to select Data Files at the Report horizontal list at the Generate Reports screen by setting Transmit Setup / Options / Report to Data Files.

    <Version Notes>ǚ         <Main Help Menu>   



Microsoft Windows and Personal Taxprep

What is a PIF file?

A PIF or Program Information File is needed to run a DOS application under Microsoft Windows. The PIF contains information about the program's memory requirements and how it uses the components of the computer. If no PIF is specified, Microsoft Windows will run the application under a set of default assumption regarding memory and component use. Generally, however, an application will run better under Windows if a customized PIF is used that reflects the local hardware environment.

Taxprep Requirements

Although some DOS programs will run seamlessly without a customized PIF, Personal Taxprep (and other Taxprep programs) requires a PIF to run under Windows. Simply running T1.EXE through Microsoft Windows' Program Manager may result in data loss in certain circumstances, such as the use of the coupling feature. Use of the customized PIF file included with Personal Taxprep will prevent these problems.

Configuration

The supplied PIF is configured to run Personal Taxprep as efficiently as possible under Microsoft Windows. The program will run in exclusive mode when it is active - that is, other programs will not be allowed to run in the background. Furthermore, the T1 will not run in the background if it is not the active program. It will pause until it becomes active again.

Shortcut Key

Taxprep has assigned a "shortcut key" sequence of Ctrl-Alt-T to reactivate the T1 when it is in the background. This can be changed, if need be, by using the Program Manager's File / Properties menu item.

Networks

A second PIF file, called T1LAN.PIF, has been provided for compatibility with certain networks. T1.PIF is sufficient for use on most networks, but networks with older drivers may require T1LAN.PIF.

Taxprep Icon

Taxprep's logo has been included in the form of an attractive icon for use with Microsoft Windows and Taxprep products.

Installing the PIF and Icon

The T1's installation routine will copy the PIF (T1.PIF and T1LAN.PIF) and icon (TAXPREP.ICO) to the Personal Taxprep directory. Consult your Microsoft Windows manual or Windows' on-line help for instructions regarding installing a DOS program, PIF file, and icon to run under the Program Manager.

    <Version Notes>ǚ         <Main Help Menu>   





        EFILE92

        OverviewzV 
        Personal Taxprep and EFILE! 
        Step by stepn 


                                            <Main Help Menu>   


Overview

Basic Concepts

A tax preparer who wishes to participate in electronically filing returns has to be authorized by Revenue Canada.  This is done by filing an application form, called form T200.  If you have not yet filled out this form and need assistance, please contact Taxprep customer service.

The preparer will have to obtain authorization from the taxpayer to EFILE the return, by having the taxpayer fill out form T183.  It should be noted that with EFILE, the tax preparer has to assume the responsibility of "filing" the return.  With paper returns, the responsibility of actually filing the returns generally rests with the tax payer.  See Preparing returns for EFILE:- Other Considerations for more information about form T183.

The authorized tax preparer will then prepare tax returns using Taxprep in the normal manner, ensuring that:  the data has been entered correctly, that the taxpayer's position has been optimized,  diagnostics have been reviewed, etc.  The preparer will then select those returns which are eligible for EFILE, and get them ready for transmission using all the EFILE specific work charts in the program, such as the EFILE Work chart, EFILE Diagnostics, etc.

The program is then used to convert these returns, which are in Taxprep specific electronic format, into the format specified by Revenue Canada.

The program will then transmit these returns, in batches of returns known as Return Transmission Units (RTUs), from the tax preparer's computer to Revenue Canada's computer.  The transmission process includes updating the EFILE status of the selected returns directly into their data files.

The EFILE'd returns are evaluated or assessed by Revenue Canada's software.  Based on this evaluation, Revenue Canada accepts or rejects the return, providing error codes explaining why a specific return was rejected. The preparer is notified electronically in the form of Acknowledgment Files (ACKs).

When Taxprep processes these acknowledgment files, the data files will be updated automatically with this information.   The tax preparer can then take appropriate action.  The accepted returns can be printed using the special limited print EFILE Print format, while rejected returns can be corrected and re-transmitted in a subsequent RTU.

The above overview assumes that the tax preparation process is organized in the manner described below.

Types of Electronic filers

For the purposes of this document, there are essentially two kinds of Electronic Filers:

1

EFILE preparer's.  These are individuals or firms who prepare returns for EFILE, but who will generally be using the Taxprep EFILE Transmission Service for actually transmitting the returns.  These types of EFILE'ers will transmit RTUs and receive ACKs using the normal voice-quality telephone lines. These preparers do not have to undergo a Compatibility Test.

2

EFILE Preparers / Transmitters.  These individuals or firms will prepare the returns (just like the ones above), but who will be transmitting returns directly to Revenue Canada through leased dedicated lines.  These preparers have to undergo the Compatibility Test.  In December, 1992, Taxprep provided a separate EFILE Module which would enable you to do this test.  If you have not yet passed this test, please contact customer service.

The Taxprep program supports both types of EFILE'ers.  You can also choose a third party transmitter (other than Taxprep) to transmit your returns.

Taxprep transmission service

The following are the most important reasons for selecting the Taxprep transmission service:

- Reduced fixed costs.

- No long distance charges for transmissions.

- No need to pass Revenue Canada's compatibility test.

- Technical communications support from Taxprep.

- Increased ease-of-use.



Organizing your tax preparation procedures for EFILE

Being properly organized is the key to success with EFILE.  The most important element of the EFILE procedures is to have one specific workstation responsible for all EFILE transmission activities. This is because the matching of RTUs with ACKs is a very important part of controlling the EFILE process.  Having multiple transmitters within one office could create some serious problems.

Workstation Installation

The EFILE transmission workstation is the one which will have the modem attached.  During the installation of Version 92.1, you will be asked to specifically identify the workstation which will be used for transmission.  The INSTALL program will create a special EFILE work sub-directory called EFILE92, which branches from the Version 92.1 program directory. Taxprep will use the EFILE92 directory to store copies of RTUs, match them to the ACKs received, store errorlog reports in case a transmission could not be completed, create working files etc.

It should be noted that a companion file to the transmitted RTU (called *.TPU), which remains in EFILE92, will not only have the names of the returns which were transmitted in that RTU but also their datafile paths.  This allows the program to update the returns themselves with the results of the ACKs when they are received from Revenue Canada. Therefore, for Personal Taxprep to correctly update returns as regards their status with Revenue Canada, they should not be moved from their original directory.

The EFILE Transmission utilities (under Utilities in the pull-down menu) will only be accessible from the workstation which, during the INSTALL,  was identified as the EFILE Transmission station.

If you are in a networked environment, and the T1 program is stored on the file server, then all users will be able to access the EFILE transmission utilities.

Functions of the EFILE transmission workstation

The EFILE transmission station is responsible for building RTUs, transmitting them to Revenue Canada, receiving and processing ACKs, and printing the various reports (including the ACKs).

It is strongly advised that the EFILE transmission station has access to all selected EFILE eligible returns. This is because when a return is selected for inclusion into a RTU, Personal Taxprep will update the status flag for that return from "EFILE eligible" to "Sent for EFILE". Once the ACK for that specific RTU is downloaded and processed, the status flag on that datafile will be updated to either "EFILE - accepted" or "EFILE - rejected". The error codes from Revenue Canada will also be updated to the EFILE Work chart of the specific return. This EFILE status can be changed from inside the T1 program.

If the data files are stored on floppy disks, we strongly advise that the selected returns are copied to a sub-directory in the EFILE transmit workstation before using the following options: Utilities / Build EFILE RTU, Utilities / Build EFILE SEND, Utilities / Quick Transmit, or Utilities / Transmit. Once the ACK is received and processed, the datafile can be transferred back to the floppy disk.

If data files are stored in different stand-alone workstations, then eligible returns which are selected for EFILE should be transferred to the EFILE transmission workstation by floppy. They should then be copied to a subdirectory from which they could be selected for inclusion into a RTU. The data files should remain in the same sub-directory until the ACK for that specific RTU is processed. At that point, the data files can be transferred back to the workstation operated by the person responsible for those returns.

If you are in a multi-user environment, for example a NOVELL network, and the data files are stored in different subdirectories on the file server, then you must ensure that the EFILE transmission workstation has access to the datafile subdirectories. You must also ensure that once the EFILE transmission process is well under way, you should not move returns from one sub-directory to another or to rename sub-directories.



Hardware requirements and Setup

For the purpose of this document, the hardware requirements will be described under the assumption that you are going to use the Taxprep transmission service, where you will be provided with the appropriate hardware.

If you already have your modem, or you will be transmitting directly and will be purchasing your modem later, the explanation below can be used as a general guide as to the hardware requirements and installation.

Hardware supplied

Taxprep will supply the following hardware for use with the Taxprep transmission service:

1. An external modem which will be in a package entitled P.C. Logic, 24 EX.  This package will contain:

- The external modem (white steel casing).

- The AC adapter (black).

- One phone connector cable.

2. Two transparent plastic bags, containing:

- One RS-232 cable with a 25 pin male connector ("male" indicates that the pins are visible) and a 9 pin female ("female" indicates that no pins are visible) connector at the other end. This is the shorter, 12" cable.

- A RS-232 extension cable with 25 pin connectors on both sides.

Set-up

Below are the steps required to connect your modem.

1 Ensure that you have all the items noted above.

2. Using the short RS 232 cable:

Connect the 9 pin female connector to the 9 pin male serial port in the back of your transmission workstation.

Connect the 25 pin male connector of the RS-232:-  Directly to the modem; or to the RS-232 extension cable, which in turn is attached to the modem.

3. Connect the phone cable from the wall outlet to the "Line-in" slot in the modem.

3a.If the telephone line is to be shared with a regular phone line, then connect an additional phone line from the phone to the "phone-in" slot in the modem.

3b.  If the telephone line is to be shared with a fax machine, then attach the telephone cable from the fax machine to the "phone-in" slot in the modem.

NOTE:-Options 3a and 3 b are not available for EFILE Preparers/Transmitters as their rented transmission lines are dedicated only to transmit to Revenue Canada.

4. Connect the AC Adapter from the power supply (wall unit, power bar, etc.) to the modem.

5. Switch on the modem.

F10 / Utilities / Transmit Setup

For more detailed instructions, please see below for "Step by Step:- Setup for EFILE and/or SEND".

In Utilities / Transmit Setup  there are five options: Destination, Modem, Options, Cancel, and Ok.

Destination

<Destination> selects the destination to where your tax returns will be transmitted:

DataPac Direct - Rev Can - for the production filing of returns for EFILE and returns prepared for SEND using a DataPac dedicated line.

DataPac Dial Up - Rev Can - for Compatibility testing if you do not yet have a direct line supplied by DataPac.

FasPac Direct - Rev Can - for the production filing of returns for EFILE and returns prepared for SEND using a FasPac dedicated line.

FasPac Dial Up - Rev Can - for Compatibility testing if you do not yet have a direct line supplied by FasPac.

Taxprep EFILE Service - for users of Taxprep's EFILE service.

Taxprep Print Service - Taxprep Print Service will not be available until Version 92.2's release in March 1993.

User definable - used for custom destination scripts created by Taxprep in the future or for scripts created by advanced users.

Destination is further broken into the options: Ok, Cancel, Modem, and Defaults.

Ok: Accept selections.

Cancel: Do not accept selections and exit <Destination>.

Modem: See below

Defaults

In <Defaults> you will find:

Phone number: If you are performing the Compatibility Test and using a DataPac or FasPac dial-up number, you would enter it here. If you are using Taxprep's Print or EFILE Service, you would enter the number supplied by Taxprep. In all cases if your modem is connected to an internal line, that is you have to "dial 9 to get out", enter 9 followed by two commas before required number (i.e., 9,,555-1234). The commas are half-second delays, allowing your phone system time to connect with an outside line. Add additional commas if you need a longer delay.

Script and File Encryption: Ignore Script and File Encryption items. These are features that will be added in the future.

Modem

The Modem option lets you select the type of modem you are using. If you do not see your brand of modem listed (e.g., Zoom), then select Hayes-compatible. Nearly all modems that operate at 300-2400-baud are Hayes-compatible.

If you are registered with Taxprep for either EFILE or our Print Service, a P.C. Logic modem will be provided for you. Select the P.C. Logic modem from the menu.

Protocol: You must select a transmission protocol. A protocol sets a communication standard for the exchange of data between two computers. We recommends the use of Xmodem for this version of EFILE.

Com Port: There are four choices for the communications/serial port your modem is using. The program defaults to Com 1 but you may need to return to Utilities / Transmit Setup / Modem and select a higher port number if you are not able to get a response when you transmit.

BaudRate: BaudRate is the speed at which the modem transmits data. For transmitting of RTUs BaudRate must be set to 1200 or 2400.

Options

In Options you will find:

Customer #: If you are a subscriber to Taxprep's Print or EFILE service, you input your Taxprep customer number in this cell.

Transmitter Agent #.: This number is assigned by Revenue Canada. If you are a subscriber to Taxprep's Print or EFILE service, you would leave this cell blank.

Password: The password will be either provided by Revenue Canada if you are a Transmitter Agent (EFILEing direct to Revenue Canada through DataPac or FasPac) or by Taxprep if you are a subscriber to Taxprep's Print or EFILE service.

Transmission Type: The transmission type will be either Test or Production. Test should only be selected when you are performing the Compatibility Test with Revenue Canada. Production should be selected when you are actually electronically filing your client's returns and transmitting SEND RTUs.

Mode: The mode is the type of RTU you are transmitting. You will select RTU for transmitting EFILE RTUs (to Revenue Canada or Taxprep's EFILE transmission service), SEND for SEND RTUs, and PRINT SVR for Taxprep's Print Service RTUs.

NUI and NUI Password: The NUI (network user identification) is provided by the your telecommunications carrier, DataPac or FasPac. Similarly, the NUI Password is also provided by the telecommunications carrier.

Report: ACK, OLD ACKs and TSR are different types of reports. You can choose which report you would like to review. The report you select here in Utilities / Transmit Setup / Options will be the report you will see displayed on-screen or printed in Utilities / Transmit.

Show: This command will break down the ACK and OLD ACK report further. The type of Show report you choose here will be the one you will see displayed on screen or printed in Utilities / Transmit. Further information regarding Show will be discussed in the "Quick Transmit EFILE/Transmit EFILE" section of this document.

Error Display: You have the flexibility to show errors two ways with the error display.  The type of error display you choose here will be the one you will see displayed on screen or printed in Utilities / Transmit. Further information regarding Error Display will be discussed in the "Quick Transmit EFILE/Transmit EFILE" section of this document. "Full Error Codes" is not available for this tax season.



    <EFILE92>U                             <Main Help Menu>   


Preparing returns for EFILE - EFILE Workchart

EFILE Default information

Before preparing returns for electronic filing, you should enter your Preparer's Agent Number and the receiving taxation centre in the Preparer's Profile and then save your configuration.  This procedure will ensure that all subsequent returns accessed will have this information defaulted.

Checking EFILE eligibility

Once the return is complete, jump to the EFILE workchart. The eligibility section will show you if the return is eligible for EFILE. If a return is ineligible, the reason(s) will be listed in the EFILE Diagnostics workchart.

The program will determine eligibility based on the information available from the return. However, you must also review the list of additional EFILE exclusions which cannot be determined by the program (e.g. Canadian source income from Lloyds of London). These additional items are listed in a separate section in the EFILE workchart. A yes answer to any item will cause the return to be ineligible.

Entering additional information

An EFILE return contains additional data fields which are not normally entered when preparing regular files.  Most of these additional data fields can be determined by the program.  The data which cannot be determined, must be entered in the EFILE workchart.

A specific set of diagnostics are flagged when conditions dictate that additional information may be required.  A common example would be when interest income is reported on line 121 of the T1 jacket. A diagnostic is flagged to prompt you to allocate the income source between bank, bond, trust, and mortgages.

Some of this additional information is optional and does not have to be entered.  Optional information is clearly indicated in the EFILE workchart.

Checking for EFILE errors

The EFILE workchart will likewise indicate if there are errors which would cause the return to be rejected by Revenue Canada. Any errors will be displayed in the EFILE Diagnostics workchart. Correct the inappropriate data in the return to remove the error diagnostic.

The EFILE errors listed are reproduced from Appendix A of Revenue Canada Electronic Filer's Guide. Certain errors which cannot be detected by the program (e.g. the birth date entered does not match Revenue Canada's records) are not included in the error diagnostics.



Preparing returns for EFILE - Other Considerations

Selecting a return for EFILE

If a return is eligible for EFILE, and has no errors which would cause that return to be rejected by Revenue Canada, it may be selected for EFILE.

You may also choose to have all of your returns selected for electronic filing by setting the default in the Preparer's Profile. Each return will then be automatically selected, however, ineligible returns will not be selected unless errors are first resolved.

If for any reason, you do not agree that the errors flagged by the program are correct and wish to select the return for EFILE anyways, you can answer yes to that question in the EFILE workchart.

Form T183

A taxpayer's signed authorization must be obtained prior to electronic filing.  In addition, the taxpayer must also sign a declaration that the total income, taxable income, etc. in the return are correctly represented.  This form should not be mailed to Revenue Canada, but must be retained for subsequent verification.

It is often not practical to obtain a taxpayer's authorization and declaration in a single visit to your office.  As a solution, you can print Form T183 and obtain the taxpayer's authorization before the return is completed. You then have the authorization to complete the return and file the return electronically.

When the return is completed, you can re-print Form T183 (with the declared amounts updated) and obtain the taxpayer's second signature.  Alternatively, you can use the original T183, write the amounts from the return in the declaration and obtain the taxpayer's signature.

Form T7DR(A)

When there is a balance due on a return which has been electronically filed, the payment must be made with Form T7DR(A).  This form is obtained from Revenue Canada and cannot be re-produced by the program in laser facsimile or plain paper format.  The facility to print information from a return on the Revenue Canada forms will be provided in Version 92.1.

The form and payment should be mailed to Revenue Canada by April 30th. A taxpayer can also make this payment at a financial institution.

Document Control Number

A unique Document Control Number (DCN) which identifies each SEND/EFILE return is automatically created by the program. The DCN is created by combining your Preparer's Agent Number with the first 8 digits of the taxpayer's Social Insurance Number.

If you are using the Taxprep EFILE transmission service, you should not change the assigned Document Control Number.

Selected Financial Data (SFD)

If you have self-employment income or rental income, you must submit selected financial data with your EFILE return.  Much of this information is defaulted in the regular preparation of a return.

One item unique to electronic filing is the requirement to enter a Standard Industrial Classification (SIC) code.  You must select the relevant code in the self-employment or rental statement.

There are two types of Selected financial information required, one related to farming (jump code SFD 2) and the other for other business or rental property (jump code SFD 1).

To be eligible for EFILE, you are limited to a combination of three self-employment or rental statements.

Selected financial data is updated automatically by the program from the first three self-employment/rental statements entered in the return. These amounts represent selected financial data and does not necessarily include all items from your financial statements.  As a result, there is no need to adjust your statements to match the SFD.  Expenses which cannot be readily allocated to a SFD field are listed at the bottom of each SFD whereby they may be updated to an appropriate SFD field at your discretion.  The SFD also includes optional fields relating to balance sheet items which may also be entered at your discretion.

If you have not used one of the statements provided in the program (e.g. T776 or T2124), that is, you have entered the self-employment income by overriding the T1 jacket or you have entered your income in Form T5013, the SFD record will not be updated properly.

In these situations, you must access the relevant business summary (e.g. Rental Income summary) and arbitrarily enter a gross or net income amount to trigger a SFD be linked to the EFILE record.

After the SFD has been linked to the EFILE record, you may now access the SFD record and enter all necessary information such as SIC code, fiscal period, revenue and expense items.

EFILE Summary workchart

The EFILE summary workchart provides a view of EFILE records created.  You should never need to verify this summary workchart. However, this workchart is provided to allow you the possibility to modify an EFILE record if you so choose.

Printing

One of the distinct advantages to electronic filing is the removal of the requirement for printing multiple copies of returns.  If a return has been accepted for EFILE, you do not need file a paper copy of this return to Revenue Canada.

There are certain exceptions, however. If Consent form T1013 is obtained from the taxpayer, a signed copy of that form must be filed to Revenue Canada.  Revenue Canada also requires that signed copies of any elections (e.g. T581- forward averaging) should be filed with them by the due date when applicable.

Taxpayers who opt for EFILE still require a copy of the return that was filed.  In most cases, they do not require a detailed return such as one which would be submitted if the return was filed conventionally.  The program provides a T1 jacket outline option, which in most cases, prints the return in a single page summary.  This alternative is a time and cost saver to clients who do not demand a full copy of the return.

There is an EFILE.FMT provided which defaults the T1 jacket outline, Form T183, client letter, and only forms which may require a signature to be printed.  You can modify this print format to your choosing by adding or deleting forms. If you use the EFILE.FMT, you do not have to select the EFILE format option during Batch Print or Print Return. By selecting the EFILE print option at Batch Print or Print Return, only EFILE relevant forms will be printed regardless of the print format currently loaded.

SEND

You can only access Revenue Canada's System for Electronic Notification of Debt (SEND) if you are a registered discounter. To prepare a SEND, you require the taxpayer's name (and whether that name has changed since the taxpayer had last filed), SIN, and birth date.  The discounter's registration number should by entered in the preparer's profile and saved under Configure / Save.

To select a return for SEND, you either default that setting in the Preparer's Profile or make that setting in the SEND workchart. If a return is not eligible for SEND, a SEND diagnostic (jump code SE DIAG) will be flagged.



    <EFILE92>U                             <Main Help Menu>   


Step by step Conventions

EFILE RTU: A transmission unit that holds the returns you have flagged for electronic filing.

SEND RTU: A transmission unit that holds the returns with completed SEND workcharts for submission to Revenue Canada's System for Electronic Notification of Debts.

The Step by step chapters give you the exact key combinations that are required to perform the basic operations of EFILE and SEND. Detailed descriptions of menu options are available in the preceding chapters.

Step by step: Setup for EFILE and/or SEND Production

The step-by-step instructions below give you the exact key combinations that are required to set yourself up for EFILE and/or SEND production. Detailed descriptions of menu options are available in the preceding chapters.

1

Complete the Carrier Worksheet. Since you have numbers and passwords supplied from various sources (e.g., Revenue Canada and DataPac), the Carrier Worksheet is a good place to collate all the information. This will assist you when completing the setup procedure in the program. Most of the information on this form will be defaulted. You should, however, verify that the defaults are correct for your circumstances. For example, Protocol will default to Xmodem. You should ensure Protocol is exactly the same as the one you specified on form T200. As well, within the program, the Communications Port will default to serial port Com 1. Ensure this is correct for your computer. You may need to change Communications Port to a higher number.

2

Select Utilities / Transmit Setup from Personal Taxprep's menu bar. You will now be at the Transmit Setup screen. Down the left hand side are the default settings. You will need to change some of them to match the data you have recorded on the Carrier Worksheet and change others to allow you to transmit RTUs.

3

[Tab] to <Dest.> and press [Enter] to arrive at the Select Destination screen.

4

Use the arrow keys to highlight either DataPac Direct or FasPac Direct. Press [Enter] and [Tab] to <Ok> and you will return to the Transmit Setup screen.

5

[Tab] to <Ok> and press [Enter] to return to the Transmit Setup screen.

6

[Tab] to <Modem> and press [Enter].

7

You will now be at the Setup Modem screen.

8

Review Protocol, Com Port, BaudRate, and Modem settings. You should ensure Protocol is exactly the same as the one you specified on form T200. Com Port defaults to 1. A Com port is the serial connection between your computer and your modem. Other devices (like mice and printers) can use Com ports as well. If you are not familiar with which port your Modem uses, you just have to try each Com port setting. BaudRate should be 2400. Select your modem brand from the list. If you do not see your brand (e.g., Zoom) select Hayes & Hayes Compatible 2400.

9

Use the arrow keys and [Enter] to highlight and change whatever settings require it. When all the appropriate settings have been selected, [Tab] to <Ok> and press [Enter] to return back to the Transmit Setup screen.

10

[Tab] to <Options> and press [Enter].

11

Transmitter Agent # and Password are assigned by Revenue Canada, so [Tab] to each line and enter the assigned alphanumeric combination. Ignore Customer #.

12

Transmission Type should be set to Production and Mode and should be set to RTU if you are filing Personal Taxprep returns. Select SEND under Mode if you are accessing the System for the Electronic Notification of Debts.

13

The NUI and NUI Password are assigned by the communications carrier you have chosen to transmit your RTUs, so [Tab] to each line and enter the assigned alphanumeric combination.

14

[Tab] to Report. Set it for ACK. [Tab] to Show. Set it for Rejected, since you will be most concerned about RTUs that are rejected. Alternatively, you can set it to All to get a report about which RTUs were accepted and rejected. [Tab] to Error Display. Set it for Error Codes Only.

15

[Tab] to <Ok>and press [Enter] to arrive at the Transmit Setup screen.

16

Review your settings one last time. If they are all correct, you are now ready to use Utilities / Transmit or Utilities / Quick Transmit.

17

To return to the Utilities menu, [Tab] to <Ok> at the bottom of the screen and press [Enter]. DO NOT PRESS [Esc]. [Esc] will cancel any changes you have made and return you to the Utilities menu with all the original defaults still intact.

Remember

In Step 12 if you set Mode to RTU you are ready for electronically filing returns (i.e., transmitting EFILE RTUs). If you set Mode to SEND you are ready to access the System for the Electronic Notification of Debts (i.e., transmitting SEND). Utilities / Quick Transmit operates independantly of Mode, with respect to transmission, as it will transmit ALL RTUs (EFILE or SEND.)

Step by step: Quick Transmit

The step-by-step instructions below give you the exact key combinations that are required to use Personal Taxprep's Quick Transmit utility. Quick Transmit will build and transmit any return file set for EFILE or any return file with that has a completed SEND workchart.

To cover the widest possible circumstances the step-by-step instructions speak of transmitting more than one RTU. It is likely Quick Transmit will only create one RTU if you are not a discounter and two RTUs if you are a discounter and have completed one or more Returns prepared for SENDs.

1

Select Utilities / Quick Transmit from Personal Taxprep's menu bar.

2

Personal Taxprep will scan your file path, build EFILE and/or SEND RTUs, and transmit them to Revenue Canada.

3

Immediately after transmission, you will see a log detailing what RTUs were transmitted. If you see "Errors In Transmission See Log", one or more of your RTUs have not been accepted. On that screen, select the print option, read the hard copy to determine which RTUs have not been accepted. These will have to be re-transmitted.

If an RTU is rejected in transmission, this does not mean the RTU contains an invalid return or SEND file. That information is available later from Revenue Canada in the form of an Acknowledgment Report or ACK.

If you have an RTU to retransmit follow step 4. If not, go to step 5.

4

To re-transmit press [Esc] until you return to the menu bar and the copyright screen. Select Utilities / Transmit from Personal Taxprep's menu bar. In the dialog box on left you will see a list a RTUs. Unless more RTUs have been built with Utilities / Build EFILE RTU or Utilities / Build EFILE SEND the RTUs displayed will be the rejected ones. [Tab] to <Select ALL> and press [Enter].

5

After 3 or more hours, you can pick up your Acknowledgment files. These files will be saved to your EFILE directory with the extension *.ACK, and they will tell you the status of the individual returns or Returns prepared for SENDs contained with the RTU. Select Utilities / Transmit after the 3 hour waiting period.

6

[Tab] to <Transmit> and press [Enter]. You do not have to transmit any more RTUs to pickup your Acknowledgment files.

7

After your Acknowledgment files have been transferred from Revenue Canada's computer to yours, it is time to view the files and generate reports. From the Transmit screen [Tab] to <Reports> and press [Enter] to arrive at the Generate Reports screen.

8

To view an Acknowledgment file, highlight it with the arrow keys and press [Enter]. [Tab] to <View> and press [Enter]. Press [Esc] to return to the Generate Reports screen. (Before you go to the Generate Reports screen, you should first check to see if ACK has been set up to show under Utilities / Transmit Setup's <Options>. Use the Transmit screen's <Setup> to move to <Options> to verify this. If ACK is not highlighted then highlight ACK, select <Ok> and select <Ok> once more to return to the Transmit screen.)

9

After viewing as many Acknowledgment files as desired, print out all of them. Select the files individually or use <Select All> and then [Tab] to <Print> and press [Enter].

10

Printing your Acknowledgment files will generate the following reports:

"SEND RESULT LIST" reports for discounted RTUs

"ACCEPTED RECORDS LIST" and "NON-ACCEPTED RECORDS LIST" for EFILE RTUs

Step by step: Build EFILE RTU or Build EFILE SEND

The step-by-step instructions below give you the exact key combinations that are required to build RTUs for EFILE or SEND. Once the RTUs are built, see Step by step Transmit.

Remember

Unlike Utilities / Quick Transmit, you can only use Utilities / Transmit if you have "manually" created RTUs using the Build option.

1

From Personal Taxprep's menu bar select Utilities / Build EFILE RTU to build an EFILE RTU or Utilities / Build EFILE SEND to build a SEND RTU.

2

Regardless of which option you have selected, you will now be in the Edit RTU screen. The upper most text will read either "Edit RTU:  RXXXXX01" or "Edit RTU:  SXXXXX01", the Xs represent today's date. R indicates you are building an EFILE RTU, S indicates you are building a SEND RTU. The two digit number indicates the number of RTUs built that day. If this is the first EFILE RTU built for the day the last two numbers will be 01. If it is the sixth EFILE RTU built for the day, it will be 06.

The file path will default to Personal Taxprep's configured file path. If you have been saving returns for EFILE or Returns prepared for SEND in their own directory, you can use the middle list box to locate the appropriate directory.

The list box in the left will show all the return files or Returns prepared for SEND eligible for transmission. Return files or Returns prepared for SEND that are not eligible for transmission will not be displayed. Return file or Returns prepared for SEND that have been rejected in Acknowledgment reports will not be displayed until the errors have been corrected.

3

[Tab] to <Select ALL> and press [Enter] if you want all the listed return files or Returns prepared for SENDs included in the RTU. You will see all the files move to the list box on the right.

There is a limit of 200 files or Returns prepared for SEND. If you have more than 200, say 250, <Select ALL> will take the first 200. After building the RTU, return to Personal Taxprep's copyright screen and repeat steps 1 through 3 to create a new RTU for the remaining 50.

If you do not want to select all, highlight the desired files individually with the arrow keys and press [Enter] to move them to the box on the right.

4

When the desired return files or Returns prepared for SENDs have been moved to the right list box, [Tab] to <Done> and press [Enter]. Your newly created RTU will be saved in your EFILE92 directory.

5

After creating as many RTUs as needed, you are now ready to transmit them with Utilities / Transmit. See the following step by step chapter.

Step by step: Transmit

The step-by-step instructions below give you the exact key combinations that are required to transmit the RTUs (EFILE and SEND) you created in the previous chapter. Detailed descriptions of menu options are available in the preceding chapters.

1

From Personal Taxprep's menu bar select Utilities / Transmit. You will now be at the Transmit screen. At the very top of the screen you should see "Select R.T.U. (or S.E.N.D.) files for PRODUCTION MODE transmission".

It is important that the text at the top reads "PRODUCTION MODE transmission". If it reads "TEST", [Tab] to <Setup> at the bottom of the screen and press [Enter]. You will notice you are at the Transmit Setup screen, which is normally accessed via Utilities / Setup. [Tab] to <Options> to change Transmission type. (see steps 10 to 15 in the chapter titled "Step by step Setup for EFILE and/or SEND Production" for more details). <Ok> will take you back to the Transmit screen. The text at the top should now read PRODUCTION MODE.

Do not worry if you want to transmit EFILE RTUs and the text at the top reads "S.E.N.D." (or visa versa).

2

In the dialog box on left you will see a list of the RTUs you have built. RTUs that were rejected due to transmission errors will also appear in the box. [Tab] to <Select ALL> and press [Enter]. If you don't want to transmit all of the RTUs, highlight the desired one individually with the arrow keys and press [Enter]. [Tab] to <Transmit> and press [Enter].

3

After 3 or more hours, you can pick up your Acknowledgment files. These files will be saved to your EFILE directory with the extension *.ACK, and they will tell you the status of the individual returns or Returns prepared for SENDs contained with the RTU. Select Utilities / Transmit after the 3 hour waiting period.

4

[Tab] to <Transmit> and press [Enter]. You do not have to transmit any more RTUs to pickup your Acknowledgment files.

5

After your Acknowledgment files have been transferred from Revenue Canada's computer to yours, it is time to view the files and generate reports. From the Transmit screen [Tab] to <Reports> and press [Enter] to arrive at the Generate Reports screen.

6

To view an Acknowledgment file, highlight it with the arrow keys and press [Enter]. [Tab] to <View> and press [Enter]. Press [Esc] to return to the Generate Reports screen.

7

After viewing as many Acknowledgment files as desired, print out all of them. Select the files individually or use <Select All> and then [Tab] to <Print> and press [Enter]. Once you print out an Acknowledgment file, Personal Taxprep will convert it to an Old Acknowledgment file. Simply put, acknowledgment files have the extension *.ACK. Personal Taxprep will give printed ACKs the extension *.ACX.

8

Printing your Acknowledgment files will generate the following reports:

9

"SEND RESULT LIST" reports for discounted RTUs

10

"ACCEPTED RECORDS LIST" and "NON-ACCEPTED RECORDS LIST" for EFILE RTUs



    <EFILE92>U                             <Main Help Menu>   
End of File

Ay &O4  $ t 
   p L?.   J5 IF *$ z G P   gaI 9 { J 	E D K   % " L A  3 +:   Qn|  / q  o # '   y ; .  [n  _     & u ^  e 4)<   	  G 0 ` *  B b 
K/0 1= v rZ6+     2  ,( : > iR'  r 2x  6|4  ?    7  1  g  s=1S @     >c    7  \ + 
 h  <8A   
 T i  B 6    O ) j  2  C P   s  k  Q  D     R  >kl 7  ,  S    a T       U d     e V   u8  W    X     Y 	 l - (oZ N* V  w  ^   vABOUT     E ADD       v$ zADDSUM    #  APP       ' ! APPEN      [ APPEN1     APPEN2    % ATLAN       COUPLE    O CREDIT     Configure   }DEDSUM    4 f DEP       	 5EF        U  EF1       zV EF2       ! cEF3       n EFDATREP  N@ EFREV     6 N END       } Edit      	  FAM       . FED       O dFORMSAV   7 FORMSAV1   FORMSAV2   <FORMSAV3  & C FORMSAV4    FORMSAV5   m FORMSAV6  
 bFORMSAV7   fFORMSAV8   
 pFile        H GSTC      , } IDENT       INC       I) INCSUM     JAC       5(  LASERFAC0   LASERFAC1 )  3LASERFAC10	 LASERFAC11
 `LASERFAC12
 LASERFAC2 K  LASERFAC3 *  LASERFAC4   LASERFAC5   %LASERFAC6   LASERFAC7   LASERFAC8  LASERFAC9  LASFAC     M LASFAC0     LASFAC1    !LASFAC10  * :LASFAC11  +  LASFAC12  '.  LASFAC2   6 "LASFAC3    #LASFAC4   u $LASFAC5   
  LASFAC6     LASFAC7   !  LASFAC8   %  LASFAC9   & MANIT      NET       v=  NONREF    C NR6       U ONTAR      OPT1       OPT2       OPT3        OPT4        OPT5      { wOPT6       OPT7       ] OPT8      m  OPT9      [  OPT9A      OPT9B     3 q OPT9C      OPT9D      OPT9E      EOPT9F      ~OPT9G      OPT9H       OPT9I      !OPT9J     P OPT9K      OPT9L     %  OPTION    a Options     PENSUM     PRE       J /PRIOR     P (PROCED     PROCESS    PROF       PROV      ۫ @RELEASE    RESOR     q RRHBP     1 SCHED1    C SCHED3    ɐ SCHED4    ; SCHED5     SCHED6    4 SCHED7     ~ SCHED8     SELF       SELF13     SELFCCA    SELFFIX    SELFMINV  e  SELFREAL   SELFSTAT   SLIPS     S SLIPVIEW  /T SPOUSE     HSUMM       ;Search      T1A       VW T1E       vX T1M       \ T1SCHED    T2011     מ T2017       T2038      T2097      T2200     @  T2203     E  T2204      T2222     t T4        v\ T4A       bb  T5        m  T541      c  T581      j UT626      n T657      :v  T691      W} T746      ˇ T777      M  T778       T936      | TOABON    ~ FTOABUA     -TOABUB     TOABUC     TOABUD     TOABUE     TOACFD      TOACOA      TOACSB      TOACTB    U2 TOADEC    @ TOAEXP    M TOAFIA     WTOAFIB     XTOAFIC     TOAFID     8TOAFIE     9TOAFRA     TOAFRB     TOAFRC     TOAFRD     TOAFRE     jTOAFTA    j* TOAFTB    j* TOAFTC    j* 3TOAFTD    j* TOAFTE    j* TOANRR    U TOAPRA     TOAPRB     TOAPRC     TOAPRD     TOAPRE     MTOARRS    $ TOASRA     TOASRB      TOASRC      TOASRD      TOASRE      TOASRF      TOASRG      TOASRH      TOASRI      TOASRJ     TOATIE    vX TOATIM    \ TOATRA    ɐ TOATRB    ɐ TOATRC    ɐ TOATRD    ɐ TOATRE    ɐ TOATRF    ɐ TOATRG    ɐ TOATSA    st TOATSB    bb =TOATSC    v\ TOATSD    y TOATSE    _{ TOATSF    q TOATSG    m TOATSH    w TOATSL    v TOATSN     TOATSO     TOATTA     TOATTB     TOATTC     TOATTD     TOATTE     TOATTF     TOATTG     @TOATTH     \TOATTI     TOATTJ     TORCAA     TORCAB     TORCAC     TORCAD     TORCAE     %TORCAF     TORCAG     TORCBA     TORCBB     TORCBC     TORCBD     TORCBE     TORCBF     TORCBG     TORCCA     TORCCF     TORCCG     TORCFA     TORCFB     TORCFC     TORCFD     TORCFE     TORCFF     TORCFG     TORCPA     TORCPB     TORCPC     TORCPD     TORCPE     ]TORCPF     TORCPG     TORDGN    m TORRES    ? TORRRS    $ TORTSA    st TORTSB    bb TORTSC    v\ TORTSD    y TORTSE    _{ TORTSF    q TORTSG    m TORTSH    w TORTSI    v\ TORTSL    v 
TORTSN     hTORTSO     {TOTAL     H7 TOTHER    q TOWABL    k TOWADD    # TOWALR    q TOWAMT    M TOWAVG    מ TOWBCR    q #TOWBIL     TOWBUS     xTOWCAP    :v TOWCIL    | TOWCLA10  + "TOWCLA9    + TOWCLD     TOWCLS     _TOWCOM     TOWCRA    
 TOWCRB    
 9TOWCRC    
 TOWCRD     TOWCRE     TOWCRG     'TOWCRH     TOWCRJ     TOWDEP    . TOWDFT     TOWDIS     TOWDON    i$ TOWEAA     TOWEAB     TOWEAC     TOWEAD     TOWEAE     TOWEAF     TOWEAG     .TOWEBA     TOWEBB     TOWEBC     TOWEBD     TOWEBE     TOWEBF     TOWEBG     TOWECA     TOWECF     TOWECG     TOWEFA     TOWEFB     TOWEFC     TOWEFD     TOWEFE     TOWEFF     TOWEFG     TOWEMP    ) TOWEPA     TOWEPB     TOWEPC     TOWEPD     tTOWEPE     TOWEPF     TOWEPG     YTOWFAC    j TOWFAT    c TOWFIS     TOWFRM     TOWGST    , TOWIDT     mTOWIDT31  Q TOWIDT33   TOWIDT34  Q TOWIDT35  Q TOWIDT36   TOWIDT76   TOWIDT77   TOWIDT78   TOWIDT79   TOWIDT80   TOWINS    { TOWINT     TOWITC     TOWJAC    5( TOWJAC1   ) TOWJAC11  y/ TOWJAC112 B> TOWJAC114 N TOWJAC115 N TOWJAC128  TOWJAC13  3 TOWJAC151 5 TOWJAC152 L: TOWJAC153 L: TOWJAC160 AF TOWJAC161 AF TOWJAC162 AF  TOWJAC163 AF TOWJAC164 AF TOWJAC165 AF TOWJAC166 AF TOWJAC167 AF TOWJAC168 AF TOWJAC169 AF TOWJAC170 AF TOWJAC171 AF TOWJAC172 AF TOWJAC173 AF TOWJAC174 AF TOWJAC175 AF TOWJAC176 AF TOWJAC177 AF TOWJAC178 AF TOWJAC179 AF TOWJAC180 AF TOWJAC181 AF TOWJAC182 AF TOWJAC183 AF TOWJAC184 AF TOWJAC185 AF TOWJAC186 AF TOWJAC187 AF TOWJAC188 AF TOWJAC189 AF TOWJAC190 AF TOWJAC191 AF TOWJAC192 AF TOWJAC193 AF TOWJAC194 AF TOWJAC195 AF TOWJAC196 AF TOWJAC197 AF TOWJAC198 AF TOWJAC199 AF TOWJAC200 AF TOWJAC201 AF TOWJAC207 N 
TOWJAC208 N 0TOWJAC209 N ?TOWJAC210 N TOWJAC211 N TOWJAC220 D TOWJAC221 D TOWJAC222 D TOWJAC223 D TOWJAC224 D TOWJAC225 D TOWJAC251 R) TOWJAC252 R) TOWJAC268 5 TOWJAC269 5 TOWJAC27  B> TOWJAC274 g7 TOWJAC275 8 TOWJAC28  L: TOWJAC283 5 TOWJAC29  f; TOWJAC33  < TOWJAC4    + TOWJAC418 I TOWJAC42  = TOWJAC43  > TOWJAC45  B> TOWJAC46  B> TOWJAC47  B> TOWJAC48  B> TOWJAC49  B> TOWJAC50  B> TOWJAC51  B TOWJAC55  B> TOWJAC56  C TOWJAC57  D TOWJAC58  AF TOWJAC59  AF TOWJAC60  AF TOWJAC61  AF TOWJAC62  AF TOWJAC63  AF TOWJAC64  AF TOWJAC67  G TOWJAC68  G TOWJAC68   TOWJAC69  H TOWJAC7   + &TOWJAC71  I TOWJAC72  I TOWJAC73  'K TOWJAC74  'K TOWJAC75  'K TOWJAC76  M TOWJAC8   . TOWLSC    3 TOWMAR    q TOWMED    ; TOWMIA     TOWMIB     TOWMIC     TOWMID     TOWMIE     ;TOWMIN    W} )TOWMLT    E ,TOWNOR    t TOWNTI    x TOWOET    n TOWONE    C TOWOTD    4 TOWOTI     TOWOTP     TOWOVR     TOWPRF     TOWRES    ? TOWREV     TOWREX    ˇ 5TOWRIP    XB TOWRNT     TOWRPP    -L TOWRPT     TOWRSS    : TOWSAR    q TOWSIX    4 TOWSTC    j* TOWSUM     TOWSVN     TOWTAB     TOWTIA    VW TOWTRE    ɐ TOWTRN    v$ TOWTXD    
 USEC1H1     USEC1H2   Z!  USEC3H1   $  USEC3H2   *  USEC3H3   3  USEC3H4   ;  USEC3H5   EA  USEC3H6   T  USEC4H1   Z  USEC4H2   6e  USEC4H3   9k  USEC4H4   {  USEC4H5     USEC4H6   -  USEC4H7   ۖ  USEC4H8   <  USEC4H9     USEC5H1   Ǳ  USEC5H2     USEC5H3     USEC5H3A    USEC5H4     USEC5H5     USEC5H6     USEC5H65   USEC5H7   ^% USEC5H8    USEC6H1   , USEC6H2   i3 USEC6H3   7 USEC6H4   < USEC6H5   @ USEC6H6   6D USEC6H7   SS USEC6H8   I USEC7H1   Y USEC7H2   ` USEC7H3   
c USEC7H4   p USEC7H5    USEC7H6   ht USEC7H65  } USEC7H651 J USEC7H6510 USEC7H652 P USEC7H653 I USEC7H654 Ã USEC7H655 j USEC7H656 Ʌ USEC7H657 ҆ USEC7H658  USEC7H659 K USEC7H7    USEC8H1   ! -USEC8H2   < USEC8H3   R USEC8H4    USEC8H5    USEC8H6    USECHAP1    USECHAP3    USECHAP4    USECHAP5  	  USECHAP6    USECHAP7  K
  USECHAP8    USEINDEX  a  USER        View        WEST      
 WINPREP   L WORK      ) WORK1     
 WORK10    ? WORK11    XB WORK12    -L WORK2     k WORK3     M WORK4      WORK5     i$ WORK6     j* WORK65    U2 WORK7     3 WORK9     : general      index                       	    K
    a    	            Z!  $  *  3  ;  EA  T  Z  6e  9k  {    -  ۖ  <    Ǳ                )  K  *            	 
 
   ^% , i3 7 < @ 6D I SS Y ` 
c p ht } J P I Ã j Ʌ ҆  K    ! < R    ' J   . O    	  v$ 5( I) H7 v= C P S /T v\ bb m q  C ɐ ;  4   , ۫ 
    q    4 #      e  ) 
 k M  i$ j* U2 3 : ? XB -L O U VW vX \ c j n :v W} ˇ M  | מ    @ E  t a     {   m [  3        P  %   %  E 7   &   
   
    6  u 
  ! % & * + '. 1 6 N@ L U zV ! n } TOWHLP  HLP      TOWHLP  HSH    TOWHLP  PGE                    HLP  HSH  PGE    