/*
** distctrl.h
** This include file contains enumerated data types and constants necessary
** for using Windows messaging control interface with Acrobat Distiller.
** (c) Copyright 1994, Adobe Systems, Inc.  All Rights Reserved.
*/

#define FILENAMESIZE	_MAX_PATH
#define MAXSTRINGSIZE	260					/* 256 + extra for command line */
#define MAXFOLDERS  	100
#define ID_TIMER 		1
#define DM_DISTILL		WM_USER	+ 1
#define DM_DONE			WM_USER + 2

typedef enum {
	EQ_NO_SAVE_DIALOG,
	EQ_DEFAULT_OLD_DEST,
	EQ_DEFAULT_SOURCE
} EnqueueOptions;

typedef struct _DISTILLRECORD {
	HWND		sender;
	char		fileList[MAXSTRINGSIZE];
	char        outputFile[FILENAMESIZE];
} DISTILLRECORD, *LPDISTILLRECORD;
