// cviewdoc.cpp : implementation of the CCviewerDoc class
//
#include <string.h>

#include "stdafx.h"
#include "cviewer.h"

#include "cviewdoc.h"
#include "mainfrm.h"

#include "acrobat.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                
                                
// #defines for View Mode
#define 	ZOOMTYPE_NONAUTO		0
#define		ZOOMTYPE_FITPAGE		1
#define		ZOOMTYPE_FITWIDTH		2

                                
/////////////////////////////////////////////////////////////////////////////
// CCviewerDoc

IMPLEMENT_DYNCREATE(CCviewerDoc, CDocument)

BEGIN_MESSAGE_MAP(CCviewerDoc, CDocument)
	//{{AFX_MSG_MAP(CCviewerDoc)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_FIRSTPAGE, OnUpdateViewFirstpage)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_LASTPAGE, OnUpdateViewLastpage)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_NEXTPAGE, OnUpdateViewNextpage)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_PREVPAGE, OnUpdateViewPrevpage)
	ON_COMMAND(ID_VIEW_FIRSTPAGE, OnViewFirstpage)
	ON_COMMAND(ID_VIEW_LASTPAGE, OnViewLastpage)
	ON_COMMAND(ID_VIEW_NEXTPAGE, OnViewNextpage)
	ON_COMMAND(ID_VIEW_PREVPAGE, OnViewPrevpage)
	ON_COMMAND(ID_VIEW_ACTUALSIZE, OnViewActualsize)
	ON_COMMAND(ID_VIEW_FITPAGE, OnViewFitpage)
	ON_COMMAND(ID_VIEW_FITWIDTH, OnViewFitwidth)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_FITPAGE, OnUpdateViewFitpage)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_FITWIDTH, OnUpdateViewFitwidth)    
//	ON_UPDATE_COMMAND_UI(ID_TOOLS_HAND, OnUpdateTools)
	ON_COMMAND(ID_TOOLS_HAND, OnToolsHand)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CCviewerDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CCviewerDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCviewerDoc construction/destruction
  
CCviewerDoc::CCviewerDoc()
{
	EnableAutomation();

    // initialize pointers to acrobat objects to NULL
	m_pAcroAVDoc = NULL;

	AfxOleLockApp();
}

CCviewerDoc::~CCviewerDoc()
{
    // delete acrobat objects	
	if (m_pAcroAVDoc != NULL) {
		m_pAcroAVDoc->Close(FALSE);
		delete m_pAcroAVDoc;
	}

	AfxOleUnlockApp();
}



// Called when a document is opened
BOOL CCviewerDoc::OnOpenDocument(const char* pszPathName)
{	
	// Create new CAcroAVDoc  
	COleException e;
	m_pAcroAVDoc = new CAcroAVDoc;
	if (!m_pAcroAVDoc->CreateDispatch("AcroExch.AVDoc",&e)) {
		AfxMessageBox("Failed to create AVDoc :<");
		return(FALSE);
	}

	// Open Specified .PDF file
	
	POSITION pos = GetFirstViewPosition();
	CView* pFirstView = GetNextView( pos );
	HWND OurHWND = pFirstView->m_hWnd;

//	BOOL ok = m_pAcroAVDoc->Open(pszPathName, "Printing...");
	BOOL ok = m_pAcroAVDoc->OpenInWindow(pszPathName, (short) OurHWND);
	if (!ok) {
		AfxMessageBox("Error Opening File :<");     	
        return(FALSE);
	}     
	
	// Get # of pages in file
	CAcroPDDoc TempDoc; 
	TempDoc.AttachDispatch(m_pAcroAVDoc->GetPDDoc(),TRUE);
	NumPages = TempDoc.GetNumPages(); 
    
	return(TRUE);
}
// Called by framework to save file
BOOL CCviewerDoc::OnSaveDocument(const char* pszPathName)
{
	// Pass filename through to Acrobat's save function
	CAcroPDDoc TempDoc; 
	TempDoc.AttachDispatch(m_pAcroAVDoc->GetPDDoc(),TRUE);

	return(TempDoc.Save(1,pszPathName));
}


void CCviewerDoc::GotoPage(unsigned long NewPage)
{
	if ((NewPage < NumPages) && (NewPage >= 0)) {
                                
        // Get the AVPageView 
		CAcroAVPageView TempPageView; 
		TempPageView.AttachDispatch(m_pAcroAVDoc->GetAVPageView(),TRUE);

		// switch page
        TempPageView.GoTo(NewPage);
	}                            
}	


void CCviewerDoc::SetScale(int NewScale)
{
	// Set new zoom type and scale in viewer
	SetCurrentZoomType(ZOOMTYPE_NONAUTO, NewScale);
}



unsigned long CCviewerDoc::GetCurrentPageNum()
{
	// Get the AVPageView 
	CAcroAVPageView TempPageView; 
	TempPageView.AttachDispatch(m_pAcroAVDoc->GetAVPageView(),TRUE);
    return(TempPageView.GetPageNum());
}

int CCviewerDoc::GetCurrentZoomType()
{
	// Get the AVPageView 
	CAcroAVPageView TempPageView; 
	TempPageView.AttachDispatch(m_pAcroAVDoc->GetAVPageView(),TRUE);
    return(TempPageView.GetZoomType());
}

void CCviewerDoc::SetCurrentZoomType(int NewType, int NewScale)
{
	// Get the AVPageView 
	CAcroAVPageView TempPageView; 
	TempPageView.AttachDispatch(m_pAcroAVDoc->GetAVPageView(),TRUE);
    
    // Set the zoom type: parameter 2 is ignored by viewer except
    // in case of type being no auto-resizing
    TempPageView.ZoomTo(NewType, NewScale);
}


void CCviewerDoc::CloseAVDoc()
{
	if (m_pAcroAVDoc) {
		m_pAcroAVDoc->Close(TRUE);
		delete m_pAcroAVDoc;
		m_pAcroAVDoc = NULL;
	}
}	

/////////////////////////////////////////////////////////////////////////////
// CCviewerDoc serialization

void CCviewerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCviewerDoc diagnostics

#ifdef _DEBUG
void CCviewerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CCviewerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCviewerDoc commands
 
void CCviewerDoc::OnUpdateViewFirstpage(CCmdUI* pCmdUI)
{
	// Only enable Go to First Page button if not on first page already
	pCmdUI->Enable((BOOL) GetCurrentPageNum() > 0);
}

void CCviewerDoc::OnUpdateViewLastpage(CCmdUI* pCmdUI)
{
	// Only enable Go to Last Page button if not on last page already
	pCmdUI->Enable((BOOL) (GetCurrentPageNum() < (unsigned long) (NumPages-1)));
}

void CCviewerDoc::OnUpdateViewNextpage(CCmdUI* pCmdUI)
{
	// Only enable Go to Next Page button if not on last page already
	pCmdUI->Enable((BOOL) (GetCurrentPageNum() < (unsigned long) (NumPages-1)));	
}

void CCviewerDoc::OnUpdateViewPrevpage(CCmdUI* pCmdUI)
{
	// Only enable Go to Previous Page button if not on first page already
	pCmdUI->Enable((BOOL) GetCurrentPageNum() > 0);	
}

void CCviewerDoc::OnViewFirstpage()
{
	// Go to first page
	GotoPage(0);
}

void CCviewerDoc::OnViewLastpage()
{
	// Go to last page
	GotoPage(NumPages-1);
}

void CCviewerDoc::OnViewNextpage()
{
	// Go to next page
	GotoPage(GetCurrentPageNum()+1);
}
         
void CCviewerDoc::OnViewPrevpage()
{
	// Go to previous page
	GotoPage(GetCurrentPageNum()-1);
}
 

void CCviewerDoc::OnViewActualsize()
{
	// Set zoom type to display actual size
	SetCurrentZoomType(ZOOMTYPE_NONAUTO,100);
}

void CCviewerDoc::OnViewFitpage()
{
	// Set zoom type  to display fit page
	SetCurrentZoomType(ZOOMTYPE_FITPAGE,0);
}

void CCviewerDoc::OnViewFitwidth()
{
	// Set viewmode to display fit width
	SetCurrentZoomType(ZOOMTYPE_FITWIDTH,0);
}


void CCviewerDoc::OnUpdateViewFitpage(CCmdUI* pCmdUI)
{
	// Check fit page option if Viewmode is fit page
	pCmdUI->SetCheck((BOOL) GetCurrentZoomType() == ZOOMTYPE_FITPAGE);	
}

void CCviewerDoc::OnUpdateViewFitwidth(CCmdUI* pCmdUI)
{
	// Check fit width option if Viewmode is fit width
	pCmdUI->SetCheck((BOOL) GetCurrentZoomType() == ZOOMTYPE_FITWIDTH);	
}
                                                               

void CCviewerDoc::OnUpdateTools(CCmdUI* pCmdUI)
{
	// Enable tools whenever a file is open
	pCmdUI->Enable((BOOL) TRUE);
}

void CCviewerDoc::OnToolsHand()
{  
#if 0
	CAcroAVPageView tpV;
	CAcroPDPage pdP;
	CAcroPDTextSelect pdTS;
	CAcroHiliteList hlist;
	LPDISPATCH lpDisp;
	COleException e;
	long i, num;
	CString b;
#endif	
	((CMainFrame *)AfxGetApp()->m_pMainWnd)->GetAcroApp()->SetActiveTool("Hand",TRUE);
#if 0
	tpV.AttachDispatch(m_pAcroAVDoc->GetAVPageView(), TRUE);
	pdP.AttachDispatch(tpV.GetPage());
	// set up new HiliteList
	if (!hlist.CreateDispatch("AcroExch.HiliteList", &e)) {
		AfxMessageBox("Failed to create HiliteList");
		return;
	}
	hlist.Add(1,0);
	lpDisp = pdP.CreateWordHilite(hlist.m_lpDispatch);
	pdTS.AttachDispatch(lpDisp);
//	m_pAcroAVDoc->SetTextSelection(pdTS.m_lpDispatch);
//	m_pAcroAVDoc->ShowTextSelect();
	num = pdTS.GetNumText();
	for (i=0;i<(1+num);i++) {
		b = pdTS.GetText(i);
	}	
#endif
}
  