
#include <windows.h>    
#include <commdlg.h>
#include <memory.h>
#include "..\acroauto.h"

BOOL OpenTheFile(LPCSTR szFileName);

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;            
HANDLE hPrevInstance;        
char *lpCmdLine;             
int nCmdShow;
{
	BOOL rval;

	OPENFILENAME ofn;
	char szDirName[256];
	char szFile[256], szFileTitle[256];
	UINT  i, cbString;
	char  chReplace;    /* string separator for szFilter */
	const char*  szFilter0 = "Acrobat (*.pdf)|*.pdf|All Files (*.*)|*.*|";
	char szFilter[256];
	
	/* copy the filter string so that we can change it */
	lstrcpy(szFilter,szFilter0); 
	
	/* Get the system directory name, and store in szDirName */
	
	GetSystemDirectory(szDirName, sizeof(szDirName));
	szFile[0] = '\0';

	cbString = lstrlen(szFilter);	
	chReplace = szFilter[cbString - 1]; /* retrieve wildcard */
	
	for (i = 0; szFilter[i] != '\0'; i++) {
	    if (szFilter[i] == chReplace)
	       szFilter[i] = '\0';
	}
	
	/* Set all structure members to zero. */
	
	memset(&ofn, 0, sizeof(OPENFILENAME));
	
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile= szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = szDirName;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	
	
	if (!GetOpenFileName(&ofn)) {
		return FALSE;
	}
	
	rval = OpenTheFile(ofn.lpstrFile);

	return rval;
}


BOOL OpenTheFile(LPCSTR szFileName)                
{
	HACROAUTO hAcroAuto;
	HACROAPP hAcroApp; 
	HACROAVDOC hAcroAVDoc;
	BOOL rval;

	// For Ole 2.0 programs, it is recommended that the line
	// SetMessageQueue(96) be places in you WinMain or InitInstance
	// code.  This line will clear the current message queue, so do it early
	SetMessageQueue(96);
	hAcroAuto = AcroAutoInitialize();
	if (!hAcroAuto) return FALSE;     
	hAcroApp = AcroAppNew();
	if (!hAcroApp) {
		rval = FALSE; 
		goto error;
	}

	AcroAppShow(hAcroApp);
		
	hAcroAVDoc = AcroAVDocNew();
	if (!hAcroAVDoc) {
		rval = FALSE;
		goto error1;
	}

	rval = AcroAVDocOpen(hAcroAVDoc,szFileName,"");

	AcroAVDocDelete(hAcroAVDoc);	
error1:
	AcroAppDelete(hAcroApp);
error:
	AcroAutoUninitialize(hAcroAuto);
	return rval;
	
} 
