; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
; Revs.:  MJP 3/8/88, DCY 12/13/88
;
; If DoWait is calling your procedures at the improper time (or is not calling
; them at all), include a call to TKDebug at the beginning of each erroneously
; activated procedure.  TKDebug will attempt to determine the cause of the
; problem.
;
; Erroneous activation of a procedure most often occurs because a custom
; procedure fails to alert DoWait of explicit movement out of the current
; field.  (Inform DoWait by calling either NewField, ArriveField,
; ArriveRecord, NewTable, or ArriveTable.)
;
; Once you have completed and tested your application, remember to remove
; calls to TKDebug from your procedures.  The PrepareFinal/Extract subsystem
; of TKMenu will do this for you automatically.
;
; NOTE:  InitWait DOES NOT load TKDebug from the Toolkit library (in a
;        completed application, you should have no need for it), you need
;        to do so yourself.
;
Proc TKDebug()
   Private TKErrMsg,
           CTable,
           CForm,
           X

   TKErrMsg = ""
   X = Match(TKDPASet[ImageNo()],"TK.._..",CTable,CForm)

   If Search(CTable,Table()) = 0
      Then TKErrMsg = "ArriveTable() not called upon arrival into "+Table()+
                      " table from "+CTable+" table"
   Endif

   If Form() <> CForm and TKErrMsg = ""
      Then TKErrMsg = "Expecting to be within Form "+CForm+" of "+CTable+
                      " table"
   Endif

   If NFields(Table()) <> ArraySize(TKAction) and TKErrMsg = ""
      Then TKErrMsg = "DPA set for "+CTable+" table is out of date"
   Endif

   If ColNo() <> TKFieldNum and TKErrMsg = ""
      Then TKErrMsg = "Unexpected departure form field # "+TKFieldNum
   Endif

   If TKErrMsg <> ""
      Then Message "DoWait Error: ",TKErrMsg
           Debug
   Endif
Endproc
