; Copyright (c) 1987, 1988 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  MJP 2/29/88, DCY 12/12/88
; ****************************************************************************
; GetPassword accepts an alphanumeric string from a user but allows you to
; specify which characters (if any) to display on the screen as a user types.
;
; Note that GetPassword requires a user to enter a value or press [Esc].  If
; the user presses [Esc], GetPassword returns a null ("") string.  Otherwise
; it returns the string a user entered.
;
; GetPassword requires two arguments:
; 
;      MaxLen: Maximum length of string to accept
;    EchoChar: Character(s) to be displayed upon each keystroke
;
; NOTE: GetPassword accepts a string at the current canvas cursor position.
;       Since it does not support wrap-around, make sure the string you
;       request from a user will fit entirely on the current line.
;
Proc GetPassword(MaxLen,EchoChar)
   Private;MaxLen,       ;Maximum acceptable string length
          ;EchoChar,     ;Character(s) to display upon each keystroke
           Pass,         ;Current string as entered by user
           Char          ;Last keystroke entered

   Pass = ""
   Char = GetChar()
   While (Char <> 13 or IsBlank(Pass)) and Char <> 27 ;Accept until ENTER or ESC
      Switch
         Case Char = 127 :            ;CtrlBackspace
            @ Row(),Col()-Len(Pass)*Len(EchoChar)
            ?? Spaces(Len(Pass)*Len(EchoChar))
            @ Row(),Col()-Len(Pass)*Len(EchoChar)
            Pass = ""
         Case Char > 31 and Len(Pass) < MaxLen :   ;Acceptable character
            ?? EchoChar
            Pass = Pass+Chr(Char)
         Case Char = 8 and Match(Pass,"..@",Pass) :   ;Backspace
            @ Row(),Col()-Len(EchoChar)
            ?? Spaces(Len(EchoChar))
            @ Row(),Col()-Len(EchoChar)
         Case Char = 13 :
            Message "Please enter a password"
         Otherwise :                                ;Illegal character
            Beep
      Endswitch
      Char = GetChar()
   Endwhile

   If Char = 27
      Then Return ""
      Else Return Pass
   Endif

Endproc
