/*----------------------------------------------------------------------
   sqlsys.h - RDS SQL extension module and user-defined function header

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef SQLSYS_H
#define SQLSYS_H

#ifdef __cplusplus
extern "C" {
#endif

typedef void * HMOD;
typedef void * HSYS;

typedef void (REXTERNAL *MODINIT_FCNPTR) (HMOD);
typedef void (REXTERNAL *MODCLEANUP_FCNPTR) (HMOD);

typedef void (REXTERNAL  TRANSACTTRIGGER) (short, char *, char *, void *);
typedef void (REXTERNAL *PTRANSACTTRIGGER) (short, char *, char *, void *);

/* arguments for SQLTransactTrigger() */
#define SYS_COMMIT_EVERY 0
#define SYS_COMMIT_ONCE  1

#define SYS_REMOVE      -1
#define SYS_COMMIT       SQL_COMMIT
#define SYS_ROLLBACK     SQL_ROLLBACK


/* user defined function proto-types */
typedef short (REXTERNAL UDFCHECK)   (HSYS, short, const VALUE*, VALUE *, short *);
typedef short (REXTERNAL UDFFUNC)    (HSYS, void **, short, const VALUE*, VALUE*);
typedef short (REXTERNAL UDFINIT)    (HSYS, void **);
typedef void  (REXTERNAL UDFCLEANUP) (HSYS, void **);
typedef short (REXTERNAL UDFRESET)   (HSYS, void **);

typedef short (REXTERNAL *PUDFCHECK)   (HSYS, short, const VALUE*, VALUE *, short *);
typedef short (REXTERNAL *PUDFFUNC)    (HSYS, void **, short, const VALUE*, VALUE*);
typedef short (REXTERNAL *PUDFINIT)    (HSYS, void **);
typedef void  (REXTERNAL *PUDFCLEANUP) (HSYS, void **);
typedef short (REXTERNAL *PUDFRESET)   (HSYS, void **);

typedef struct udfloadtable {
    char         udfName[33];    /* name of user function */
    PUDFFUNC     udfCall;        /* address of user function */
    PUDFCHECK    udfCheck;       /* type checking call */
    PUDFINIT     udfInit;        /* initilization for user function */
    PUDFCLEANUP  udfCleanup;     /* cleanup for user function */
    PUDFRESET    udfReset;       /* reset for user function */
} UDFLOADTABLE,*PUDFLOADTABLE;

void REXTERNAL udfDescribeFcns (unsigned short *, PUDFLOADTABLE *, char **);

typedef void (REXTERNAL *UDFDESC_FCNPTR) (unsigned short *, PUDFLOADTABLE *, char **);
typedef void (REXTERNAL UDFDESC_FCN) (unsigned short *, PUDFLOADTABLE *, char **);


/* user defined procedures proto-types */

typedef short (REXTERNAL UDPCHECK)         (short, const short*, VALUE *);
typedef short (REXTERNAL UDPEXECUTE)       (void **, short, VALUE*, short, HSTMT *, VALUE *);
typedef short (REXTERNAL UDPMORERESULTS)   (void **, short, VALUE*, short, HSTMT *, VALUE *);
typedef short (REXTERNAL UDPINIT)          (void **, short, VALUE*, RDM_SESS, short, VALUE *);
typedef void  (REXTERNAL UDPCLEANUP)       (void **, short);

typedef short (REXTERNAL *PUDPCHECK)       (short, const short*, VALUE *);
typedef short (REXTERNAL *PUDPEXECUTE)     (void **, short, VALUE*, short, HSTMT *, VALUE *);
typedef short (REXTERNAL *PUDPMORERESULTS) (void **, short, VALUE*, short, HSTMT *, VALUE *);
typedef short (REXTERNAL *PUDPINIT)        (void **, short, VALUE*, RDM_SESS, short, VALUE *);
typedef void  (REXTERNAL *PUDPCLEANUP)     (void **, short);

typedef struct udploadtable {
    char            udpName[33];      /* name of user procedure */
    PUDPCHECK       udpCheck;         /* type checking */
    PUDPEXECUTE     udpExecute;       /* execute first result set */
    PUDPMORERESULTS udpMoreResults;   /* move to next result set */
    PUDPINIT        udpInit;          /* initilization for user procedure */
    PUDPCLEANUP     udpCleanup;       /* cleanup for user procedure */
} UDPLOADTABLE,*PUDPLOADTABLE;

void REXTERNAL udpDescribeFcns (unsigned short *, PUDPLOADTABLE *, char **);

typedef void (REXTERNAL *UDPDESC_FCNPTR) (unsigned short *, PUDPLOADTABLE *, char **);
typedef void (REXTERNAL UDPDESC_FCN) (unsigned short *, PUDPLOADTABLE *, char **);

/* user defined import/export filter proto-types */

#define SQL_IMPORT 0
#define SQL_EXPORT 1

typedef short (REXTERNAL IEFCHECK)   (HSYS, short, VALUE *, VALUE *);
typedef short (REXTERNAL IEFFETCH)   (HSYS, void **, short, VALUE*, VALUE *);
typedef short (REXTERNAL IEFSTORE)   (HSYS, void **, short, VALUE*, VALUE *);
typedef short (REXTERNAL IEFINIT)    (HSYS, void **, short, short, VALUE *, short *, VALUE_DESCR **, VALUE *);
typedef void  (REXTERNAL IEFCLEANUP) (HSYS, void **);

typedef short (REXTERNAL *PIEFCHECK)   (HSYS, short, VALUE *, VALUE *);
typedef short (REXTERNAL *PIEFFETCH)   (HSYS, void **, short, VALUE*, VALUE *);
typedef short (REXTERNAL *PIEFSTORE)   (HSYS, void **, short, VALUE*, VALUE *);
typedef short (REXTERNAL *PIEFINIT)    (HSYS, void **, short, short, VALUE *, short *, VALUE_DESCR **, VALUE *);
typedef void  (REXTERNAL *PIEFCLEANUP) (HSYS, void **);

typedef struct iefloadtable {
    char        iefName[33];    /* name of import/export filter */
    PIEFFETCH   iefFetch;       /* import filter fetch call */
    PIEFSTORE   iefStore;       /* export filter store call */
    PIEFCHECK   iefCheck;       /* type checking call for filters */
    PIEFINIT    iefInit;        /* init call for both import/export filters */
    PIEFCLEANUP iefCleanup;     /* cleanup call for filters */
} IEFLOADTABLE, *PIEFLOADTABLE;


void REXTERNAL iefDescribeFcns (unsigned short *, PIEFLOADTABLE *, char **);

typedef void (REXTERNAL *IEFDESC_FCNPTR) (unsigned short *, PIEFLOADTABLE *, char **);
typedef void (REXTERNAL IEFDESC_FCN) (unsigned short *, PIEFLOADTABLE *, char **);


/* ======================================================================
    Retrieve a system defined memory tag for user-defined functions
*/
short REXTERNAL SYSMemoryTag(
    HSYS     hSys,
    short   *pudftag)
;

/* ======================================================================
    Retrieve the RDM_DB handle for a specified database
*/
short REXTERNAL SYSDBHandle(
    HSYS     hSys,
    char    *dbname,
    RDM_DB  *phDb)
;
/* ======================================================================
    Convert an RDM DB_ADDR to an SQL_DBADDR (RowId)
*/
short REXTERNAL SYSDbaToRowId(
    HSYS     hSys,
    char    *tblname,
    DB_ADDR  dba,
    long    *lv)
;
/* ======================================================================
    Convert an SQL_DBADDR for a table to an RDM DB_ADDR
*/
short REXTERNAL SYSRowIdToDba(
    HSYS     hSys,
    char    *tblname,
    long     rowid,
    DB_ADDR *dbap)
;
/* ======================================================================
    Get the DB_ADDR for the current row of the specified table
*/
short REXTERNAL SYSRowDba(
    HSYS     hSys,
    char    *tblname,
    DB_ADDR *dbap)
;
/* ======================================================================
    Get the RowId (SQL_DBADDR) for the current row of the specified table
*/
short REXTERNAL SYSRowId(
    HSYS   hSys,
    char  *tblname,
    long  *pRowid)
;
/* ======================================================================
    Get the RDM_SESS (SessionId) associated with a HSYS
*/
short REXTERNAL SYSSessionId(
    HSYS      hSys,
    RDM_SESS *hSess)
;
/* ======================================================================
    Get the statement type associated with a HSYS
*/
short REXTERNAL SYSDescribeStmt(
    HSYS   hSys,
    short *pStype)
;
/* ======================================================================
    Convert a VALUE entry
*/
short REXTERNAL SYSValConvert(
    HSYS      hSys,
    short     rtype,
    VALUE    *lv)
;
/* ======================================================================
    Change the sign of a VALUE
*/
short REXTERNAL SYSValChgSign(
    HSYS         hSys,
    VALUE       *lv)
;
/* ======================================================================
    Compare 2 VALUEs
*/
short REXTERNAL SYSValCompare(
    HSYS         hSys,
    const VALUE *lv,
    const VALUE *rv)
;
/* ======================================================================
    Add 2 VALUEs
*/
short REXTERNAL SYSValAdd(
    HSYS         hSys,
    const VALUE *lv,
    const VALUE *rv,
    VALUE       *result)
;
/* ======================================================================
    Subtract 2 VALUEs
*/
short REXTERNAL SYSValSub(
    HSYS         hSys,
    const VALUE *lv,
    const VALUE *rv,
    VALUE       *result)
;
/* ======================================================================
    Multiply 2 VALUEs
*/
short REXTERNAL SYSValMult(
    HSYS         hSys,
    const VALUE *lv,
    const VALUE *rv,
    VALUE       *result)
;
/* ======================================================================
    Divide 2 VALUEs
*/
short REXTERNAL SYSValDiv(
    HSYS         hSys,
    const VALUE *lv,
    const VALUE *rv,
    VALUE       *result)
;
/* ======================================================================
    Register a Transaction Trigger
*/
short REXTERNAL SQLTransactTrigger(
    HMOD              hMod,
    RDM_SESS          hSess,
    char             *name,
    PTRANSACTTRIGGER  Trigger,
    void             *ptr,
    short             mode)
;
#ifdef __cplusplus
}
#endif

#endif /* SQLSYS_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/SQLSYS.H_V   1.17   25 Aug 1994 09:45:12   BRADB  $
*/
