/*===========================================================================
    sqldefs.h - SAG/ODBC-core standard constant and type definitions.

    Used on both client and server side.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQLDEFS_H
#define SQLDEFS_H

#include "rdsbasic.h"

#ifdef __cplusplus
extern "C" {
#endif

/* SQL data types for C */
typedef char           SCHAR;
typedef unsigned char  TEXT;
typedef short          SWORD;
typedef unsigned short UWORD;
typedef long           SDWORD;
typedef unsigned long  UDWORD;
typedef double         SDOUBLE;
#ifndef AIX
typedef long double    LDOUBLE;
#else
typedef double         LDOUBLE;
#endif
typedef float          SFLOAT;
typedef void RFAR  *   PTR;
typedef void RFAR  *   HENV;
typedef void RFAR  *   HDBC;
typedef void RFAR  *   HSTMT;
typedef short          RETCODE;

/* already defined in os2.h */
#ifndef OS2DEF_INCLUDED
typedef unsigned char  UCHAR;
typedef int          BOOL;
#endif

/* HELP RichM -- this isn't quite right -- we really want to do this for ALL
   compilations here, and DEBUG isn't good enough (since QA doesn't set it).
   Note that the DEFINE_UCHAR_AS_CHAR is for the benefit of clients who might
   want it....
*/
#if defined(DEBUG) || defined(DEFINE_UCHAR_AS_CHAR)
#define UCHAR char
#endif

#define RSQL_ODBC_VER       "01.00.0000"
#define RSQL_ODBC_COMPAT    "01.00.0000"

/* function return codes */
#define SQL_INVALID_HANDLE       (-2)
#define SQL_ERROR                (-1)
#define SQL_SUCCESS               0
#define SQL_SUCCESS_WITH_INFO     1
#define SQL_STILL_EXECUTING       2
#define SQL_NEED_DATA            99
#define SQL_NO_DATA_FOUND       100

/* SQL function control codes */
#define SQL_CLOSE           0       /* SQLFreeStmt close */
#define SQL_DROP            1       /* SQLFreeStmt drop */
#define SQL_UNBIND          2       /* SQLFreeStmt unbind */
#define SQL_RESET_PARAMS    3       /* SQLFreeStmt reset params */
#define SQL_DROP_NOCLOSE    4       /* SQLFreeStmt drop (internal use only) */

#define SQL_COMMIT          0       /* SQLTransact commit */
#define SQL_ROLLBACK        1       /* SQLTransact rollback */

/* standard SQL data types */
#define SQL_CHAR             1
#define SQL_NUMERIC          2
#define SQL_DECIMAL          3
#define SQL_INTEGER          4
#define SQL_SMALLINT         5
#define SQL_FLOAT            6
#define SQL_REAL             7
#define SQL_DOUBLE           8
#define SQL_VARCHAR         12

#define SQL_TYPE_MIN         1
#define SQL_TYPE_MAX        12
#define SQL_TYPE_NULL       0

#define SQL_MAX_MESSAGE_LENGTH 512

/* C data type to SQL data type mapping */
#define SQL_C_CHAR          SQL_CHAR
#define SQL_C_TEXT          SQL_CHAR
#define SQL_C_LONG          SQL_INTEGER
#define SQL_C_SHORT         SQL_SMALLINT
#define SQL_C_FLOAT         SQL_REAL
#define SQL_C_DOUBLE        SQL_DOUBLE
#define SQL_C_NUMTEXT       SQL_DECIMAL
#define SQL_C_DEFAULT       99

/* null status codes */
#define SQL_NO_NULLS            0
#define SQL_NULLABLE            1
#define SQL_NULLABLE_UNKNOWN    2

/* special length code */
#define SQL_NULL_DATA       (-1)
#define SQL_DATA_AT_EXEC    (-2)
#define SQL_NTS             (-3)      /* null terminated string indicator */

/* SQLError null handles */
#define SQL_NULL_HENV       NULL
#define SQL_NULL_HSTMT      NULL
#define SQL_NULL_HDBC       NULL

/* SQLColAttributes() defines */
#define SQL_COLUMN_COUNT            0
#define SQL_COLUMN_NAME             1
#define SQL_COLUMN_TYPE             2
#define SQL_COLUMN_LENGTH           3
#define SQL_COLUMN_PRECISION        4
#define SQL_COLUMN_SCALE            5
#define SQL_COLUMN_DISPLAY_SIZE     6
#define SQL_COLUMN_NULLABLE         7
#define SQL_COLUMN_UNSIGNED         8
#define SQL_COLUMN_MONEY            9
#define SQL_COLUMN_UPDATABLE        10
#define SQL_COLUMN_AUTO_INCREMENT   11
#define SQL_COLUMN_CASE_SENSITIVE   12
#define SQL_COLUMN_SEARCHABLE       13
#define SQL_COLUMN_TYPE_NAME        14

/* SQLColAttributes() defines for SQL_COLUMN_UPDATABLE */
#define SQL_ATTR_READONLY           0
#define SQL_ATTR_WRITE              1
#define SQL_ATTR_READWRITE_UNKNOWN  2

/* SQLColAttributes() defines for SQL_COLUMN_SEARCHABLE and SQLGetInfo() */
#define SQL_UNSEARCHABLE            0
#define SQL_LIKE_ONLY               1
#define SQL_ALL_EXCEPT_LIKE         2
#define SQL_SEARCHABLE              3

#ifdef __cplusplus
}
#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/SQLDEFS.H_V   1.31   18 Apr 1994 12:11:56   RICHM  $
*/
#endif
