#ifndef RSQLBCD_H
#define RSQLBCD_H

/**********************************************************************/
/*
    bcd.h  -      RSQL system binary-coded-decimal function header.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
*/
/**********************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define BCD_LESS        0
#define BCD_LESSEQ      1
#define BCD_EQ          2
#define BCD_GREATER     3
#define BCD_GREATEREQ   4

#define BCD_PACKED      0
#define BCD_NORMALIZED  1

#define MINPREC      1      /* Min digits in a bcd number             */
#define BCDBYTES     33     /* Max allowed storage space in database. */

#define MINDIGITS      32   /* Normalized BCDS have mininum scale and precision  */
#define WORKINGSPACE   45   /* Extra space for converting strings with exponents */
#define WORKINGBUFFER   5   /* Extra buffer space for overflow/underflow         */

extern short BCDDLen;

typedef struct decimal_s {
   short         Format;    /* 0 = packed bcd, 1 = Normalized                                         */
   short         LDigits;   /* Actual # of digits left of decimal.                                    */
   short         RDigits;   /* Actual # of digits right of decimal.                                   */
   short         prec;      /* Precision: 1 <= p <= 64                                                */
   short         scale;     /* Scale:     0 <= s <= p                                                 */
   char          flags;     /*            bit 0,  0 = overflow, 1 = overflow occured                  */
                            /*            bit 1,  0 = precision lost, 1 = truncation occured          */
   char         *val;       /* copy input decimals here. Must be allocated by caller                  */
   char         *buf;       /* Temporary buffers, for internal use only. Must be allocated by caller  */
   char         *buf2;      /* Temporary buffers, for divide only, only allocate for result struct    */
} DECIMAL_STRUCT;           /* Decimal:   bit 0 = sign, 0 = neg, 1 = pos.                             */
                            /*            bit 4  - 7,  digit 1                                        */
                            /*            bit 8  - 11, digit 2                                        */
                            /*            bit 12 - 15, digit 3                                        */
                            /*            ...                                                         */

char RFAR * REXTERNAL v_dtoa(double v, char RFAR *r);

short REXTERNAL BCD_Digits(short MaxL, short MaxR, short RFAR *Len);

short REXTERNAL BCD_Add(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Sub(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Mult(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Div(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Add_Norm(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Sub_Norm(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Mult_Norm(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Div_Norm(DECIMAL_STRUCT RFAR *v1, DECIMAL_STRUCT RFAR *v2, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Cmp_Norm(DECIMAL_STRUCT RFAR *v1, short op, DECIMAL_STRUCT RFAR *v2);

short REXTERNAL BCD_Cmp(DECIMAL_STRUCT RFAR *v1, short op, DECIMAL_STRUCT RFAR *v2);

short REXTERNAL BCD_EqZero(DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_to_BCD(DECIMAL_STRUCT RFAR *v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_to_Char(DECIMAL_STRUCT RFAR *v, char RFAR *r, short len);

short REXTERNAL BCD_to_Short(DECIMAL_STRUCT RFAR *v, short RFAR *r);

short REXTERNAL BCD_to_Long(DECIMAL_STRUCT RFAR *v, long RFAR *r);

short REXTERNAL BCD_to_Float(DECIMAL_STRUCT RFAR *v, float RFAR *r);

short REXTERNAL BCD_to_Double(DECIMAL_STRUCT RFAR *v, double RFAR *r);

short REXTERNAL Char_to_BCD(char RFAR *v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL Short_to_BCD(short v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL Long_to_BCD(long v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL Float_to_BCD(float v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL Double_to_BCD(double v, DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_ChgSign(DECIMAL_STRUCT RFAR *r);

short REXTERNAL BCD_Sign(DECIMAL_STRUCT RFAR *v);

short REXTERNAL BCD_OverFlow(DECIMAL_STRUCT RFAR *v);

short REXTERNAL BCD_PrecLoss(DECIMAL_STRUCT RFAR *v);

void  REXTERNAL BCD_Normalize(DECIMAL_STRUCT *r);

short REXTERNAL BCD_UnNormalize(DECIMAL_STRUCT *r);

#ifdef __cplusplus
}
#endif

#endif
/**********************************************************************/
/*
$Header:   P:/PAT/INCLUDE/VCS/RSQLBCD.H_V   1.6   18 Apr 1994 12:11:38   RICHM  $
*/
/**********************************************************************/
