/*----------------------------------------------------------------------
   rpcproto.h - Velocis Client Remote Procedure Calls.

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RPCPROTO_H
#define RPCPROTO_H

#ifdef __cplusplus
extern "C" {
#endif

#include "dpldata.h"

typedef struct {
    short (REXTERNAL *envFcn)(PDPLDATADESC, PDPLDATADESC);
    short envFcnID;
} RPCLOADTABLE, RFAR *PRPCLOADTABLE;

typedef short (REXTERNAL INIT_FCN)      (RDM_SESS);
typedef short (REXTERNAL CLEAN_FCN)     (RDM_SESS);
typedef void (REXTERNAL MODDESC_FCN)
    (short, unsigned short RFAR *, PRPCLOADTABLE RFAR *, char RFAR * RFAR *);

typedef short (REXTERNAL *INIT_FCNPTR)      (RDM_SESS);
typedef short (REXTERNAL *CLEAN_FCNPTR)     (RDM_SESS);
typedef void (REXTERNAL *MODDESC_FCNPTR)
    (short, unsigned short RFAR *, PRPCLOADTABLE RFAR *, char RFAR * RFAR *);

void REXTERNAL ModDescribeFcns (short, unsigned short RFAR *,
    PRPCLOADTABLE RFAR *, char RFAR * RFAR *);
short REXTERNAL ModInit (RDM_SESS);
short REXTERNAL ModCleanup (RDM_SESS);

typedef struct RPCBINDLIST_ {
    unsigned short usInitAlloc;      /* Initial and future allocations */
    unsigned short usNumItems;       /* Number of Bind Items in the List */
    unsigned short usMaxItems;       /* Max Bind Item */
    unsigned short usStructLvl;      /* Current Structure Nesting Level */
    PDPLDATAITEM pBindItems;
} RPCBINDLIST, RFAR *PRPCBINDLIST;

PDPLDATADESC REXTERNAL dpl_makeDataDesc(unsigned short, void RFAR *,
    unsigned short);
void REXTERNAL rpc_freeParmList(PDPLDATADESC);
void REXTERNAL rpc_freeBindList(PRPCBINDLIST);
short REXTERNAL rpc_putParm(PDPLDATADESC, unsigned short, void RFAR *,
    unsigned short);
short REXTERNAL rpc_putStructParm(PDPLDATADESC, PDPLDATAITEM, void RFAR *);
short REXTERNAL rpc_getNumParms(PDPLDATADESC, unsigned short *);
short REXTERNAL rpc_getParm(PDPLDATADESC, void RFAR *, PDPLDATAITEM RFAR *);
void REXTERNAL rpc_initParmList(PDPLDATADESC);
PRPCBINDLIST REXTERNAL rpc_allocBindList(unsigned short);
short REXTERNAL rpc_bindParm(PRPCBINDLIST, unsigned short ,void RFAR *,
    unsigned short);
short REXTERNAL rpc_putBoundParms(PRPCBINDLIST, PDPLDATADESC);
short REXTERNAL rpc_getBoundParms(PRPCBINDLIST, PDPLDATADESC);
short REXTERNAL rpc_peekNextParm(PDPLDATADESC, PDPLDATAITEM RFAR *,
    unsigned short RFAR *, unsigned char RFAR *, unsigned short RFAR *,
    unsigned short RFAR *);

#define rpc_allocParmList(a) dpl_makeDataDesc(a+2, NULL, 0)

short REXTERNAL rpc_emLoad(
    char RFAR *emname,
    short RFAR *hSvc,
    RDM_SESS hSess
);
short REXTERNAL rpc_emUnload(
    short hSvc,
    RDM_SESS hSess
);
short REXTERNAL rpc_emAttach(
    char RFAR *emname,
    short RFAR *hSvc,
    RDM_SESS hSess
);
short REXTERNAL rpc_emGetHandle(
    char RFAR *emname,
    short RFAR *hSvc,
    RDM_SESS hSessw
);
short REXTERNAL rpc_emDetach(
    short hSvc,
    RDM_SESS hSess
);
short REXTERNAL rpc_emCall(
    short hSvc,
    short fcnID,
    PDPLDATADESC inParms,
    PDPLDATADESC RFAR *outParms,
    short RFAR *retCode,
    RDM_SESS hSess
);

short REXTERNAL rpc_emPriorityCall(
    short hSvc,
    short fcnID,
    PDPLDATADESC inParms,
    PDPLDATADESC RFAR *outParms,
    short RFAR *retCode,
    RDM_SESS hSess
);

short REXTERNAL rpc_getRemSysType(
    RDM_SESS RDSSessId,            /* RDS Session Id  */
    short RFAR *psRemSysType
);

RDM_SESS REXTERNAL rpc_remoteSess(
    RDM_SESS hSess
);

RDM_DB REXTERNAL rpc_remoteDb(
    RDM_DB hDb
);

short REXTERNAL rpc_svcHandle(
    const char RFAR *emName
);

short REXTERNAL rpc_svcCreate(
    char RFAR *emName,
    char RFAR *emPath,
    char RFAR * RFAR *loadStr,
    short RFAR *hSvc,
    unsigned short RFAR *pusNumFcns,
    void RFAR * RFAR *ppFcnTable
);

short REXTERNAL rpc_svcDelete(
    short hSvc
);

short REXTERNAL rpc_svcAttach(
    RDM_SESS hSess,
    short hSvc
);

short REXTERNAL rpc_svcDetach(
    RDM_SESS hSess,
    short hSvc
);

short REXTERNAL rpc_svcIsAttached(
    RDM_SESS hSess,
    short hSvc
);

void REXTERNAL rpc_taskCreate(
    char RFAR *uname,
    RDM_SESS hSess
);

short REXTERNAL rpc_taskCount(
    void
);

void RFAR * RFAR * REXTERNAL rpc_taskGetContext(
    RDM_SESS hSess,
    short hSvc
);
void REXTERNAL rpc_taskSetPriv(
    char priv,
    RDM_SESS hSess
);

char REXTERNAL rpc_taskGetPriv(
    RDM_SESS hSess
);

char RFAR *REXTERNAL rpc_taskUserName(
    RDM_SESS hSess
);

void REXTERNAL rpc_taskDelete(
    RDM_SESS hSess
);

void REXTERNAL rpc_taskDelContext(
    RDM_SESS hSess,
    short hSvc
);

char RFAR *REXTERNAL rpc_getUserName(
    RDM_SESS hSess 
);

char RFAR *REXTERNAL rpc_getServerName(
    void
);

#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/RPCPROTO.H_V   1.25   11 Nov 1994 08:30:50   BRADB  $
*/
