/*----------------------------------------------------------------------
   rollfor.h

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#define C_BADCHGLOG (-2500)
#define C_OPENERR   (-2501)
#define TOTINC 500
#define REDO_INC 100
#define IGN_INC 50


typedef struct {
    char dbname[DBASENAMELEN];   /* name of database     */
    RDM_DB hdb;                  /* dbase handle         */
    unsigned short dbid;         /* catalog dbase number */
    char createchg[8];           /* createchg            */
    unsigned long createofs;     /* createofs            */
} DBASEINF;


typedef struct {
    char grpname[8];
    char curchg[8];
    unsigned long curofs;
    char endchg[8];              /* ending change log         */
    unsigned long endofs;        /* ending offset             */
    struct ign_region *ign_ptr;  /* pointer to ignore records */
    short totdbs;                /* total dbaseinf records    */
    short totign;                /* total ignore records      */
    DBASEINF *dbase_rec;         /* pointer to dbaseinfs      */
    RDM_SESS hSess;              /* Rdm Session               */
} FAMILYINF;

typedef struct {
    unsigned short transid;
    unsigned long lowAddr;
    unsigned long highAddr;
} IGNUNDOREGION;

typedef struct {
    unsigned short transid;
    unsigned long lowAddr;
    unsigned long highAddr;
    unsigned char inFamily;
} REDOLIST;

short Comp_cycle(
    char *curchg,
    unsigned long curofs,
    char *endchg,
    unsigned long endofs
);

void IncCycle(
    char *cycle
);

short RollInit(
    char *grpname,
    FAMILYINF *family_rec,
    unsigned long savesetid,
    RDM_SESS hSess
);

short ProcChangeLog(
    FAMILYINF *family_rec,
    char *local_path,
    char **pfile_name
);

/*
$Header:   P:/PAT/INCLUDE/VCS/ROLLFOR.H_V   1.8   16 Aug 1994 08:17:12   BRADB  $
*/

