/*----------------------------------------------------------------------
    rmcomp.h - Velocis resource manager prototypes.

    This file contains function prototypes from the Resource Manager which
    may be used by client applications.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RMCOMP_H
#define RMCOMP_H

#ifndef NO_NESTED_H
#include <stddef.h>
#include "rdsbasic.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Extended file attributes */
#define RM_EXIT_ON_FAIL	    0x01
#define RM_RELATIVE_SEEK    0x02
#define RM_NOGROW           0x04
#define RM_FPRINTF          0x08
#define RM_EXCLUSIVE        0x10
#define RM_DIRECTIO         0x20
#define RM_STICKY           0x40
#define RM_LAZY             0x80

void RFAR *REXTERNAL rm_getMemory(
    size_t size,
    short tag
);

void RFAR *REXTERNAL rm_cGetMemory(
    size_t size,
    short tag
);

void RFAR *REXTERNAL rm_extendMemory(
     void RFAR *memblock,
     size_t newsize,
     short tag
);

void RFAR * REXTERNAL rm_growMemory(
    void RFAR *ptr,
    size_t newsize,
    short tag
);

void REXTERNAL rm_freeMemory(
    void RFAR *ptr,
    short tag
);

char RFAR *REXTERNAL rm_Strdup(
    const char RFAR *cp,
    short tag
);

void REXTERNAL rm_zFreeMemory(
    void RFAR * ptr,
    short tag
);

/* File handling functions */

#ifdef UNIX
#define O_TEXT 0
#define O_BINARY 0
#endif

short REXTERNAL rm_fileOpen(
    char *fn,
    unsigned int flags,
    short xflags,
    unsigned long creLen,
    unsigned long extLen
);

void REXTERNAL rm_fileClose(
    short handle
);

long REXTERNAL rm_fileSeek(
    short handle,
    unsigned long addr
);

unsigned int REXTERNAL rm_fileRead(
    short handle,
    void *buf,
    unsigned int length
);

unsigned int REXTERNAL rm_fileWrite(
    short handle,
    void *buf,
    unsigned int length
);

int REXTERNAL rm_fileValidate(
    char *pszFileName
);

typedef void * RMF_STREAM;
RMF_STREAM REXTERNAL rm_fileStreamOpen(
    char *fname,
    char *mode
);

void REXTERNAL rm_fileStreamClose(
    RMF_STREAM rmf
);

char * REXTERNAL rm_fileStreamGets(
    RMF_STREAM rmf,
    char *buf,
    int len
);

int REXTERNAL rm_fileStreamPuts(
    RMF_STREAM rmf,
    char *buf
);

char * REXTERNAL rm_fileStreamGetLine(
    RMF_STREAM rmf,
    char **buf,
    size_t *len
);

void REXTERNAL rm_putLocalEnv(
    char *cp
);

char * REXTERNAL rm_getLocalEnv(
    char *cp
);

char * REXTERNAL rm_getenv(
    char *cp
);
short REXTERNAL rm_iniSet(
    char *section,
    char *entry,
    char *value
);
short REXTERNAL rm_iniGet(
    char *section,
    char *entry,
    char *buffer,
    short length,
    short flag
);
short REXTERNAL rm_iniSetPrivate(
    char *section,
    char *entry,
    char *value,
    char *iniName
);
short REXTERNAL rm_iniGetPrivate(
    char *section,
    char *entry,
    char *buffer,
    short length,
    short flag,
    char *iniName
);
#ifdef __NETWARE_386__
int rm_Register(
   char *name,			/* -> name of module to register    */
   int  *base	/* -> base of table of function entry points	    */
);
#endif


#ifdef WINDOWS
void    __cdecl RDSWinYield(void);
#endif

#ifdef MEMTRAP
#include "memtrap.h"
#endif

#ifdef __cplusplus
}
#endif

#endif /* RMCOMP_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RMCOMP.H_V   1.31   09 Feb 1995 13:00:10   BRADB  $
*/
