/*----------------------------------------------------------------------
   rm.h - Velocis resource manager.

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RM_H
#define RM_H

#ifndef NO_NESTED_H
#include <sys/types.h>

#ifdef WATC
#include <time.h>
#endif
#endif /* NO_NESTED_H */

#ifdef UNIX
#ifndef O_BINARY
#define O_BINARY 0
#endif
#else
#ifndef O_SYNC
#define O_SYNC 0
#endif
#endif

#ifdef __NETWARE_386__
typedef long HSEM;
#endif

/* flags to rm_memReport */
#define MEM_REP_FREEBLOCKS 0x01   /* prints free block lines */
#define MEM_REP_TAG        0x02   /* restricts report to one tag */
#define MEM_REP_SUMMARY    0x04   /* print summary totals only */
#define MEM_REP_LEAK	   0x08   /* list all unlisted blocks */
#define MEM_REP_TAG_LIST   0x10   /* listing of allocations per tag */
#define MEM_REP_INITIALIZE 0x20   /* visits all allocations */
#define MEM_REP_ALL        0x40   /* include allocations w/o file line */

/* max string that can be output via s_systemLogWrite */
#define RM_MAXLOGSTR       256

/* Resource Manager Return codes */
#define RM_OKAY     0
#define RM_TIMEOUT  1
#define RM_QUEUE_EMPTY 2

/* flags */
#define RM_INDEFINITE_WAIT (-1L)
#define RM_QUEUE_WAIT 1
#define RM_QUEUE_NOWAIT 2

/* File creation and extention sizes */
#define FILE_CREATE_SIZE 8192L
#define FILE_EXTEND_SIZE 16384L
#define CHK_EXTEND_SIZE 65536L

/* shutdown control */
#define OS_TERM_NORMAL 0
#define OS_TERM_QUIT   1
#define OS_TERM_THREAD 2
#define OS_TERM_ABORT  3

/* memory POOLS */
typedef struct _rm_pool_hdr {
    struct _rm_pool_hdr *next;
    char buf[1];
} RM_POOL_HDR;

typedef struct {
    RM_POOL_HDR  *next;
    short         tag;
    unsigned long max;
    unsigned long cnt;
    short         sem;
    long          timeout;
} RM_POOL;

RM_POOL * REXTERNAL rm_allocPool(
    unsigned long max,
    short tag,
    char *semName,
    long timeout
);

void * REXTERNAL rm_getFromPool(
    size_t sz,
    RM_POOL *rmp
);

short REXTERNAL rm_putInPool(
    void *ptr,
    RM_POOL *rmp
);

short REXTERNAL rm_zFreePool(
    RM_POOL **rmp
);

/* Memory handling functions */
void REXTERNAL rm_init(
    long memlimit,
    short filelim,
    unsigned long minfree
);
void REXTERNAL rm_userSave(
    char *szUserName,
    RDM_SESS hSess
);

void REXTERNAL rm_userGet(
    char *szUserName,
    RDM_SESS *hSess
);

/* File function that allows fprintf to occur */

unsigned short REXTVARARG rm_filePrintf(
    short handle,
    char * pszFormat,
    ...
);

void REXTERNAL heapdump(
    char *msg,
    int detail,
    long *mfree,
    long *used
);

void RINTERNAL fatalRMExit(
    char *msg
);

/* Operating system compatibility functions */

void *REXTERNAL rm_getSeg(
    size_t nbytes
);

void REXTERNAL rm_freeSeg(
    void *ptr
);

void REXTERNAL rm_setOSHandleLimit(
    unsigned short nHandles
);

unsigned long REXTERNAL rm_getDiskFreeSpace(
    char *path
);

int REXTERNAL rm_getDiskFull(
);

void REXTERNAL rm_setDiskFull(
    int
);

#ifdef WINDOWS

#define rm_tokenName(a)             /**/
#define rm_gshmCreate(a,b,c)        0
#define rm_gshmTerminate()          RM_OKAY
#define rm_gshmDelete(a)            RM_OKAY
#define rm_syncCreate(a)            0
#define rm_syncOpen(a)              0
#define rm_syncDelete(a)            RM_OKAY
#define rm_syncEnterExcl(a, b)      RM_OKAY
#define rm_syncExitExcl(a)          RM_OKAY
#define rm_syncWait(a, b)           RM_OKAY
#define rm_syncStart(a)             RM_OKAY
#define rm_syncResume(a)            RM_OKAY
#define rm_syncTerminate()          RM_OKAY
#define rm_enterCritSec()           /**/
#define rm_exitCritSec()            /**/
#define rm_queueCreate(a)           0
#define rm_queueOpen(a)             0
#define rm_queueDelete(a)           RM_OKAY
#define rm_queueWrite(a, b, c, d, e)   RM_OKAY
#define rm_queueRead(a, b, c, d, e) RM_OKAY
#define rm_queueTerminate()         RM_OKAY
#define rm_threadDefaultPriority(a) /**/
#define rm_threadBegin(a, b, c, d)  0
#define rm_threadEnd()              /**/
#define rm_foregroundThread()       1
#define rm_setForegroundThread()    1
#define rm_sleep(a)                 /**/
#define rm_setOSTerm(a)             /**/
#define rm_getOSTerm()              0

char *REXTERNAL getWinEnv(
    char *cp
);

void REXTERNAL putWinEnv(
    char *cp
);

#else /* WINDOWS */

short REXTERNAL rm_syncCreate(
    char *syncName
);

short REXTERNAL rm_syncOpen(
    char *syncName
);

short REXTERNAL rm_syncDelete(
    short syncHandle
);

#ifdef __NETWARE_386__
HSEM REXTERNAL rm_syncRMtoOS(
    short syncHandle
);

short REXTERNAL rm_syncOStoRM(
    HSEM hSem
);
#endif

short REXTERNAL rm_syncTerminate(
    void
);

void REXTERNAL rm_tokenName(
    char *tokenName
);

short REXTERNAL rm_gshmCreate(
    char *syncName,
    int   iSize,
    void  **ppvBuf
);

short REXTERNAL rm_gshmDelete(
    short syncHandle
);

short REXTERNAL rm_gshmTerminate(
    void
);

short REXTERNAL rm_syncEnterExcl(
    short syncHandle,
    long timeout
);

short REXTERNAL rm_syncExitExcl(
    short syncHandle
);

short REXTERNAL rm_syncWait(
    short syncHandle,
    long timeout
);

short REXTERNAL rm_syncStart(
    short syncHandle
);

short REXTERNAL rm_syncResume(
    short syncHandle
);

void REXTERNAL rm_enterCritSec(
    void
);

void REXTERNAL rm_exitCritSec(
    void
);

short REXTERNAL rm_queueCreate(
    char *queueName
);

short REXTERNAL rm_queueOpen(
    char *queueName
);

short REXTERNAL rm_queueDelete(
    short queueHandle
);

short REXTERNAL rm_queueTerminate(
    void
);

void REXTERNAL rm_queuePurge(
    short     queueHandle,
    short     msgid
);

short REXTERNAL rm_queueWrite(
    short  queueHandle,
    void  *buf,
    short  bufLen,
    short  msgid,
    short  qFlag
);

short REXTERNAL rm_queueRead(
    short  queueHandle,
    void **buf,
    short *bufLen,
    short *pmsgid,
    short  qFlag
);

short REXTERNAL rm_threadDefaultPriority(
    short priority
);

short REXTERNAL rm_threadBegin(
    void (* (RTHREAD fcnAddr))(void *),
    unsigned stackSize,
    void *argList,
    short priority
);

void REXTERNAL rm_threadEnd(
    void
);

short REXTERNAL rm_foregroundThread(
    void
);

short REXTERNAL rm_setForegroundThread(
    void
);

void REXTERNAL rm_sleep(
    unsigned long mSec
);

void REXTERNAL rm_setOSTerm(
    short level
);

short REXTERNAL rm_getOSTerm(
    void
);

#endif /* WINDOWS */
#endif /* RM_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RM.H_V   1.68   01 Mar 1995 11:22:10   BRADB  $
*/
