/*----------------------------------------------------------------------------
   rdmproto.h:  Velocis function declarations

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------------*/

#ifndef RDMPROTO_H
#define RDMPROTO_H

#ifdef __cplusplus
extern "C" {
#endif

/* The s_login and s_logout prototypes are included here so that it is not
 * necessary to include adm.h when just using the RDM functions.
 */
typedef short (REXTERNAL PING_CALLBACK)   (short, short, unsigned short, unsigned short, void *);
typedef short (REXTERNAL *pPING_CALLBACK) (short, short, unsigned short, unsigned short, void *);

short REXTERNAL s_ping(
    char *server,
    char *node,
    short count,
    unsigned short pktsz,
    pPING_CALLBACK pingBack,
    void *ptr
);

short REXTERNAL s_login(
    char RFAR *serverName,
    char RFAR *userName,
    char RFAR *userPW,
    RDM_SESS RFAR *hSess
);
short REXTERNAL s_logout(
    RDM_SESS hSess
);

RDM_DB REXTERNAL d_catDb(
    RDM_SESS hSess
);
short REXTERNAL d_checkpoint(
    RDM_SESS hSess
);
short REXTERNAL d_close(
    RDM_SESS hSess
);
short REXTERNAL d_closetask(
    RDM_SESS hSess
);
short REXTERNAL d_cmfree(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_cmlock(
    short    set,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_cmtype(
    short    set,
    short RFAR *cmtype,
    RDM_DB   hDb
);
short REXTERNAL d_cofree(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_colock(
    short    set,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_connect(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_connectn(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_cotype(
    short    set,
    short RFAR *cotype,
    RDM_DB   hDb
);
short REXTERNAL d_crfree(
    RDM_DB   hDb
);
short REXTERNAL d_crget(
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_crlock(
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_crread(
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_crset(
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_crslock(
    short    set,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_crtype(
    short RFAR *crtype,
    RDM_DB   hDb
);
short REXTERNAL d_crwrite(
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_csfree(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_cslock(
    short    set,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_csmget(
    short    set,
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_csmread(
    short    set,
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_csmset(
    short    set,
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_csmwrite(
    short    set,
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_csoget(
    short    set,
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_csoread(
    short    set,
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_csoset(
    short    set,
    DB_ADDR RFAR *dba,
    RDM_DB   hDb
);
short REXTERNAL d_csowrite(
    short    set,
    long     field,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_curkey(
    RDM_DB   hDb
);
short REXTERNAL d_dbafree(
    DB_ADDR   dba,
    RDM_DB  hDb
);
short REXTERNAL d_dbalock(
    DB_ADDR  dba,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_dbflush(
    RDM_DB   hDb
);
short REXTERNAL d_dbnum(
    char RFAR *dbname,
    RDM_SESS hSess
);
short REXTERNAL d_decode_dba(
    DB_ADDR dba,
    short RFAR *file,
    long RFAR *slot
);
short REXTERNAL d_delete(
    RDM_DB   hDb
);
short REXTERNAL d_dict(
    short    item,
    short    element,
    void RFAR *values,
    char     objname[OBJNAMELEN],
    RDM_DB   hDb
);
short REXTERNAL d_dictEntry(
    short    item,
    short    element,
    void RFAR * RFAR *pEntry,
    RDM_DB   hDb
);
short REXTERNAL d_discon(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_disdel(
    RDM_DB   hDb
);
short REXTERNAL d_encode_dba(
    short   file,
    long  slot,
    DB_ADDR RFAR *dba
);
short REXTERNAL d_errinfo(
    char RFAR *errbuf,
    short    length,
    RDM_SESS hSess
);
short REXTERNAL d_fillnew(
    short    nrec,
    void RFAR *recval,
    RDM_DB   hDb
);
short REXTERNAL d_fillnewat(
    short    nrec,
    void RFAR *recval,
    DB_ADDR  RFAR *absdba,
    RDM_DB   hDb
);
short REXTERNAL d_findco(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_findfm(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_findlm(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_findnm(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_findpm(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_fd_size(
    long   fld,
    short RFAR *fldsize,
    RDM_DB hDb
);
short REXTERNAL d_getTaskName(
    char RFAR *TaskName,
    RDM_SESS hSess
);

short REXTERNAL d_getchgInfo(
    CHGINFO RFAR *chgInfo,
    RDM_SESS hSess
);

short REXTERNAL d_grplock(
    GROUPLOCK RFAR *glock,
    unsigned short num,
    RDM_SESS hSess
);
short REXTERNAL d_iclose(
    RDM_DB   hDb
);
short REXTERNAL d_iopen(
    const char RFAR *dbname,
    const char RFAR *openmode,
    RDM_SESS hSess,
    RDM_DB RFAR *hDb
);
short REXTERNAL d_ismember(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_isowner(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_keydel(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keydir(
    long  field,
    short dir,
    RDM_DB hDb
);
short REXTERNAL d_keyexist(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keyfind(
    long     field,
    const void RFAR *fldval,
    RDM_DB   hDb
);
short REXTERNAL d_keyfrst(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keylast(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keynext(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keyprev(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keyread(
    long     field,
    void RFAR *key_val,
    RDM_DB   hDb
);
short REXTERNAL d_keystore(
    long     field,
    RDM_DB   hDb
);
short REXTERNAL d_keyrdstate(
    long  field,                /* key field constant */
    void RFAR *buf,
    RDM_DB hDb
);
short REXTERNAL d_keyszstate(
    long  field,                /* key field constant */
    unsigned short RFAR *pSize,
    RDM_DB hDb
);
short REXTERNAL d_keywrstate(
    long  field,                /* key field constant */
    void RFAR *buf,
    RDM_DB hDb
);
short REXTERNAL d_makenew(
    short    nrec,
    RDM_DB   hDb
);
short REXTERNAL d_members(
    short    set,
    long RFAR *tot,
    RDM_DB   hDb
);
short REXTERNAL d_open(
    const char RFAR *dbname,
    const char RFAR *openmode,
    RDM_SESS hSess,
    RDM_DB RFAR *hDb
);
short REXTERNAL d_opentask(
    const char RFAR *userName,
    RDM_SESS RFAR *hSess
);
short REXTERNAL d_pkeyfind(
    long     field,
    short nFields,
    unsigned short partialStrLen,
    const void RFAR *fldval,
    RDM_DB   hDb
);
short REXTERNAL d_pkeynext(
    long     field,
    short nFields,
    unsigned short partialStrLen,
    const void RFAR *fldval,
    RDM_DB   hDb
);
short REXTERNAL d_pkeyprev(
    long     field,
    short nFields,
    unsigned short partialStrLen,
    const void RFAR *fldval,
    RDM_DB   hDb
);
short REXTERNAL d_rdcurr(
    DB_ADDR RFAR *currbuff,
    short    buflen,
    short RFAR *currsize,
    RDM_DB   hDb
);
short REXTERNAL d_rdlockmodes(
    short    dirty_reads,
    short    freeable,
    RDM_SESS hSess
);

short REXTERNAL d_readonly(
    char RFAR *dbname
);

short REXTERNAL d_recfrst(
    short    rec,
    RDM_DB   hDb
);
short REXTERNAL d_reclast(
    short    rec,
    RDM_DB   hDb
);
short REXTERNAL d_recnext(
    RDM_DB   hDb
);
short REXTERNAL d_recprev(
    RDM_DB   hDb
);
short REXTERNAL d_recread(
    short    rec,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_recset(
    short    rec,
    RDM_DB   hDb
);
short REXTERNAL d_recsetat(
    short   rec,                /* record type */
    DB_ADDR dba,
    RDM_DB hDb
);
short REXTERNAL d_recwrite(
    short    rec,
    void RFAR *data,
    RDM_DB   hDb
);
short REXTERNAL d_release(
    short    freeFlag,
    RDM_SESS hSess
);
short REXTERNAL d_reset_dberr(
    ERRORPROC func,
    RDM_SESS hSess
);
short REXTERNAL d_rtfree(
    short    rec,
    RDM_DB   hDb
);
short REXTERNAL d_rtlock(
    short    rec,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_rt_size(
    short  rec,
    short RFAR *recsize,
    RDM_DB hDb
);
short REXTERNAL d_setkey(
    long     field,
    void RFAR *fldvalue,
    RDM_DB   hDb
);
short REXTERNAL d_stfree(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_stlock(
    short    set,
    char RFAR *ltype,
    RDM_DB   hDb
);
short REXTERNAL d_set_dberr(
    ERRORPROC func,
    void RFAR *svcptr,
    RDM_SESS hSess
);
short REXTERNAL d_setmm(
    short    sett,
    short    sets,
    RDM_DB   hDb
);
short REXTERNAL d_setmo(
    short    setm,
    short    seto,
    RDM_DB   hDb
);
short REXTERNAL d_setmr(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_setom(
    short    nseto,
    short    nsetm,
    RDM_DB   hDb
);
short REXTERNAL d_setoo(
    short    nsett,
    short    nsets,
    RDM_DB   hDb
);
short REXTERNAL d_setor(
    short    nset,
    RDM_DB   hDb
);
short REXTERNAL d_setrm(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_setro(
    short    set,
    RDM_DB   hDb
);
short REXTERNAL d_stampverifyback(
    unsigned long savesetid,
    short mode,
    RDM_DB hDb
);
short REXTERNAL d_testSess(
    RDM_SESS hSess
);
short REXTERNAL d_timeout(
    short    sec,
    RDM_SESS hSess
);
short REXTERNAL d_trabort(
    RDM_SESS hSess
);
short REXTERNAL d_tractive(
    short RFAR *bool,
    RDM_SESS hSess
);
short REXTERNAL d_trbegin(
    const char RFAR *tid,
    RDM_SESS hSess
);
short REXTERNAL d_trend(
    RDM_SESS hSess
);
short REXTERNAL d_trmark(
    const char RFAR *mtag,
    RDM_SESS hSess
);
short REXTERNAL d_trrollback(
    const char RFAR *mtag,
    RDM_SESS hSess
);
short REXTERNAL d_unset_dberr(
    ERRORPROC func,
    RDM_SESS hSess
);
short REXTERNAL d_wrcurr(
    DB_ADDR RFAR *currbuff,
    unsigned short buflen,
    RDM_DB   hDb
);

#ifdef __cplusplus
}
#endif

#endif /* RDMPROTO_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RDMPROTO.H_V   1.38   16 Feb 1995 13:39:20   BRADB  $
*/
