/*---------------------------------------------------------------------------
    prntutil.h -- utility print support module

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
    Name: SetSTDIO
 Purpose: Overrides the handles for STDIN, STDOUT and STDERR.

          A NULL in any parameter causes that parameter to be ignored.
-----------------------------------------------------------------------------*/
extern   void     SetSTDIO(FILE * hstdin,
                           FILE * hstdout,
                           FILE * hstderr
                          );

/*---------------------------------------------------------------------------
    Name: ToSTDOUT 
          ToSTDERR

 Purpose: Print a format string and parameters to STDOUT or STDERR.
          These routines use vsprintf to format the string before printing.
-----------------------------------------------------------------------------*/
extern   short    ToSTDERR(char * pszFormat, ...);
extern   short    ToSTDOUT(char * pszFormat, ...);



/*---------------------------------------------------------------------------
    Name: PrintBanner
 Purpose: Print the Raima banner, utility name and copyright


 Example:   PrintBanner(stderr, "Database Access Language Utility");

            The above prints the following to STDERR.

            Velocis 
            Database Access Language Utility
            Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.

-----------------------------------------------------------------------------*/
extern   void     PrintBanner(FILE * hOut, char * pszName);



/*---------------------------------------------------------------------------
    Name: Separator
 Purpose: Print a separator line on a report.
-----------------------------------------------------------------------------*/
extern   void     Separator(short sNewLineFore,    /* New lines before     */
                            short cbLine,          /* Length of separator  */
                            short sNewLineAft      /* New lines after      */
                           );

/*
$Header:   P:/PAT/INCLUDE/VCS/PRNTUTIL.H_V   1.3   18 Apr 1994 12:10:44   RICHM  $
*/

