/*----------------------------------------------------------------------
    platform.h:  Velocis platform-dependent definitions

    This file should contains definitions which are affected by the
    platform being used.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef PLATFORM_H
#define PLATFORM_H

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to make it easy to switch between K&R and ANSI prototypes. */
#ifndef NO_ANSI_PROTOTYPES
#define __ARGS(x) x
#else
#define __ARGS(x) ()
#endif

/* The following are used to eliminate compiler warnings. */
#ifdef __BORLANDC__
#define VOIDPTR   (void *)
#else
#ifdef M70
#define VOIDPTR   (void *)
#else
#define VOIDPTR   
#endif
#endif

#define RSTATIC       static

#ifdef HPUX
#include <sys/stdsyms.h>
#endif

#ifdef WINDOWS
#include <windows.h>
#endif

#ifdef WIN32_NT
#include <windows.h>

BOOL WINAPI _CRT_INIT(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved);

#define RFAR
#define RNEAR
#undef MSDOS

#ifdef MSC
#define REXTERNAL     APIENTRY
#define REXTVARARG
#define RINTERNAL
#define RNEARPROC
#define RTHREAD
#endif

#endif  /* WIN32_NT */

#if defined(WINDOWS) && !defined(WIN32_NT)

#undef MSDOS
#define RFAR   far
#define RNEAR  near

#ifdef MSC 
#define REXTERNAL     _pascal __loadds
#define RINTERNAL     
#define REXTVARARG    _loadds
#define RNEARPROC     _near
#define RTHREAD
#endif
#ifdef __BORLANDC__
#define REXTERNAL     pascal
#define RINTERNAL
#define REXTVARARG
#define RNEARPROC
#define RTHREAD
#endif

#endif /* WINDOWS */

#ifdef __NETWARE_386__

#ifdef WATC
#undef MSDOS
#undef far
#define far
#undef RFAR
#define RFAR
#define getenv getWatcEnv
#define REXTERNAL
#define RINTERNAL
#define REXTVARARG
#define RNEARPROC
#define RTHREAD
#undef NULL
#define NULL 0
#endif

#endif
#ifdef OS2

#ifndef RFAR            /* give PC-lint a way to suppress this */
#define RFAR   far
#endif

#define RNEAR  near
#undef MSDOS

#ifdef WATC

#undef MSDOS
#undef far
#define far
#undef RFAR
#define RFAR
#define getenv getWatcEnv
#define REXTERNAL
#define RINTERNAL
#define REXTVARARG
#define RNEARPROC
#define RTHREAD
#undef NULL
#define NULL 0

#else

#ifdef MSC
#define REXTERNAL     _pascal _loadds
#define REXTVARARG    _loadds
#define RINTERNAL     _fastcall
#define RNEARPROC     _near _fastcall
#define RTHREAD
#else
#ifdef __BORLANDC__
#define REXTERNAL     pascal
#define REXTVARARG
#define RINTERNAL
#define RNEARPROC
#define RTHREAD
#ifdef RFAR
#undef  RFAR
#undef  RNEAR
#endif
#define RFAR
#define RNEAR
#else
#if defined(__IBMC__) || defined(__IBMCPP__)
#define cdecl
#define REXTERNAL 
#define REXTVARARG
#define RINTERNAL
#define RNEARPROC
#define RTHREAD     _Optlink
#ifdef RFAR
#undef  RFAR
#undef  RNEAR
#endif
#define RFAR
#define RNEAR
#endif /* __IBMC__ */
#endif /* __BORLANDC__ */
#endif /* MSC */
#endif /* WATC */

#endif /* OS2 */

#ifdef UNIX

#define NON_THREADED        /* turns off starting server as thread */

#if !defined(AIX)
#define ALLOCA_CHALLENGED    /* deprived of alloca :( */
#endif

#define cdecl
#define RFAR
#define RNEAR
#define REXTERNAL
#define REXTVARARG
#define RINTERNAL
#define RNEARPROC
#define RTHREAD

#endif
#ifdef MSDOS
#ifndef RFAR            /* give PC-lint a way to suppress this */
#define RFAR   far
#endif
#define RNEAR  near
#ifdef MSC 
#define REXTERNAL     _pascal
#define RINTERNAL     _fastcall
#define REXTVARARG    
#define RNEARPROC     _near _fastcall
#define RTHREAD
#endif
#ifdef __BORLANDC__
#define REXTERNAL     pascal
#define RINTERNAL
#define REXTVARARG
#define RNEARPROC
#define RTHREAD
#endif

#endif

#ifndef NULL
#define NULL ((void RFAR *)0)
#endif

/* directory separator character:
*/
#ifdef UNIX
#define DIRCHAR '/'
#else
#define DIRCHAR '\\'
#endif

/* To satisfy compilers that warn about unreferenced parameters */
#ifdef MSC
#define UNREF_PARM(a) a=a;
#endif
#ifdef WATC
#define UNREF_PARM(a) a=a;
#endif

#ifndef UNREF_PARM
#define UNREF_PARM(a)
#endif

#if defined(RDSWIN) && !defined(QUICKWIN)
#define sscanf   RDSsscanf
#define printf   RDSprintf
#define fdopen   RDSfdopen
#define exit     RDSexit
#define strftime RDSstrftime
#endif

#if defined(WIN32_NT) || defined(WINDOWS)
#define stricmp   _stricmp
#endif

#ifdef WINDOWS
#define strnicmp   _strnicmp
#define ftime     _ftime
#define PAT_GETCH _getch
#define PAT_PUTCH _putch
#define PAT_OPEN  _open
#define PAT_READ  _read
#define PAT_WRITE _write
#define PAT_LSEEK _lseek
#define PAT_CLOSE _close
#else
#define PAT_GETCH getch
#define PAT_PUTCH putch
#define PAT_OPEN  open
#define PAT_READ  read
#define PAT_WRITE write
#define PAT_LSEEK lseek
#define PAT_CLOSE close
#endif

#ifdef __cplusplus
}
#endif

#ifdef RDS_PRINTF_DLG
#include <stdarg.h>
#include <stdio.h>

#define printf	rds_printf_dlg

/* ======================================================================
   Use a MessageBox for printf under Windows
*/
RSTATIC void REXTVARARG rds_printf_dlg(
    char *format,
    ...)
{
	char buf[256];
	va_list marker;
	
	va_start (marker, format);
	vsprintf(buf, format, marker);
	MessageBox((HWND)NULL, buf, "PRINTF", MB_OK);
	va_end(marker);
}

#define RDS_TRACE printf("RDS_TRACE: %s(%d)", __FILE__, __LINE__);
#else
#define RDS_TRACE /**/
#endif

#endif /* PLATFORM_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/PLATFORM.H_V   1.40   19 Dec 1994 10:07:44   WAYNE  $
*/
